/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.UI;

import com.iplanet.jato.RequestHandler;
import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.RequestHandlingTiledViewBase;
import com.iplanet.jato.view.TiledView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.html.StaticTextField;
import com.sun.identity.authentication.UI.CallBackChoiceTiledView;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public class CallBackTiledView
extends RequestHandlingTiledViewBase
implements TiledView,
RequestHandler {
    private Callback[] callbacks = null;
    private List requiredList = null;
    private Callback curCallback = null;
    private int curTile = 0;
    public static final String TXT_INDEX = "txtIndex";
    public static final String TILED_CHOICE = "tiledChoices";
    public static final String TXT_PROMPT = "txtPrompt";
    public static final String TXT_VALUE = "txtValue";

    public CallBackTiledView(View parent, String name) {
        super(parent, name);
        this.setPrimaryModel((DatasetModel)this.getDefaultModel());
        this.registerChildren();
    }

    protected void registerChildren() {
        this.registerChild(TXT_INDEX, StaticTextField.class);
        this.registerChild(TILED_CHOICE, CallBackChoiceTiledView.class);
        this.registerChild(TXT_PROMPT, StaticTextField.class);
        this.registerChild(TXT_VALUE, StaticTextField.class);
    }

    protected View createChild(String name) {
        if (name.equals(TXT_INDEX)) {
            return new StaticTextField((ContainerView)this, TXT_INDEX, (Object)"");
        }
        if (name.equals(TILED_CHOICE)) {
            return new CallBackChoiceTiledView((View)this, TILED_CHOICE);
        }
        if (name.equals(TXT_PROMPT)) {
            return new StaticTextField((ContainerView)this, TXT_PROMPT, (Object)"");
        }
        if (name.equals(TXT_VALUE)) {
            return new StaticTextField((ContainerView)this, TXT_VALUE, (Object)"");
        }
        throw new IllegalArgumentException("Invalid child name [" + name + "]");
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        if (this.getPrimaryModel() == null) {
            throw new ModelControlException("Primary model is null");
        }
        if (this.callbacks != null) {
            this.getPrimaryModel().setSize(this.callbacks.length);
        } else {
            this.getPrimaryModel().setSize(0);
        }
        super.beginDisplay(event);
        this.resetTileIndex();
    }

    public boolean nextTile() throws ModelControlException {
        boolean movedToRow = super.nextTile();
        if (movedToRow) {
            this.curTile = this.getTileIndex();
            this.curCallback = this.callbacks[this.curTile];
            this.setDisplayFieldValue(TXT_INDEX, Integer.toString(this.curTile));
            if (this.curCallback instanceof NameCallback) {
                this.setNameCallbackInfo((NameCallback)this.curCallback);
            } else if (this.curCallback instanceof PasswordCallback) {
                this.setPasswordCallbackInfo((PasswordCallback)this.curCallback);
            } else if (this.curCallback instanceof ChoiceCallback) {
                this.setChoiceCallbackInfo((ChoiceCallback)this.curCallback);
            } else {
                this.setDisplayFieldValue(TXT_PROMPT, "");
                this.setDisplayFieldValue(TXT_VALUE, "");
                CallBackChoiceTiledView tView = (CallBackChoiceTiledView)this.getChild(TILED_CHOICE);
                tView.setChoices(this.curTile, null, 0);
            }
        }
        return movedToRow;
    }

    public void setCallBackArray(Callback[] callbacks, List requiredList) {
        this.callbacks = callbacks;
        this.requiredList = requiredList;
    }

    private void setNameCallbackInfo(NameCallback nc) {
        this.setDisplayFieldValue(TXT_PROMPT, nc.getPrompt());
        this.setDisplayFieldValue(TXT_VALUE, nc.getName());
        CallBackChoiceTiledView tView = (CallBackChoiceTiledView)this.getChild(TILED_CHOICE);
        tView.setChoices(this.curTile, null, 0);
    }

    private void setPasswordCallbackInfo(PasswordCallback pc) {
        this.setDisplayFieldValue(TXT_PROMPT, pc.getPrompt());
        char[] tmp = pc.getPassword();
        if (tmp == null) {
            this.setDisplayFieldValue(TXT_VALUE, "");
        } else {
            this.setDisplayFieldValue(TXT_VALUE, new String(tmp));
        }
        CallBackChoiceTiledView tView = (CallBackChoiceTiledView)this.getChild(TILED_CHOICE);
        tView.setChoices(this.curTile, null, 0);
    }

    private void setChoiceCallbackInfo(ChoiceCallback cc) {
        this.setDisplayFieldValue(TXT_PROMPT, cc.getPrompt());
        this.setDisplayFieldValue(TXT_VALUE, "");
        CallBackChoiceTiledView tView = (CallBackChoiceTiledView)this.getChild(TILED_CHOICE);
        tView.setChoices(this.curTile, cc.getChoices(), cc.getDefaultChoice());
    }

    public boolean beginTextBoxDisplay(ChildDisplayEvent event) {
        return this.curCallback != null && this.curCallback instanceof NameCallback;
    }

    public boolean beginPasswordDisplay(ChildDisplayEvent event) {
        return this.curCallback != null && this.curCallback instanceof PasswordCallback;
    }

    public boolean beginChoiceDisplay(ChildDisplayEvent event) {
        return this.curCallback != null && this.curCallback instanceof ChoiceCallback;
    }

    public boolean beginIsRequiredDisplay(ChildDisplayEvent event) {
        String s;
        boolean required = false;
        if (this.requiredList != null && !this.requiredList.isEmpty() && (s = (String)this.requiredList.get(this.curTile - 1)) != null && s.length() > 0) {
            required = true;
        }
        return required;
    }
}

