/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.internal;

import com.iplanet.am.util.SecureRandomManager;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.util.I18n;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.internal.AuthLoginThread;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.authentication.internal.AuthSSOToken;
import com.sun.identity.authentication.internal.AuthSubject;
import com.sun.identity.authentication.internal.InvalidAuthContextException;
import com.sun.identity.authentication.internal.LoginContext;
import com.sun.identity.authentication.internal.server.AuthSPrincipal;
import com.sun.identity.authentication.internal.util.AuthI18n;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.ServiceManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.security.Principal;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.login.LoginException;
import netscape.ldap.LDAPDN;
import netscape.ldap.util.DN;

public final class AuthContext {
    public static final int AUTH_NOT_STARTED = 1;
    public static final int AUTH_IN_PROGRESS = 2;
    public static final int AUTH_SUCCESS = 3;
    public static final int AUTH_FAILED = 4;
    public static final int AUTH_COMPLETED = 5;
    protected final String authComponentName = "Authentication";
    protected static final String authKeyName = "authContext";
    protected static final String authDebugName = "amAuthInternal";
    protected static Debug authDebug = Debug.getInstance((String)"amAuthInternal");
    protected String organizationName = null;
    protected String applicationName = null;
    protected int loginStatus;
    protected LoginException loginException;
    protected Callback[] informationRequired;
    protected Callback[] submittedInformation;
    protected AuthLoginThread loginThread;
    protected LoginContext loginContext;
    protected SSOToken token;
    protected static I18n myAuthI18n = AuthI18n.authI18n;
    private static boolean isEnableHostLookUp = Boolean.valueOf(SystemProperties.get("com.sun.am.session.enableHostLookUp"));

    public AuthContext() throws LoginException {
        this("");
    }

    public AuthContext(Principal principal, char[] password) throws LoginException {
        this(null, principal, password);
    }

    public AuthContext(Principal principal, char[] password, String hostname, int port) throws LoginException {
        this("ldap://" + hostname + ":" + port, principal, password);
    }

    public AuthContext(String orgName, Principal principal, char[] password) throws LoginException {
        if (principal == null) {
            throw new LoginException(myAuthI18n.getString("com.iplanet.auth.invalid-username"));
        }
        if (password == null) {
            throw new LoginException(myAuthI18n.getString("com.iplanet.auth.invalid-password"));
        }
        AuthSubject subject = new AuthSubject();
        if (orgName != null) {
            this.organizationName = orgName;
        }
        this.reset(subject);
        this.loginContext.updateSharedState(principal.getName(), password);
        boolean gotName = false;
        boolean gotPassword = false;
        if (authDebug.messageEnabled()) {
            authDebug.message("Instantiated AuthContext with parameters organization name: " + this.organizationName + "; " + (principal == null ? "principal is null" : "principal: ") + principal + "; " + (password.length == 0 ? "password is empty\n" : "password present\n"));
        }
        this.startLogin();
        while (this.hasMoreRequirements()) {
            authDebug.message("AuthContext::init() Has requirements");
            Callback[] callbacks = this.getRequirements();
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    authDebug.message("Got NameCallback");
                    NameCallback nc = (NameCallback)callbacks[i];
                    Set sops = subject.getPrincipals();
                    AuthSPrincipal[] aps = sops.toArray(new AuthSPrincipal[0]);
                    if (aps.length != 1) continue;
                    nc.setName(aps[0].getName());
                    authDebug.message("Set namecallback name = " + aps[0].getName());
                    gotName = true;
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    authDebug.message("Got PasswordCallback");
                    PasswordCallback pc = (PasswordCallback)callbacks[i];
                    pc.setPassword(password);
                    gotPassword = true;
                    continue;
                }
                if (callbacks[i] instanceof TextOutputCallback) {
                    authDebug.message("AuthContext::init() Got TextOutputCallback");
                    continue;
                }
                if (callbacks[i] instanceof TextInputCallback) {
                    authDebug.message("AuthContext::init() Got TextInputCallback");
                    continue;
                }
                if (callbacks[i] instanceof ChoiceCallback) {
                    authDebug.message("AuthContext::init() Got ChoiceCallback");
                    ChoiceCallback cc = (ChoiceCallback)callbacks[i];
                    cc.setSelectedIndex(0);
                    continue;
                }
                authDebug.message("AuthContext::init() Got Unknown Callback");
            }
            this.submitRequiredInformation(callbacks);
        }
        if (authDebug.messageEnabled() && gotName && gotPassword) {
            authDebug.message("AuthContext::init() Got name and password callbacks");
        }
        if (authDebug.messageEnabled()) {
            authDebug.message("AuthContext::init() Login status: " + this.getLoginStatus());
        }
        if (this.getLoginStatus() == 4) {
            throw this.getLoginException();
        }
    }

    protected AuthContext(String orgName, AuthSubject subject) throws LoginException {
        String orgname = orgName;
        if (authDebug.messageEnabled()) {
            authDebug.message("Instantiating AuthContext with parameters organization name: " + orgName + "; " + (subject == null ? "subject is null" : "subject: " + subject));
        }
        if (orgName != null) {
            if (orgName.startsWith("auth://")) {
                String appName = null;
                int offset = 7;
                String subsample = orgName.substring(offset);
                int i2 = subsample.indexOf("/");
                if (i2 != -1) {
                    orgname = subsample.substring(0, i2);
                    authDebug.message("AuthContext::init() auth:// form, orgname = " + orgname);
                    subsample = subsample.substring(i2 + 1);
                    appName = subsample.length() > 0 ? ((i2 = subsample.indexOf("?")) != -1 ? subsample.substring(0, i2) : subsample) : null;
                } else {
                    orgname = subsample;
                }
                if (appName != null) {
                    this.applicationName = appName;
                }
            } else if (orgName.startsWith("local://")) {
                authDebug.message("local form AuthContext specified; " + orgName);
                int offset = 8;
                orgname = orgName.substring(offset);
            }
        }
        this.organizationName = orgname;
        this.reset(subject);
    }

    public AuthContext(String orgName) throws LoginException {
        this(orgName, null);
        authDebug.message("Instantiated AuthContext with organization name: " + orgName);
    }

    protected AuthContext(byte[] bArray) throws LoginException {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(bArray);
            ObjectInputStream bin = new ObjectInputStream(bis);
            String readOrgName = (String)bin.readObject();
            int readStatus = bin.readInt();
            AuthSubject readSubject = (AuthSubject)bin.readObject();
            this.organizationName = readOrgName;
            this.reset(readSubject);
            this.setLoginStatus(readStatus);
        }
        catch (IOException e) {
            authDebug.message("AuthContext::bArray constructor():IOException" + e);
            throw new LoginException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            authDebug.message("AuthContext::bArray constructor():ClassNotFoundException" + e);
            throw new LoginException(e.getMessage());
        }
    }

    protected void reset() throws LoginException {
        authDebug.message("AuthContext::reset()");
        this.reset(null);
        authDebug.message("AuthContext::reset() exiting");
    }

    protected void reset(AuthSubject subject) throws LoginException {
        if (authDebug.messageEnabled()) {
            authDebug.message("AuthContext::reset(" + this.organizationName + ", " + (subject == null ? "null" : subject.toString()) + ")");
        }
        this.loginStatus = 1;
        this.informationRequired = null;
        this.submittedInformation = null;
        this.loginException = null;
        this.loginThread = new AuthLoginThread(this);
        authDebug.message("AuthLoginThread isAlive = " + this.loginThread.isAlive());
        String contextName = null;
        contextName = this.applicationName == null ? this.organizationName : this.organizationName + "%" + this.applicationName;
        authDebug.message("AuthContext::reset:using contextName=" + contextName);
        this.loginContext = subject == null ? new LoginContext(contextName, this.loginThread) : new LoginContext(contextName, subject, this.loginThread);
        if (authDebug.messageEnabled()) {
            authDebug.message("Successfully reset AuthContext for organization: " + this.organizationName + (subject == null ? " with no subject name " : " with subjects: " + subject));
        }
    }

    protected AuthSubject getSubject() {
        authDebug.message("AuthContext::getSubject()");
        return this.loginContext.getSubject();
    }

    public void startLogin() throws LoginException {
        authDebug.message("AuthContext::startLogin() called");
        if (this.getLoginStatus() != 1) {
            authDebug.message("AuthContext::startLogin called when the current login state is" + this.getLoginStatus());
            throw new LoginException(myAuthI18n.getString("authError-invalidMethod" + this.getLoginStatus()));
        }
        this.loginStatus = 2;
        authDebug.message("AuthContext::startLogin() starting a new thread to run the login process");
        try {
            this.loginThread.start();
        }
        catch (Exception ex) {
            authDebug.message("exception starting thread: " + ex);
            throw new LoginException(ex.getMessage());
        }
    }

    public boolean hasMoreRequirements() {
        authDebug.message("AuthContext::requiresMoreInformation()");
        return this.getRequirements() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Callback[] getRequirements() {
        authDebug.message("AuthContext::getInformationRequired()");
        if (this.getLoginStatus() != 2) {
            authDebug.message("AuthContext:getInformationRequired() called when the current login state is: " + this.getLoginStatus());
            return null;
        }
        while (this.informationRequired == null && this.getLoginStatus() == 2) {
            try {
                authDebug.message("AuthContext::getInformationRequired() waiting for Callback array");
                AuthLoginThread authLoginThread = this.loginThread;
                synchronized (authLoginThread) {
                    if (this.informationRequired == null && this.getLoginStatus() == 2) {
                        this.loginThread.wait();
                    }
                }
                authDebug.message("AuthContext::getInformationRequired() returned from waiting for Callback array");
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.informationRequired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitRequiredInformation(Callback[] info) {
        authDebug.message("AuthContext::submitRequestedInformation()");
        this.informationRequired = null;
        AuthLoginThread authLoginThread = this.loginThread;
        synchronized (authLoginThread) {
            this.submittedInformation = info;
            this.loginThread.notify();
        }
        authDebug.message("AuthContext::submitRequestedInformation() sending notify to sleeping threads");
    }

    public void logout() throws LoginException {
        authDebug.message("AuthContext::logout()");
        this.loginContext.logout();
        authDebug.message("Called LoginContext::logout()");
        this.loginStatus = 5;
    }

    public LoginException getLoginException() {
        authDebug.message("AuthContext::getLoginException()");
        return this.loginException;
    }

    public int getLoginStatus() {
        authDebug.message("AuthContext::getLoginStatus()");
        return this.loginStatus;
    }

    protected void setLoginStatus(int status) {
        authDebug.message("AuthContext::setLoginStatus()");
        this.loginStatus = status;
    }

    public Principal getPrincipal() {
        Iterator items;
        Set sop = this.getSubject().getPrincipals();
        if (authDebug.messageEnabled()) {
            authDebug.message("AuthContext::getAuthPrincipal(): " + sop);
        }
        if ((items = sop.iterator()).hasNext()) {
            return (Principal)items.next();
        }
        return null;
    }

    public AuthPrincipal getAuthPrincipal() {
        authDebug.message("AuthContext::getAuthPrincipal()");
        Set sop = this.getSubject().getPrincipals();
        Iterator items = sop.iterator();
        if (items.hasNext()) {
            return (AuthPrincipal)items.next();
        }
        return null;
    }

    protected Set getPrincipals() {
        authDebug.message("AuthContext::getAuthPrincipals()");
        return this.getSubject().getPrincipals();
    }

    protected byte[] toByteArray() {
        block4: {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream bout = new ObjectOutputStream(bos);
                bout.writeObject(this.organizationName == null ? " " : this.organizationName);
                bout.writeInt(this.loginStatus);
                bout.writeObject(this.loginContext.getSubject());
                byte[] bytestuff = bos.toByteArray();
                return bytestuff;
            }
            catch (IOException iox) {
                if (authDebug.messageEnabled()) {
                    authDebug.message("AuthContext:toByteArray():IOException", (Throwable)iox);
                }
            }
            catch (Exception e) {
                if (!authDebug.messageEnabled()) break block4;
                authDebug.message("AuthContext:toByteArray():Exception", (Throwable)e);
            }
        }
        return null;
    }

    public String getOrganizationName() {
        String rootSuffix;
        if (this.organizationName == null && (rootSuffix = (this.organizationName = ServiceManager.getBaseDN())) != null && this.organizationName != null) {
            rootSuffix = new DN(rootSuffix).toRFCString().toLowerCase();
            this.organizationName = new DN(this.organizationName).toRFCString().toLowerCase();
        }
        return this.organizationName;
    }

    protected String getApplicationName() {
        return this.applicationName;
    }

    public SSOToken getSSOToken() throws InvalidAuthContextException {
        block12: {
            if (this.token != null) {
                return this.token;
            }
            this.token = new AuthSSOToken(this);
            try {
                if (this.getOrganizationName() != null) {
                    this.token.setProperty("Organization", this.getOrganizationName());
                }
                InetAddress address = InetAddress.getLocalHost();
                String ipAddress = address.getHostAddress();
                String strHostName = address.getHostName();
                if (authDebug.messageEnabled()) {
                    authDebug.message("Complete Host : " + address.toString());
                    authDebug.message("getSSOToken : HOST Name : " + strHostName);
                    authDebug.message("getSSOToken : IP : " + ipAddress);
                }
                if (ipAddress != null) {
                    if (isEnableHostLookUp) {
                        if (strHostName != null) {
                            this.token.setProperty("HostName", strHostName);
                        }
                    } else {
                        this.token.setProperty("HostName", ipAddress);
                    }
                    this.token.setProperty("Host", ipAddress);
                }
                this.token.setProperty("AuthType", "ldap");
                String principal = this.getPrincipal().getName();
                if (principal != null) {
                    this.token.setProperty("Principal", principal);
                    String username = principal;
                    if (DN.isDN((String)principal)) {
                        username = LDAPDN.explodeDN((String)principal, (boolean)true)[0];
                    }
                    StringBuffer uuid = new StringBuffer(100);
                    uuid.append("id=").append(username).append(",ou=user,").append(this.getOrganizationName());
                    this.token.setProperty("sun.am.UniversalIdentifier", uuid.toString());
                }
                this.token.setProperty("AuthLevel", Integer.toString(0));
                SecureRandom secureRandom = SecureRandomManager.getSecureRandom();
                String amCtxId = Long.toHexString(secureRandom.nextLong());
                this.token.setProperty("AMCtxId", amCtxId);
                if (authDebug.messageEnabled()) {
                    authDebug.message("SSOToken : Organization : " + this.token.getProperty("Organization"));
                    authDebug.message("SSOToken : Principal : " + this.token.getProperty("Principal"));
                    authDebug.message("SSOToken : HostName : " + this.token.getProperty("HostName"));
                    authDebug.message("SSOToken : Host : " + this.token.getProperty("Host"));
                    authDebug.message("SSOToken : getIPAddress : " + this.token.getIPAddress());
                    authDebug.message("SSOToken : getHostName : " + this.token.getHostName());
                    authDebug.message("SSOToken : ContextId : " + this.token.getProperty("AMCtxId"));
                }
            }
            catch (Exception e) {
                if (!authDebug.warningEnabled()) break block12;
                authDebug.warning("getSSOToken: setProperty exception : ", (Throwable)e);
            }
        }
        return this.token;
    }
}

