/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.ldap;

import com.sun.identity.shared.locale.AMResourceBundleCache;
import com.sun.identity.shared.locale.L10NMessage;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import netscape.ldap.LDAPException;

public class LDAPUtilException
extends LDAPException
implements L10NMessage {
    private String msgID;
    private String bundleName;
    private String message;
    private Object[] args;
    private static String defaultBundleName = "amAuthLDAP";
    AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();

    public LDAPUtilException() {
    }

    public LDAPUtilException(String message) {
        super(message);
    }

    protected LDAPUtilException(String message, int errorCode) {
        super(message, errorCode);
    }

    public LDAPUtilException(String msgID, Object[] args) {
        this.msgID = msgID;
        this.args = args;
        this.bundleName = defaultBundleName;
        this.message = this.getL10NMessage(Locale.ENGLISH);
    }

    public LDAPUtilException(String msgID, int errorCode, Object[] args) {
        super(msgID, errorCode);
        this.msgID = msgID;
        this.args = args;
        this.bundleName = defaultBundleName;
        this.message = this.getL10NMessage(Locale.ENGLISH);
    }

    public LDAPUtilException(String rbName, String msgID, int errorCode, Object[] args) {
        super(msgID, errorCode);
        this.msgID = msgID;
        this.args = args;
        this.bundleName = rbName;
        this.message = this.getL10NMessage(Locale.ENGLISH);
    }

    public LDAPUtilException(Throwable ex) {
        this.message = ex.getMessage();
        if (ex instanceof L10NMessage) {
            L10NMessage lex = (L10NMessage)ex;
            this.bundleName = lex.getResourceBundleName();
            this.msgID = lex.getErrorCode();
            this.args = lex.getMessageArgs();
        }
    }

    public String getL10NMessage(Locale locale) {
        if (this.msgID == null) {
            return this.getMessage();
        }
        String result = this.msgID;
        if (this.bundleName != null && locale != null) {
            ResourceBundle bundle = this.amCache.getResBundle(this.bundleName, locale);
            result = bundle.getString(this.msgID);
            if (this.args != null && this.args.length != 0) {
                result = MessageFormat.format(result, this.args);
            }
        }
        return result;
    }

    public String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        return super.getMessage();
    }

    public Object[] getMessageArgs() {
        return this.args;
    }

    public String getErrorCode() {
        return this.msgID;
    }

    public String getResourceBundleName() {
        return this.bundleName;
    }
}

