/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.service.AuthException;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.AMResourceBundleCache;
import com.sun.identity.shared.locale.Locale;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;

public class CompositeAdvices {
    String indexName;
    String orgDN;
    private static AuthD ad = AuthD.getAuth();
    private static Debug debug = AuthD.debug;
    int numberOfModules = 0;
    Vector modList;
    String clientType = AuthUtils.getDefaultClientType();
    java.util.Locale userLocale;
    private static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    ResourceBundle rb = null;
    Map moduleMap = null;
    int type;

    public CompositeAdvices(String indexName, String orgDN, String clientType, java.util.Locale loc) throws AuthException {
        try {
            debug.message("in CompositeAdvices constructor");
            this.indexName = indexName;
            this.orgDN = orgDN;
            this.clientType = clientType;
            this.userLocale = loc;
            if (debug.messageEnabled()) {
                debug.message("indexName : " + indexName);
                debug.message("orgDN     : " + orgDN);
                debug.message("clientType: " + clientType);
                debug.message("userLocale: " + this.userLocale);
            }
            this.rb = amCache.getResBundle("amAuth", this.userLocale);
            Map authInstances = AuthUtils.processCompositeAdviceXML(indexName, orgDN, clientType);
            Set moduleInstances = null;
            if (authInstances.get("AuthenticateToRealmConditionAdvice") != null) {
                this.type = 1;
                moduleInstances = (Set)authInstances.get("AuthenticateToRealmConditionAdvice");
            } else if (authInstances.get("AuthenticateToServiceConditionAdvice") != null) {
                this.type = 2;
                moduleInstances = (Set)authInstances.get("AuthenticateToServiceConditionAdvice");
            } else if (authInstances.get("AuthSchemeConditionAdvice") != null) {
                this.type = 3;
                moduleInstances = (Set)authInstances.get("AuthSchemeConditionAdvice");
            }
            if (moduleInstances != null && !moduleInstances.isEmpty()) {
                this.getAuthModulesConfig(moduleInstances);
            }
            debug.message("end CompositeAdvices constructor");
        }
        catch (Exception e) {
            throw new AuthException(e);
        }
    }

    private void getAuthModulesConfig(Set returnModuleInstances) {
        this.modList = new Vector();
        this.moduleMap = new HashMap();
        int i = 0;
        Iterator iter = returnModuleInstances.iterator();
        while (iter.hasNext()) {
            String moduleName = (String)iter.next();
            String localizedName = this.getModuleLocalizedName(moduleName);
            this.moduleMap.put(localizedName, moduleName);
            this.modList.addElement(localizedName);
            ++i;
        }
        this.numberOfModules = i;
    }

    public int getNumberOfAuthModules() {
        return this.numberOfModules;
    }

    private String[] getModuleList() {
        String[] moduleList = new String[this.modList.size()];
        this.modList.copyInto(moduleList);
        return moduleList;
    }

    public String getModuleName() {
        Enumeration vList = this.modList.elements();
        return (String)this.moduleMap.get(vList.nextElement());
    }

    public Callback[] createChoiceCallback() throws AuthException {
        debug.message("In createChoiceCallback");
        String[] moduleList = this.getModuleList();
        Callback[] callbacks = new Callback[1];
        try {
            ChoiceCallback choiceCallback = new ChoiceCallback(Locale.getString((ResourceBundle)this.rb, (String)"modulePrompt", (Debug)debug), moduleList, 0, false);
            callbacks[0] = choiceCallback;
        }
        catch (IllegalArgumentException ie) {
            debug.error("Number of arguments not correct", (Throwable)ie);
            throw new AuthException("callbackError", null);
        }
        catch (Exception e) {
            debug.error("Error: ", (Throwable)e);
            throw new AuthException("callbackError", null);
        }
        if (debug.messageEnabled()) {
            debug.message("Callback is.. :" + callbacks[0]);
        }
        return callbacks;
    }

    protected String getModuleLocalizedName(String moduleName) {
        return Locale.getString((ResourceBundle)this.rb, (String)moduleName, (Debug)debug);
    }

    protected Map getModuleMap() {
        return this.moduleMap;
    }

    protected int getType() {
        return this.type;
    }
}

