/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.services.util.Crypt;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CLIRequest;
import com.sun.identity.cli.Debugger;
import com.sun.identity.cli.IDefinition;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.InitializeSystem;
import com.sun.identity.cli.OutputWriter;
import com.sun.identity.cli.SubCommand;
import com.sun.identity.cli.UsageFormatter;
import com.sun.identity.common.ShutdownManager;
import com.sun.identity.setup.Bootstrap;
import com.sun.identity.setup.ConfiguratorException;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.L10NMessage;
import com.sun.identity.tools.bundles.VersionCheck;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class CommandManager {
    private static final String IMPORT_SVC_CMD = "import-svc-cfg";
    private static final String RESOURCE_BUNDLE_NAME = "cliBase";
    public static ResourceBundle resourceBundle = ResourceBundle.getBundle("cliBase");
    private static Debug debugger;
    private ResourceBundle rbMessages;
    private Map environment;
    private String commandName;
    private String logName;
    private FileOutputStream statusOS;
    private IOutput outputWriter;
    private List definitionObjects;
    private List requestQueue = new Vector();
    private boolean bContinue;
    public static InitializeSystem initSys;
    private Set ssoTokens = new HashSet();

    public static void main(String[] argv) {
        if (argv.length > 0 && argv[0].equals(IMPORT_SVC_CMD)) {
            try {
                initSys = new InitializeSystem();
            }
            catch (FileNotFoundException ex) {
                System.err.println("Cannot bootstrap the system" + ex.getMessage());
                System.exit(1);
            }
            catch (IOException ex) {
                System.err.println("Cannot bootstrap the system" + ex.getMessage());
            }
            catch (LDAPServiceException ex) {
                System.err.println("Cannot bootstrap the system" + ex.getMessage());
            }
        } else {
            try {
                Bootstrap.load();
            }
            catch (ConfiguratorException ex) {
                System.err.println(ex.getL10NMessage(Locale.getDefault()));
                System.exit(1);
            }
            catch (Exception e) {
                System.err.println("Cannot bootstrap the system" + e.getMessage());
                System.exit(1);
            }
            if (VersionCheck.isVersionValid() == 1) {
                System.exit(1);
            }
        }
        debugger = Debug.getInstance((String)"amCLI");
        CommandManager.getIsInstallTime();
        Crypt.checkCaller();
        new CommandManager(argv);
    }

    public CommandManager(Map env) throws CLIException {
        this.init(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandManager(String[] argv) {
        int exitCode = 0;
        try {
            this.init(argv);
            this.requestQueue.add(new CLIRequest(null, argv));
            this.serviceRequestQueue();
        }
        catch (CLIException e) {
            String msg;
            Debugger.error(this, "CommandManager.<init>", e);
            String remainReq = null;
            if (!this.requestQueue.isEmpty()) {
                String[] arg = new String[]{Integer.toString(this.requestQueue.size())};
                remainReq = MessageFormat.format(this.rbMessages.getString("remaining-unprocessed-requests"), arg);
            }
            String string = msg = e instanceof L10NMessage ? ((L10NMessage)e).getL10NMessage(this.getLocale()) : e.getMessage();
            if (this.outputWriter != null) {
                this.outputWriter.printlnError(msg);
                if (remainReq != null) {
                    this.outputWriter.printlnError(remainReq);
                }
            } else {
                System.out.println(msg);
                if (remainReq != null) {
                    System.out.println(remainReq);
                }
            }
            this.printUsageOnException(e);
            exitCode = e.getExitCode();
        }
        finally {
            this.destroySSOTokens();
            ShutdownManager.getInstance().shutdown();
        }
        System.exit(exitCode);
    }

    private void printUsageOnException(CLIException e) {
        int exitCode = e.getExitCode();
        try {
            SubCommand cmd;
            String scmd;
            if (exitCode == 11 && (scmd = e.getSubcommandName()) != null && (cmd = this.getSubCommand(scmd)) != null) {
                UsageFormatter.getInstance().format(this, cmd);
            }
        }
        catch (CLIException ex) {
            debugger.error("CommandManager.printUsageOnException", (Throwable)ex);
        }
    }

    private void init(Map env) throws CLIException {
        String webEnabledURL;
        this.environment = new HashMap();
        Locale locale = (Locale)env.get("locale");
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.environment.put("locale", locale);
        try {
            this.rbMessages = ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME, locale);
        }
        catch (MissingResourceException e) {
            this.outputWriter.printlnError(e.getMessage());
            System.exit(1);
        }
        String defintionFiles = (String)env.get("definitionFiles");
        this.setupDefinitions(defintionFiles);
        this.commandName = (String)env.get("commandName");
        if (this.commandName == null || this.commandName.length() == 0) {
            throw new CLIException(this.rbMessages.getString("exception-message-missing-command-name"), 3);
        }
        this.outputWriter = (IOutput)env.get("outputWriter");
        if (this.outputWriter == null) {
            throw new CLIException("output writer is not defined.", 16);
        }
        if (env.get("debug") != null) {
            this.environment.put("debug", Boolean.TRUE);
        }
        if (env.get("verbose") != null) {
            this.environment.put("verbose", Boolean.TRUE);
        }
        if ((webEnabledURL = (String)env.get("webEnabledURL")) != null) {
            this.environment.put("webEnabledURL", webEnabledURL);
        }
        debugger = Debug.getInstance((String)"amCLI");
    }

    private void init(String[] argv) throws CLIException {
        this.environment = new HashMap();
        this.getLocale(argv);
        String defintionFiles = System.getProperty("definitionFiles");
        this.setupDefinitions(defintionFiles);
        this.commandName = System.getProperty("commandName");
        if (this.commandName == null || this.commandName.length() == 0) {
            throw new CLIException(this.rbMessages.getString("exception-message-missing-command-name"), 3);
        }
        String outputWriterClassName = System.getProperty("outputWriter");
        this.getOutputWriter(outputWriterClassName);
        if (CommandManager.getFlag(argv, "debug", "d")) {
            this.environment.put("debug", Boolean.TRUE);
        }
        if (CommandManager.getFlag(argv, "verbose", "v")) {
            this.environment.put("verbose", Boolean.TRUE);
        }
        if (CommandManager.getFlag(argv, "nolog", "O")) {
            this.environment.put("nolog", Boolean.TRUE);
        }
        debugger = Debug.getInstance((String)"amCLI");
    }

    private void setupDefinitions(String defintionFiles) throws CLIException {
        if (defintionFiles == null || defintionFiles.length() == 0) {
            throw new CLIException(this.rbMessages.getString("exception-message-missing-definition-class"), 2);
        }
        this.initDefinitions(defintionFiles);
    }

    private void initDefinitions(String definitionClassNames) throws CLIException {
        if (this.isVerbose()) {
            this.outputWriter.printlnMessage(this.rbMessages.getString("verbose-reading-definition-files"));
        }
        this.definitionObjects = new ArrayList();
        StringTokenizer st = new StringTokenizer(definitionClassNames, ",");
        while (st.hasMoreTokens()) {
            String className = st.nextToken();
            this.getDefinitionObject(className);
        }
    }

    private void getDefinitionObject(String className) throws CLIException {
        try {
            Class<?> clazz = Class.forName(className);
            IDefinition defClass = (IDefinition)clazz.newInstance();
            this.definitionObjects.add(defClass);
            this.logName = defClass.getLogName();
        }
        catch (ClassNotFoundException e) {
            Object[] param = new Object[]{className};
            String message = MessageFormat.format(this.rbMessages.getString("exception-message-definition-class-not-found"), param);
            throw new CLIException(message, 4);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            Object[] param = new Object[]{className};
            String message = MessageFormat.format(this.rbMessages.getString("exception-message-illegal-access-definition-class"), param);
            throw new CLIException(message, 8);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            Object[] param = new Object[]{className};
            String message = MessageFormat.format(this.rbMessages.getString("exception-message-instantiation-definition-class"), param);
            throw new CLIException(message, 7);
        }
        catch (ClassCastException e) {
            Object[] param = new Object[]{className};
            String message = MessageFormat.format(this.rbMessages.getString("exception-message-class-cast-definition-class"), param);
            throw new CLIException(message, 6);
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.rbMessages;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public void setStatusFileName(String statusFileName) throws CLIException {
        if (statusFileName != null && statusFileName.trim().length() > 0) {
            try {
                this.statusOS = new FileOutputStream(statusFileName);
            }
            catch (FileNotFoundException ex) {
                throw new CLIException(ex, 127);
            }
        }
    }

    public List getDefinitionObjects() {
        return this.definitionObjects;
    }

    public boolean isLogOff() {
        return this.environment.get("nolog") != null;
    }

    public String getLogName() {
        return this.logName;
    }

    public Locale getLocale() {
        return (Locale)this.environment.get("locale");
    }

    public boolean isVerbose() {
        return this.environment.get("verbose") != null;
    }

    public boolean isDebugOn() {
        return this.environment.get("debug") != null;
    }

    static Debug getDebugger() {
        return debugger;
    }

    public IOutput getOutputWriter() {
        return this.outputWriter;
    }

    public SubCommand getSubCommand(String name) {
        SubCommand subcmd = null;
        Iterator i = this.definitionObjects.iterator();
        while (i.hasNext() && subcmd == null) {
            IDefinition def = (IDefinition)i.next();
            subcmd = def.getSubCommand(name);
        }
        return subcmd;
    }

    public String getProductName() {
        String productName = "";
        if (this.definitionObjects != null && !this.definitionObjects.isEmpty()) {
            IDefinition def = (IDefinition)this.definitionObjects.get(this.definitionObjects.size() - 1);
            productName = def.getProductName();
        }
        return productName;
    }

    private void getOutputWriter(String className) throws CLIException {
        try {
            this.outputWriter = className == null || className.length() == 0 ? (IOutput)OutputWriter.class.newInstance() : (IOutput)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String[] param = new String[]{className};
            String msg = "Cannot construct output writer {0}.";
            throw new CLIException(MessageFormat.format(msg, param), 16);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serviceRequestQueue() throws CLIException {
        if (this.isVerbose()) {
            this.outputWriter.printlnMessage(this.rbMessages.getString("verbose-processing-request"));
        }
        block11: while (true) {
            try {
                while (!this.requestQueue.isEmpty()) {
                    CLIRequest req = (CLIRequest)this.requestQueue.remove(0);
                    try {
                        req.process(this);
                        if (this.statusOS == null) continue block11;
                        String status = CommandManager.formatStatus(req.getOptions(), 0);
                        this.statusOS.write(status.getBytes());
                        continue block11;
                    }
                    catch (CLIException e) {
                        if (this.isVerbose()) {
                            e.printStackTrace(System.out);
                        }
                        if (this.statusOS != null) {
                            String status = CommandManager.formatStatus(req.getOptions(), e.getExitCode());
                            this.statusOS.write(status.getBytes());
                        }
                        if (!this.bContinue) throw e;
                        this.outputWriter.printlnError(e.getMessage());
                        continue;
                        return;
                    }
                }
            }
            catch (IOException e) {
                throw new CLIException(e, 127);
            }
        }
        finally {
            if (this.statusOS != null) {
                try {
                    this.statusOS.close();
                }
                catch (IOException ex) {}
                this.statusOS = null;
            }
        }
    }

    private static String formatStatus(String[] options, int exitCode) {
        String strCode = Integer.toString(exitCode);
        if (exitCode < 10) {
            strCode = "  " + strCode;
        } else if (exitCode < 100) {
            strCode = " " + strCode;
        }
        StringBuffer buff = new StringBuffer();
        buff.append(strCode).append(" ");
        for (int i = 0; i < options.length; ++i) {
            buff.append(options[i]).append(" ");
        }
        return buff.toString() + "\n";
    }

    private static boolean getFlag(String[] argv, String longName, String shortName) throws CLIException {
        boolean flag = false;
        for (int i = 0; i < argv.length && !flag; ++i) {
            String str;
            String s = argv[i];
            if (!s.equals("--" + longName) && !s.equals("-" + shortName)) continue;
            flag = true;
            int nextIdx = i + 1;
            if (nextIdx >= argv.length || (str = argv[nextIdx]).startsWith("-")) continue;
            throw new CLIException("Incorrect " + longName + " option.", 11);
        }
        return flag;
    }

    private void getLocale(String[] argv) throws CLIException {
        Locale locale = null;
        for (int i = 0; i < argv.length && locale == null; ++i) {
            String s = argv[i];
            if (!s.equals("--locale") && !s.equals("-l")) continue;
            int nextIdx = i + 1;
            if (nextIdx >= argv.length) {
                throw new CLIException("Incorrect locale option.", 11);
            }
            String strLocale = argv[nextIdx];
            if (strLocale.startsWith("-")) {
                throw new CLIException("Incorrect locale option.", 11);
            }
            locale = CommandManager.getLocale(strLocale);
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.environment.put("locale", locale);
        try {
            this.rbMessages = ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME, locale);
        }
        catch (MissingResourceException e) {
            this.outputWriter.printlnError(e.getMessage());
            System.exit(1);
        }
    }

    private static Locale getLocale(String strLocale) {
        StringTokenizer st = new StringTokenizer(strLocale, "_");
        String lang = st.hasMoreTokens() ? st.nextToken() : "";
        String country = st.hasMoreTokens() ? st.nextToken() : "";
        String variant = st.hasMoreTokens() ? st.nextToken() : "";
        return new Locale(lang, country, variant);
    }

    private static void getIsInstallTime() {
        String strInstallTime = System.getProperty("installTime");
        if (strInstallTime != null && strInstallTime.trim().length() > 0 && strInstallTime.trim().toLowerCase().equals("true")) {
            SystemProperties.initializeProperties("com.sun.identity.security.amadmin", "true");
        }
    }

    public void setContinueFlag(boolean bContinue) {
        this.bContinue = bContinue;
    }

    public void addToRequestQueue(CLIRequest request) {
        this.requestQueue.add(request);
    }

    public String getWebEnabledURL() {
        return (String)this.environment.get("webEnabledURL");
    }

    public boolean webEnabled() {
        String url = this.getWebEnabledURL();
        return url != null && url.length() > 0;
    }

    public void registerSSOToken(SSOToken ssoToken) {
        this.ssoTokens.add(ssoToken);
    }

    private void destroySSOTokens() {
        try {
            SSOTokenManager mgr = SSOTokenManager.getInstance();
            Iterator i = this.ssoTokens.iterator();
            while (i.hasNext()) {
                SSOToken token = (SSOToken)i.next();
                mgr.destroyToken(token);
            }
        }
        catch (SSOException e) {
            Debugger.error(this, "CommandManager.destroySSOTokens", (Throwable)((Object)e));
        }
    }
}

