/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class FormatUtils {
    public static final String SPACE = "    ";
    public static final String MASKED_PWD = "********";

    private FormatUtils() {
    }

    public static String printServiceNames(Set serviceNames, String template, SSOToken ssoToken) throws SMSException, SSOException {
        StringBuffer buff = new StringBuffer();
        String[] arg = new String[1];
        if (serviceNames != null) {
            Iterator i = serviceNames.iterator();
            while (i.hasNext()) {
                String i18nKey;
                SchemaType type;
                ServiceSchema schema;
                String serviceName = (String)i.next();
                ServiceSchemaManager mgr = new ServiceSchemaManager(serviceName, ssoToken);
                Set types = mgr.getSchemaTypes();
                if (types.isEmpty() || (schema = mgr.getSchema(type = (SchemaType)types.iterator().next())) == null || (i18nKey = schema.getI18NKey()) == null || i18nKey.length() <= 0) continue;
                arg[0] = serviceName;
                buff.append(MessageFormat.format(template, arg)).append("\n");
            }
        }
        return buff.toString();
    }

    public static String printAttributeValues(String template, Map attributeValues, Set passwords) {
        HashMap map = new HashMap(attributeValues.size() * 2);
        HashSet<String> setPwd = new HashSet<String>(2);
        setPwd.add(MASKED_PWD);
        Iterator i = attributeValues.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Object key = entry.getKey();
            if (passwords.contains(key)) {
                map.put(key, setPwd);
                continue;
            }
            map.put(key, (HashSet<Object>)entry.getValue());
        }
        return FormatUtils.printAttributeValues(template, map);
    }

    public static String printAttributeValues(String template, Map attributeValues) {
        StringBuffer buff = new StringBuffer();
        if (attributeValues != null) {
            String[] args = new String[2];
            Iterator i = attributeValues.keySet().iterator();
            while (i.hasNext()) {
                String name;
                args[0] = name = (String)i.next();
                Set values = (Set)attributeValues.get(name);
                if (values.isEmpty()) {
                    args[1] = "";
                    buff.append(MessageFormat.format(template, args)).append("\n");
                    continue;
                }
                Iterator j = values.iterator();
                while (j.hasNext()) {
                    args[1] = (String)j.next();
                    buff.append(MessageFormat.format(template, args)).append("\n");
                }
            }
        }
        return buff.toString();
    }

    public static String formatProperties(Map prop) {
        StringBuffer buff = new StringBuffer();
        if (prop != null) {
            TreeSet<String> sorted = new TreeSet<String>();
            Iterator<Object> i = prop.keySet().iterator();
            while (i.hasNext()) {
                sorted.add((String)i.next());
            }
            i = sorted.iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                String value = (String)prop.get(key);
                buff.append(key).append("=").append(value).append("\n");
            }
        }
        return buff.toString();
    }

    public static String formatMap(String keyLabel, String propLabel, Map map) {
        StringBuffer buff = new StringBuffer();
        int szColKey = keyLabel.length();
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            szColKey = Math.max(szColKey, key.length());
        }
        int szColProp = propLabel.length();
        Iterator<Object> i2 = map.values().iterator();
        while (i2.hasNext()) {
            String val = (String)i2.next();
            szColProp = Math.max(szColProp, val.length());
        }
        buff.append(FormatUtils.padString(keyLabel, szColKey)).append(" ").append(propLabel).append("\n");
        buff.append(FormatUtils.padString("-", "-", szColKey)).append(" ").append(FormatUtils.padString("-", "-", szColProp)).append("\n");
        i2 = map.keySet().iterator();
        while (i2.hasNext()) {
            String key = (String)i2.next();
            String prop = (String)map.get(key);
            buff.append(FormatUtils.padString(key, szColKey)).append(" ").append(FormatUtils.padString(prop, szColProp)).append("\n");
        }
        return buff.toString();
    }

    private static String padString(String str, int pad) {
        return FormatUtils.padString(str, " ", pad);
    }

    private static String padString(String str, String padStr, int pad) {
        for (int i = str.length(); i < pad; ++i) {
            str = str + padStr;
        }
        return str;
    }
}

