/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.agentconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.common.DisplayUtils;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class ListAgents
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String realm = this.getStringOptionValue("realm");
        String patternType = this.getStringOptionValue("agenttype");
        String filter = this.getStringOptionValue("filter");
        if (patternType == null) {
            patternType = "";
        }
        if (filter == null || filter.length() == 0) {
            filter = "*";
        }
        String[] params = new String[]{realm, patternType, filter};
        this.writeLog(0, Level.INFO, "ATTEMPT_LIST_AGENTS", params);
        try {
            AMIdentity amid;
            Iterator i;
            AMIdentityRepository amir = new AMIdentityRepository(adminSSOToken, realm);
            IdSearchResults isr = amir.searchIdentities(IdType.AGENTONLY, filter, new IdSearchControl());
            Set results = isr.getSearchResults();
            if (results != null && !results.isEmpty()) {
                i = results.iterator();
                while (i.hasNext()) {
                    amid = (AMIdentity)i.next();
                    if (this.matchType(amid, patternType)) continue;
                    i.remove();
                }
            }
            if (results != null && !results.isEmpty()) {
                i = results.iterator();
                while (i.hasNext()) {
                    amid = (AMIdentity)i.next();
                    Object[] args = new Object[]{amid.getName(), amid.getUniversalId()};
                    outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("format-search-agent-results"), args));
                }
            } else {
                outputWriter.printlnMessage(this.getResourceString("search-agent-no-entries"));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_LIST_AGENTS", params);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, patternType, filter, e.getMessage()};
            this.debugError("ListAgents.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_LIST_AGENTS", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, patternType, filter, e.getMessage()};
            this.debugError("ListAgents.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_LIST_AGENTS", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }

    private boolean matchType(AMIdentity amid, String pattern) throws IdRepoException, SSOException {
        Map attrValues;
        Set set;
        boolean matched;
        boolean bl = matched = pattern.length() == 0;
        if (!matched && (set = (Set)(attrValues = amid.getAttributes()).get("AgentType")) != null && !set.isEmpty()) {
            String t = (String)set.iterator().next();
            matched = DisplayUtils.wildcardMatch(t, pattern);
        }
        return matched;
    }
}

