/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.authentication;

import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.config.AMAuthenticationManager;
import com.sun.identity.authentication.config.AMAuthenticationSchema;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.log.Level;

public class CreateAuthInstance
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        String name = this.getStringOptionValue("name");
        String type = this.getStringOptionValue("authtype");
        String[] params = new String[]{realm, name, type};
        this.writeLog(0, Level.INFO, "ATTEMPT_CREATE_AUTH_INSTANCE", params);
        try {
            AMAuthenticationManager mgr = new AMAuthenticationManager(adminSSOToken, realm);
            AMAuthenticationSchema as = mgr.getAuthenticationSchema(type);
            mgr.createAuthenticationInstance(name, type, as.getAttributeValues());
            this.getOutputWriter().printlnMessage(this.getResourceString("authentication-created-auth-instance-succeeded"));
            this.writeLog(0, Level.INFO, "SUCCEEDED_CREATE_AUTH_INSTANCE", params);
        }
        catch (AMConfigurationException e) {
            this.debugError("CreateAuthInstance.handleRequest", (Throwable)((Object)e));
            this.writeLog(0, Level.INFO, "FAILED_CREATE_AUTH_INSTANCE", params);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

