/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.authentication;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.config.AMAuthenticationInstance;
import com.sun.identity.authentication.config.AMAuthenticationManager;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.authentication.config.AuthConfigurationEntry;
import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CommandManager;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.log.Level;
import com.sun.identity.sm.SMSException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class UpdateAuthConfigurationEntries
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        String configName = this.getStringOptionValue("name");
        String datafile = this.getStringOptionValue("datafile");
        List listEntries = rc.getOption("entries");
        if (datafile == null && listEntries == null) {
            throw new CLIException(this.getResourceString("authentication-set-auth-config-entries-missing-data"), 11, rc.getSubCommand().getName());
        }
        String[] params = new String[]{realm, configName};
        this.writeLog(0, Level.INFO, "ATTEMPT_SET_AUTH_CONFIG_ENTRIES", params);
        try {
            List entries = this.parse(datafile, listEntries);
            this.validateEntries(realm, adminSSOToken, entries, params);
            HashMap configData = new HashMap(2);
            HashSet<String> tmp = new HashSet<String>(2);
            String xml = AMAuthConfigUtils.authConfigurationEntryToXMLString(entries);
            tmp.add(xml);
            configData.put("iplanet-am-auth-configuration", tmp);
            IOutput outputWriter = this.getOutputWriter();
            AMAuthConfigUtils.replaceNamedConfig(configName, 0, configData, realm, adminSSOToken);
            outputWriter.printlnMessage(this.getResourceString("authentication-set-auth-config-entries-succeeded"));
            this.writeLog(0, Level.INFO, "SUCCEEDED_SET_AUTH_CONFIG_ENTRIES", params);
        }
        catch (AMConfigurationException e) {
            this.debugError("GetAuthConfigurationEntries.handleRequest", (Throwable)((Object)e));
            this.writeLog(0, Level.INFO, "FAILED_SET_AUTH_CONFIG_ENTRIES", params);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            this.debugError("GetAuthConfigurationEntries.handleRequest", e);
            this.writeLog(0, Level.INFO, "FAILED_SET_AUTH_CONFIG_ENTRIES", params);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            this.debugError("GetAuthConfigurationEntries.handleRequest", (Throwable)((Object)e));
            this.writeLog(0, Level.INFO, "FAILED_SET_AUTH_CONFIG_ENTRIES", params);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }

    private void validateEntries(String realm, SSOToken adminSSOToken, List entries, String[] params) throws CLIException {
        if (entries != null && !entries.isEmpty()) {
            Set instanceNames = this.getInstanceNames(realm, adminSSOToken, params);
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                AuthConfigurationEntry token = (AuthConfigurationEntry)i.next();
                String instanceName = token.getLoginModuleName();
                if (instanceNames.contains(instanceName)) continue;
                Object[] p = new Object[]{instanceName};
                throw new CLIException(MessageFormat.format(this.getResourceString("authentication-set-auth-config-entries-instance-not-found"), p), 127);
            }
        }
    }

    private Set getInstanceNames(String realm, SSOToken adminSSOToken, String[] params) throws CLIException {
        HashSet<String> names = new HashSet<String>();
        try {
            AMAuthenticationManager mgr = new AMAuthenticationManager(adminSSOToken, realm);
            Set instances = mgr.getAuthenticationInstances();
            Iterator i = instances.iterator();
            while (i.hasNext()) {
                AMAuthenticationInstance instance = (AMAuthenticationInstance)i.next();
                names.add(instance.getName());
            }
        }
        catch (AMConfigurationException e) {
            this.debugError("ListAuthInstances.handleRequest", (Throwable)((Object)e));
            this.writeLog(0, Level.INFO, "FAILED_SET_AUTH_CONFIG_ENTRIES", params);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        return names;
    }

    private List parse(String fileName, List listEntries) throws CLIException, AMConfigurationException {
        CommandManager mgr = this.getCommandManager();
        List results = null;
        if (fileName != null) {
            results = this.parse(mgr, fileName);
        }
        if (listEntries != null && !listEntries.isEmpty()) {
            if (results != null) {
                results.addAll(this.parse(mgr, listEntries));
            } else {
                results = this.parse(mgr, listEntries);
            }
        }
        return results == null ? new ArrayList() : results;
    }

    private List parse(CommandManager mgr, String fileName) throws CLIException, AMConfigurationException {
        BufferedReader in = null;
        ArrayList<AuthConfigurationEntry> entries = new ArrayList<AuthConfigurationEntry>();
        try {
            in = new BufferedReader(new FileReader(fileName));
            String line = in.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0) {
                    entries.add(this.getAuthConfigurationEntry(mgr, line));
                }
                line = in.readLine();
            }
        }
        catch (IOException e) {
            throw new CLIException(e, 24);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return entries;
    }

    private List parse(CommandManager mgr, List list) throws CLIException, AMConfigurationException {
        ArrayList<AuthConfigurationEntry> entries = new ArrayList<AuthConfigurationEntry>();
        if (list != null && !list.isEmpty()) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                String s = ((String)i.next()).trim();
                if (s.length() <= 0) continue;
                entries.add(this.getAuthConfigurationEntry(mgr, s));
            }
        }
        return entries;
    }

    private AuthConfigurationEntry getAuthConfigurationEntry(CommandManager mgr, String str) throws CLIException, AMConfigurationException {
        System.out.println(str);
        StringTokenizer st = new StringTokenizer(str, "|");
        if (st.countTokens() < 2) {
            throw AttributeValues.createIncorrectFormatException(mgr, str);
        }
        String name = st.nextToken();
        String flag = st.nextToken();
        String options = st.countTokens() > 0 ? st.nextToken() : null;
        return new AuthConfigurationEntry(name, flag, options);
    }
}

