/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.datastore;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.log.Level;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CreateDataStore
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        String name = this.getStringOptionValue("name");
        String type = this.getStringOptionValue("datatype");
        String datafile = this.getStringOptionValue("datafile");
        List listValues = rc.getOption("attributevalues");
        if (datafile == null && listValues == null) {
            throw new CLIException(this.getResourceString("datastore-create-datastore-missing-data"), 11, rc.getSubCommand().getName());
        }
        Map attributeValues = AttributeValues.parse(this.getCommandManager(), datafile, listValues);
        String[] params = new String[]{realm, name, type};
        this.writeLog(0, Level.INFO, "ATTEMPT_CREATE_DATASTORE", params);
        try {
            ServiceConfigManager svcCfgMgr = new ServiceConfigManager("sunIdentityRepositoryService", adminSSOToken);
            ServiceConfig cfg = svcCfgMgr.getOrganizationConfig(realm, null);
            if (cfg == null) {
                OrganizationConfigManager orgCfgMgr = new OrganizationConfigManager(adminSSOToken, realm);
                Map attrValues = this.getDefaultAttributeValues(adminSSOToken);
                cfg = orgCfgMgr.addServiceConfig("sunIdentityRepositoryService", attrValues);
            }
            cfg.addSubConfig(name, type, 0, attributeValues);
            this.getOutputWriter().printlnMessage(this.getResourceString("datastore-create-datastore-succeeded"));
            this.writeLog(0, Level.INFO, "SUCCEEDED_CREATE_DATASTORE", params);
        }
        catch (SMSException e) {
            this.debugError("CreateDataStore.handleRequest", e);
            this.writeLog(0, Level.INFO, "FAILED_CREATE_DATASTORE", params);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            this.debugError("CreateDataStore.handleRequest", (Throwable)((Object)e));
            this.writeLog(0, Level.INFO, "FAILED_CREATE_DATASTORE", params);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }

    private Map getDefaultAttributeValues(SSOToken adminSSOToken) throws SMSException, SSOException {
        ServiceSchemaManager schemaMgr = new ServiceSchemaManager("sunIdentityRepositoryService", adminSSOToken);
        ServiceSchema orgSchema = schemaMgr.getOrganizationSchema();
        Set attrs = orgSchema.getAttributeSchemas();
        HashMap<String, Set> values = new HashMap<String, Set>(attrs.size() * 2);
        Iterator iter = attrs.iterator();
        while (iter.hasNext()) {
            AttributeSchema as = (AttributeSchema)iter.next();
            values.put(as.getName(), as.getDefaultValues());
        }
        return values;
    }
}

