/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.sso.SSOException;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.schema.SchemaCommand;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import java.text.MessageFormat;
import java.util.logging.Level;

public class SetAttributeSchemaBooleanValues
extends SchemaCommand {
    static final String ARGUMENT_TRUE_VALUE = "truevalue";
    static final String ARGUMENT_FALSE_VALUE = "falsevalue";
    static final String ARGUMENT_TRUE_I18N_KEY = "truei18nkey";
    static final String ARGUMENT_FALSE_I18N_KEY = "falsei18nkey";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        String schemaType = this.getStringOptionValue("schematype");
        String serviceName = this.getStringOptionValue("servicename");
        String subSchemaName = this.getStringOptionValue("subschemaname");
        String attributeName = this.getStringOptionValue("attributename");
        String trueValue = this.getStringOptionValue(ARGUMENT_TRUE_VALUE);
        String trueI18nKey = this.getStringOptionValue(ARGUMENT_TRUE_I18N_KEY);
        String falseValue = this.getStringOptionValue(ARGUMENT_FALSE_VALUE);
        String falseI18nKey = this.getStringOptionValue(ARGUMENT_FALSE_I18N_KEY);
        ServiceSchema ss = this.getServiceSchema();
        IOutput outputWriter = this.getOutputWriter();
        String[] params = new String[]{serviceName, schemaType, subSchemaName, attributeName};
        this.writeLog(0, Level.INFO, "ATTEMPT_SET_ATTRIBUTE_SCHEMA_BOOLEAN_VALUES", params);
        try {
            AttributeSchema attrSchema = ss.getAttributeSchema(attributeName);
            attrSchema.setBooleanValues(trueValue, trueI18nKey, falseValue, falseI18nKey);
            this.writeLog(0, Level.INFO, "SUCCEED_SET_ATTRIBUTE_SCHEMA_BOOLEAN_VALUES", params);
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("attribute-schema-set-boolean-values-succeed"), params));
        }
        catch (SSOException e) {
            String[] args = new String[]{serviceName, schemaType, subSchemaName, attributeName, e.getMessage()};
            this.debugError("SetAttributeSchemaBooleanValues.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_SET_ATTRIBUTE_SCHEMA_BOOLEAN_VALUES", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serviceName, schemaType, subSchemaName, attributeName, e.getMessage()};
            this.debugError("SetAttributeSchemaBooleanValues.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_SET_ATTRIBUTE_SCHEMA_BOOLEAN_VALUES", args);
            throw new CLIException(e, 127);
        }
    }
}

