/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.serverconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.sm.SMSException;
import java.text.MessageFormat;
import java.util.logging.Level;

public class DeleteServer
extends AuthenticatedCommand {
    private static final String SERVER_CONFIG_XML_FILE = "serverconfigxml";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String serverName = this.getStringOptionValue("servername");
        String[] params = new String[]{serverName};
        try {
            if (ServerConfiguration.isLegacy(adminSSOToken)) {
                outputWriter.printMessage(this.getResourceString("serverconfig-no-supported"));
                return;
            }
            this.writeLog(0, Level.INFO, "ATTEMPT_DELETE_SERVER", params);
            if (ServerConfiguration.isServerInstanceExist(adminSSOToken, serverName)) {
                ServerConfiguration.deleteServerInstance(adminSSOToken, serverName);
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("delete-server-config-succeeded"), params));
            } else {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("delete-server-config-dont-exists"), params));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_DELETE_SERVER", params);
        }
        catch (SSOException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("DeleteServer.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_DELETE_SERVER", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("DeleteServer.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_DELETE_SERVER", args);
            throw new CLIException(e, 127);
        }
    }
}

