/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.serverconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CLIUtil;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.sm.SMSException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;

public class GetServerConfigXML
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String serverName = this.getStringOptionValue("servername");
        String outfile = this.getStringOptionValue("outfile");
        IOutput outputWriter = this.getOutputWriter();
        try {
            if (ServerConfiguration.isLegacy(adminSSOToken)) {
                outputWriter.printMessage(this.getResourceString("serverconfig-no-supported"));
                return;
            }
            String[] params = new String[]{serverName};
            this.writeLog(0, Level.INFO, "ATTEMPT_GET_SERVER_CONFIG_XML", params);
            String xml = ServerConfiguration.getServerConfigXML(adminSSOToken, serverName);
            if (xml != null && xml.length() > 0) {
                if (outfile != null && outfile.length() > 0) {
                    CLIUtil.writeToFile(outfile, xml);
                } else {
                    outputWriter.printlnMessage(xml);
                }
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("get-serverconfig-xml-succeeded"), params));
            } else {
                outputWriter.printlnMessage(this.getResourceString("get-server-config-xml-no-result-no-results"));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_GET_SERVER_CONFIG_XML", params);
        }
        catch (IOException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("GetServerConfigXML.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_GET_SERVER_CONFIG_XML", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("GetServerConfigXML.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_GET_SERVER_CONFIG_XML", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("GetServerConfigXML.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_GET_SERVER_CONFIG_XML", args);
            throw new CLIException(e, 127);
        }
    }
}

