/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.serverconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.sm.SMSException;
import java.io.IOException;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ImportServer
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String serverName = this.getStringOptionValue("servername");
        String xmlFile = this.getStringOptionValue("xmlfile");
        String[] params = new String[]{serverName};
        try {
            if (ServerConfiguration.isLegacy(adminSSOToken)) {
                outputWriter.printMessage(this.getResourceString("serverconfig-no-supported"));
                return;
            }
            this.writeLog(0, Level.INFO, "ATTEMPT_IMPORT_SERVER", params);
            if (!ServerConfiguration.isServerInstanceExist(adminSSOToken, serverName)) {
                ServerConfiguration.importServerInstance(adminSSOToken, serverName, xmlFile);
                outputWriter.printlnMessage(this.getResourceString("import-server-succeeded"));
            } else {
                outputWriter.printlnMessage(this.getResourceString("import-server-already-exists"));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_IMPORT_SERVER", params);
        }
        catch (ConfigurationException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("CreateServer.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_IMPORT_SERVER", args);
            throw new CLIException(e, 127);
        }
        catch (ParserConfigurationException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("CreateServer.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_IMPORT_SERVER", args);
            throw new CLIException(e, 127);
        }
        catch (SAXException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("CreateServer.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_IMPORT_SERVER", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("CreateServer.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_IMPORT_SERVER", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (IOException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("CreateServer.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_IMPORT_SERVER", args);
            throw new CLIException(e, 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("CreateServer.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_IMPORT_SERVER", args);
            throw new CLIException(e, 127);
        }
    }
}

