/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common.configuration;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.FQDNUrl;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AgentConfiguration {
    public static final String AGENT_TYPE_J2EE = "J2EEAgent";
    public static final String AGENT_TYPE_WEB = "WebAgent";
    public static final String AGENT_TYPE_2_DOT_2_AGENT = "2.2_Agent";
    public static final String ATTR_NAME_PWD = "userpassword";
    public static final String ATTR_NAME_FREE_FORM = "com.sun.identity.agents.config.freeformproperties";
    public static final String ATTR_CONFIG_REPO = "com.sun.identity.agents.config.repository.location";
    public static final String VAL_CONFIG_REPO_LOCAL = "local";
    private static final String AGENT_LOCAL_PROPERTIES = "agentlocaleprop";
    private static Map localAgentProperties;
    private static final Pattern patternArray;

    private AgentConfiguration() {
    }

    public static Set getAgentTypes() throws SMSException, SSOException {
        Set names;
        HashSet agentTypes = new HashSet();
        ServiceSchema ss = AgentConfiguration.getOrganizationSchema();
        if (ss != null && (names = ss.getSubSchemaNames()) != null && !names.isEmpty()) {
            agentTypes.addAll(names);
        }
        return agentTypes;
    }

    private static void validateAgentType(String type) throws ConfigurationException {
        AgentConfiguration.validateAgentType(type, false);
    }

    private static void validateAgentType(String type, boolean isGroup) throws ConfigurationException {
        try {
            Set types = AgentConfiguration.getAgentTypes();
            if (isGroup) {
                types.remove(AGENT_TYPE_2_DOT_2_AGENT);
            }
            if (!types.contains(type)) {
                Object[] param = new Object[]{type};
                throw new ConfigurationException("agent.invalid.type", param);
            }
        }
        catch (SMSException e) {
            throw new ConfigurationException(e.getMessage());
        }
        catch (SSOException e) {
            throw new ConfigurationException(e.getMessage());
        }
    }

    public static void createAgentGroup(SSOToken ssoToken, String realm, String agentGroupName, String agentType, Map attrValues) throws IdRepoException, SSOException, SMSException, ConfigurationException {
        AgentConfiguration.createAgentGroupEx(ssoToken, realm, agentGroupName, agentType, attrValues, null, null);
    }

    public static void createAgentGroup(SSOToken ssoToken, String realm, String agentGroupName, String agentType, Map attrValues, String serverURL, String agentURL) throws IdRepoException, SSOException, SMSException, MalformedURLException, ConfigurationException {
        if (serverURL == null || serverURL.trim().length() == 0) {
            throw new ConfigurationException("create.agent.invalid.server.url", null);
        }
        FQDNUrl urlAgent = null;
        if (agentURL != null && agentURL.trim().length() > 0) {
            urlAgent = new FQDNUrl(agentURL);
        }
        AgentConfiguration.createAgentGroupEx(ssoToken, realm, agentGroupName, agentType, attrValues, new FQDNUrl(serverURL), urlAgent);
    }

    private static void createAgentGroupEx(SSOToken ssoToken, String realm, String agentGroupName, String agentType, Map attrValues, FQDNUrl serverURL, FQDNUrl agentURL) throws IdRepoException, SSOException, SMSException, ConfigurationException {
        AgentConfiguration.validateAgentType(agentType, true);
        AMIdentityRepository amir = new AMIdentityRepository(ssoToken, realm);
        Map attributeValues = AgentConfiguration.parseAttributeMap(agentType, attrValues);
        if (attributeValues.containsKey(ATTR_NAME_PWD)) {
            throw new ConfigurationException("create.agent.group.cannot.have.password", null);
        }
        HashSet<String> setAgentType = new HashSet<String>(2);
        setAgentType.add(agentType);
        attributeValues.put("AgentType", setAgentType);
        Map inheritedValues = AgentConfiguration.getDefaultValues(agentType, true);
        inheritedValues.putAll(attributeValues);
        if (serverURL != null || agentURL != null) {
            AgentConfiguration.tagswapAttributeValues(inheritedValues, agentType, serverURL, agentURL);
        }
        amir.createIdentity(IdType.AGENTGROUP, agentGroupName, inheritedValues);
    }

    public static void createAgent(SSOToken ssoToken, String realm, String agentName, String agentType, Map attrValues, String serverURL, String agentURL) throws IdRepoException, SSOException, SMSException, MalformedURLException, ConfigurationException {
        if (serverURL == null || serverURL.trim().length() == 0) {
            throw new ConfigurationException("create.agent.invalid.server.url", null);
        }
        if (agentURL == null || agentURL.trim().length() == 0) {
            throw new ConfigurationException("create.agent.invalid.agent.url", null);
        }
        AgentConfiguration.createAgentEx(ssoToken, realm, agentName, agentType, attrValues, new FQDNUrl(serverURL), new FQDNUrl(agentURL));
    }

    public static void createAgent(SSOToken ssoToken, String realm, String agentName, String agentType, Map attrValues) throws IdRepoException, SSOException, SMSException, ConfigurationException {
        AgentConfiguration.createAgentEx(ssoToken, realm, agentName, agentType, attrValues, null, null);
    }

    private static void createAgentEx(SSOToken ssoToken, String realm, String agentName, String agentType, Map attrValues, FQDNUrl serverURL, FQDNUrl agentURL) throws IdRepoException, SSOException, SMSException, ConfigurationException {
        AgentConfiguration.validateAgentType(agentType);
        AMIdentityRepository amir = new AMIdentityRepository(ssoToken, realm);
        Map attributeValues = AgentConfiguration.parseAttributeMap(agentType, attrValues);
        HashSet<String> setAgentType = new HashSet<String>(2);
        setAgentType.add(agentType);
        attributeValues.put("AgentType", setAgentType);
        Map inheritedValues = AgentConfiguration.getDefaultValues(agentType, false);
        inheritedValues.putAll(attributeValues);
        if (serverURL != null || agentURL != null) {
            AgentConfiguration.tagswapAttributeValues(inheritedValues, agentType, serverURL, agentURL);
        }
        amir.createIdentity(IdType.AGENTONLY, agentName, inheritedValues);
    }

    private static void tagswapAttributeValues(Map attributeValues, String agentType, FQDNUrl serverURL, FQDNUrl agentURL) throws ConfigurationException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (serverURL != null) {
            if (!serverURL.isValid()) {
                throw new ConfigurationException("create.agent.invalid.server.url", null);
            }
            if (!serverURL.isFullyQualified()) {
                throw new ConfigurationException("create.agent.server.url.not.fqdn", null);
            }
            String uri = serverURL.getURI();
            if (uri.length() == 0) {
                throw new ConfigurationException("create.agent.invalid.server.url.missing.uri", null);
            }
            String port = serverURL.getPort();
            if (port.equals("-1")) {
                throw new ConfigurationException("create.agent.invalid.server.url.missing.port", null);
            }
            map.put("SERVER_PROTO", serverURL.getProtocol());
            map.put("SERVER_HOST", serverURL.getHost());
            map.put("SERVER_PORT", port);
            map.put("AM_SERVICES_DEPLOY_URI", uri);
        }
        if (agentURL != null) {
            String uri;
            String port = agentURL.getPort();
            map.put("AGENT_PROTO", agentURL.getProtocol());
            map.put("AGENT_HOST", agentURL.getHost());
            map.put("AGENT_PORT", port);
            if (agentType.equals(AGENT_TYPE_J2EE)) {
                if (!agentURL.isValid()) {
                    throw new ConfigurationException("create.agent.invalid.agent.url", null);
                }
                if (!agentURL.isFullyQualified()) {
                    throw new ConfigurationException("create.agent.invalid.agent.url", null);
                }
                uri = agentURL.getURI();
                if (uri.length() == 0) {
                    throw new ConfigurationException("create.agent.invalid.agent.url.missing.uri", null);
                }
                map.put("AGENT_APP_URI", uri);
                String logFileName = agentURL.getHost();
                logFileName = "amAgent_" + logFileName.replaceAll("\\.", "_") + "_" + port + ".log";
                map.put("AUDIT_LOG_FILENAME", logFileName);
            } else if (agentType.equals(AGENT_TYPE_WEB)) {
                uri = agentURL.getURI();
                if (uri.length() > 0) {
                    throw new ConfigurationException("create.agent.invalid.agent.url.uri.not.required", null);
                }
                map.put("AGENT_APP_URI", uri);
            }
        }
        Iterator i = attributeValues.keySet().iterator();
        while (i.hasNext()) {
            String attrName = (String)i.next();
            Set values = (Set)attributeValues.get(attrName);
            HashSet<String> newValues = new HashSet<String>(values.size() * 2);
            Iterator j = values.iterator();
            while (j.hasNext()) {
                String value = (String)j.next();
                newValues.add(AgentConfiguration.tagswap(map, value));
            }
            values.clear();
            values.addAll(newValues);
        }
    }

    private static String tagswap(Map map, String value) {
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String k = (String)i.next();
            value = value.replaceAll("@" + k + "@", (String)map.get(k));
        }
        return value;
    }

    public static void updateAgent(SSOToken ssoToken, String realm, String agentName, Map attrValues, boolean bSet) throws IdRepoException, SSOException, SMSException {
        AMIdentity amid = new AMIdentity(ssoToken, agentName, IdType.AGENTONLY, realm, null);
        String agentType = AgentConfiguration.getAgentType(amid);
        Map attributeValues = AgentConfiguration.parseAttributeMap(agentType, attrValues);
        if (!bSet) {
            Map origValues = amid.getAttributes(attributeValues.keySet());
            Iterator i = attributeValues.keySet().iterator();
            while (i.hasNext()) {
                String attrName = (String)i.next();
                attributeValues.put(attrName, AgentConfiguration.updateAttrValues(agentType, attrName, (Set)origValues.get(attrName), (Set)attributeValues.get(attrName)));
            }
        }
        amid.setAttributes(attributeValues);
        amid.store();
    }

    private static Set updateAttrValues(String agentType, String attrName, Set origValues, Set newValues) throws SMSException, SSOException {
        AttributeSchema as = AgentConfiguration.getAgentAttributeSchema(attrName, agentType);
        return as.getType().equals(AttributeSchema.Type.LIST) ? AgentConfiguration.updateAttrValues(origValues, newValues) : newValues;
    }

    private static Set updateAttrValues(Set origValues, Set newValues) {
        if (origValues == null || origValues.isEmpty()) {
            return newValues;
        }
        HashSet<String> set = new HashSet<String>();
        set.addAll(origValues);
        Iterator i = newValues.iterator();
        while (i.hasNext()) {
            int idx;
            String val = (String)i.next();
            if (val.startsWith("[") && (idx = val.indexOf(93)) != -1) {
                String key = val.substring(0, idx + 1);
                AgentConfiguration.removeEntryByKey(set, key);
            }
            set.add(val);
        }
        return set;
    }

    private static boolean removeEntryByKey(Set set, String key) {
        boolean bRemoved = false;
        String match = key + "=";
        Iterator i = set.iterator();
        while (i.hasNext() && !bRemoved) {
            String val = (String)i.next();
            if (!val.startsWith(match)) continue;
            i.remove();
            bRemoved = true;
        }
        return bRemoved;
    }

    public static void updateAgentGroup(SSOToken ssoToken, String realm, String agentGroupName, Map attrValues) throws IdRepoException, SSOException, SMSException, ConfigurationException {
        AgentConfiguration.updateAgentGroup(ssoToken, realm, agentGroupName, attrValues, true);
    }

    public static void updateAgentGroup(SSOToken ssoToken, String realm, String agentGroupName, Map attrValues, boolean bSet) throws IdRepoException, SSOException, SMSException, ConfigurationException {
        AMIdentity amid = new AMIdentity(ssoToken, agentGroupName, IdType.AGENTGROUP, realm, null);
        String agentType = AgentConfiguration.getAgentType(amid);
        Map attributeValues = AgentConfiguration.parseAttributeMap(agentType, attrValues);
        if (attributeValues.containsKey(ATTR_NAME_PWD)) {
            throw new ConfigurationException("update.agent.group.cannot.have.password", null);
        }
        if (!bSet) {
            Map origValues = amid.getAttributes(attributeValues.keySet());
            Iterator i = attributeValues.keySet().iterator();
            while (i.hasNext()) {
                String attrName = (String)i.next();
                attributeValues.put(attrName, AgentConfiguration.updateAttrValues(agentType, attrName, (Set)origValues.get(attrName), (Set)attributeValues.get(attrName)));
            }
        }
        amid.setAttributes(attributeValues);
        amid.store();
    }

    public static Set getAgentAttributeSchemas(String agentTypeName) throws SMSException, SSOException {
        ServiceSchema ssType;
        Set attrs;
        HashSet attrSchemas = new HashSet();
        ServiceSchema ss = AgentConfiguration.getOrganizationSchema();
        if (ss != null && (attrs = (ssType = ss.getSubSchema(agentTypeName)).getAttributeSchemas()) != null && !attrs.isEmpty()) {
            attrSchemas.addAll(attrs);
        }
        Iterator i = attrSchemas.iterator();
        while (i.hasNext()) {
            AttributeSchema as = (AttributeSchema)i.next();
            if (!as.getType().equals(AttributeSchema.Type.VALIDATOR)) continue;
            i.remove();
        }
        return attrSchemas;
    }

    private static Set getAgentAttributeSchemaNames(String agentTypeName) throws SMSException, SSOException {
        Set attrSchemas = AgentConfiguration.getAgentAttributeSchemas(agentTypeName);
        HashSet<String> names = new HashSet<String>(attrSchemas.size() * 2);
        Iterator i = attrSchemas.iterator();
        while (i.hasNext()) {
            AttributeSchema as = (AttributeSchema)i.next();
            names.add(as.getName());
        }
        return names;
    }

    public static Map getAgentGroupAttributes(SSOToken ssoToken, String realm, String agentGroupName) throws IdRepoException, SMSException, SSOException {
        AMIdentity amid = new AMIdentity(ssoToken, agentGroupName, IdType.AGENTGROUP, realm, null);
        Map values = amid.getAttributes();
        if (values != null) {
            values.remove(ATTR_NAME_PWD);
        }
        return AgentConfiguration.unparseAttributeMap(AgentConfiguration.getAgentType(amid), values);
    }

    public static Map getAgentAttributes(SSOToken ssoToken, String realm, String agentName) throws IdRepoException, SMSException, SSOException {
        AMIdentity amid = new AMIdentity(ssoToken, agentName, IdType.AGENTONLY, realm, null);
        return AgentConfiguration.getAgentAttributes(amid, true);
    }

    public static Map getAgentAttributes(SSOToken ssoToken, String realm, String agentName, boolean bInherit) throws IdRepoException, SMSException, SSOException {
        IdType type = bInherit ? IdType.AGENT : IdType.AGENTONLY;
        AMIdentity amid = new AMIdentity(ssoToken, agentName, type, realm, null);
        return AgentConfiguration.getAgentAttributes(amid, true);
    }

    public static Map getAgentAttributes(AMIdentity amid, boolean reformat) throws IdRepoException, SMSException, SSOException {
        HashMap values = amid.getAttributes();
        String agentType = AgentConfiguration.getAgentType(amid);
        if (AgentConfiguration.supportLocalProperties(agentType) && AgentConfiguration.isPropertiesLocallyStored(amid)) {
            Set localProp = AgentConfiguration.getLocalPropertyNames(agentType);
            HashMap temp = new HashMap(localProp.size() * 2);
            Iterator i = localProp.iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                temp.put(key, values.get(key));
            }
            values = temp;
        }
        return reformat ? AgentConfiguration.unparseAttributeMap(agentType, values) : AgentConfiguration.correctAttributeNames(agentType, values);
    }

    private static boolean isPropertiesLocallyStored(AMIdentity amid) throws IdRepoException, SSOException {
        boolean isLocal = false;
        Set setRepo = amid.getAttribute(ATTR_CONFIG_REPO);
        if (setRepo != null && !setRepo.isEmpty()) {
            String repo = (String)setRepo.iterator().next();
            isLocal = repo.equalsIgnoreCase(VAL_CONFIG_REPO_LOCAL);
        }
        return isLocal;
    }

    private static String getAgentType(AMIdentity amid) throws IdRepoException, SSOException {
        Set setType = amid.getAttribute("AgentType");
        return setType != null && !setType.isEmpty() ? (String)setType.iterator().next() : "";
    }

    private static Map parseAttributeMap(String agentType, Map attrValues) throws SMSException, SSOException {
        HashMap dummy = new HashMap();
        dummy.putAll(attrValues);
        HashMap<String, Set> result = new HashMap<String, Set>();
        Set attributeSchemas = AgentConfiguration.getAgentAttributeSchemas(agentType);
        if (attributeSchemas != null && !attributeSchemas.isEmpty()) {
            Iterator i = attributeSchemas.iterator();
            while (i.hasNext()) {
                AttributeSchema as = (AttributeSchema)i.next();
                Set values = AgentConfiguration.parseAttributeMap(as, dummy);
                if (values == null) continue;
                result.put(as.getName(), values);
            }
        }
        if (!dummy.isEmpty()) {
            HashSet<String> freeForm = new HashSet<String>();
            Iterator i = dummy.keySet().iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                Set values = (Set)dummy.get(name);
                Iterator j = values.iterator();
                while (j.hasNext()) {
                    freeForm.add(name + "=" + (String)j.next());
                }
            }
            result.put(ATTR_NAME_FREE_FORM, freeForm);
        }
        return result;
    }

    private static Set parseAttributeMap(AttributeSchema as, Map attrValues) {
        Set<String> results = null;
        String attrName = as.getName();
        if (as.getType().equals(AttributeSchema.Type.LIST)) {
            results = new HashSet();
            int lenAttrName = attrName.length();
            Iterator i = attrValues.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                if (!key.startsWith(attrName)) continue;
                String sKey = key.substring(lenAttrName);
                Set set = (Set)attrValues.get(key);
                if (set != Collections.EMPTY_SET) {
                    if (sKey.startsWith("[") && sKey.endsWith("]")) {
                        results.add(sKey + "=" + set.iterator().next());
                    } else if (attrName.equals(key)) {
                        results.add((String)set.iterator().next());
                    }
                }
                i.remove();
            }
            if (results.isEmpty()) {
                results = null;
            }
        } else {
            results = (Set)attrValues.remove(attrName);
        }
        return results;
    }

    private static Map correctAttributeNames(String agentType, Map attrValues) throws SMSException, SSOException {
        HashMap<String, Set> result = new HashMap<String, Set>();
        Set asNames = AgentConfiguration.getAgentAttributeSchemaNames(agentType);
        if (asNames != null && !asNames.isEmpty()) {
            Iterator i = asNames.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                Set values = (Set)attrValues.get(name);
                if (values == null) continue;
                result.put(name, values);
            }
        } else {
            result.putAll(attrValues);
        }
        return result;
    }

    private static Map unparseAttributeMap(String agentType, Map attrValues) throws SMSException, SSOException {
        HashMap<String, Set> result = new HashMap<String, Set>();
        Set asNames = AgentConfiguration.getAgentAttributeSchemaNames(agentType);
        Set asListType = AgentConfiguration.getAttributesSchemaNames(agentType, AttributeSchema.Type.LIST);
        Set asValidatorType = AgentConfiguration.getAttributesSchemaNames(agentType, AttributeSchema.Type.VALIDATOR);
        if (asListType == null) {
            asListType = Collections.EMPTY_SET;
        }
        if (asValidatorType == null) {
            asValidatorType = Collections.EMPTY_SET;
        }
        if (asNames != null && !asNames.isEmpty()) {
            Iterator i = asNames.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                Set values = (Set)attrValues.get(name);
                if (values == null || values.isEmpty()) continue;
                if (name.equals(ATTR_NAME_FREE_FORM)) {
                    AgentConfiguration.handleFreeFormAttrValues(values, result);
                    continue;
                }
                if (asValidatorType.contains(name)) continue;
                if (asListType.contains(name)) {
                    Iterator j = values.iterator();
                    while (j.hasNext()) {
                        HashSet<String> set;
                        String val = (String)j.next();
                        int idx = val.indexOf("]=");
                        if (idx != -1) {
                            set = new HashSet<String>(2);
                            set.add(val.substring(idx + 2));
                            String indice = val.substring(0, idx + 1);
                            indice = indice.replaceAll("=", "\\\\=");
                            result.put(name + indice, set);
                            continue;
                        }
                        set = new HashSet(2);
                        set.add(val);
                        result.put(name, set);
                    }
                    continue;
                }
                result.put(name, values);
            }
        } else {
            result.putAll(attrValues);
        }
        return result;
    }

    private static void handleFreeFormAttrValues(Set values, Map result) {
        Iterator i = values.iterator();
        while (i.hasNext()) {
            String val = (String)i.next();
            Matcher m = patternArray.matcher(val);
            if (m.find()) {
                HashSet<String> set = new HashSet<String>(2);
                set.add(m.group(2));
                result.put(m.group(1), set);
                continue;
            }
            int idx = val.indexOf("=");
            if (idx == -1) continue;
            HashSet<String> set = new HashSet<String>(2);
            set.add(val.substring(idx + 1));
            result.put(val.substring(0, idx), set);
        }
    }

    public static Set getAttributesSchemaNames(AMIdentity amid, AttributeSchema.Syntax syntax) throws SMSException, SSOException, IdRepoException {
        HashSet<String> results = new HashSet<String>();
        Set attributeSchemas = AgentConfiguration.getAgentAttributeSchemas(AgentConfiguration.getAgentType(amid));
        if (attributeSchemas != null && !attributeSchemas.isEmpty()) {
            Iterator i = attributeSchemas.iterator();
            while (i.hasNext()) {
                AttributeSchema as = (AttributeSchema)i.next();
                if (!as.getSyntax().equals(syntax)) continue;
                results.add(as.getName());
            }
        }
        return results;
    }

    public static Set getAttributesSchemaNames(String agentType, AttributeSchema.Type type) throws SMSException, SSOException {
        HashSet<String> results = new HashSet<String>();
        Set attributeSchemas = AgentConfiguration.getAgentAttributeSchemas(agentType);
        if (attributeSchemas != null && !attributeSchemas.isEmpty()) {
            Iterator i = attributeSchemas.iterator();
            while (i.hasNext()) {
                AttributeSchema as = (AttributeSchema)i.next();
                if (!as.getType().equals(type)) continue;
                results.add(as.getName());
            }
        }
        return results;
    }

    private static ServiceSchema getOrganizationSchema() throws SMSException, SSOException {
        ServiceSchema ss = null;
        SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        ServiceSchemaManager ssm = new ServiceSchemaManager("AgentService", adminToken);
        if (ssm != null) {
            ss = ssm.getSchema(SchemaType.ORGANIZATION);
        }
        return ss;
    }

    public static Map getDefaultValues(String agentType, boolean bGroup) throws SMSException, SSOException {
        HashMap<String, Set> mapDefault = new HashMap<String, Set>();
        Set attributeSchemas = AgentConfiguration.getAgentAttributeSchemas(agentType);
        if (attributeSchemas != null && !attributeSchemas.isEmpty()) {
            Iterator i = attributeSchemas.iterator();
            while (i.hasNext()) {
                AttributeSchema as = (AttributeSchema)i.next();
                mapDefault.put(as.getName(), as.getDefaultValues());
            }
        }
        if (bGroup) {
            mapDefault.remove(ATTR_NAME_PWD);
        }
        return mapDefault;
    }

    public static Map getChoiceValues(String name, String agentType) throws SMSException, SSOException {
        String[] cValues;
        HashMap<String, String> choiceValues = new HashMap<String, String>();
        AttributeSchema as = AgentConfiguration.getAgentAttributeSchema(name, agentType);
        if (as != null && (cValues = as.getChoiceValues()) != null) {
            for (int i = 0; i < cValues.length; ++i) {
                String v = cValues[i];
                choiceValues.put(as.getChoiceValueI18NKey(v), v);
            }
        }
        return choiceValues;
    }

    public static AttributeSchema getAgentAttributeSchema(String name, String agentTypeName) throws SMSException, SSOException {
        AttributeSchema as = null;
        ServiceSchema ss = AgentConfiguration.getOrganizationSchema();
        if (ss != null) {
            ServiceSchema ssType = ss.getSubSchema(agentTypeName);
            as = ssType.getAttributeSchema(name);
        }
        return as;
    }

    public static Set getInheritedAttributeNames(AMIdentity amid) throws IdRepoException, SSOException, SMSException {
        String agentType = AgentConfiguration.getAgentType(amid);
        Set attributeSchemaNames = AgentConfiguration.getAgentAttributeSchemaNames(agentType);
        Map values = AgentConfiguration.getAgentAttributes(amid, false);
        if (values != null && !values.isEmpty()) {
            attributeSchemaNames.removeAll(values.keySet());
        }
        return attributeSchemaNames;
    }

    public static void updateInheritance(AMIdentity amid, Map inherit) throws IdRepoException, SSOException, SMSException {
        HashSet<String> toInherit = new HashSet<String>();
        HashSet<String> notToInherit = new HashSet<String>();
        Iterator i = inherit.keySet().iterator();
        while (i.hasNext()) {
            String attrName = (String)i.next();
            String flag = (String)inherit.get(attrName);
            if (flag.equals("1")) {
                toInherit.add(attrName);
                continue;
            }
            notToInherit.add(attrName);
        }
        Map origValues = AgentConfiguration.getAgentAttributes(amid, false);
        Map values = amid.getAttributes(toInherit);
        if (!values.isEmpty()) {
            amid.removeAttributes(values.keySet());
        }
        String agentType = AgentConfiguration.getAgentType(amid);
        Map attrSchemas = AgentConfiguration.getAttributeSchemas(agentType, notToInherit);
        HashMap<String, Set> resetValues = new HashMap<String, Set>(notToInherit.size() * 2);
        Iterator i2 = notToInherit.iterator();
        while (i2.hasNext()) {
            String attrName = (String)i2.next();
            if (origValues.get(attrName) != null) continue;
            AttributeSchema as = (AttributeSchema)attrSchemas.get(attrName);
            Set defaultValues = as.getDefaultValues();
            if (defaultValues == null) {
                resetValues.put(attrName, Collections.EMPTY_SET);
                continue;
            }
            resetValues.put(attrName, defaultValues);
        }
        if (!resetValues.isEmpty()) {
            amid.setAttributes(resetValues);
            amid.store();
        }
    }

    public static Map getAttributeSchemas(String agentType, Collection names) throws SMSException, SSOException {
        HashMap<String, AttributeSchema> map = new HashMap<String, AttributeSchema>();
        Set attributeSchema = AgentConfiguration.getAgentAttributeSchemas(agentType);
        Iterator i = attributeSchema.iterator();
        while (i.hasNext()) {
            AttributeSchema as = (AttributeSchema)i.next();
            if (!names.contains(as.getName())) continue;
            map.put(as.getName(), as);
        }
        return map;
    }

    public static ResourceBundle getServiceResourceBundle(Locale locale) throws SMSException, SSOException {
        SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        ServiceSchemaManager ssm = new ServiceSchemaManager("AgentService", adminToken);
        String rbName = ssm.getI18NFileName();
        return ResourceBundle.getBundle(rbName, locale);
    }

    public static void AddAgentToGroup(AMIdentity group, AMIdentity agent) throws IdRepoException, SSOException, ConfigurationException {
        if (!group.isExists()) {
            Object[] param = new String[]{group.getName()};
            throw new ConfigurationException("cannot.add.agent.to.group.group.does.not.exist", param);
        }
        if (!agent.isExists()) {
            Object[] param = new String[]{agent.getName()};
            throw new ConfigurationException("cannot.add.agent.to.group.agent.does.not.exist", param);
        }
        String agentType = AgentConfiguration.getAgentType(agent);
        String agentGroupType = AgentConfiguration.getAgentType(group);
        if (AgentConfiguration.supportLocalProperties(agentType) && AgentConfiguration.isPropertiesLocallyStored(agent)) {
            String agentName = agent.getName();
            Object[] param = new String[]{agentName};
            throw new ConfigurationException("cannot.add.agent.to.group.proeprties.locally.stored", param);
        }
        if (!agentType.equals(agentGroupType)) {
            String agentName = agent.getName();
            String groupName = group.getName();
            Object[] param = new String[]{agentName, groupName};
            throw new ConfigurationException("cannot.add.agent.to.group.type.mismatched", param);
        }
        group.addMember(agent);
    }

    public static boolean supportLocalProperties(String agentType) {
        return localAgentProperties.containsKey(agentType);
    }

    public static Set getLocalPropertyNames(String agentType) {
        return (Set)localAgentProperties.get(agentType);
    }

    static {
        patternArray = Pattern.compile("(.+?\\[.*?\\]\\s*?)=(.*)");
        localAgentProperties = new HashMap();
        ResourceBundle rb = ResourceBundle.getBundle(AGENT_LOCAL_PROPERTIES);
        Enumeration<String> e = rb.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            HashSet<String> set = new HashSet<String>();
            String value = rb.getString(key);
            StringTokenizer st = new StringTokenizer(value, ",");
            while (st.hasMoreTokens()) {
                set.add(st.nextToken());
            }
            localAgentProperties.put(key, set);
        }
    }
}

