/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.agentconfig;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.configuration.AgentConfiguration;
import com.sun.identity.console.agentconfig.model.AgentsModel;
import com.sun.identity.console.agentconfig.model.AgentsModelImpl;
import com.sun.identity.console.base.AMPrimaryMastHeadViewBean;
import com.sun.identity.console.base.AMViewBeanBase;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.components.view.html.SerializedField;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.table.CCActionTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class AgentConfigInheritViewBean
extends AMPrimaryMastHeadViewBean {
    private static final String DEFAULT_DISPLAY_URL = "/console/agentconfig/AgentConfigInherit.jsp";
    private static final String TBL_PROPERTY_NAMES = "tblPropertyNames";
    private static final String PGTITLE_THREE_BTNS = "pgtitleThreeBtns";
    static final String PG_ATTR_PROPERTY_NAMES = "pgAttrPropertyNames";
    static final String PG_ATTR_CONFIG_PAGE = "pgAttrConfigPage";
    private static final String TBL_COL_PROPERTY_NAME = "tblColPropertyName";
    private static final String TBL_COL_VALUE = "tblColValue";
    private static final String TBL_DATA_PROPERTY_NAME = "tblDataPropertyName";
    private static final String TBL_DATA_PROPERTY_HELP = "tblDataPropertyHelp";
    private static final String TBL_DATA_VALUE = "tblDataValue";
    private CCActionTableModel tblPropertyNamesModel = null;
    private CCPageTitleModel ptModel;
    private boolean submitCycle;

    public AgentConfigInheritViewBean() {
        super("AgentConfigInherit");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
    }

    protected void initialize() {
        String universalId;
        if (!this.initialized && (universalId = (String)this.getPageSessionAttribute("universalId")) != null) {
            super.initialize();
            this.createPageTitleModel();
            this.createTableModel();
            this.registerChildren();
            this.initialized = true;
        }
    }

    protected void registerChildren() {
        super.registerChildren();
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.registerChild(TBL_PROPERTY_NAMES, CCActionTable.class);
        this.tblPropertyNamesModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        if (name.equals(TBL_PROPERTY_NAMES)) {
            SerializedField szCache = (SerializedField)this.getChild("szCache");
            this.populatePropertyNameTableModel((List)szCache.getSerializedObj());
            view = new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.tblPropertyNamesModel, name);
        } else {
            view = name.equals(PGTITLE_THREE_BTNS) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (this.tblPropertyNamesModel.isChildSupported(name) ? this.tblPropertyNamesModel.createChild((View)this, name) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : super.createChild(name)));
        }
        return view;
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.save");
        this.ptModel.setValue("button2", (Object)"button.reset");
        this.ptModel.setValue("button3", (Object)this.getBackButtonLabel());
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        Set propertyNames = (Set)this.getPageSessionAttribute(PG_ATTR_PROPERTY_NAMES);
        this.populatePropertyNameTableModel(propertyNames);
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = this.getRequestContext().getRequest();
        return new AgentsModelImpl(req, this.getPageSessionAttributes());
    }

    private void createTableModel() {
        this.tblPropertyNamesModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblAgentInheritProperties.xml"));
        this.tblPropertyNamesModel.setTitleLabel("label.items");
        this.tblPropertyNamesModel.setActionValue(TBL_COL_PROPERTY_NAME, (Object)"table.inherit.property.name.column.name");
        this.tblPropertyNamesModel.setActionValue(TBL_COL_VALUE, (Object)"table.inherit.property.name.column.value");
    }

    private void populatePropertyNameTableModel(Collection propertyNames) {
        if (!this.submitCycle && propertyNames != null) {
            this.tblPropertyNamesModel.clearAll();
            SerializedField szCache = (SerializedField)this.getChild("szCache");
            String universalId = (String)this.getPageSessionAttribute("universalId");
            String agentType = this.getAgentType();
            String curRealm = (String)this.getPageSessionAttribute("currentRealm");
            AgentsModel model = (AgentsModel)this.getModel();
            Set inheritedPropertyNames = model.getInheritedPropertyNames(curRealm, universalId);
            Map nameToSchemas = model.getAttributeSchemas(agentType, propertyNames);
            this.removeNonInheritable(nameToSchemas);
            try {
                ResourceBundle rb = AgentConfiguration.getServiceResourceBundle(model.getUserLocale());
                String groupName = model.getAgentGroup(curRealm, universalId);
                Map groupValues = model.getGroupAttributeValues(curRealm, groupName);
                ArrayList<String> cache = new ArrayList<String>();
                int counter = 0;
                Iterator i = propertyNames.iterator();
                while (i.hasNext()) {
                    String name;
                    AttributeSchema as;
                    if (counter > 0) {
                        this.tblPropertyNamesModel.appendRow();
                    }
                    if ((as = (AttributeSchema)nameToSchemas.get(name = (String)i.next())) != null) {
                        String displayName = rb.getString(as.getI18NKey());
                        this.tblPropertyNamesModel.setValue(TBL_DATA_PROPERTY_NAME, (Object)displayName);
                        try {
                            String help = rb.getString(as.getI18NKey() + ".help");
                            this.tblPropertyNamesModel.setValue(TBL_DATA_PROPERTY_HELP, (Object)help);
                        }
                        catch (MissingResourceException e) {
                            this.tblPropertyNamesModel.setValue(TBL_DATA_PROPERTY_HELP, (Object)"");
                        }
                        Object oValue = groupValues.get(name);
                        String value = "";
                        if (oValue != null && (value = oValue.toString()).length() >= 2) {
                            value = value.substring(1, value.length() - 1);
                        }
                        this.tblPropertyNamesModel.setValue(TBL_DATA_VALUE, (Object)value);
                        this.tblPropertyNamesModel.setSelectionVisible(counter, true);
                        this.tblPropertyNamesModel.setRowSelected(inheritedPropertyNames.contains(name));
                        cache.add(name);
                    }
                    ++counter;
                }
                szCache.setValue(cache);
            }
            catch (AMConsoleException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
            }
            catch (SMSException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
            }
            catch (SSOException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
            }
        }
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.forwardTo();
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        String name;
        this.submitCycle = true;
        CCActionTable table = (CCActionTable)this.getChild(TBL_PROPERTY_NAMES);
        table.restoreStateData();
        Integer[] selected = this.tblPropertyNamesModel.getSelectedRows();
        SerializedField szCache = (SerializedField)this.getChild("szCache");
        List list = (List)szCache.getSerializedObj();
        HashMap<String, String> inherit = new HashMap<String, String>();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            name = (String)i.next();
            inherit.put(name, "0");
        }
        for (int i2 = 0; i2 < selected.length; ++i2) {
            name = (String)list.get(selected[i2]);
            inherit.put(name, "1");
        }
        try {
            AgentsModel model = (AgentsModel)this.getModel();
            String universalId = (String)this.getPageSessionAttribute("universalId");
            model.updateAgentConfigInheritance(universalId, inherit);
            this.setInlineAlertMessage("info", "message.information", "agentcfg.inheritance.updated");
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        this.forwardTo();
    }

    public void handleButton3Request(RequestInvocationEvent event) throws ModelControlException {
        try {
            AMViewBeanBase vb = (AMViewBeanBase)this.getViewBean(Class.forName((String)this.getPageSessionAttribute(PG_ATTR_CONFIG_PAGE)));
            this.removePageSessionAttribute(PG_ATTR_CONFIG_PAGE);
            this.removePageSessionAttribute(PG_ATTR_PROPERTY_NAMES);
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
        catch (ClassNotFoundException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    protected String getBackButtonLabel() {
        return this.getBackButtonLabel("page.title.agent.config");
    }

    private void removeNonInheritable(Map nameToSchema) {
        Iterator i = nameToSchema.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (!name.equalsIgnoreCase("userpassword")) continue;
            i.remove();
            break;
        }
    }

    protected String getAgentType() {
        return (String)this.getPageSessionAttribute("superagenttype");
    }
}

