/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.agentconfig;

import com.sun.identity.console.base.model.AMModelBase;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;

public class AgentTabManager {
    private static AgentTabManager instance = new AgentTabManager();
    private Map tabs = new TreeMap();
    private Map tabOrder = new HashMap();
    private Map sectionOrder = new HashMap();

    private AgentTabManager() {
        this.initInstance();
    }

    public static AgentTabManager getInstance() {
        return instance;
    }

    public Map getAttributeNames(String agentType, int tabId) {
        Map results = null;
        List list = this.getTabs(agentType);
        if (list != null && !list.isEmpty()) {
            String tabName = tabId == -1 ? (String)list.iterator().next() : this.getTabName(agentType, tabId);
            Map map = (Map)this.tabs.get(agentType);
            if (map != null) {
                results = (Map)map.get(tabName);
            }
        }
        return results;
    }

    public List getTabs(String agentType) {
        return (List)this.tabOrder.get(agentType);
    }

    public String getDefaultTab(String agentType) {
        List list = (List)this.tabOrder.get(agentType);
        return list != null ? (String)list.get(0) : null;
    }

    public List getSectionOrder(String agentType, String tab) {
        if (tab != null) {
            Map map = (Map)this.sectionOrder.get(agentType);
            return map != null ? (List)map.get(tab) : null;
        }
        return null;
    }

    public boolean isFirstTab(String agentType, String tab) {
        return tab == null || tab.equals(this.getDefaultTab(agentType));
    }

    private void initInstance() {
        Map tabProperties = this.getTabProperties();
        Iterator i = tabProperties.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Set values = (Set)tabProperties.get(key);
            Iterator j = values.iterator();
            while (j.hasNext()) {
                String value = (String)j.next();
                this.addTabEntry(key, value);
            }
        }
        ResourceBundle rbOrder = ResourceBundle.getBundle("agenttaborder");
        Enumeration<String> e = rbOrder.getKeys();
        while (e.hasMoreElements()) {
            StringTokenizer st;
            String key = e.nextElement();
            String value = rbOrder.getString(key);
            int idx = key.indexOf(46);
            String agentType = key.substring(0, idx);
            String marker = key.substring(idx + 1);
            if (marker.equals("tab")) {
                ArrayList<String> list = new ArrayList<String>();
                st = new StringTokenizer(value, " ");
                while (st.hasMoreTokens()) {
                    list.add(st.nextToken().trim());
                }
                this.tabOrder.put(agentType, list);
                continue;
            }
            if (!marker.equals("section")) continue;
            HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
            this.sectionOrder.put(agentType, map);
            st = new StringTokenizer(value, " ");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                int idx1 = token.indexOf(46);
                String tab = token.substring(0, idx1);
                String section = token.substring(idx1 + 1);
                ArrayList<String> list = (ArrayList<String>)map.get(tab);
                if (list == null) {
                    list = new ArrayList<String>();
                    map.put(tab, list);
                }
                list.add(section);
            }
        }
    }

    private void addTabEntry(String key, String value) {
        StringTokenizer st = new StringTokenizer(key, ".");
        if (st.countTokens() == 3) {
            TreeSet<String> mapSection;
            TreeMap<String, TreeSet<String>> mapTab;
            String agentType = st.nextToken();
            String tab = st.nextToken();
            String section = st.nextToken();
            TreeMap mapAgentType = (TreeMap)this.tabs.get(agentType);
            if (mapAgentType == null) {
                mapAgentType = new TreeMap();
                this.tabs.put(agentType, mapAgentType);
            }
            if ((mapTab = (TreeMap<String, TreeSet<String>>)mapAgentType.get(tab)) == null) {
                mapTab = new TreeMap<String, TreeSet<String>>();
                mapAgentType.put(tab, mapTab);
            }
            if ((mapSection = (TreeSet<String>)mapTab.get(section)) == null) {
                mapSection = new TreeSet<String>();
                mapTab.put(section, mapSection);
            }
            mapSection.add(value);
        }
    }

    private Map getTabProperties() {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("agenttab.properties");
        HashMap<String, HashSet<String>> map = new HashMap<String, HashSet<String>>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            String line = reader.readLine();
            while (line != null) {
                if (!line.startsWith("#") && line.trim().length() > 0) {
                    int idx = line.indexOf(61);
                    String key = line.substring(0, idx).trim();
                    String value = line.substring(idx + 1).trim();
                    HashSet<String> set = (HashSet<String>)map.get(key);
                    if (set == null) {
                        set = new HashSet<String>();
                        map.put(key, set);
                    }
                    set.add(value);
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            AMModelBase.debug.error("AgentTabManager.getTabProperties", (Throwable)e);
        }
        return map;
    }

    public String getTabName(String agentType, int tabIdx) {
        String sIdx = Integer.toString(tabIdx);
        sIdx = sIdx.substring("4600".length());
        int idx = Integer.parseInt(sIdx);
        List list = (List)this.tabOrder.get(agentType);
        return (String)list.get(idx);
    }

    public int getTabId(String agentType, String tabName) {
        int idx = -1;
        List list = (List)this.tabOrder.get(agentType);
        for (int i = 0; i < list.size() && idx == -1; ++i) {
            String name = (String)list.get(i);
            if (!name.equals(tabName)) continue;
            idx = Integer.parseInt("4600" + i);
        }
        return idx;
    }
}

