/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.authentication;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.config.AMAuthenticationInstance;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.authentication.config.AuthConfigurationEntry;
import com.sun.identity.console.authentication.AuthActionTiledView;
import com.sun.identity.console.authentication.AuthPropertiesViewBean;
import com.sun.identity.console.authentication.ReorderAuthChainsViewBean;
import com.sun.identity.console.authentication.model.AuthConfigurationModel;
import com.sun.identity.console.authentication.model.AuthConfigurationModelImpl;
import com.sun.identity.console.authentication.model.AuthPropertiesModel;
import com.sun.identity.console.authentication.model.AuthPropertiesModelImpl;
import com.sun.identity.console.base.AMPrimaryMastHeadViewBean;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.delegation.model.DelegationConfig;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class AuthConfigViewBean
extends AMPrimaryMastHeadViewBean {
    public static final String DEFAULT_DISPLAY_URL = "/console/authentication/AuthConfig.jsp";
    private static final String PGTITLE_THREE_BTNS = "pgtitleThreeBtns";
    private static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    private AuthConfigurationModel acModel = null;
    private CCActionTableModel entryTableModel = null;
    private AMPropertySheetModel propertySheetModel;
    private CCPageTitleModel ptModel;
    public static final String ADD_ENTRY_BUTTON = "addEntryButton";
    public static final String AUTH_ENTRY_TABLE = "authConfigEntryTable";
    public static final String CRITERIA = "criteria";
    public static final String CRITERIA_LABEL = "criteriaLabel";
    public static final String ENTRY_LIST = "authConfigEntryList";
    public static final String MODULE_NAME = "moduleName";
    public static final String MODULE_NAME_LABEL = "moduleNameLabel";
    public static final String OPTION_FIELD = "optionField";
    public static final String OPTION_FIELD_LABEL = "optionFieldLabel";
    public static final String REMOVE_ENTRY_BUTTON = "removeEntryButton";
    public static final String REORDER_ENTRY_BUTTON = "reorderEntryButton";
    public static final String REQUIRED_FLAG = "REQUIRED";
    public static final String ACTION_TILED_VIEW = "actionTiledView";
    private String currentRealm = null;
    private String configName = null;
    private boolean tablePopulated = false;

    public AuthConfigViewBean() {
        super("AuthConfig");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
    }

    protected void initialize() {
        String realmName;
        if (!this.initialized && (realmName = (String)this.getPageSessionAttribute("CurrentProfileView")) != null) {
            super.initialize();
            this.initialized = true;
            this.createPageTitleModel();
            this.createPropertyModel(realmName);
            this.createAuthEntryTable();
            this.registerChildren();
        }
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PGTITLE_THREE_BTNS, CCPageTitle.class);
        this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
        this.registerChild(ACTION_TILED_VIEW, AuthActionTiledView.class);
        this.registerChild(AUTH_ENTRY_TABLE, CCActionTable.class);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
        this.ptModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        if (!this.tablePopulated) {
            this.populateEntryTable();
        }
        if (name.equals(PGTITLE_THREE_BTNS)) {
            view = new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name);
        } else if (name.equals(PROPERTY_ATTRIBUTE)) {
            view = new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name);
        } else if (this.ptModel.isChildSupported(name)) {
            view = this.ptModel.createChild((View)this, name);
        } else if (name.equals(ACTION_TILED_VIEW)) {
            view = new AuthActionTiledView((View)this, this.entryTableModel, name);
        } else if (name.equals(AUTH_ENTRY_TABLE)) {
            CCActionTable table = new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.entryTableModel, name);
            table.setTiledView((ContainerView)((AuthActionTiledView)this.getChild(ACTION_TILED_VIEW)));
            view = table;
        } else {
            view = this.propertySheetModel.isChildSupported(name) ? this.propertySheetModel.createChild((View)this, name, this.getModel()) : super.createChild(name);
        }
        return view;
    }

    private AuthPropertiesModel getPropertiesModel() {
        RequestContext rc = RequestManager.getRequestContext();
        HttpServletRequest req = rc.getRequest();
        return new AuthPropertiesModelImpl(req, this.getPageSessionAttributes());
    }

    private List getInstanceNames() {
        AuthPropertiesModel apm = this.getPropertiesModel();
        Set tmp = apm.getAuthInstances();
        HashSet<String> instances = new HashSet<String>(tmp.size() * 2);
        Iterator i = tmp.iterator();
        while (i.hasNext()) {
            AMAuthenticationInstance inst = (AMAuthenticationInstance)i.next();
            instances.add(inst.getName());
        }
        return AMFormatUtils.sortItems(instances, apm.getUserLocale());
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.resetButtonState(REMOVE_ENTRY_BUTTON);
        this.acModel = (AuthConfigurationModel)this.getModel();
        String title = this.acModel.getLocalizedString("page.title.auth.config.edit");
        String[] param = new String[]{this.getConfigName()};
        this.ptModel.setPageTitleText(MessageFormat.format(title, param));
        AuthConfigurationModel model = (AuthConfigurationModel)this.getModel();
        if (model != null) {
            AMPropertySheet ps = (AMPropertySheet)this.getChild(PROPERTY_ATTRIBUTE);
            ps.setAttributeValues(this.getValues(model), model);
        }
        if (!this.tablePopulated) {
            this.populateEntryTable();
        }
        CCButton btnReorder = (CCButton)this.getChild(REORDER_ENTRY_BUTTON);
        btnReorder.setDisabled(model.getNumberEntries() < 2);
        if (this.getInstanceNames().isEmpty()) {
            CCButton btnAdd = (CCButton)this.getChild(ADD_ENTRY_BUTTON);
            btnAdd.setDisabled(true);
            this.setInlineAlertMessage("info", "message.information", "authentication.instance.list.empty");
        }
        this.showInvalidSet();
    }

    public void showInvalidSet() {
        HashSet<String> invalidSet = new HashSet<String>();
        HashSet validSet = new HashSet();
        List list = this.getInstanceNames();
        if (list != null && !list.isEmpty()) {
            validSet.addAll(list);
        }
        AuthConfigurationModel model = (AuthConfigurationModel)this.getModel();
        int size = model.getNumberEntries();
        for (int i = 0; i < size; ++i) {
            String module = model.getModuleName(i);
            if (validSet.contains(module)) continue;
            invalidSet.add(module);
        }
        if (!invalidSet.isEmpty()) {
            StringBuffer buff = new StringBuffer();
            boolean bFirst = true;
            Iterator i = invalidSet.iterator();
            while (i.hasNext()) {
                if (bFirst) {
                    bFirst = false;
                } else {
                    buff.append(", ");
                }
                buff.append((String)i.next());
            }
            Object[] params = new Object[]{buff.toString()};
            String msg = invalidSet.size() > 1 ? "authentication.instance.invalids" : "authentication.instance.invalid";
            this.setInlineAlertMessage("warning", "message.warning", MessageFormat.format(model.getLocalizedString(msg), params));
        }
    }

    private Map getValues(AuthConfigurationModel model) {
        Map values = (Map)this.getPageSessionAttribute("acReorderTrack");
        if (values == null) {
            try {
                values = model.getValues();
            }
            catch (AMConsoleException a) {
                this.setInlineAlertMessage("warning", "message.warning", "noproperties.message");
            }
        }
        return values == null ? Collections.EMPTY_MAP : values;
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        CCActionTable table = (CCActionTable)this.getChild(AUTH_ENTRY_TABLE);
        table.restoreStateData();
        this.acModel = (AuthConfigurationModel)this.getModel();
        this.acModel.setEntries(this.getTableData());
        try {
            Map original = this.acModel.getValues();
            AMPropertySheet ps = (AMPropertySheet)this.getChild(PROPERTY_ATTRIBUTE);
            Map updated = ps.getAttributeValues(original, true, this.acModel);
            this.acModel.setValues(updated);
            this.acModel.store(this.getRealmName(), this.getConfigName());
            this.setInlineAlertMessage("info", "message.information", "authentication.save.ok");
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
            this.tablePopulated = false;
        }
        this.forwardTo();
    }

    private List getTableData() throws ModelControlException {
        debug.message("AuthConfigViewBean.getTableData");
        ArrayList<AuthConfigurationEntry> entryList = new ArrayList<AuthConfigurationEntry>();
        CCActionTable table = (CCActionTable)this.getChild(AUTH_ENTRY_TABLE);
        table.restoreStateData();
        int size = this.entryTableModel.getNumRows();
        for (int i = 0; i < size; ++i) {
            this.entryTableModel.setRowIndex(i);
            String module = (String)this.entryTableModel.getValue(MODULE_NAME);
            String flag = (String)this.entryTableModel.getValue(CRITERIA);
            String option = (String)this.entryTableModel.getValue(OPTION_FIELD);
            try {
                AuthConfigurationEntry ae = new AuthConfigurationEntry(module, flag, option);
                entryList.add(ae);
                continue;
            }
            catch (AMConfigurationException e) {
                debug.warning("AuthConfigViewBean.getTableData() Couldn't create the auth configuration entry", (Throwable)((Object)e));
            }
        }
        if (debug.messageEnabled()) {
            debug.message("AuthConfigViewBean.getTableData() Data created for the config table - " + entryList);
        }
        return entryList;
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.acModel = (AuthConfigurationModel)this.getModel();
        this.acModel.reset(this.getRealmName(), this.getConfigName());
        this.tablePopulated = false;
        this.removePageSessionAttribute(ENTRY_LIST);
        this.forwardTo();
    }

    public void handleButton3Request(RequestInvocationEvent event) {
        this.backTrail();
        AuthPropertiesViewBean vb = (AuthPropertiesViewBean)this.getViewBean(AuthPropertiesViewBean.class);
        this.removePageSessionAttribute(ENTRY_LIST);
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleAddEntryButtonRequest(RequestInvocationEvent event) throws ModelControlException {
        List currentEntries = this.getTableData();
        Iterator i = this.getInstanceNames().iterator();
        String moduleName = (String)i.next();
        try {
            AuthConfigurationEntry ace = new AuthConfigurationEntry(moduleName, REQUIRED_FLAG, "");
            currentEntries.add(ace);
            this.acModel.setEntries(currentEntries);
            this.setPageSessionAttribute(ENTRY_LIST, (Serializable)((Object)this.acModel.getXMLValue(this.getRealmName(), this.getConfigName())));
        }
        catch (AMConfigurationException a) {
            debug.warning("AuthConfigViewBean.handleAddEntryButtonRequest() Adding new config entry failed", (Throwable)((Object)a));
        }
        this.cacheValues();
        this.populateEntryTable();
        this.forwardTo();
    }

    public void handleRemoveEntryButtonRequest(RequestInvocationEvent event) throws ModelControlException {
        CCActionTable table = (CCActionTable)this.getChild(AUTH_ENTRY_TABLE);
        table.restoreStateData();
        Integer[] selected = this.entryTableModel.getSelectedRows();
        this.acModel = (AuthConfigurationModel)this.getModel();
        this.acModel.removeAuthEntries(selected);
        String xml = this.acModel.getXMLValue(this.getRealmName(), this.getConfigName());
        this.setPageSessionAttribute(ENTRY_LIST, (Serializable)((Object)xml));
        this.cacheValues();
        this.tablePopulated = false;
        this.forwardTo();
    }

    public void handleReorderEntryButtonRequest(RequestInvocationEvent event) throws ModelControlException {
        CCActionTable table = (CCActionTable)this.getChild(AUTH_ENTRY_TABLE);
        table.restoreStateData();
        this.cacheValues();
        this.setPageSessionAttribute(ENTRY_LIST, (Serializable)((Object)AMAuthConfigUtils.authConfigurationEntryToXMLString(this.getTableData())));
        ReorderAuthChainsViewBean vb = (ReorderAuthChainsViewBean)this.getViewBean(ReorderAuthChainsViewBean.class);
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    private void cacheValues() throws ModelControlException {
        AuthConfigurationModel acModel = (AuthConfigurationModel)this.getModel();
        try {
            Map original = acModel.getValues();
            AMPropertySheet ps = (AMPropertySheet)this.getChild(PROPERTY_ATTRIBUTE);
            this.setPageSessionAttribute("acReorderTrack", (HashMap)ps.getAttributeValues(original, true, acModel));
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
            this.forwardTo();
        }
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.save");
        this.ptModel.setValue("button2", (Object)"button.reset");
        this.ptModel.setValue("button3", (Object)this.getBackButtonLabel("config.auth.label"));
    }

    protected AMModel getModelInternal() {
        RequestContext rc = RequestManager.getRequestContext();
        this.acModel = new AuthConfigurationModelImpl(rc.getRequest(), this.getPageSessionAttributes());
        this.acModel.initialize(this.getRealmName(), this.getConfigName());
        return this.acModel;
    }

    private void createPropertyModel(String realmName) {
        DelegationConfig dConfig = DelegationConfig.getInstance();
        boolean canModify = dConfig.hasPermission(realmName, null, "MODIFY", this.getModel(), ((Object)((Object)this)).getClass().getName());
        String xmlFile = canModify ? "com/sun/identity/console/propertyAuthConfig.xml" : "com/sun/identity/console/propertyAuthConfig_Readonly.xml";
        this.propertySheetModel = new AMPropertySheetModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(xmlFile));
        this.propertySheetModel.clear();
    }

    private void createAuthEntryTable() {
        this.entryTableModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblAuthConfig.xml"));
        this.entryTableModel.setTitleLabel("label.items");
        this.entryTableModel.setActionValue(MODULE_NAME_LABEL, (Object)"authentication.config.entry.module.column");
        this.entryTableModel.setActionValue(CRITERIA_LABEL, (Object)"authentication.config.entry.criteria.column");
        this.entryTableModel.setActionValue(OPTION_FIELD_LABEL, (Object)"authentication.config.entry.option.column");
        this.entryTableModel.setActionValue(ADD_ENTRY_BUTTON, (Object)"authentication.config.entry.add.button");
        this.entryTableModel.setActionValue(REMOVE_ENTRY_BUTTON, (Object)"authentication.config.entry.delete.button");
        this.entryTableModel.setActionValue(REORDER_ENTRY_BUTTON, (Object)"authentication.config.entry.reorder.button");
        this.propertySheetModel.setModel(AUTH_ENTRY_TABLE, this.entryTableModel);
    }

    private String getRealmName() {
        if (this.currentRealm == null) {
            this.currentRealm = (String)this.getPageSessionAttribute("currentRealm");
        }
        return this.currentRealm;
    }

    private String getConfigName() {
        if (this.configName == null) {
            this.configName = (String)this.getPageSessionAttribute("authConfigurationEntryName");
        }
        return this.configName;
    }

    private void populateEntryTable() {
        this.tablePopulated = true;
        this.entryTableModel.clearAll();
        this.acModel = (AuthConfigurationModel)this.getModel();
        String entryValue = (String)this.getPageSessionAttribute(ENTRY_LIST);
        if (entryValue != null && entryValue.length() > 0) {
            this.acModel.setXMLValue(entryValue);
        } else {
            entryValue = this.acModel.getXMLValue(this.getRealmName(), this.getConfigName());
        }
        if (debug.messageEnabled()) {
            debug.message("AuthConfigViewBean.populateEntryTable() creating table from: " + entryValue);
        }
        int size = this.acModel.getNumberEntries();
        for (int x = 0; x < size; ++x) {
            String module = this.acModel.getModuleName(x);
            String flag = this.acModel.getModuleFlag(x);
            String options = this.acModel.getModuleOptions(x);
            if (x > 0) {
                this.entryTableModel.appendRow();
            }
            this.entryTableModel.setValue(MODULE_NAME, (Object)module);
            this.entryTableModel.setValue(CRITERIA, (Object)flag);
            this.entryTableModel.setValue(OPTION_FIELD, (Object)options);
        }
        this.setPageSessionAttribute(ENTRY_LIST, (Serializable)((Object)entryValue));
    }

    public String getOptionFieldValue(int index) {
        this.acModel = (AuthConfigurationModelImpl)this.getModel();
        return this.acModel.getModuleOptions(index);
    }

    public String getModuleFlag(int index) {
        this.acModel = (AuthConfigurationModelImpl)this.getModel();
        return this.acModel.getModuleFlag(index);
    }

    public String getModuleName(int index) {
        this.acModel = (AuthConfigurationModelImpl)this.getModel();
        return this.acModel.getModuleName(index);
    }

    public OptionList getModuleNameChoiceValues() {
        return this.createOptionList(this.getInstanceNames());
    }

    public OptionList getCriteriaNameChoiceValues() {
        this.acModel = (AuthConfigurationModelImpl)this.getModel();
        return this.createOptionList(this.acModel.getCriteriaMap());
    }

    protected String getBreadCrumbDisplayName() {
        String[] arg = new String[]{this.getConfigName()};
        AuthConfigurationModelImpl model = (AuthConfigurationModelImpl)this.getModel();
        return MessageFormat.format(model.getLocalizedString("breadcrumbs.auth.editConfiguration"), arg);
    }

    protected boolean startPageTrail() {
        return false;
    }
}

