/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.base;

import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.console.base.BlankTabViewBean;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.base.model.AccessControlModel;
import com.sun.identity.console.controller.TabController;
import com.sun.web.ui.model.CCNavNode;
import com.sun.web.ui.model.CCNavNodeInterface;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AMTabEntry {
    public static final String NONE_VIEWBEAN = "none";
    public static final String NONE_URL = "none";
    private int id;
    private String label;
    private String tooltip;
    private String status;
    private String url;
    private String viewbean;
    private boolean delegateUI;
    private Set permissions;
    private String accessLevel;
    private Class controller;
    private AMTabEntry parentNode;
    private List children = new ArrayList();
    private Set serviceNamePrefixes = new HashSet();
    private Set serviceNames = new HashSet();

    public AMTabEntry(Node root) throws AMConsoleException {
        NamedNodeMap attrs = root.getAttributes();
        if (attrs == null) {
            throw new AMConsoleException("AMTabEntry.<init> incorrect XML format");
        }
        this.setID(attrs);
        this.label = this.setAttribute(attrs, "label", "AMTabEntry.<init> missing label attribute");
        this.tooltip = this.setAttribute(attrs, "tooltip", "AMTabEntry.<init> missing tooltip attribute");
        this.status = this.setAttribute(attrs, "status", "AMTabEntry.<init> missing status attribute");
        this.viewbean = this.setAttribute(attrs, "viewbean", "AMTabEntry.<init> missing viewbean attribute");
        this.url = this.setAttribute(attrs, "url", "AMTabEntry.<init> missing url attribute");
        this.accessLevel = this.setAttribute(attrs, "accesslevel", null);
        this.permissions = this.setAttributes(attrs, "permissions", "AMTabEntry.<init> missing permissions attribute" + this.label);
        this.delegateUI = this.getBoolAttribute(attrs, "delegateUI");
        this.controller = this.getController(attrs);
        this.setChildren(root);
        this.setServiceNameInfo(root);
    }

    public AMTabEntry(int _id, String _label, String _tooltip, String _status, String _url, Set _permissions, String _viewbean) {
        this.id = _id;
        this.label = _label;
        this.tooltip = _tooltip;
        this.status = _status;
        this.url = _url;
        this.permissions = _permissions;
        this.viewbean = _viewbean;
    }

    public AMTabEntry matchedID(int idx) {
        AMTabEntry entry = null;
        if (this.getID() == idx) {
            entry = this;
        } else {
            int sz = this.children.size();
            for (int i = 0; i < sz && entry == null; ++i) {
                AMTabEntry child = (AMTabEntry)this.children.get(i);
                entry = child.matchedID(idx);
            }
        }
        return entry;
    }

    public int getID() {
        String strID = Integer.toString(this.id);
        AMTabEntry parent = this.parentNode;
        if (parent != null) {
            strID = parent.getID() + strID;
        }
        return Integer.parseInt(strID);
    }

    public void removeChildren() {
        this.children.clear();
    }

    public void addChild(AMTabEntry tab) {
        boolean found = false;
        Iterator i = this.children.iterator();
        while (i.hasNext() && !found) {
            AMTabEntry a = (AMTabEntry)i.next();
            if (!a.url.equals(tab.url)) continue;
            found = true;
        }
        if (!found) {
            this.children.add(tab);
            tab.parentNode = this;
        }
    }

    public String getURL(AccessControlModel model, String realmName) {
        String target = null;
        if (this.canView() && this.canView(model, realmName)) {
            if (this.url.equals("none")) {
                Iterator i = this.children.iterator();
                while (i.hasNext() && target == null) {
                    AMTabEntry child = (AMTabEntry)i.next();
                    target = child.getURL(model, realmName);
                }
            } else {
                target = this.url;
            }
        }
        return target;
    }

    public boolean canView(AccessControlModel model, String realmName) {
        return this.canView() && model.canView(this.permissions, this.accessLevel, realmName, this.delegateUI);
    }

    private boolean canView() {
        boolean can = true;
        if (this.controller != null) {
            try {
                TabController c = (TabController)this.controller.newInstance();
                can = c.isVisible();
            }
            catch (InstantiationException e) {
                AMModelBase.debug.error("AMTabEntry.canView", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                AMModelBase.debug.error("AMTabEntry.canView", (Throwable)e);
            }
        }
        return can;
    }

    public List getChildren() {
        return this.children;
    }

    public int getID(AccessControlModel model, String realmName) {
        return this.canView(model, realmName) ? this.id : -1;
    }

    public String getViewBean() {
        return this.viewbean;
    }

    public Set getPermissions() {
        return this.permissions;
    }

    public CCNavNode getNavNode(AccessControlModel model, String realmName) {
        boolean hasChild = true;
        CCNavNode navNode = null;
        if (this.canView() && this.canView(model, realmName)) {
            navNode = new CCNavNode(this.getID(), this.label, this.tooltip, this.status);
            if (!this.children.isEmpty()) {
                hasChild = false;
                Iterator iter = this.children.iterator();
                while (iter.hasNext()) {
                    AMTabEntry child = (AMTabEntry)iter.next();
                    CCNavNode childNavNode = child.getNavNode(model, realmName);
                    if (childNavNode == null) continue;
                    navNode.addChild((CCNavNodeInterface)childNavNode);
                    hasChild = true;
                }
            }
        }
        return hasChild ? navNode : null;
    }

    public Class getTabClass() throws AMConsoleException {
        Class clazz = null;
        if (this.viewbean.equals("none")) {
            clazz = BlankTabViewBean.class;
        } else {
            try {
                clazz = Class.forName(this.viewbean);
            }
            catch (ClassNotFoundException e) {
                throw new AMConsoleException(e);
            }
        }
        return clazz;
    }

    public Class getTabClass(int id) throws AMConsoleException {
        Class clazz = null;
        if (this.getID() == id) {
            if (this.viewbean.equals("none")) {
                clazz = BlankTabViewBean.class;
            } else {
                try {
                    clazz = Class.forName(this.viewbean);
                }
                catch (ClassNotFoundException e) {
                    throw new AMConsoleException(e);
                }
            }
        } else {
            Iterator iter = this.children.iterator();
            while (iter.hasNext() && clazz == null) {
                AMTabEntry child = (AMTabEntry)iter.next();
                clazz = child.getTabClass(id);
            }
        }
        return clazz;
    }

    public Set getServiceNames() {
        return this.serviceNames;
    }

    public Set getServiceNamePrefixes() {
        return this.serviceNamePrefixes;
    }

    private void setID(NamedNodeMap attrs) throws AMConsoleException {
        Node nodeID = attrs.getNamedItem("id");
        if (nodeID == null) {
            throw new AMConsoleException("AMTabEntry.<init> missing id attribute");
        }
        try {
            this.id = Integer.parseInt(nodeID.getNodeValue());
        }
        catch (NumberFormatException e) {
            throw new AMConsoleException("AMTabEntry.<init> incorrect id attribute");
        }
    }

    private boolean getBoolAttribute(NamedNodeMap attrs, String attrName) {
        boolean boolVal = false;
        Node nodeID = attrs.getNamedItem(attrName);
        if (nodeID != null) {
            String value = nodeID.getNodeValue().trim();
            boolVal = value.equals("true");
        }
        return boolVal;
    }

    private Class getController(NamedNodeMap attrs) {
        String value;
        Class<?> clazz = null;
        Node nodeID = attrs.getNamedItem("controller");
        if (nodeID != null && (value = nodeID.getNodeValue().trim()).length() > 0) {
            try {
                clazz = Class.forName(value);
            }
            catch (ClassNotFoundException e) {
                AMModelBase.debug.error("AMTabEntry.getController", (Throwable)e);
            }
        }
        return clazz;
    }

    private String setAttribute(NamedNodeMap attrs, String attrName, String exceptionMsg) throws AMConsoleException {
        String value = null;
        Node nodeID = attrs.getNamedItem(attrName);
        if (nodeID == null) {
            if (exceptionMsg != null) {
                throw new AMConsoleException(exceptionMsg);
            }
        } else {
            value = nodeID.getNodeValue().trim();
            if (value.length() == 0) {
                value = null;
                if (exceptionMsg != null) {
                    throw new AMConsoleException(exceptionMsg);
                }
            }
        }
        return value;
    }

    private Set setAttributes(NamedNodeMap attrs, String attrName, String exceptionMsg) throws AMConsoleException {
        Node nodeID = attrs.getNamedItem(attrName);
        if (nodeID == null) {
            throw new AMConsoleException(exceptionMsg);
        }
        String strValue = nodeID.getNodeValue().trim();
        if (strValue.length() == 0) {
            throw new AMConsoleException(exceptionMsg);
        }
        HashSet<String> values = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(strValue, ",");
        while (st.hasMoreTokens()) {
            values.add(st.nextToken().trim());
        }
        return values;
    }

    private void setChildren(Node root) throws AMConsoleException {
        NodeList childrenNodes = root.getChildNodes();
        for (int i = 0; i < childrenNodes.getLength(); ++i) {
            Node child = childrenNodes.item(i);
            if (!child.getNodeName().equalsIgnoreCase("tab")) continue;
            AMTabEntry childTab = new AMTabEntry(child);
            if (ServerConfiguration.isLegacy() && childTab.getID() == 42) continue;
            childTab.parentNode = this;
            this.children.add(childTab);
        }
    }

    private void setServiceNameInfo(Node root) {
        NodeList childrenNodes = root.getChildNodes();
        for (int i = 0; i < childrenNodes.getLength(); ++i) {
            Node child = childrenNodes.item(i);
            if (!child.getNodeName().equalsIgnoreCase("services")) continue;
            this.serviceNamePrefixes = this.getChildNodeValues(child, "prefixes", "prefix");
            this.serviceNames = this.getChildNodeValues(child, "serviceNames", "serviceName");
        }
    }

    private Set getChildNodeValues(Node startNode, String parentTagName, String childTagName) {
        HashSet values = new HashSet();
        NodeList childrenNodes = startNode.getChildNodes();
        for (int i = 0; i < childrenNodes.getLength(); ++i) {
            Node child = childrenNodes.item(i);
            if (!child.getNodeName().equalsIgnoreCase(parentTagName)) continue;
            values.addAll(this.getChildNodeValues(child, childTagName));
        }
        return values;
    }

    private Set getChildNodeValues(Node startNode, String childTagName) {
        HashSet<String> values = new HashSet<String>();
        NodeList childrenNodes = startNode.getChildNodes();
        for (int i = 0; i < childrenNodes.getLength(); ++i) {
            Node child = childrenNodes.item(i);
            if (!child.getNodeName().equalsIgnoreCase(childTagName)) continue;
            values.add(child.getFirstChild().getNodeValue());
        }
        return values;
    }
}

