/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.base.model;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.console.base.model.AMAdminConstants;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class AMCommonNameGenerator
implements AMAdminConstants,
ServiceListener {
    private static SSOToken adminSSOToken = AMAdminUtils.getSuperAdminSSOToken();
    private static final String DEFAULT_FORMAT = "{givenname} {initials} {sn}";
    private static Debug debug = Debug.getInstance((String)"amConsole");
    private static AMCommonNameGenerator instance = new AMCommonNameGenerator();
    private static ServiceSchemaManager serviceSchemaManager;
    private static ServiceConfigManager serviceConfigManager;
    private Map mapRealmToFormat = new HashMap();
    private static final String ROOT = "/";

    private AMCommonNameGenerator() {
        this.initialize();
    }

    private void initialize() {
        try {
            serviceSchemaManager = new ServiceSchemaManager("iPlanetG11NSettings", adminSSOToken);
            serviceConfigManager = new ServiceConfigManager("iPlanetG11NSettings", adminSSOToken);
            serviceConfigManager.addListener(this);
            serviceSchemaManager.addListener(this);
        }
        catch (SMSException smse) {
            debug.error("AMCommonNameGenerator.initManager", (Throwable)smse);
        }
        catch (SSOException ssoe) {
            debug.error("AMCommonNameGenerator.initManager", (Throwable)((Object)ssoe));
        }
    }

    public static AMCommonNameGenerator getInstance() {
        return instance;
    }

    public String generateCommonName(String univId, AMModel model) {
        String commonName = "";
        Map userInfoMap = this.getUserAttributeValues(univId);
        if (userInfoMap != null && !userInfoMap.isEmpty()) {
            String token;
            String localeStr = AMAdminUtils.getFirstElement((Set)userInfoMap.get("preferredlocale"));
            if (localeStr == null || localeStr.trim().length() == 0) {
                localeStr = model.getUserLocale().toString();
            }
            String format = this.getCommonNameFormat(localeStr, model);
            Set tokens = this.getTokens(format);
            Map mapAttrValue = this.getAttributeValues(userInfoMap, tokens);
            commonName = format;
            Iterator<Object> iter = mapAttrValue.keySet().iterator();
            while (iter.hasNext()) {
                token = (String)iter.next();
                String value = (String)mapAttrValue.get(token);
                if (!format.equals(DEFAULT_FORMAT)) {
                    value = value + " ";
                }
                commonName = AMFormatUtils.replaceString(commonName, token, value);
            }
            tokens.removeAll(mapAttrValue.keySet());
            iter = tokens.iterator();
            while (iter.hasNext()) {
                token = (String)iter.next();
                int idx = commonName.indexOf(token + " ");
                if (idx != -1) {
                    commonName = commonName.substring(0, idx) + commonName.substring(idx + token.length() + 1);
                    continue;
                }
                idx = commonName.indexOf(token);
                if (idx == -1) continue;
                commonName = commonName.substring(0, idx) + commonName.substring(idx + token.length());
            }
        }
        return commonName;
    }

    private Map getUserAttributeValues(String univId) {
        HashMap values = null;
        try {
            AMIdentity amid = IdUtils.getIdentity(adminSSOToken, univId);
            if (amid != null) {
                Map map = amid.getAttributes();
                Map attributeSchemasNames = this.getAttributeSchemaExactNames(amid.getType().getName());
                values = new HashMap(map.size() * 2);
                Iterator i = map.keySet().iterator();
                while (i.hasNext()) {
                    String name = (String)i.next();
                    String exactName = (String)attributeSchemasNames.get(name);
                    if (exactName == null) {
                        exactName = name;
                    }
                    values.put(exactName, map.get(name));
                }
            }
        }
        catch (SSOException e) {
            debug.warning("AMCommonNameGenerator.getUserAttributeValues", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.warning("AMCommonNameGenerator.getUserAttributeValues", (Throwable)e);
        }
        catch (IdRepoException e) {
            debug.warning("AMCommonNameGenerator.getUserAttributeValues", (Throwable)e);
        }
        return values != null ? values : Collections.EMPTY_MAP;
    }

    private Map getAttributeSchemaExactNames(String idType) throws SMSException, SSOException, IdRepoException {
        HashMap<String, String> mapping = new HashMap<String, String>();
        String serviceName = IdUtils.getServiceName(IdUtils.getType(idType));
        if (serviceName != null) {
            ServiceSchemaManager svcSchemaMgr = new ServiceSchemaManager(serviceName, adminSSOToken);
            ServiceSchema svcSchema = svcSchemaMgr.getSchema(idType);
            Set attributeSchemas = svcSchema != null ? svcSchema.getAttributeSchemas() : Collections.EMPTY_SET;
            Iterator i = attributeSchemas.iterator();
            while (i.hasNext()) {
                AttributeSchema as = (AttributeSchema)i.next();
                String name = as.getName();
                mapping.put(name.toLowerCase(), name);
            }
        }
        return mapping;
    }

    private Map getAttributeValues(Map userInfoMap, Set tokens) {
        HashMap<String, String> map = new HashMap<String, String>(tokens.size() * 2);
        Iterator iter = tokens.iterator();
        while (iter.hasNext()) {
            String token = (String)iter.next();
            String attrName = token.substring(1, token.length() - 1);
            String strValue = AMAdminUtils.getFirstElement((Set)userInfoMap.get(attrName));
            if (strValue == null || strValue.length() <= 0) continue;
            map.put(token, strValue);
        }
        return map;
    }

    private Set getTokens(String format) {
        int end;
        HashSet<String> tokens = new HashSet<String>();
        int start = format.indexOf(123);
        while (start != -1 && (end = format.indexOf(125, start + 1)) != 1) {
            tokens.add(format.substring(start, end + 1));
            format = format.substring(end + 1);
            start = format.indexOf(123);
        }
        return tokens;
    }

    private String getCommonNameFormat(String locale, AMModel model) {
        int idx;
        String format = null;
        Map map = this.getFormats(model);
        if (map != null && !map.isEmpty() && (format = (String)map.get(locale.toLowerCase())) == null && (idx = locale.indexOf(95)) != -1) {
            locale = locale.substring(0, idx);
            format = (String)map.get(locale.toLowerCase());
        }
        return format != null ? format : DEFAULT_FORMAT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map addFormats(String realm) {
        Set values = null;
        Map map = null;
        try {
            AMIdentityRepository repo = new AMIdentityRepository(adminSSOToken, realm);
            AMIdentity realmIdentity = repo.getRealmIdentity();
            Set servicesFromIdRepo = realmIdentity.getAssignedServices();
            if (servicesFromIdRepo.contains("iPlanetG11NSettings")) {
                map = realmIdentity.getServiceAttributes("iPlanetG11NSettings");
            } else {
                OrganizationConfigManager orgCfgMgr = new OrganizationConfigManager(adminSSOToken, realm);
                map = orgCfgMgr.getServiceAttributes("iPlanetG11NSettings");
            }
        }
        catch (SSOException e) {
            debug.warning("AMCommonNameGenerator.addFormats", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.warning("AMCommonNameGenerator.addFormats", (Throwable)e);
        }
        catch (IdRepoException e) {
            debug.warning("AMCommonNameGenerator.addFormats", (Throwable)e);
        }
        if (map != null && !map.isEmpty()) {
            values = (Set)map.get("sun-identity-g11n-settings-common-name-format");
        }
        if (values == null || values.isEmpty()) {
            if (serviceSchemaManager != null) {
                try {
                    values = AMAdminUtils.getAttribute(serviceSchemaManager, SchemaType.ORGANIZATION, "sun-identity-g11n-settings-common-name-format");
                }
                catch (SMSException e) {
                    debug.error("AMCommonNameGenerator.addFormats", (Throwable)e);
                }
            } else {
                debug.error("AMCommonNameGenerator.addFormats: formats are not added because Console cannot get an instance of service schema manager.");
            }
        }
        Map mapFormats = this.getFormatMap(values);
        Map map2 = this.mapRealmToFormat;
        synchronized (map2) {
            this.mapRealmToFormat.put(realm, mapFormats);
        }
        return mapFormats;
    }

    private Map getFormatMap(Set formats) {
        HashMap<String, String> map = new HashMap<String, String>(formats.size());
        Iterator i = formats.iterator();
        while (i.hasNext()) {
            String format = (String)i.next();
            StringTokenizer st = new StringTokenizer(format, "=");
            if (st.countTokens() == 2) {
                String localeName = st.nextToken().trim();
                String formatString = st.nextToken().trim();
                map.put(localeName.toLowerCase(), formatString);
                continue;
            }
            debug.error("Incorrect common name format, " + format + " in Globalization Service");
        }
        return map;
    }

    public Map getFormats(AMModel model) {
        String startDN = model.getStartDN();
        Map map = (Map)this.mapRealmToFormat.get(startDN);
        if (map == null) {
            map = this.addFormats(startDN);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schemaChanged(String serviceName, String version) {
        Map map = this.mapRealmToFormat;
        synchronized (map) {
            this.mapRealmToFormat.remove(ROOT);
        }
    }

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
        Map map = this.mapRealmToFormat;
        synchronized (map) {
            this.mapRealmToFormat.remove(orgName);
        }
    }
}

