/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.base.model;

import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientException;
import com.iplanet.services.cdm.ClientsManager;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.shared.debug.Debug;
import java.util.Locale;

public class AMI18NUtils {
    public static final String KEY_CLIENT_TYPE = "clientType";
    private static Debug debug = Debug.getInstance((String)"amConsole");

    public static String getClientType(SSOToken ssoToken) {
        String clientType = "";
        try {
            clientType = ssoToken.getProperty(KEY_CLIENT_TYPE);
            if (debug.messageEnabled()) {
                debug.message("AMI18NUtils.getClientType, " + clientType);
            }
        }
        catch (SSOException ssoe) {
            debug.error("AMI18NUtils.getClientType", (Throwable)((Object)ssoe));
        }
        return clientType;
    }

    public static String getCharset(String clientType, Locale loc) {
        String charset;
        try {
            Client client = ClientsManager.getInstance(clientType);
            String string = charset = client != null ? client.getCharset(loc) : "ISO-8859-1";
            if (debug.messageEnabled()) {
                debug.message("AMI18NUtils.getCharset, " + charset);
            }
        }
        catch (ClientException ce) {
            debug.warning("AMI18NUtils.getCharset - couldn't retrieve the client charset, reverting to default.");
            charset = "ISO-8859-1";
        }
        return charset;
    }

    public static String getContentType(String clientType) {
        String contentType;
        try {
            Client client = ClientsManager.getInstance(clientType);
            contentType = client != null ? client.getProperty("contentType") : "genericHTML";
        }
        catch (ClientException ce) {
            debug.warning("AMI18NUtils.getContentType - couldn't retrieve the content type, reverting to default.");
            contentType = "genericHTML";
        }
        return contentType;
    }
}

