/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.delegation.model.DelegationConfig;
import com.sun.identity.console.policy.PolicyOpViewBeanBase;
import com.sun.identity.console.policy.ProfileViewBeanBase;
import com.sun.identity.console.policy.SelectConditionTypeViewBean;
import com.sun.identity.console.policy.model.CachedPolicy;
import com.sun.identity.console.policy.model.PolicyCache;
import com.sun.identity.console.policy.model.PolicyModel;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.web.ui.model.CCAddRemoveModel;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public abstract class ConditionOpViewBeanBase
extends ProfileViewBeanBase {
    protected static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    public static final String CALLING_VIEW_BEAN = "ConditionOpViewBeanBaseCallingVB";
    public static final String PG_SESSION_CONDITION_NAME = "conditionName";
    public static final String PG_SESSION_CONDITION_TYPE = "conditionType";
    protected static final String REALM_NAME = "tfRealmName";
    protected static final String CONDITION_NAME = "tfConditionName";
    protected static final String CONDITION_TYPE = "conditionTypeName";
    protected static final String CONDITION_TYPE_NAME = "tfConditionTypeName";
    public static final String VALUES_TEXT_VALUE = "valuesTextValue";
    public static final String VALUES_SINGLE_CHOICE_VALUE = "valuesSingleChoiceValue";
    public static final String VALUES_MULTIPLE_CHOICE_VALUE = "valuesMultipleChoiceValue";
    protected CCPageTitleModel ptModel;
    protected String realmName;
    protected CCAddRemoveModel addRemoveModel;
    protected AMPropertySheetModel propertySheetModel;
    protected boolean canModify;
    protected boolean submitCycle;

    public ConditionOpViewBeanBase(String name, String defaultDisplayURL) {
        super(name, defaultDisplayURL);
    }

    protected void initialize() {
        if (!this.initialized) {
            this.initialized = this.createPropertyModel();
            if (this.initialized) {
                super.initialize();
                this.createPageTitleModel();
                this.createTableModel();
                this.registerChildren();
            }
        }
    }

    private boolean createPropertyModel() {
        String curRealm;
        boolean init = false;
        HttpServletRequest req = RequestManager.getRequestContext().getRequest();
        String condType = (String)this.getPageSessionAttribute(PG_SESSION_CONDITION_TYPE);
        if ((condType == null || condType.trim().length() == 0) && (condType = req.getParameter(this.getName() + "." + CONDITION_TYPE)) != null && condType.trim().length() > 0) {
            this.setPageSessionAttribute(PG_SESSION_CONDITION_TYPE, (Serializable)((Object)condType));
        }
        if (!((curRealm = (String)this.getPageSessionAttribute("currentRealm")) != null && curRealm.trim().length() != 0 || (curRealm = req.getParameter(this.getName() + "." + REALM_NAME)) != null && curRealm.trim().length() != 0)) {
            this.setPageSessionAttribute("currentRealm", (Serializable)((Object)curRealm));
        }
        boolean bl = init = curRealm != null && curRealm.trim().length() > 0 && condType != null && condType.trim().length() > 0;
        if (init) {
            DelegationConfig dConfig = DelegationConfig.getInstance();
            this.canModify = dConfig.hasPermission(this.realmName, null, "MODIFY", this.getModel(), ((Object)((Object)this)).getClass().getName());
            this.propertySheetModel = new AMPropertySheetModel(this.getConditionXML(curRealm, condType, !this.canModify));
            this.propertySheetModel.clear();
            if (this.canModify) {
                this.addRemoveModel = new CCAddRemoveModel();
                this.addRemoveModel.setShowMoveUpDownButtons("false");
                this.addRemoveModel.clear();
                this.propertySheetModel.setModel(VALUES_MULTIPLE_CHOICE_VALUE, this.addRemoveModel);
            }
        }
        return init;
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        view = this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : (name.equals(PROPERTY_ATTRIBUTE) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name) : (this.propertySheetModel.isChildSupported(name) ? this.propertySheetModel.createChild((View)this, name, this.getModel()) : super.createChild(name)));
        return view;
    }

    public AMPropertySheetModel getPropertySheetModel() {
        return this.propertySheetModel;
    }

    public void setErrorMessage(String msg) {
        this.setInlineAlertMessage("error", "message.error", msg);
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        if (!this.submitCycle) {
            PolicyModel model = (PolicyModel)this.getModel();
            String conditionName = (String)this.getPageSessionAttribute(PG_SESSION_CONDITION_NAME);
            this.propertySheetModel.setValue(CONDITION_NAME, conditionName);
            Map map = model.getActiveConditionTypes(this.realmName);
            String condType = (String)this.getPageSessionAttribute(PG_SESSION_CONDITION_TYPE);
            String i18nName = (String)map.get(condType);
            this.propertySheetModel.setValue(CONDITION_TYPE_NAME, i18nName);
            this.propertySheetModel.setValue(REALM_NAME, this.realmName);
            this.setPropertiesValues(this.getDefaultValues());
        }
    }

    protected void setPropertiesValues(Map values) {
        if (values != null && !values.isEmpty()) {
            Iterator i = values.keySet().iterator();
            while (i.hasNext()) {
                String propName = (String)i.next();
                Set val = (Set)values.get(propName);
                if (val == null || val.isEmpty()) continue;
                this.propertySheetModel.setValues(propName, val.toArray(), this.getModel());
            }
        }
    }

    protected Condition createCondition() throws ModelControlException, AMConsoleException {
        Condition condition = null;
        String conditionType = (String)this.getPageSessionAttribute(PG_SESSION_CONDITION_TYPE);
        String conditionName = this.getConditionName();
        Map values = this.getValues(conditionType);
        if (conditionName != null && values != null) {
            condition = this.createCondition(conditionType, values);
        }
        return condition;
    }

    private Condition createCondition(String conditionType, Map values) throws AMConsoleException {
        String realmName = (String)this.getPageSessionAttribute("currentRealm");
        PolicyModel model = (PolicyModel)this.getModel();
        return model.createCondition(realmName, conditionType, values);
    }

    private String getConditionName() {
        String conditionName = (String)this.propertySheetModel.getValue(CONDITION_NAME);
        if ((conditionName = conditionName.trim()).length() == 0) {
            this.setInlineAlertMessage("error", "message.error", "policy.missing.conditionName");
            conditionName = null;
        }
        return conditionName;
    }

    protected Map getValues(String conditionType) throws ModelControlException {
        String realmName;
        PolicyModel model = (PolicyModel)this.getModel();
        Map values = this.getConditionValues(model, realmName = (String)this.getPageSessionAttribute("currentRealm"), conditionType);
        if (values == null || values.isEmpty()) {
            if (!this.isInlineAlertMessageSet()) {
                this.setInlineAlertMessage("error", "message.error", this.getMissingValuesMessage());
            }
            values = null;
        }
        return values;
    }

    protected Map getConditionValues(PolicyModel model, String realmName, String conditionType) {
        List propertyNames = model.getConditionPropertyNames(realmName, conditionType);
        HashMap<String, Set> values = new HashMap<String, Set>(propertyNames.size() * 2);
        Iterator iter = propertyNames.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Object[] array = this.propertySheetModel.getValues(name);
            if (array == null || array.length <= 0) continue;
            if (array.length == 1) {
                String v = array[0].toString();
                if (v == null || v.trim().length() <= 0) continue;
                HashSet<String> val = new HashSet<String>(2);
                val.add(v.trim());
                values.put(name, val);
                continue;
            }
            values.put(name, AMAdminUtils.toSet(array));
        }
        return values;
    }

    protected CachedPolicy getCachedPolicy() throws AMConsoleException {
        CachedPolicy policy = null;
        String cacheID = (String)this.getPageSessionAttribute("policyCacheID");
        if (cacheID != null) {
            PolicyCache cache = PolicyCache.getInstance();
            PolicyModel model = (PolicyModel)this.getModel();
            policy = model.getCachedPolicy(cacheID);
        }
        return policy;
    }

    protected void forwardToPolicyViewBean() {
        try {
            Class<?> clazz = Class.forName((String)this.removePageSessionAttribute(CALLING_VIEW_BEAN));
            PolicyOpViewBeanBase vb = (PolicyOpViewBeanBase)this.getViewBean(clazz);
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
        catch (ClassNotFoundException e) {
            debug.error("ConditionOpViewBeanBase.forwardToPolicyViewBean", (Throwable)e);
            this.forwardTo();
        }
    }

    public void handleButton3Request(RequestInvocationEvent event) {
        this.backTrail();
        this.forwardToPolicyViewBean();
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        SelectConditionTypeViewBean vb = (SelectConditionTypeViewBean)this.getViewBean(SelectConditionTypeViewBean.class);
        this.unlockPageTrailForSwapping();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    protected String getConditionXML(String curRealm, String condType, boolean readonly) {
        PolicyModel model = (PolicyModel)this.getModel();
        return model.getConditionXML(curRealm, condType, readonly);
    }

    protected String getMissingValuesMessage() {
        return "policy.missing.condition.value";
    }

    protected void createTableModel() {
    }

    protected Map getLabelValueMap(Set values) {
        HashMap<String, String> map = new HashMap<String, String>(values.size() * 2);
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            String val = (String)iter.next();
            if (val == null || val.length() == 0) {
                map.put("", this.getModel().getLocalizedString("policy.condition.null.realm"));
                continue;
            }
            map.put(val, this.getPath(val));
        }
        return map;
    }

    protected abstract void createPageTitleModel();

    protected abstract boolean hasValues();

    protected abstract Map getDefaultValues();
}

