/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMDisplayType;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.base.model.QueryResults;
import com.sun.identity.console.delegation.model.DelegationConfig;
import com.sun.identity.console.policy.ConditionAddViewBean;
import com.sun.identity.console.policy.ConditionEditViewBean;
import com.sun.identity.console.policy.ConditionProxyViewBean;
import com.sun.identity.console.policy.PolicyViewBean;
import com.sun.identity.console.policy.ProfileViewBeanBase;
import com.sun.identity.console.policy.ReferralAddViewBean;
import com.sun.identity.console.policy.ReferralEditViewBean;
import com.sun.identity.console.policy.ReferralProxyViewBean;
import com.sun.identity.console.policy.ResponseProviderAddViewBean;
import com.sun.identity.console.policy.ResponseProviderEditViewBean;
import com.sun.identity.console.policy.ResponseProviderProxyViewBean;
import com.sun.identity.console.policy.RuleEditViewBean;
import com.sun.identity.console.policy.RuleNoResourceEditViewBean;
import com.sun.identity.console.policy.RuleWithPrefixEditViewBean;
import com.sun.identity.console.policy.SelectConditionTypeViewBean;
import com.sun.identity.console.policy.SelectReferralTypeViewBean;
import com.sun.identity.console.policy.SelectResponseProviderTypeViewBean;
import com.sun.identity.console.policy.SelectServiceTypeViewBean;
import com.sun.identity.console.policy.SelectSubjectTypeViewBean;
import com.sun.identity.console.policy.SubjectAddViewBean;
import com.sun.identity.console.policy.SubjectEditViewBean;
import com.sun.identity.console.policy.SubjectNoneAddViewBean;
import com.sun.identity.console.policy.SubjectNoneEditViewBean;
import com.sun.identity.console.policy.SubjectProxyViewBean;
import com.sun.identity.console.policy.model.CachedPolicy;
import com.sun.identity.console.policy.model.PolicyModel;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.Rule;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.identity.policy.interfaces.Referral;
import com.sun.identity.policy.interfaces.ResponseProvider;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class PolicyOpViewBeanBase
extends ProfileViewBeanBase {
    protected static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    public static final String WIZARD = "wizard";
    private static final String TBL_RULES = "tblRules";
    private static final String TBL_RULES_COL_NAME = "tblRulesColName";
    private static final String TBL_RULES_COL_TYPE = "tblRulesColType";
    private static final String TBL_RULES_DATA_NAME = "ruleName";
    private static final String TBL_RULES_DATA_TYPE = "ruleType";
    private static final String TBL_RULES_ACTION_HREF = "tblRulesEditLink";
    private static final String TBL_REFERRALS = "tblReferrals";
    private static final String TBL_REFERRALS_COL_NAME = "tblReferralsColName";
    private static final String TBL_REFERRALS_COL_TYPE = "tblReferralsColType";
    private static final String TBL_REFERRALS_DATA_NAME = "referralName";
    private static final String TBL_REFERRALS_DATA_TYPE = "referralType";
    private static final String TBL_REFERRALS_ACTION_HREF = "tblReferralsEditLink";
    private static final String TBL_SUBJECTS = "tblSubjects";
    private static final String TBL_SUBJECTS_COL_NAME = "tblSubjectsColName";
    private static final String TBL_SUBJECTS_COL_TYPE = "tblSubjectsColType";
    private static final String TBL_SUBJECTS_COL_ACTION = "tblSubjectsColAction";
    private static final String TBL_SUBJECTS_DATA_NAME = "subjectName";
    private static final String TBL_SUBJECTS_DATA_TYPE = "subjectType";
    private static final String TBL_SUBJECTS_ACTION_HREF = "tblSubjectsEditLink";
    private static final String TBL_RESPONSE_ATTRIBUTES = "tblResponseProviders";
    private static final String TBL_RESPONSE_ATTRIBUTES_COL_NAME = "tblResponseProvidersColName";
    private static final String TBL_RESPONSE_ATTRIBUTES_COL_TYPE = "tblResponseProvidersColType";
    private static final String TBL_RESPONSE_ATTRIBUTES_COL_ACTION = "tblResponseProvidersColAction";
    private static final String TBL_RESPONSE_ATTRIBUTES_DATA_NAME = "responseProviderName";
    private static final String TBL_RESPONSE_ATTRIBUTES_DATA_TYPE = "responseProviderType";
    private static final String TBL_RESPONSE_ATTRIBUTES_ACTION_HREF = "tblResponseProvidersEditLink";
    private static final String TBL_CONDITIONS = "tblConditions";
    private static final String TBL_CONDITIONS_COL_NAME = "tblConditionsColName";
    private static final String TBL_CONDITIONS_COL_TYPE = "tblConditionsColType";
    private static final String TBL_CONDITIONS_DATA_NAME = "conditionName";
    private static final String TBL_CONDITIONS_DATA_TYPE = "conditionType";
    private static final String TBL_CONDITIONS_ACTION_HREF = "tblConditionsEditLink";
    private static final String ATTR_DESCRIPTION = "tfDescription";
    private static final String ATTR_ISACTIVE = "cbIsActive";
    private static Map PROPERTY_MAPPING = new HashMap(4);
    protected CCPageTitleModel ptModel;
    private CCActionTableModel tblRulesModel;
    private CCActionTableModel tblReferralsModel;
    private CCActionTableModel tblResponseProvidersModel;
    private CCActionTableModel tblSubjectsModel;
    private CCActionTableModel tblConditionsModel;
    private AMPropertySheetModel propertySheetModel;
    private boolean bPopulateTables;

    public PolicyOpViewBeanBase(String name, String defaultDisplayURL) {
        super(name, defaultDisplayURL);
    }

    protected void initialize() {
        String realmName;
        if (!this.initialized && (realmName = (String)this.getPageSessionAttribute("currentRealm")) != null) {
            super.initialize();
            this.initialized = true;
            this.createPageTitleModel();
            this.createPropertyModel(realmName);
            this.createTableModels();
            this.registerChildren();
        }
    }

    protected void createPropertyModel(String realmName) {
        DelegationConfig dConfig = DelegationConfig.getInstance();
        boolean canModify = dConfig.hasPermission(realmName, null, "MODIFY", this.getModel(), ((Object)((Object)this)).getClass().getName());
        this.propertySheetModel = new AMPropertySheetModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.getPropertyXMLFileName(!canModify)));
        this.propertySheetModel.clear();
    }

    protected void createRuleTableModels() {
        this.tblRulesModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblPMRules.xml"));
        this.tblRulesModel.setTitleLabel("label.items");
        this.tblRulesModel.setActionValue("tblRulesButtonAdd", (Object)"button.new");
        this.tblRulesModel.setActionValue("tblRulesButtonDelete", (Object)"button.delete");
        this.tblRulesModel.setActionValue(TBL_RULES_COL_NAME, (Object)"policy.rules.table.column.name");
        this.tblRulesModel.setActionValue(TBL_RULES_COL_TYPE, (Object)"policy.rules.table.column.type");
        this.propertySheetModel.setModel(TBL_RULES, this.tblRulesModel);
    }

    protected void createReferralTableModels() {
        this.tblReferralsModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblPMReferrals.xml"));
        this.tblReferralsModel.setTitleLabel("label.items");
        this.tblReferralsModel.setActionValue("tblReferralsButtonAdd", (Object)"button.new");
        this.tblReferralsModel.setActionValue("tblReferralsButtonDelete", (Object)"button.delete");
        this.tblReferralsModel.setActionValue(TBL_REFERRALS_COL_NAME, (Object)"policy.referrals.table.column.name");
        this.tblReferralsModel.setActionValue(TBL_REFERRALS_COL_TYPE, (Object)"policy.referrals.table.column.type");
        this.propertySheetModel.setModel(TBL_REFERRALS, this.tblReferralsModel);
    }

    protected void createSubjectTableModels() {
        this.tblSubjectsModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblPMSubjects.xml"));
        this.tblSubjectsModel.setTitleLabel("label.items");
        this.tblSubjectsModel.setActionValue("tblSubjectsButtonAdd", (Object)"button.new");
        this.tblSubjectsModel.setActionValue("tblSubjectsButtonDelete", (Object)"button.delete");
        this.tblSubjectsModel.setActionValue(TBL_SUBJECTS_COL_NAME, (Object)"policy.subjects.table.column.name");
        this.tblSubjectsModel.setActionValue(TBL_SUBJECTS_COL_TYPE, (Object)"policy.subjects.table.column.type");
        this.tblSubjectsModel.setActionValue(TBL_SUBJECTS_COL_ACTION, (Object)"policy.subjects.table.column.action");
        this.propertySheetModel.setModel(TBL_SUBJECTS, this.tblSubjectsModel);
    }

    protected void createResponseProviderTableModels() {
        this.tblResponseProvidersModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblPMResponseProviders.xml"));
        this.tblResponseProvidersModel.setTitleLabel("label.items");
        this.tblResponseProvidersModel.setActionValue("tblResponseProvidersButtonAdd", (Object)"button.new");
        this.tblResponseProvidersModel.setActionValue("tblResponseProvidersButtonDelete", (Object)"button.delete");
        this.tblResponseProvidersModel.setActionValue(TBL_RESPONSE_ATTRIBUTES_COL_NAME, (Object)"policy.responseproviders.table.column.name");
        this.tblResponseProvidersModel.setActionValue(TBL_RESPONSE_ATTRIBUTES_COL_TYPE, (Object)"policy.responseproviders.table.column.type");
        this.tblResponseProvidersModel.setActionValue(TBL_RESPONSE_ATTRIBUTES_COL_ACTION, (Object)"policy.responseproviders.table.column.action");
        this.propertySheetModel.setModel(TBL_RESPONSE_ATTRIBUTES, this.tblResponseProvidersModel);
    }

    protected void createConditionTableModels() {
        this.tblConditionsModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblPMConditions.xml"));
        this.tblConditionsModel.setTitleLabel("label.items");
        this.tblConditionsModel.setActionValue("tblConditionsButtonAdd", (Object)"button.new");
        this.tblConditionsModel.setActionValue("tblConditionsButtonDelete", (Object)"button.delete");
        this.tblConditionsModel.setActionValue(TBL_CONDITIONS_COL_NAME, (Object)"policy.conditions.table.column.name");
        this.tblConditionsModel.setActionValue(TBL_CONDITIONS_COL_TYPE, (Object)"policy.conditions.table.column.type");
        this.propertySheetModel.setModel(TBL_CONDITIONS, this.tblConditionsModel);
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        if (!this.bPopulateTables) {
            this.populateTables();
            this.bPopulateTables = true;
        }
        view = this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : (name.equals(PROPERTY_ATTRIBUTE) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name) : (this.propertySheetModel.isChildSupported(name) ? this.propertySheetModel.createChild((View)this, name, this.getModel()) : super.createChild(name)));
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        try {
            this.populateRulesTable();
            CachedPolicy cachedPolicy = this.getCachedPolicy();
            Policy policy = cachedPolicy.getPolicy();
            String realmName = (String)this.getPageSessionAttribute("currentRealm");
            PolicyModel model = (PolicyModel)this.getModel();
            CCButton btn = (CCButton)this.getChild("tblRulesButtonAdd");
            if (!model.canCreateRule(policy, realmName)) {
                btn.setDisabled(true);
            }
            btn = (CCButton)this.getChild("tblRulesButtonDelete");
            btn.setDisabled(true);
            if (!this.isInlineAlertMessageSet() && cachedPolicy.isPolicyModified() && this.isProfilePage()) {
                this.setInlineAlertMessage("info", "message.information", "policy.unsaved.message");
            }
        }
        catch (AMConsoleException e) {
            CCButton btn = (CCButton)this.getChild("tblRulesButtonAdd");
            btn.setDisabled(true);
            btn = (CCButton)this.getChild("tblRulesButtonDelete");
            btn.setDisabled(true);
        }
    }

    protected void populateReferralsTable() throws AMConsoleException {
        this.tblReferralsModel.clearAll();
        CachedPolicy cachedPolicy = this.getCachedPolicy();
        Policy policy = cachedPolicy.getPolicy();
        Set referralsNames = policy.getReferralNames();
        if (referralsNames != null && !referralsNames.isEmpty()) {
            PolicyModel model = (PolicyModel)this.getModel();
            String realmName = (String)this.getPageSessionAttribute("currentRealm");
            Map localizedRflTypeNames = model.getActiveReferralTypes(realmName);
            boolean firstEntry = true;
            Iterator iter = referralsNames.iterator();
            while (iter.hasNext()) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    this.tblReferralsModel.appendRow();
                }
                try {
                    String name = (String)iter.next();
                    Referral referral = policy.getReferral(name);
                    this.tblReferralsModel.setValue(TBL_REFERRALS_DATA_NAME, (Object)name);
                    String rflTypeName = referral.getReferralTypeName();
                    String displayName = (String)localizedRflTypeNames.get(rflTypeName);
                    if (displayName == null) {
                        displayName = rflTypeName;
                    }
                    this.tblReferralsModel.setValue(TBL_REFERRALS_DATA_TYPE, (Object)displayName);
                    this.tblReferralsModel.setValue(TBL_REFERRALS_ACTION_HREF, (Object)name);
                }
                catch (NameNotFoundException e) {
                    debug.warning("PolicyOpViewBeanBase.populateReferralsTable", (Throwable)e);
                }
            }
        }
    }

    protected void populateSubjectsTable() throws AMConsoleException {
        this.tblSubjectsModel.clearAll();
        CachedPolicy cachedPolicy = this.getCachedPolicy();
        Policy policy = cachedPolicy.getPolicy();
        Set subjectsNames = policy.getSubjectNames();
        if (subjectsNames != null && !subjectsNames.isEmpty()) {
            PolicyModel model = (PolicyModel)this.getModel();
            String realmName = (String)this.getPageSessionAttribute("currentRealm");
            QueryResults queryResults = model.getActiveSubjectTypes(realmName);
            Map localizedSbjTypeNames = (Map)queryResults.getResults();
            boolean firstEntry = true;
            Iterator iter = subjectsNames.iterator();
            while (iter.hasNext()) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    this.tblSubjectsModel.appendRow();
                }
                try {
                    String name = (String)iter.next();
                    Subject subject = policy.getSubject(name);
                    this.tblSubjectsModel.setValue(TBL_SUBJECTS_DATA_NAME, (Object)name);
                    String sbjTypeName = model.getSubjectTypeName(realmName, subject);
                    String displayName = (String)localizedSbjTypeNames.get(sbjTypeName);
                    if (displayName == null) {
                        displayName = sbjTypeName;
                    }
                    this.tblSubjectsModel.setValue(TBL_SUBJECTS_DATA_TYPE, (Object)displayName);
                    this.tblSubjectsModel.setValue(TBL_SUBJECTS_ACTION_HREF, (Object)name);
                }
                catch (NameNotFoundException e) {
                    debug.warning("PolicyOpViewBeanBase.populateSubjectsTable", (Throwable)e);
                }
            }
        }
    }

    protected void populateResponseProvidersTable() throws AMConsoleException {
        this.tblResponseProvidersModel.clearAll();
        CachedPolicy cachedPolicy = this.getCachedPolicy();
        Policy policy = cachedPolicy.getPolicy();
        Set responseProviderNames = policy.getResponseProviderNames();
        if (responseProviderNames != null && !responseProviderNames.isEmpty()) {
            PolicyModel model = (PolicyModel)this.getModel();
            String realmName = (String)this.getPageSessionAttribute("currentRealm");
            Map localizedRespAttrTypeNames = model.getActiveResponseProviderTypes(realmName);
            boolean firstEntry = true;
            Iterator i = responseProviderNames.iterator();
            while (i.hasNext()) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    this.tblResponseProvidersModel.appendRow();
                }
                try {
                    String name = (String)i.next();
                    ResponseProvider provider = policy.getResponseProvider(name);
                    this.tblResponseProvidersModel.setValue(TBL_RESPONSE_ATTRIBUTES_DATA_NAME, (Object)name);
                    String respAttrTypeName = model.getResponseProviderTypeName(realmName, provider);
                    String displayName = (String)localizedRespAttrTypeNames.get(respAttrTypeName);
                    if (displayName == null) {
                        displayName = respAttrTypeName;
                    }
                    this.tblResponseProvidersModel.setValue(TBL_RESPONSE_ATTRIBUTES_DATA_TYPE, (Object)displayName);
                    this.tblResponseProvidersModel.setValue(TBL_RESPONSE_ATTRIBUTES_ACTION_HREF, (Object)name);
                }
                catch (NameNotFoundException e) {
                    debug.warning("PolicyOpViewBeanBase.populateResponseProvidersTable", (Throwable)e);
                }
            }
        }
    }

    protected void populateConditionsTable() throws AMConsoleException {
        this.tblConditionsModel.clearAll();
        CachedPolicy cachedPolicy = this.getCachedPolicy();
        Policy policy = cachedPolicy.getPolicy();
        Set conditionNames = policy.getConditionNames();
        if (conditionNames != null && !conditionNames.isEmpty()) {
            PolicyModel model = (PolicyModel)this.getModel();
            String realmName = (String)this.getPageSessionAttribute("currentRealm");
            Map localizedCndTypeNames = model.getActiveConditionTypes(realmName);
            boolean firstEntry = true;
            Iterator iter = conditionNames.iterator();
            while (iter.hasNext()) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    this.tblConditionsModel.appendRow();
                }
                try {
                    String name = (String)iter.next();
                    Condition condition = policy.getCondition(name);
                    this.tblConditionsModel.setValue(TBL_CONDITIONS_DATA_NAME, (Object)name);
                    String cndTypeName = model.getConditionTypeName(realmName, condition);
                    String displayName = (String)localizedCndTypeNames.get(cndTypeName);
                    if (displayName == null) {
                        displayName = cndTypeName;
                    }
                    this.tblConditionsModel.setValue(TBL_CONDITIONS_DATA_TYPE, (Object)displayName);
                    this.tblConditionsModel.setValue(TBL_CONDITIONS_ACTION_HREF, (Object)name);
                }
                catch (NameNotFoundException e) {
                    debug.warning("PolicyOpViewBeanBase.populateConditionsTable", (Throwable)e);
                }
            }
        }
    }

    protected void populateRulesTable() throws AMConsoleException {
        this.tblRulesModel.clearAll();
        CachedPolicy cachedPolicy = this.getCachedPolicy();
        Policy policy = cachedPolicy.getPolicy();
        Set ruleNames = policy.getRuleNames();
        if (ruleNames != null && !ruleNames.isEmpty()) {
            PolicyModel model = (PolicyModel)this.getModel();
            Map localizedSvcTypeNames = model.getServiceTypeNames();
            boolean firstEntry = true;
            Iterator iter = ruleNames.iterator();
            while (iter.hasNext()) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    this.tblRulesModel.appendRow();
                }
                try {
                    String name = (String)iter.next();
                    Rule rule = policy.getRule(name);
                    this.tblRulesModel.setValue(TBL_RULES_DATA_NAME, (Object)name);
                    this.tblRulesModel.setValue(TBL_RULES_DATA_TYPE, localizedSvcTypeNames.get(rule.getServiceTypeName()));
                    this.tblRulesModel.setValue(TBL_RULES_ACTION_HREF, (Object)name);
                }
                catch (NameNotFoundException e) {
                    debug.warning("PolicyOpViewBeanBase.populateRulesTable", (Throwable)e);
                }
            }
        }
    }

    protected void populateAttributes() throws AMConsoleException {
        CachedPolicy cachedPolicy = this.getCachedPolicy();
        Policy policy = cachedPolicy.getPolicy();
        this.propertySheetModel.setValue("tfName", policy.getName());
        this.propertySheetModel.setValue(ATTR_DESCRIPTION, policy.getDescription());
        this.propertySheetModel.setValue(ATTR_ISACTIVE, policy.isActive() ? "true" : "false");
    }

    protected void forwardToPolicyViewBean() {
        PolicyViewBean vb = (PolicyViewBean)this.getViewBean(PolicyViewBean.class);
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleTblRulesButtonAddRequest(RequestInvocationEvent event) throws ModelControlException {
        PolicyModel model = (PolicyModel)this.getModel();
        try {
            if (!this.reconstructPolicy()) {
                this.setPageSessionAttribute("SelectServiceTypeViewBeanCallingVB", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
                SelectServiceTypeViewBean vb = (SelectServiceTypeViewBean)this.getViewBean(SelectServiceTypeViewBean.class);
                this.unlockPageTrail();
                this.passPgSessionMap((ViewBean)vb);
                vb.forwardTo(this.getRequestContext());
            } else {
                this.forwardTo();
            }
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyOpViewBeanBase.handleTblRulesButtonAddRequest", (Throwable)e);
            this.redirectToStartURL();
        }
    }

    public void handleTblRulesButtonDeleteRequest(RequestInvocationEvent event) throws ModelControlException {
        CCActionTable table = (CCActionTable)this.getChild(TBL_RULES);
        table.restoreStateData();
        try {
            CachedPolicy cachedPolicy = this.getCachedPolicy();
            Policy policy = cachedPolicy.getPolicy();
            Integer[] selected = this.tblRulesModel.getSelectedRows();
            for (int i = 0; i < selected.length; ++i) {
                this.tblRulesModel.setRowIndex(selected[i].intValue());
                String ruleName = (String)this.tblRulesModel.getValue(TBL_RULES_DATA_NAME);
                policy.removeRule(ruleName);
            }
            cachedPolicy.setPolicyModified(true);
            this.forwardTo();
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyOpViewBeanBase.handleTblRulesButtonDeleteRequest", (Throwable)e);
            this.redirectToStartURL();
        }
    }

    public void handleTblRulesEditLinkRequest(RequestInvocationEvent event) throws ModelControlException {
        PolicyModel model = (PolicyModel)this.getModel();
        String name = (String)this.getDisplayFieldValue(TBL_RULES_ACTION_HREF);
        this.setPageSessionAttribute("RuleOpViewBeanBaseCallingVB", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
        this.setPageSessionAttribute("editRuleName", (Serializable)((Object)name));
        try {
            CachedPolicy cachedPolicy = this.getCachedPolicy();
            Policy policy = cachedPolicy.getPolicy();
            Rule rule = policy.getRule(name);
            RuleEditViewBean vb = null;
            if (rule.getResourceName() == null) {
                vb = (RuleNoResourceEditViewBean)this.getViewBean(RuleNoResourceEditViewBean.class);
                this.setPageSessionAttribute("withResource", Boolean.FALSE);
            } else {
                String serviceType;
                String realmName = (String)this.getPageSessionAttribute("currentRealm");
                vb = model.canCreateNewResource(realmName, serviceType = rule.getServiceTypeName()) ? (RuleEditViewBean)this.getViewBean(RuleEditViewBean.class) : (RuleEditViewBean)this.getViewBean(RuleWithPrefixEditViewBean.class);
                this.setPageSessionAttribute("withResource", Boolean.TRUE);
            }
            this.unlockPageTrail();
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
        catch (NameNotFoundException e) {
            this.setInlineAlertMessage("error", "message.error", this.getModel().getErrorString(e));
            this.forwardTo();
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyOpViewBeanBase.handleTblRulesEditLinkRequest", (Throwable)e);
            this.redirectToStartURL();
        }
    }

    protected boolean reconstructPolicy() throws ModelControlException, AMConsoleException {
        PolicyModel model = (PolicyModel)this.getModel();
        return this.reconstructPolicyGeneral(model);
    }

    private boolean reconstructPolicyGeneral(PolicyModel model) throws AMConsoleException {
        boolean active;
        boolean bError = false;
        String policyName = (String)this.propertySheetModel.getValue("tfName");
        policyName = policyName.trim();
        String description = (String)this.propertySheetModel.getValue(ATTR_DESCRIPTION);
        description = description.trim();
        String isActive = (String)this.propertySheetModel.getValue(ATTR_ISACTIVE);
        boolean bl = active = isActive != null && isActive.equals("true");
        if (policyName.length() == 0) {
            this.setInlineAlertMessage("error", "message.error", "policy.missing.policyName");
            bError = true;
            return bError;
        }
        CachedPolicy cachedPolicy = this.getCachedPolicy();
        Policy policy = cachedPolicy.getPolicy();
        try {
            policy.setDescription(description);
            policy.setActive(active);
            policy.setName(policyName);
        }
        catch (InvalidNameException e) {
            this.setInlineAlertMessage("error", "message.error", model.getErrorString(e));
            bError = true;
        }
        return bError;
    }

    public void handleTblReferralsButtonAddRequest(RequestInvocationEvent event) throws ModelControlException {
        String curRealm = (String)this.getPageSessionAttribute("currentRealm");
        PolicyModel model = (PolicyModel)this.getModel();
        try {
            if (!this.reconstructPolicy()) {
                this.unlockPageTrail();
                Map activeReferralTypes = model.getActiveReferralTypes(curRealm);
                if (activeReferralTypes.size() == 1) {
                    String referralType = (String)activeReferralTypes.keySet().iterator().next();
                    String viewBeanURL = model.getReferralViewBeanURL(curRealm, referralType);
                    this.removePageSessionAttribute(WIZARD);
                    this.setPageSessionAttribute("ReferralOpViewBeanBaseCallingVB", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
                    if (viewBeanURL != null && viewBeanURL.trim().length() > 0) {
                        this.forwardToReferralURL(viewBeanURL, "", referralType, curRealm, "add");
                    } else {
                        this.forwardToReferralAddViewBean(referralType);
                    }
                } else {
                    this.setPageSessionAttribute("SelectReferralTypeViewBeanCallingVB", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
                    SelectReferralTypeViewBean vb = (SelectReferralTypeViewBean)this.getViewBean(SelectReferralTypeViewBean.class);
                    this.setPageSessionAttribute(WIZARD, (Serializable)((Object)"true"));
                    this.passPgSessionMap((ViewBean)vb);
                    vb.forwardTo(this.getRequestContext());
                }
            } else {
                this.forwardTo();
            }
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyOpViewBeanBase.handleTblReferralsButtonAddRequest", (Throwable)e);
            this.redirectToStartURL();
        }
    }

    private void forwardToReferralAddViewBean(String referralType) {
        ReferralAddViewBean vb = (ReferralAddViewBean)this.getViewBean(ReferralAddViewBean.class);
        this.setPageSessionAttribute("ReferralOpViewBeanBaseCallingVB", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
        this.setPageSessionAttribute("referralTypType", (Serializable)((Object)referralType));
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    private void forwardToReferralURL(String url, String referralName, String referralType, String realmName, String op) {
        ReferralProxyViewBean vb = (ReferralProxyViewBean)this.getViewBean(ReferralProxyViewBean.class);
        this.passPgSessionMap((ViewBean)vb);
        vb.setURL(url, op);
        vb.setDisplayFieldValue("rflType", referralType);
        vb.setDisplayFieldValue("rflName", referralName);
        if (realmName == null || realmName.trim().length() == 0) {
            realmName = AMModelBase.getStartDN(this.getRequestContext().getRequest());
        }
        vb.setDisplayFieldValue("locDN", realmName);
        vb.setDisplayFieldValue("cachedID", (String)this.getPageSessionAttribute("policyCacheID"));
        vb.setDisplayFieldValue("tfOp", op);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleTblReferralsButtonDeleteRequest(RequestInvocationEvent event) throws ModelControlException {
        CCActionTable table = (CCActionTable)this.getChild(TBL_REFERRALS);
        table.restoreStateData();
        try {
            CachedPolicy cachedPolicy = this.getCachedPolicy();
            Policy policy = cachedPolicy.getPolicy();
            Integer[] selected = this.tblReferralsModel.getSelectedRows();
            for (int i = 0; i < selected.length; ++i) {
                this.tblReferralsModel.setRowIndex(selected[i].intValue());
                String name = (String)this.tblReferralsModel.getValue(TBL_REFERRALS_DATA_NAME);
                policy.removeReferral(name);
            }
            cachedPolicy.setPolicyModified(true);
            this.populateReferralsTable();
            this.forwardTo();
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyOpViewBeanBase.handleTblReferralsButtonDeleteRequest", (Throwable)e);
            this.redirectToStartURL();
        }
    }

    public void handleTblReferralsEditLinkRequest(RequestInvocationEvent event) throws ModelControlException {
        PolicyModel model = (PolicyModel)this.getModel();
        String name = (String)this.getDisplayFieldValue(TBL_REFERRALS_ACTION_HREF);
        this.setPageSessionAttribute("ReferralOpViewBeanBaseCallingVB", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
        this.setPageSessionAttribute("editReferralName", (Serializable)((Object)name));
        try {
            CachedPolicy cachedPolicy = this.getCachedPolicy();
            Policy policy = cachedPolicy.getPolicy();
            Referral referral = policy.getReferral(name);
            String realmName = (String)this.getPageSessionAttribute("currentRealm");
            String referralType = referral.getReferralTypeName();
            String viewBeanURL = model.getReferralViewBeanURL(realmName, referralType);
            this.unlockPageTrail();
            if (viewBeanURL != null && viewBeanURL.trim().length() > 0) {
                this.forwardToReferralURL(viewBeanURL, name, referralType, realmName, "edit");
            } else {
                this.forwardToReferralEditViewBean(model, realmName, name, referralType);
            }
        }
        catch (NameNotFoundException e) {
            this.setInlineAlertMessage("error", "message.error", this.getModel().getErrorString(e));
            this.forwardTo();
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyOpViewBeanBase.handleTblReferralsEditLinkRequest", (Throwable)e);
            this.redirectToStartURL();
        }
    }

    private void forwardToReferralEditViewBean(PolicyModel model, String realmName, String name, String referralType) {
        ReferralEditViewBean vb = (ReferralEditViewBean)this.getViewBean(ReferralEditViewBean.class);
        this.setPageSessionAttribute("ReferralOpViewBeanBaseCallingVB", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
        this.setPageSessionAttribute(TBL_REFERRALS_DATA_NAME, (Serializable)((Object)name));
        this.setPageSessionAttribute("referralTypType", (Serializable)((Object)referralType));
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleTblSubjectsButtonAddRequest(RequestInvocationEvent event) throws ModelControlException {
        String curRealm = (String)this.getPageSessionAttribute("currentRealm");
        PolicyModel model = (PolicyModel)this.getModel();
        try {
            if (!this.reconstructPolicy()) {
                QueryResults queryResults = model.getActiveSubjectTypes(curRealm);
                Map activeSubjectTypes = (Map)queryResults.getResults();
                this.unlockPageTrail();
                if (activeSubjectTypes.size() == 1) {
                    String subjectType = (String)activeSubjectTypes.keySet().iterator().next();
                    String viewBeanURL = model.getSubjectViewBeanURL(curRealm, subjectType);
                    this.removePageSessionAttribute(WIZARD);
                    this.setPageSessionAttribute("SubjectOpViewBeanBaseCallingVB", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
                    if (viewBeanURL != null && viewBeanURL.trim().length() > 0) {
                        this.forwardToSubjectURL(viewBeanURL, "", subjectType, curRealm, "add");
                    } else {
                        this.forwardToSubjectAddViewBean(curRealm, subjectType);
                    }
                } else {
                    this.setPageSessionAttribute("SelectSubjectTypeViewBeanCallingVB", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
                    SelectSubjectTypeViewBean vb = (SelectSubjectTypeViewBean)this.getViewBean(SelectSubjectTypeViewBean.class);
                    this.setPageSessionAttribute(WIZARD, (Serializable)((Object)"true"));
                    this.passPgSessionMap((ViewBean)vb);
                    vb.forwardTo(this.getRequestContext());
                }
            } else {
                this.forwardTo();
            }
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyOpViewBeanBase.handleTblSubjectsButtonAddRequest", (Throwable)e);
            this.redirectToStartURL();
        }
    }

    private void forwardToSubjectURL(String url, String subjectName, String subjectType, String realmName, String op) {
        SubjectProxyViewBean vb = (SubjectProxyViewBean)this.getViewBean(SubjectProxyViewBean.class);
        this.passPgSessionMap((ViewBean)vb);
        vb.setURL(url, op);
        vb.setDisplayFieldValue("sbjType", subjectType);
        vb.setDisplayFieldValue("sbjName", subjectName);
        if (realmName == null || realmName.trim().length() == 0) {
            realmName = AMModelBase.getStartDN(this.getRequestContext().getRequest());
        }
        vb.setDisplayFieldValue("locDN", realmName);
        vb.setDisplayFieldValue("cachedID", (String)this.getPageSessionAttribute("policyCacheID"));
        vb.setDisplayFieldValue("tfOp", op);
        vb.forwardTo(this.getRequestContext());
    }

    private void forwardToSubjectAddViewBean(String curRealm, String subjectType) {
        SubjectAddViewBean vb = this.subjectHasValueSyntax(curRealm, subjectType) ? (SubjectAddViewBean)this.getViewBean(SubjectAddViewBean.class) : (SubjectAddViewBean)this.getViewBean(SubjectNoneAddViewBean.class);
        this.setPageSessionAttribute("SubjectOpViewBeanBaseCallingVB", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
        this.setPageSessionAttribute(TBL_SUBJECTS_DATA_TYPE, (Serializable)((Object)subjectType));
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleTblSubjectsEditLinkRequest(RequestInvocationEvent event) throws ModelControlException {
        PolicyModel model = (PolicyModel)this.getModel();
        String name = (String)this.getDisplayFieldValue(TBL_SUBJECTS_ACTION_HREF);
        this.setPageSessionAttribute("SubjectOpViewBeanBaseCallingVB", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
        this.setPageSessionAttribute("editSubjectName", (Serializable)((Object)name));
        try {
            CachedPolicy cachedPolicy = this.getCachedPolicy();
            Policy policy = cachedPolicy.getPolicy();
            Subject subject = policy.getSubject(name);
            String realmName = (String)this.getPageSessionAttribute("currentRealm");
            String subjectType = model.getSubjectTypeName(realmName, subject);
            String viewBeanURL = model.getSubjectViewBeanURL(realmName, subjectType);
            this.unlockPageTrail();
            if (viewBeanURL != null && viewBeanURL.trim().length() > 0) {
                this.forwardToSubjectURL(viewBeanURL, name, subjectType, realmName, "edit");
            } else {
                this.forwardToSubjectEditViewBean(model, realmName, name, subjectType);
            }
        }
        catch (NameNotFoundException e) {
            this.setInlineAlertMessage("error", "message.error", model.getErrorString(e));
            this.forwardTo();
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyOpViewBeanBase.handleTblSubjectsEditLinkRequest", (Throwable)e);
            this.redirectToStartURL();
        }
    }

    private void forwardToSubjectEditViewBean(PolicyModel model, String realmName, String name, String subjectType) {
        SubjectEditViewBean vb = this.subjectHasValueSyntax(realmName, subjectType) ? (SubjectEditViewBean)this.getViewBean(SubjectEditViewBean.class) : (SubjectEditViewBean)this.getViewBean(SubjectNoneEditViewBean.class);
        this.setPageSessionAttribute("SubjectOpViewBeanBaseCallingVB", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
        this.setPageSessionAttribute(TBL_SUBJECTS_DATA_NAME, (Serializable)((Object)name));
        this.setPageSessionAttribute(TBL_SUBJECTS_DATA_TYPE, (Serializable)((Object)subjectType));
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    private boolean subjectHasValueSyntax(String realmName, String subjectType) {
        PolicyModel model = (PolicyModel)this.getModel();
        Syntax syntax = model.getSubjectSyntax(realmName, subjectType);
        int displaySyntax = AMDisplayType.getDisplaySyntax(syntax);
        return displaySyntax == 0 || displaySyntax == 10 || displaySyntax == 11;
    }

    public void handleTblSubjectsButtonDeleteRequest(RequestInvocationEvent event) throws ModelControlException {
        CCActionTable table = (CCActionTable)this.getChild(TBL_SUBJECTS);
        table.restoreStateData();
        try {
            CachedPolicy cachedPolicy = this.getCachedPolicy();
            Policy policy = cachedPolicy.getPolicy();
            Integer[] selected = this.tblSubjectsModel.getSelectedRows();
            for (int i = 0; i < selected.length; ++i) {
                this.tblSubjectsModel.setRowIndex(selected[i].intValue());
                String subjectName = (String)this.tblSubjectsModel.getValue(TBL_SUBJECTS_DATA_NAME);
                policy.removeSubject(subjectName);
            }
            cachedPolicy.setPolicyModified(true);
            this.populateSubjectsTable();
            this.forwardTo();
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyOpViewBeanBase.handleTblSubjectsButtonDeleteRequest", (Throwable)e);
            this.redirectToStartURL();
        }
    }

    public void handleTblResponseProvidersButtonAddRequest(RequestInvocationEvent event) throws ModelControlException {
        String curRealm = (String)this.getPageSessionAttribute("currentRealm");
        PolicyModel model = (PolicyModel)this.getModel();
        try {
            if (!this.reconstructPolicy()) {
                Map activeTypes = model.getActiveResponseProviderTypes(curRealm);
                this.unlockPageTrail();
                if (activeTypes.size() == 1) {
                    String respAttrType = (String)activeTypes.keySet().iterator().next();
                    String viewBeanURL = model.getResponseProviderViewBeanURL(curRealm, respAttrType);
                    this.removePageSessionAttribute(WIZARD);
                    this.setPageSessionAttribute("ResponseProviderOpViewBeanBaseCallingVB", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
                    if (viewBeanURL != null && viewBeanURL.trim().length() > 0) {
                        this.forwardToResponseProviderURL(viewBeanURL, "", respAttrType, curRealm, "add");
                    } else {
                        this.forwardToResponseProviderAddViewBean(curRealm, respAttrType);
                    }
                } else {
                    this.setPageSessionAttribute("SelectResponseProviderTypeViewBeanCallingVB", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
                    SelectResponseProviderTypeViewBean vb = (SelectResponseProviderTypeViewBean)this.getViewBean(SelectResponseProviderTypeViewBean.class);
                    this.setPageSessionAttribute(WIZARD, (Serializable)((Object)"true"));
                    this.passPgSessionMap((ViewBean)vb);
                    vb.forwardTo(this.getRequestContext());
                }
            } else {
                this.forwardTo();
            }
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyOpViewBeanBase.handleTblResponseProvidersButtonAddRequest", (Throwable)e);
            this.redirectToStartURL();
        }
    }

    private void forwardToResponseProviderURL(String url, String responseProviderName, String responseProviderType, String realmName, String op) {
        ResponseProviderProxyViewBean vb = (ResponseProviderProxyViewBean)this.getViewBean(ResponseProviderProxyViewBean.class);
        this.setPageSessionAttribute("ResponseProviderOpViewBeanBaseCallingVB", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
        this.passPgSessionMap((ViewBean)vb);
        vb.setURL(url, op);
        vb.setDisplayFieldValue("providerType", responseProviderType);
        vb.setDisplayFieldValue("providerName", responseProviderName);
        if (realmName == null || realmName.trim().length() == 0) {
            realmName = AMModelBase.getStartDN(this.getRequestContext().getRequest());
        }
        vb.setDisplayFieldValue("locDN", realmName);
        vb.setDisplayFieldValue("cachedID", (String)this.getPageSessionAttribute("policyCacheID"));
        vb.setDisplayFieldValue("tfOp", op);
        vb.forwardTo(this.getRequestContext());
    }

    private void forwardToResponseProviderAddViewBean(String curRealm, String responseProviderType) {
        ResponseProviderAddViewBean vb = (ResponseProviderAddViewBean)this.getViewBean(ResponseProviderAddViewBean.class);
        this.setPageSessionAttribute("ResponseProviderOpViewBeanBaseCallingVB", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
        this.setPageSessionAttribute("providerType", (Serializable)((Object)responseProviderType));
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleTblResponseProvidersEditLinkRequest(RequestInvocationEvent event) throws ModelControlException {
        PolicyModel model = (PolicyModel)this.getModel();
        String name = (String)this.getDisplayFieldValue(TBL_RESPONSE_ATTRIBUTES_ACTION_HREF);
        this.setPageSessionAttribute("ResponseProviderOpViewBeanBaseCallingVB", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
        this.setPageSessionAttribute("editResponseProviderName", (Serializable)((Object)name));
        try {
            CachedPolicy cachedPolicy = this.getCachedPolicy();
            Policy policy = cachedPolicy.getPolicy();
            ResponseProvider provider = policy.getResponseProvider(name);
            String realmName = (String)this.getPageSessionAttribute("currentRealm");
            String responseProviderType = model.getResponseProviderTypeName(realmName, provider);
            String viewBeanURL = model.getResponseProviderViewBeanURL(realmName, responseProviderType);
            this.unlockPageTrail();
            if (viewBeanURL != null && viewBeanURL.trim().length() > 0) {
                this.forwardToResponseProviderURL(viewBeanURL, name, responseProviderType, realmName, "edit");
            } else {
                this.forwardToResponseProviderEditViewBean(model, realmName, name, responseProviderType);
            }
        }
        catch (NameNotFoundException e) {
            this.setInlineAlertMessage("error", "message.error", model.getErrorString(e));
            this.forwardTo();
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyOpViewBeanBase.handleTblResponseProvidersEditLinkRequest", (Throwable)e);
            this.redirectToStartURL();
        }
    }

    private void forwardToResponseProviderEditViewBean(PolicyModel model, String realmName, String name, String responseProviderType) {
        ResponseProviderEditViewBean vb = (ResponseProviderEditViewBean)this.getViewBean(ResponseProviderEditViewBean.class);
        this.setPageSessionAttribute("ResponseProviderOpViewBeanBaseCallingVB", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
        this.setPageSessionAttribute("providerName", (Serializable)((Object)name));
        this.setPageSessionAttribute("providerType", (Serializable)((Object)responseProviderType));
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleTblResponseProvidersButtonDeleteRequest(RequestInvocationEvent event) throws ModelControlException {
        CCActionTable table = (CCActionTable)this.getChild(TBL_RESPONSE_ATTRIBUTES);
        table.restoreStateData();
        try {
            CachedPolicy cachedPolicy = this.getCachedPolicy();
            Policy policy = cachedPolicy.getPolicy();
            Integer[] selected = this.tblResponseProvidersModel.getSelectedRows();
            for (int i = 0; i < selected.length; ++i) {
                this.tblResponseProvidersModel.setRowIndex(selected[i].intValue());
                String responseProviderName = (String)this.tblResponseProvidersModel.getValue(TBL_RESPONSE_ATTRIBUTES_DATA_NAME);
                policy.removeResponseProvider(responseProviderName);
            }
            cachedPolicy.setPolicyModified(true);
            this.populateResponseProvidersTable();
            this.forwardTo();
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyOpViewBeanBase.handleTblResponseProvidersButtonDeleteRequest", (Throwable)e);
            this.redirectToStartURL();
        }
    }

    public void handleTblConditionsButtonAddRequest(RequestInvocationEvent event) throws ModelControlException {
        PolicyModel model = (PolicyModel)this.getModel();
        try {
            if (!this.reconstructPolicy()) {
                String curRealm = (String)this.getPageSessionAttribute("currentRealm");
                Map activeConditionTypes = model.getActiveConditionTypes(curRealm);
                this.unlockPageTrail();
                if (activeConditionTypes.size() == 1) {
                    String conditionType = (String)activeConditionTypes.keySet().iterator().next();
                    String viewBeanURL = model.getConditionViewBeanURL(curRealm, conditionType);
                    this.removePageSessionAttribute(WIZARD);
                    this.setPageSessionAttribute("ConditionOpViewBeanBaseCallingVB", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
                    if (viewBeanURL != null && viewBeanURL.trim().length() > 0) {
                        this.forwardToConditionURL(viewBeanURL, "", conditionType, curRealm, "add");
                    } else {
                        this.forwardToConditionAddViewBean(curRealm, conditionType);
                    }
                } else {
                    this.setPageSessionAttribute("SelectConditionTypeViewBeanCallingVB", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
                    SelectConditionTypeViewBean vb = (SelectConditionTypeViewBean)this.getViewBean(SelectConditionTypeViewBean.class);
                    this.setPageSessionAttribute(WIZARD, (Serializable)((Object)"true"));
                    this.passPgSessionMap((ViewBean)vb);
                    vb.forwardTo(this.getRequestContext());
                }
            } else {
                this.forwardTo();
            }
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyOpViewBeanBase.handleTblConditionsButtonAddRequest", (Throwable)e);
            this.redirectToStartURL();
        }
    }

    private void forwardToConditionURL(String url, String conditionName, String conditionType, String realmName, String op) {
        ConditionProxyViewBean vb = (ConditionProxyViewBean)this.getViewBean(ConditionProxyViewBean.class);
        this.passPgSessionMap((ViewBean)vb);
        vb.setURL(url, op);
        vb.setDisplayFieldValue("cdnType", conditionType);
        vb.setDisplayFieldValue("cdnName", conditionName);
        if (realmName == null || realmName.trim().length() == 0) {
            realmName = AMModelBase.getStartDN(this.getRequestContext().getRequest());
        }
        vb.setDisplayFieldValue("locDN", realmName);
        vb.setDisplayFieldValue("cachedID", (String)this.getPageSessionAttribute("policyCacheID"));
        vb.setDisplayFieldValue("tfOp", op);
        vb.forwardTo(this.getRequestContext());
    }

    private void forwardToConditionAddViewBean(String curRealm, String conditionType) {
        ConditionAddViewBean vb = (ConditionAddViewBean)this.getViewBean(ConditionAddViewBean.class);
        this.setPageSessionAttribute("ConditionOpViewBeanBaseCallingVB", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
        this.setPageSessionAttribute(TBL_CONDITIONS_DATA_TYPE, (Serializable)((Object)conditionType));
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    private void forwardToConditionEditViewBean(PolicyModel model, String curRealm, String name, String conditionType) {
        ConditionEditViewBean vb = (ConditionEditViewBean)this.getViewBean(ConditionEditViewBean.class);
        this.setPageSessionAttribute("ConditionOpViewBeanBaseCallingVB", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
        this.setPageSessionAttribute(TBL_CONDITIONS_DATA_NAME, (Serializable)((Object)name));
        this.setPageSessionAttribute(TBL_CONDITIONS_DATA_TYPE, (Serializable)((Object)conditionType));
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleTblConditionsEditLinkRequest(RequestInvocationEvent event) throws ModelControlException {
        PolicyModel model = (PolicyModel)this.getModel();
        String name = (String)this.getDisplayFieldValue(TBL_CONDITIONS_ACTION_HREF);
        this.setPageSessionAttribute("ConditionOpViewBeanBaseCallingVB", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
        this.setPageSessionAttribute("editConditionName", (Serializable)((Object)name));
        try {
            CachedPolicy cachedPolicy = this.getCachedPolicy();
            Policy policy = cachedPolicy.getPolicy();
            Condition condition = policy.getCondition(name);
            String realmName = (String)this.getPageSessionAttribute("currentRealm");
            String conditionType = model.getConditionTypeName(realmName, condition);
            String viewBeanURL = model.getConditionViewBeanURL(realmName, conditionType);
            this.unlockPageTrail();
            if (viewBeanURL != null && viewBeanURL.trim().length() > 0) {
                this.forwardToConditionURL(viewBeanURL, name, conditionType, realmName, "edit");
            } else {
                this.forwardToConditionEditViewBean(model, realmName, name, conditionType);
            }
        }
        catch (NameNotFoundException e) {
            this.setInlineAlertMessage("error", "message.error", model.getErrorString(e));
            this.forwardTo();
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyOpViewBeanBase.handleTblConditionsButtonDeleteRequest", (Throwable)e);
            this.redirectToStartURL();
        }
    }

    public void handleTblConditionsButtonDeleteRequest(RequestInvocationEvent event) throws ModelControlException {
        CCActionTable table = (CCActionTable)this.getChild(TBL_CONDITIONS);
        table.restoreStateData();
        try {
            CachedPolicy cachedPolicy = this.getCachedPolicy();
            Policy policy = cachedPolicy.getPolicy();
            Integer[] selected = this.tblConditionsModel.getSelectedRows();
            for (int i = 0; i < selected.length; ++i) {
                this.tblConditionsModel.setRowIndex(selected[i].intValue());
                String conditionName = (String)this.tblConditionsModel.getValue(TBL_CONDITIONS_DATA_NAME);
                policy.removeCondition(conditionName);
            }
            cachedPolicy.setPolicyModified(true);
            this.populateConditionsTable();
            this.forwardTo();
        }
        catch (AMConsoleException e) {
            debug.warning("PolicyOpViewBeanBase.handleTblConditionsButtonDeleteRequest", (Throwable)e);
            this.redirectToStartURL();
        }
    }

    public void handleButton3Request(RequestInvocationEvent event) {
        this.backTrail();
        this.forwardToPolicyViewBean();
    }

    protected String getBackButtonLabel() {
        return this.getBackButtonLabel("table.policy.title.name");
    }

    protected abstract void createTableModels();

    protected abstract void createPageTitleModel();

    protected abstract String getPropertyXMLFileName(boolean var1);

    protected abstract void populateTables();

    protected abstract boolean isProfilePage();

    static {
        PROPERTY_MAPPING.put("tfName", Collections.EMPTY_SET);
        PROPERTY_MAPPING.put(ATTR_DESCRIPTION, Collections.EMPTY_SET);
        PROPERTY_MAPPING.put(ATTR_ISACTIVE, Collections.EMPTY_SET);
    }
}

