/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.service;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.common.configuration.ServerPropertyValidator;
import com.sun.identity.common.configuration.UnknownPropertyNameException;
import com.sun.identity.console.base.AMPrimaryMastHeadViewBean;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.AMViewBeanBase;
import com.sun.identity.console.base.AMViewConfig;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.service.ServerConfigInheritViewBean;
import com.sun.identity.console.service.ServerSiteViewBean;
import com.sun.identity.console.service.model.ServerSiteModel;
import com.sun.identity.console.service.model.ServerSiteModelImpl;
import com.sun.web.ui.model.CCNavNode;
import com.sun.web.ui.model.CCNavNodeInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCCheckBox;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.tabs.CCTabs;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public abstract class ServerEditViewBeanBase
extends AMPrimaryMastHeadViewBean {
    static final String PG_ATTR_SERVER_NAME = "pgAttrServerName";
    public static final String TAB_TRACKER = "CCTabs.serverConfig";
    public static final String TAB_NAME = "cscGeneral";
    private static final String PROPERTY_PREFIX = "csc";
    private static final String PGTITLE_THREE_BTNS = "pgtitleThreeBtns";
    private static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    private static final String BTN_INHERIT = "btnInherit";
    private CCPageTitleModel ptModel;
    private AMPropertySheetModel propertySheetModel;
    private Set allPropertyNames = new HashSet();
    private Set activePropertyNames = new HashSet();
    protected boolean submitCycle;
    private static final String TEXT_TEMPLATE = "<cc name=\"{0}\" tagclass=\"com.sun.web.ui.taglib.html.CCStaticTextFieldTag\"><attribute name=\"defaultValue\" value=\"{1}\" /></cc>";

    public ServerEditViewBeanBase(String name, String url) {
        super(name);
        this.setDefaultDisplayURL(url);
    }

    protected void initialize() {
        String serverName;
        if (!this.initialized && (serverName = (String)this.getPageSessionAttribute(PG_ATTR_SERVER_NAME)) != null) {
            super.initialize();
            this.createPageTitleModel();
            this.createTabModel(serverName);
            this.createPropertyModel(serverName);
            this.registerChildren();
            this.initialized = true;
        }
    }

    protected void registerChildren() {
        super.registerChildren();
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.registerChild(PGTITLE_THREE_BTNS, CCPageTitle.class);
        this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
        this.registerChild(BTN_INHERIT, CCButton.class);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PGTITLE_THREE_BTNS) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (name.equals(PROPERTY_ATTRIBUTE) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name) : (this.propertySheetModel != null && this.propertySheetModel.isChildSupported(name) ? this.propertySheetModel.createChild((View)this, name, this.getModel()) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : super.createChild(name))));
        return view;
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = RequestManager.getRequestContext().getRequest();
        return new ServerSiteModelImpl(req, this.getPageSessionAttributes());
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        String serverName = (String)this.getPageSessionAttribute(PG_ATTR_SERVER_NAME);
        ServerSiteModel model = (ServerSiteModel)this.getModel();
        this.ptModel.setPageTitleText(model.getEditServerPageTitle(serverName));
        try {
            this.setConfigProperties(serverName, model);
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    private void setConfigProperties(String serverName, ServerSiteModel model) throws AMConsoleException {
        if (!this.submitCycle) {
            Map attributeValues = model.getServerConfiguration(serverName);
            Iterator i = this.activePropertyNames.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                String propertyName = ServerEditViewBeanBase.getActualPropertyName(name);
                String val = (String)attributeValues.get(propertyName);
                if (val == null) {
                    this.propertySheetModel.setValue(name, "");
                    continue;
                }
                this.propertySheetModel.setValue(name, val);
            }
        }
    }

    static String getActualPropertyName(String name) {
        name = name.substring(3);
        return name.replaceAll("-", ".");
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.save");
        this.ptModel.setValue("button2", (Object)"button.reset");
        this.ptModel.setValue("button3", (Object)this.getBackButtonLabel());
    }

    protected void createTabModel(String serverName) {
        AMViewConfig amconfig = AMViewConfig.getInstance();
        this.tabModel = amconfig.getTabsModel(TAB_NAME, "/", this.getRequestContext().getRequest());
        if (serverName.equals("server-default")) {
            CCNavNode node = (CCNavNode)this.tabModel.getNodeById(425);
            this.tabModel.removeNode((CCNavNodeInterface)node);
        }
        this.registerChild("tabCommon", CCTabs.class);
    }

    public boolean beginBtnInheritDisplay(ChildDisplayEvent event) {
        String serverName = (String)this.getPageSessionAttribute(PG_ATTR_SERVER_NAME);
        return !serverName.equals("server-default");
    }

    private void createPropertyModel(String serverName) {
        String xml = AMAdminUtils.getStringFromInputStream(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.getPropertyXML()));
        Set uiNames = ServerEditViewBeanBase.getAllConfigUINames(xml);
        ServerSiteModel model = (ServerSiteModel)this.getModel();
        try {
            Map attrValues = model.getServerConfiguration(serverName);
            Map defaultValues = model.getServerDefaults();
            HashMap textValues = new HashMap();
            Iterator i = uiNames.iterator();
            while (i.hasNext()) {
                String uiName = (String)i.next();
                String propertyName = ServerEditViewBeanBase.getActualPropertyName(uiName);
                if (!attrValues.containsKey(propertyName)) {
                    textValues.put(uiName, defaultValues.get(propertyName));
                } else {
                    this.activePropertyNames.add(uiName);
                    i.remove();
                }
                this.allPropertyNames.add(uiName);
            }
            if (!textValues.isEmpty()) {
                xml = this.textifyXML(xml, uiNames, textValues);
            }
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        xml = this.removeParentSiteBlob(xml);
        this.propertySheetModel = new AMPropertySheetModel(xml);
        this.propertySheetModel.clear();
    }

    static Set getAllConfigUINames(String xml) {
        HashSet<String> names = new HashSet<String>();
        int start = xml.indexOf("<cc name=\"csc");
        while (start != -1) {
            int end = xml.indexOf("\"", start + 14);
            names.add(xml.substring(start + 10, end));
            start = xml.indexOf("<cc name=\"csc", end);
        }
        return names;
    }

    private String textifyXML(String xml, Set names, Map values) {
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            String value = (String)values.get(name);
            if (value == null) {
                value = "";
            }
            Object[] params = new Object[]{name, value};
            String xmlComponent = MessageFormat.format(TEXT_TEMPLATE, params);
            int idx = xml.indexOf("<cc name=\"" + name + "\"");
            if (idx == -1) continue;
            int endIdx = xml.indexOf("</cc>", idx);
            xml = xml.substring(0, idx) + xmlComponent + xml.substring(endIdx + 5);
        }
        return xml;
    }

    protected void modifyProperties() {
        String serverName = (String)this.getPageSessionAttribute(PG_ATTR_SERVER_NAME);
        ServerSiteModel model = (ServerSiteModel)this.getModel();
        try {
            model.modifyServer(serverName, null, this.getAttributeValues());
            this.setInlineAlertMessage("info", "message.information", "serverconfig.updated");
        }
        catch (UnknownPropertyNameException e) {
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    protected Map getAttributeValues() {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator i = this.activePropertyNames.iterator();
        while (i.hasNext()) {
            String uiName = (String)i.next();
            String value = (String)this.getDisplayFieldValue(uiName);
            String propertyName = ServerEditViewBeanBase.getActualPropertyName(uiName);
            View view = this.getChild(uiName);
            if (view instanceof CCCheckBox) {
                value = value.equals("true") ? ServerPropertyValidator.getTrueValue(propertyName) : ServerPropertyValidator.getFalseValue(propertyName);
            }
            map.put(propertyName, value);
        }
        return map;
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.forwardTo();
    }

    public void handleButton3Request(RequestInvocationEvent event) throws ModelControlException {
        this.returnToHomePage();
    }

    public void handleBtnInheritRequest(RequestInvocationEvent event) throws ModelControlException {
        ServerConfigInheritViewBean vb = (ServerConfigInheritViewBean)this.getViewBean(ServerConfigInheritViewBean.class);
        vb.setPageSessionAttribute("pgAttrConfigPage", (Serializable)((Object)((Object)((Object)this)).getClass().getName()));
        vb.setPageSessionAttribute("pgAttrPropertyNames", (HashSet)this.allPropertyNames);
        this.unlockPageTrailForSwapping();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void nodeClicked(RequestInvocationEvent event, int nodeID) {
        AMViewConfig amconfig = AMViewConfig.getInstance();
        try {
            AMViewBeanBase vb = this.getTabNodeAssociatedViewBean(TAB_NAME, nodeID);
            this.unlockPageTrailForSwapping();
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
        catch (AMConsoleException e) {
            debug.error("ServerEditGeneralViewBean.nodeClicked", (Throwable)e);
            this.forwardTo();
        }
    }

    private void returnToHomePage() {
        this.backTrail();
        ServerSiteViewBean vb = (ServerSiteViewBean)this.getViewBean(ServerSiteViewBean.class);
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    protected String getBreadCrumbDisplayName() {
        return "breadcrumbs.editserver";
    }

    protected boolean startPageTrail() {
        return false;
    }

    protected String getBackButtonLabel() {
        return this.getBackButtonLabel("page.title.serversite.config");
    }

    protected String removeParentSiteBlob(String xml) {
        return xml;
    }

    protected String getTrackingTabIDName() {
        return TAB_TRACKER;
    }

    protected abstract String getPropertyXML();
}

