/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm;

import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.DNUtils;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdEventListener;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepo;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdRepoListener;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchOpModifier;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdServices;
import com.sun.identity.idm.IdServicesFactory;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.idm.RepoSearchResults;
import com.sun.identity.shared.datastruct.OrderedSet;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import netscape.ldap.LDAPDN;
import netscape.ldap.util.DN;

public final class AMIdentityRepository {
    private SSOToken token;
    private String organizationDN;
    private String idRealmName;
    private IdRepo pluginClass;
    public static Debug debug = Debug.getInstance((String)"amIdm");
    public static Map listeners = new CaseInsensitiveHashMap();

    public AMIdentityRepository(SSOToken ssotoken, String realmName) throws IdRepoException, SSOException {
        this.token = ssotoken;
        this.idRealmName = realmName;
        this.organizationDN = DNMapper.orgNameToDN(realmName);
    }

    public Set getSupportedIdTypes() throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        Set res = idServices.getSupportedTypes(this.token, this.organizationDN);
        res.remove(IdType.REALM);
        return res;
    }

    public Set getAllowedIdOperations(IdType type) throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        return idServices.getSupportedOperations(this.token, type, this.organizationDN);
    }

    public IdSearchResults getSpecialIdentities(IdType type) throws IdRepoException, SSOException {
        IdSearchResults results = this.getSpecialIdentities(this.token, type, this.organizationDN);
        if (type.equals(IdType.USER)) {
            IdSearchResults newResults = new IdSearchResults(type, this.organizationDN);
            Set identities = results.getSearchResults();
            if (identities != null && !identities.isEmpty()) {
                Iterator i = identities.iterator();
                while (i.hasNext()) {
                    AMIdentity amid = (AMIdentity)i.next();
                    String remUser = amid.getName().toLowerCase();
                    if (remUser.equalsIgnoreCase("amadmin") || remUser.equalsIgnoreCase("anonymous")) continue;
                    newResults.addResult(amid, amid.getAttributes());
                }
                results = newResults;
            }
        }
        return results;
    }

    public IdSearchResults searchIdentities(IdType type, String pattern, Map avPairs, boolean recursive, int maxResults, int maxTime, Set returnAttributes, boolean returnAllAttributes) throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        IdSearchControl crtl = new IdSearchControl();
        crtl.setSearchModifiers(IdSearchOpModifier.OR, avPairs);
        crtl.setRecursive(recursive);
        crtl.setMaxResults(maxResults);
        crtl.setTimeOut(maxTime);
        crtl.setReturnAttributes(returnAttributes);
        crtl.setAllReturnAttributes(returnAllAttributes);
        return this.searchIdentities(type, pattern, crtl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IdSearchResults searchIdentities(IdType type, String pattern, IdSearchControl ctrl) throws IdRepoException, SSOException {
        IdSearchResults idSearchResults = null;
        if (type.equals(IdType.REALM)) {
            try {
                idSearchResults = new IdSearchResults(type, this.idRealmName);
                OrganizationConfigManager orgMgr = new OrganizationConfigManager(this.token, this.idRealmName);
                Set realmNames = orgMgr.getSubOrganizationNames(pattern, false);
                if (realmNames == null) return idSearchResults;
                Iterator iter = realmNames.iterator();
                while (iter.hasNext()) {
                    String realmName = (String)iter.next();
                    AMIdentity realmIdentity = this.getSubRealmIdentity(realmName);
                    HashMap attributes = new HashMap();
                    idSearchResults.addResult(realmIdentity, attributes);
                    idSearchResults.setErrorCode(0);
                }
                return idSearchResults;
            }
            catch (SMSException sme) {
                debug.error("AMIdentityRepository.searchIdentities() - Error occurred while searching " + type.getName() + ":", (Throwable)sme);
                throw new IdRepoException(sme.getMessage());
            }
        }
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        return idServices.search(this.token, type, pattern, ctrl, this.organizationDN);
    }

    public AMIdentity getRealmIdentity() throws IdRepoException, SSOException {
        return this.getRealmIdentity(this.token, this.organizationDN);
    }

    private AMIdentity getRealmIdentity(SSOToken token, String orgDN) throws IdRepoException {
        String universalId = "id=ContainerDefaultTemplateRole,ou=realm," + orgDN;
        return IdUtils.getIdentity(token, universalId);
    }

    private AMIdentity getSubRealmIdentity(String subRealmName) throws IdRepoException, SSOException {
        String realmName = this.idRealmName;
        if (DN.isDN((String)this.idRealmName)) {
            realmName = DNMapper.orgNameToRealmName(this.idRealmName);
        }
        String fullRealmName = realmName + "/" + subRealmName;
        String subOrganizationDN = DNMapper.orgNameToDN(fullRealmName);
        return this.getRealmIdentity(this.token, subOrganizationDN);
    }

    public AMIdentity createIdentity(IdType type, String idName, Map attrMap) throws IdRepoException, SSOException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        return idServices.create(this.token, type, idName, attrMap, this.organizationDN);
    }

    public Set createIdentities(IdType type, Map identityNamesAndAttrs) throws IdRepoException, SSOException {
        HashSet<AMIdentity> results = new HashSet<AMIdentity>();
        if (identityNamesAndAttrs == null || identityNamesAndAttrs.isEmpty()) {
            throw new IdRepoException("amIdRepo", "201", null);
        }
        Iterator it = identityNamesAndAttrs.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Map attrMap = (Map)identityNamesAndAttrs.get(name);
            AMIdentity id = this.createIdentity(type, name, attrMap);
            results.add(id);
        }
        return results;
    }

    public void deleteIdentities(IdType type, Set identities) throws IdRepoException, SSOException {
        this.deleteIdentities(identities);
    }

    public void deleteIdentities(Set identities) throws IdRepoException, SSOException {
        if (identities == null || identities.isEmpty()) {
            throw new IdRepoException("amIdRepo", "201", null);
        }
        Iterator it = identities.iterator();
        while (it.hasNext()) {
            AMIdentity id = (AMIdentity)it.next();
            IdServices idServices = IdServicesFactory.getDataStoreServices();
            idServices.delete(this.token, id.getType(), id.getName(), this.organizationDN, id.getDN());
        }
    }

    public boolean authenticate(Callback[] credentials) throws IdRepoException, AuthLoginException {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        return idServices.authenticate(this.organizationDN, credentials);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addEventListener(IdEventListener listener) {
        ArrayList<IdEventListener> listOfListeners = (ArrayList<IdEventListener>)listeners.get(this.organizationDN);
        if (listOfListeners == null) {
            listOfListeners = new ArrayList<IdEventListener>();
        }
        Map map = listeners;
        synchronized (map) {
            listOfListeners.add(listener);
            listeners.put(this.organizationDN, listOfListeners);
        }
        return listOfListeners.size() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(int identifier) {
        ArrayList listOfListeners = (ArrayList)listeners.get(this.organizationDN);
        if (listOfListeners != null) {
            Map map = listeners;
            synchronized (map) {
                listOfListeners.remove(identifier);
            }
        }
    }

    public static void clearCache() {
        IdServices idServices = IdServicesFactory.getDataStoreServices();
        idServices.reinitialize();
        IdUtils.initialize();
    }

    public IdSearchResults getSpecialIdentities(SSOToken token, IdType type, String orgName) throws IdRepoException, SSOException {
        OrderedSet pluginClasses = new OrderedSet();
        IdRepo thisPlugin = null;
        if (ServiceManager.isConfigMigratedTo70() && ServiceManager.getBaseDN().equalsIgnoreCase(orgName)) {
            String p = "com.sun.identity.idm.plugins.internal.SpecialRepo";
            if (this.pluginClass == null) {
                try {
                    Class<?> thisClass = Class.forName(p);
                    thisPlugin = (IdRepo)thisClass.newInstance();
                    thisPlugin.initialize(new HashMap());
                    HashMap<String, String> listenerConfig = new HashMap<String, String>();
                    listenerConfig.put("realm", orgName);
                    IdRepoListener lter = new IdRepoListener();
                    lter.setConfigMap(listenerConfig);
                    thisPlugin.addListener(token, lter);
                    this.pluginClass = thisPlugin;
                    Set opSet = thisPlugin.getSupportedOperations(type);
                    if (opSet != null && opSet.contains(IdOperation.READ)) {
                        pluginClasses.add(thisPlugin);
                    }
                }
                catch (Exception e) {
                    debug.error("Unable to instantiate plugin: " + p, (Throwable)e);
                }
            } else {
                Set opSet = this.pluginClass.getSupportedOperations(type);
                if (opSet != null && opSet.contains(IdOperation.READ)) {
                    pluginClasses.add(this.pluginClass);
                }
            }
        }
        if (pluginClasses.isEmpty()) {
            return new IdSearchResults(type, orgName);
        }
        IdRepo specialRepo = (IdRepo)pluginClasses.iterator().next();
        RepoSearchResults res = specialRepo.search(token, type, "*", 0, 0, Collections.EMPTY_SET, false, 0, Collections.EMPTY_MAP, false);
        Object[][] obj = new Object[1][2];
        obj[0][0] = res;
        obj[0][1] = Collections.EMPTY_MAP;
        return this.combineSearchResults(token, obj, 1, type, orgName, false, null);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("AMIdentityRepository object: ").append(this.organizationDN);
        return sb.toString();
    }

    private Map reverseMapAttributeNames(Map attrMap, Map configMap) {
        Map resultMap;
        if (attrMap == null || attrMap.isEmpty()) {
            return attrMap;
        }
        Map[] mapArray = this.getAttributeNameMap(configMap);
        if (mapArray == null) {
            resultMap = attrMap;
        } else {
            resultMap = new CaseInsensitiveHashMap();
            Map reverseMap = mapArray[1];
            Iterator it = attrMap.keySet().iterator();
            while (it.hasNext()) {
                String curr = (String)it.next();
                if (reverseMap.containsKey(curr)) {
                    resultMap.put((String)reverseMap.get(curr), (Set)attrMap.get(curr));
                    continue;
                }
                resultMap.put(curr, (Set)attrMap.get(curr));
            }
        }
        return resultMap;
    }

    private IdSearchResults combineSearchResults(SSOToken token, Object[][] arrayOfResult, int sizeOfArray, IdType type, String orgName, boolean amsdkIncluded, Object[][] amsdkResults) {
        Iterator it;
        CaseInsensitiveHashMap amsdkDNs = new CaseInsensitiveHashMap();
        CaseInsensitiveHashMap resultsMap = new CaseInsensitiveHashMap();
        int errorCode = 0;
        if (amsdkIncluded) {
            RepoSearchResults amsdkRepoRes = (RepoSearchResults)amsdkResults[0][0];
            Set results = amsdkRepoRes.getSearchResults();
            Map attrResults = amsdkRepoRes.getResultAttributes();
            it = results.iterator();
            while (it.hasNext()) {
                String dn = (String)it.next();
                String name = LDAPDN.explodeDN((String)dn, (boolean)true)[0];
                amsdkDNs.put(name, dn);
                HashSet<Map> attrMaps = new HashSet<Map>();
                attrMaps.add((Map)attrResults.get(dn));
                resultsMap.put(name, attrMaps);
            }
            errorCode = amsdkRepoRes.getErrorCode();
        }
        for (int i = 0; i < sizeOfArray; ++i) {
            RepoSearchResults current = (RepoSearchResults)arrayOfResult[i][0];
            Map configMap = (Map)arrayOfResult[i][1];
            it = current.getSearchResults().iterator();
            Map allAttrMaps = current.getResultAttributes();
            while (it.hasNext()) {
                String m = (String)it.next();
                String mname = DNUtils.DNtoName(m);
                Map attrMap = (Map)allAttrMaps.get(m);
                attrMap = this.reverseMapAttributeNames(attrMap, configMap);
                HashSet<Map> attrMaps = (HashSet<Map>)resultsMap.get(mname);
                if (attrMaps == null) {
                    attrMaps = new HashSet<Map>();
                }
                attrMaps.add(attrMap);
                resultsMap.put(mname, attrMaps);
            }
        }
        IdSearchResults results = new IdSearchResults(type, orgName);
        Iterator it2 = resultsMap.keySet().iterator();
        while (it2.hasNext()) {
            String mname = (String)it2.next();
            Map combinedMap = this.combineAttrMaps((Set)resultsMap.get(mname), true);
            AMIdentity id = new AMIdentity(token, mname, type, orgName, (String)amsdkDNs.get(mname));
            results.addResult(id, combinedMap);
        }
        results.setErrorCode(errorCode);
        return results;
    }

    private Map[] getAttributeNameMap(Map configMap) {
        Set attributeMap = (Set)configMap.get("sunIdRepoAttributeMapping");
        if (attributeMap == null || attributeMap.isEmpty()) {
            return null;
        }
        Map[] returnArray = new Map[2];
        int size = attributeMap.size();
        returnArray[0] = new CaseInsensitiveHashMap(size);
        returnArray[1] = new CaseInsensitiveHashMap(size);
        Iterator it = attributeMap.iterator();
        while (it.hasNext()) {
            String mapString = (String)it.next();
            int eqIndex = mapString.indexOf(61);
            if (eqIndex > -1) {
                String first = mapString.substring(0, eqIndex);
                String second = mapString.substring(eqIndex + 1);
                returnArray[0].put(first, second);
                returnArray[1].put(second, first);
                continue;
            }
            returnArray[0].put(mapString, mapString);
            returnArray[1].put(mapString, mapString);
        }
        return returnArray;
    }

    private Map combineAttrMaps(Set setOfMaps, boolean isString) {
        AMHashMap resultMap = new AMHashMap();
        Iterator it = setOfMaps.iterator();
        while (it.hasNext()) {
            Map currMap = (Map)it.next();
            if (currMap == null) continue;
            Iterator keyset = currMap.keySet().iterator();
            while (keyset.hasNext()) {
                Object thisSet;
                Object resultSet;
                String thisAttr = (String)keyset.next();
                if (isString) {
                    resultSet = (Set)resultMap.get(thisAttr);
                    thisSet = (Set)currMap.get(thisAttr);
                    if (resultSet != null) {
                        resultSet.addAll(thisSet);
                        continue;
                    }
                    resultSet = new HashSet((Set)currMap.get(thisAttr));
                    resultMap.put(thisAttr, resultSet);
                    continue;
                }
                resultSet = (byte[][])resultMap.get(thisAttr);
                thisSet = (byte[][])currMap.get(thisAttr);
                int combinedSize = ((Object)thisSet).length;
                if (resultSet != null) {
                    int i;
                    combinedSize = ((Object)resultSet).length + ((Object)thisSet).length;
                    byte[][] tmpSet = new byte[combinedSize][];
                    for (i = 0; i < ((Object)resultSet).length; ++i) {
                        tmpSet[i] = (byte[])resultSet[i];
                    }
                    for (i = 0; i < ((Object)thisSet).length; ++i) {
                        tmpSet[i] = (byte[])thisSet[i];
                    }
                    resultSet = tmpSet;
                } else {
                    resultSet = (byte[][])thisSet.clone();
                }
                resultMap.put(thisAttr, resultSet);
            }
        }
        return resultMap;
    }
}

