/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm.server;

import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.common.DNUtils;
import com.sun.identity.common.ShutdownListener;
import com.sun.identity.common.ShutdownManager;
import com.sun.identity.delegation.DelegationEvaluator;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationPermission;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepo;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdRepoFatalException;
import com.sun.identity.idm.IdRepoListener;
import com.sun.identity.idm.IdRepoServiceListener;
import com.sun.identity.idm.IdRepoUnsupportedOpException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchOpModifier;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdServices;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.idm.RepoSearchResults;
import com.sun.identity.idm.plugins.internal.AgentsRepo;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.datastruct.OrderedSet;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import netscape.ldap.LDAPDN;
import netscape.ldap.util.DN;

public class IdServicesImpl
implements IdServices {
    private static final String DELEGATION_ATTRS_NAME = "attributes";
    protected static Debug debug = Debug.getInstance((String)"amIdm");
    protected Map idRepoMap = Collections.synchronizedMap(new HashMap());
    protected Set idRepoPlugins;
    protected String notificationID;
    protected ServiceSchemaManager idRepoServiceSchemaManager;
    protected ServiceSchema idRepoSubSchema;
    private static HashSet READ_ACTION = new HashSet(2);
    private static HashSet WRITE_ACTION = new HashSet(2);
    private static IdServices _instance;
    private static int svcRevisionNumber;

    protected static synchronized IdServices getInstance() {
        if (_instance == null) {
            IdServicesImpl.getDebug().message("IdServicesImpl.getInstance(): Creating new Instance of IdServicesImpl()");
            _instance = new IdServicesImpl();
            ShutdownManager.getInstance().addShutdownListener(new ShutdownListener(){

                public void shutdown() {
                    _instance.clearIdRepoPlugins();
                }
            });
        }
        return _instance;
    }

    protected IdServicesImpl() {
        this.initializeListeners();
    }

    protected static Debug getDebug() {
        return debug;
    }

    public void reinitialize() {
        this.initializeListeners();
    }

    private void initializeListeners() {
        if (this.notificationID == null) {
            if (IdServicesImpl.getDebug().messageEnabled()) {
                IdServicesImpl.getDebug().message("IdServicesImpl.initializeListeners: setting up ServiceListener");
            }
            SSOToken stoken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            try {
                ServiceConfigManager ssm = new ServiceConfigManager(stoken, "sunIdentityRepositoryService", "1.0");
                ssm.addListener(new IdRepoServiceListener());
                this.idRepoServiceSchemaManager = new ServiceSchemaManager(stoken, "sunIdentityRepositoryService", "1.0");
                this.idRepoSubSchema = this.idRepoServiceSchemaManager.getOrganizationSchema();
                this.idRepoPlugins = this.idRepoSubSchema.getSubSchemaNames();
                IdRepoServiceListener sListener = new IdRepoServiceListener();
                this.notificationID = this.idRepoServiceSchemaManager.addListener(sListener);
                svcRevisionNumber = this.idRepoServiceSchemaManager.getRevisionNumber();
            }
            catch (SMSException smse) {
                if (IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.initializeListeners: Unable to set up a service listener for IdRepo", (Throwable)smse);
                }
            }
            catch (SSOException ssoe) {
                IdServicesImpl.getDebug().error("IdServicesImpl.initializeListeners: Unable to set up a service listener for IdRepo. ", (Throwable)((Object)ssoe));
            }
        }
    }

    public Set getFullyQualifiedNames(SSOToken token, IdType type, String name, String orgName) throws IdRepoException, SSOException {
        IdRepo idRepo;
        Iterator items;
        if (IdServicesImpl.getDebug().messageEnabled()) {
            IdServicesImpl.getDebug().message("IdServicesImpl::getFullyQualifiedNames called for type: " + type + " name: " + name + " org: " + orgName);
        }
        CaseInsensitiveHashSet answer = new CaseInsensitiveHashSet();
        IdRepoException firstException = null;
        token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        Set plugins = this.getIdRepoPlugins(orgName);
        Set cPlugins = this.getAllConfiguredPlugins(orgName, plugins);
        if (orgName.equalsIgnoreCase(ServiceManager.getBaseDN())) {
            items = cPlugins.iterator();
            while (items.hasNext()) {
                idRepo = (IdRepo)items.next();
                if (!idRepo.getClass().getName().equals("com.sun.identity.idm.plugins.internal.SpecialRepo") || !this.isSpecialRepoUser(token, type, name, orgName, idRepo)) continue;
                String fqn = idRepo.getFullyQualifiedName(token, type, name);
                answer.add(fqn);
                return answer;
            }
        }
        items = cPlugins.iterator();
        while (items.hasNext()) {
            idRepo = (IdRepo)items.next();
            if (!this.isSpecialRepoUser(token, type, name, orgName, idRepo) || !idRepo.getSupportedTypes().contains(type)) continue;
            try {
                String fqn = idRepo.getFullyQualifiedName(token, type, name);
                if (fqn == null) continue;
                answer.add(fqn);
            }
            catch (IdRepoException ide) {
                if (firstException != null) continue;
                firstException = ide;
            }
        }
        if (firstException != null && answer.isEmpty()) {
            throw firstException;
        }
        return answer;
    }

    public boolean authenticate(String orgName, Callback[] credentials) throws IdRepoException, AuthLoginException {
        IdRepo idRepo;
        if (IdServicesImpl.getDebug().messageEnabled()) {
            IdServicesImpl.getDebug().message("IdServicesImpl.authenticate: called for org: " + orgName);
        }
        IdRepoException firstException = null;
        AuthLoginException authException = null;
        SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        Set plugins = this.getIdRepoPlugins(orgName);
        Set cPlugins = null;
        try {
            cPlugins = this.getAllConfiguredPlugins(orgName, plugins);
        }
        catch (SSOException ssoe) {
            throw new IdRepoFatalException(ssoe.getL10NMessage());
        }
        Vector<IdRepo> orderedPlugins = new Vector<IdRepo>();
        IdRepo savedAgentRepo = null;
        Iterator items = cPlugins.iterator();
        while (items.hasNext()) {
            idRepo = (IdRepo)items.next();
            if (idRepo instanceof AgentsRepo) {
                savedAgentRepo = idRepo;
                continue;
            }
            orderedPlugins.add(idRepo);
        }
        if (savedAgentRepo != null) {
            orderedPlugins.add(savedAgentRepo);
        }
        items = orderedPlugins.listIterator();
        while (items.hasNext()) {
            idRepo = (IdRepo)items.next();
            if (idRepo.supportsAuthentication()) {
                if (IdServicesImpl.getDebug().messageEnabled()) {
                    IdServicesImpl.getDebug().message("IdServicesImpl.authenticate: AuthN to " + idRepo.getClass().getName() + " in org: " + orgName);
                }
                try {
                    if (!idRepo.authenticate(credentials)) continue;
                    if (IdServicesImpl.getDebug().messageEnabled()) {
                        IdServicesImpl.getDebug().message("IdServicesImpl.authenticate: AuthN success for " + idRepo.getClass().getName());
                    }
                    return true;
                }
                catch (IdRepoException ide) {
                    if (firstException != null) continue;
                    firstException = ide;
                    continue;
                }
                catch (AuthLoginException authex) {
                    if (authException != null) continue;
                    authException = authex;
                    continue;
                }
            }
            if (!IdServicesImpl.getDebug().messageEnabled()) continue;
            IdServicesImpl.getDebug().message("IdServicesImpl.authenticate: AuthN not supported by " + idRepo.getClass().getName());
        }
        if (firstException != null) {
            throw firstException;
        }
        if (authException != null) {
            throw authException;
        }
        return false;
    }

    private AMIdentity getRealmIdentity(SSOToken token, String orgDN) throws IdRepoException {
        String universalId = "id=ContainerDefaultTemplateRole,ou=realm," + orgDN;
        return IdUtils.getIdentity(token, universalId);
    }

    private AMIdentity getSubRealmIdentity(SSOToken token, String subRealmName, String parentRealmName) throws IdRepoException, SSOException {
        String realmName = parentRealmName;
        if (DN.isDN((String)parentRealmName)) {
            realmName = DNMapper.orgNameToRealmName(parentRealmName);
        }
        String fullRealmName = realmName + "/" + subRealmName;
        String subOrganizationDN = DNMapper.orgNameToDN(fullRealmName);
        return this.getRealmIdentity(token, subOrganizationDN);
    }

    private AMIdentity createRealmIdentity(SSOToken token, IdType type, String name, Map attrMap, String orgName) throws IdRepoException, SSOException {
        try {
            OrganizationConfigManager orgMgr = new OrganizationConfigManager(token, orgName);
            HashMap<String, Map> serviceAttrsMap = new HashMap<String, Map>();
            serviceAttrsMap.put("sunIdentityRepositoryService", attrMap);
            orgMgr.createSubOrganization(name, serviceAttrsMap);
            return this.getSubRealmIdentity(token, name, orgName);
        }
        catch (SMSException sme) {
            debug.error("AMIdentityRepository.createIdentity() - Error occurred while creating " + type.getName() + ":" + name, (Throwable)sme);
            throw new IdRepoException(sme.getMessage());
        }
    }

    public AMIdentity create(SSOToken token, IdType type, String name, Map attrMap, String amOrgName) throws IdRepoException, SSOException {
        if (type.equals(IdType.REALM)) {
            return this.createRealmIdentity(token, type, name, attrMap, amOrgName);
        }
        IdRepoException origEx = null;
        this.checkPermission(token, amOrgName, name, attrMap.keySet(), IdOperation.CREATE, type);
        Set plugIns = this.getIdRepoPlugins(amOrgName);
        String amsdkdn = null;
        Set configuredPluginClasses = this.getConfiguredPlugins(amOrgName, plugIns, IdOperation.CREATE, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        while (it.hasNext()) {
            IdRepo idRepo = (IdRepo)it.next();
            try {
                Map cMap = idRepo.getConfiguration();
                attrMap = this.mapAttributeNames(attrMap, cMap);
                String representation = idRepo.create(token, type, name, attrMap);
                if (!idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo")) continue;
                amsdkdn = representation;
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.create: Unable to create identity in the following repository " + idRepo.getClass().getName() + ":: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = ide;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.create: Create: Fatal Exception", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.create: Unable to create identity in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = ide;
            }
        }
        AMIdentity id = new AMIdentity(token, name, type, amOrgName, amsdkdn);
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.create: Unable to create identity " + type.getName() + " :: " + name + " in any of the configured data stores", (Throwable)origEx);
            }
            throw origEx;
        }
        return id;
    }

    private void deleteRealmIdentity(SSOToken token, String realmName, String orgDN) throws IdRepoException {
        try {
            String parentRealmName = DNMapper.orgNameToRealmName(orgDN);
            OrganizationConfigManager orgMgr = new OrganizationConfigManager(token, parentRealmName);
            orgMgr.deleteSubOrganization(realmName, true);
        }
        catch (SMSException sme) {
            throw new IdRepoException(sme.getMessage());
        }
    }

    public void delete(SSOToken token, IdType type, String name, String orgName, String amsdkDN) throws IdRepoException, SSOException {
        if (type.equals(IdType.REALM)) {
            this.deleteRealmIdentity(token, name, orgName);
            return;
        }
        IdRepoException origEx = null;
        this.checkPermission(token, orgName, name, null, IdOperation.DELETE, type);
        Set plugIns = this.getIdRepoPlugins(orgName);
        Set configuredPluginClasses = this.getConfiguredPlugins(orgName, plugIns, IdOperation.DELETE, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        while (it.hasNext()) {
            IdRepo idRepo = (IdRepo)it.next();
            try {
                if (idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && amsdkDN != null) {
                    idRepo.delete(token, type, amsdkDN);
                    continue;
                }
                idRepo.delete(token, type, name);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.delete: Unable to delete identity in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = ide;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.delete: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.delete: Unable to delete identity in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                if (ide.getErrorCode().equalsIgnoreCase("220") && origEx != null) continue;
                origEx = ide;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.delete: Unable to delete identity " + type.getName() + " :: " + name + " in any of the configured data stores", (Throwable)origEx);
            }
            throw origEx;
        }
    }

    public Map getAttributes(SSOToken token, IdType type, String name, Set attrNames, String amOrgName, String amsdkDN, boolean isString) throws IdRepoException, SSOException {
        IdRepoException origEx = null;
        this.checkPermission(token, amOrgName, name, attrNames, IdOperation.READ, type);
        Set plugIns = this.getIdRepoPlugins(amOrgName);
        Set configuredPluginClasses = this.getConfiguredPlugins(amOrgName, plugIns, IdOperation.READ, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        HashSet<Map> attrMapsSet = new HashSet<Map>();
        while (it.hasNext()) {
            IdRepo idRepo = (IdRepo)it.next();
            try {
                Map cMap = idRepo.getConfiguration();
                attrNames = this.mapAttributeNames(attrNames, cMap);
                Map aMap = null;
                aMap = idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && amsdkDN != null ? (isString ? idRepo.getAttributes(token, type, amsdkDN, attrNames) : idRepo.getBinaryAttributes(token, type, amsdkDN, attrNames)) : (isString ? idRepo.getAttributes(token, type, name, attrNames) : idRepo.getBinaryAttributes(token, type, name, attrNames));
                aMap = this.reverseMapAttributeNames(aMap, cMap);
                attrMapsSet.add(aMap);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.getAttributes: Unable to read identity in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = ide;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("GetAttributes: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.getAttributes: Unable to read identity in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = ide;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("idServicesImpl.getAttributes: Unable to get attributes for identity " + type.getName() + ", " + name + " in any configured data store", (Throwable)origEx);
            }
            throw origEx;
        }
        return this.combineAttrMaps(attrMapsSet, isString);
    }

    public Map getAttributes(SSOToken token, IdType type, String name, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        IdRepoException origEx = null;
        this.checkPermission(token, amOrgName, name, null, IdOperation.READ, type);
        Set plugIns = this.getIdRepoPlugins(amOrgName);
        Set configuredPluginClasses = this.getConfiguredPlugins(amOrgName, plugIns, IdOperation.READ, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        HashSet<Map> attrMapsSet = new HashSet<Map>();
        while (it.hasNext()) {
            IdRepo idRepo = (IdRepo)it.next();
            try {
                Map cMap = idRepo.getConfiguration();
                Map aMap = null;
                aMap = idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && amsdkDN != null ? idRepo.getAttributes(token, type, amsdkDN) : idRepo.getAttributes(token, type, name);
                if (IdServicesImpl.getDebug().messageEnabled()) {
                    IdServicesImpl.getDebug().message("IdServicesImpl.getAttributes: before reverseMapAttributeNames aMap=" + aMap);
                }
                aMap = this.reverseMapAttributeNames(aMap, cMap);
                attrMapsSet.add(aMap);
                if (!IdServicesImpl.getDebug().messageEnabled()) continue;
                IdServicesImpl.getDebug().message("IdServicesImpl.getAttributes: after before reverseMapAttributeNames attrMapsSet=" + attrMapsSet);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.getAttributes: Unable to read identity in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = ide;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.getAttributes: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.getAttributes: Unable to read identity in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = ide;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.getAttributes: Unable to get attributes for identity " + type.getName() + "::" + name + " in any configured data store", (Throwable)origEx);
            }
            throw origEx;
        }
        Map returnMap = this.combineAttrMaps(attrMapsSet, true);
        IdServicesImpl.getDebug().warning("IdServicesImpl.getAttributes exit: returnMap=" + returnMap);
        return returnMap;
    }

    public Set getMembers(SSOToken token, IdType type, String name, String amOrgName, IdType membersType, String amsdkDN) throws IdRepoException, SSOException {
        IdRepoException origEx = null;
        this.checkPermission(token, amOrgName, name, null, IdOperation.READ, type);
        Set plugIns = this.getIdRepoPlugins(amOrgName);
        Set configuredPluginClasses = this.getConfiguredPlugins(amOrgName, plugIns, IdOperation.READ, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        HashSet<Set> membersSet = new HashSet<Set>();
        HashSet amsdkMembers = new HashSet();
        boolean amsdkIncluded = false;
        while (it.hasNext()) {
            IdRepo idRepo = (IdRepo)it.next();
            if (!idRepo.getSupportedTypes().contains(membersType)) continue;
            try {
                Set members;
                boolean isAMSDK = idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo");
                Set set = members = isAMSDK && amsdkDN != null ? idRepo.getMembers(token, type, amsdkDN, membersType) : idRepo.getMembers(token, type, name, membersType);
                if (isAMSDK) {
                    amsdkMembers.addAll(members);
                    amsdkIncluded = true;
                    continue;
                }
                membersSet.add(members);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.getMembers: Unable to read identity members in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = ide;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.getMembers: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.getMembers: Unable to read identity members in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = ide;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.getMembers: Unable to get members for identity " + type.getName() + "::" + name + " in any configured data store", (Throwable)origEx);
            }
            throw origEx;
        }
        Set results = this.combineMembers(token, membersSet, membersType, amOrgName, amsdkIncluded, amsdkMembers);
        return results;
    }

    public Set getMemberships(SSOToken token, IdType type, String name, IdType membershipType, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        IdRepoException origEx = null;
        this.checkPermission(token, amOrgName, name, null, IdOperation.READ, type);
        Set plugIns = this.getIdRepoPlugins(amOrgName);
        Set configuredPluginClasses = this.getConfiguredPlugins(amOrgName, plugIns, IdOperation.READ, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        HashSet<Set> membershipsSet = new HashSet<Set>();
        HashSet amsdkMemberShips = new HashSet();
        boolean amsdkIncluded = false;
        while (it.hasNext()) {
            IdRepo idRepo = (IdRepo)it.next();
            if (!this.isSpecialRepoUser(token, type, name, amOrgName, idRepo) || !idRepo.getSupportedTypes().contains(membershipType)) continue;
            try {
                Set members;
                boolean isAMSDK = idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo");
                Set set = members = isAMSDK && amsdkDN != null ? idRepo.getMemberships(token, type, amsdkDN, membershipType) : idRepo.getMemberships(token, type, name, membershipType);
                if (isAMSDK) {
                    amsdkMemberShips.addAll(members);
                    amsdkIncluded = true;
                    continue;
                }
                membershipsSet.add(members);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.getMemberships: Unable to get memberships in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = ide;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.getMemberships: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.getMemberships: Unable to read identity in the following repository " + idRepo.getClass().getName(), (Throwable)ide);
                }
                --noOfSuccess;
                origEx = ide;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.getMemberships: Unable to get members for identity " + type.getName() + "::" + name + " in any configured data store", origEx);
            }
            throw origEx;
        }
        Set results = this.combineMembers(token, membershipsSet, membershipType, amOrgName, amsdkIncluded, amsdkMemberShips);
        return results;
    }

    private boolean isSpecialRepoUser(SSOToken token, IdType type, String name, String amOrgName, IdRepo idRepo) throws IdRepoException, SSOException {
        boolean isSpecialUser = false;
        if (idRepo.getClass().getName().equals("com.sun.identity.idm.plugins.internal.SpecialRepo")) {
            IdSearchResults results;
            Set identities;
            if (type.equals(IdType.USER) && (identities = (results = this.getSpecialIdentities(token, type, amOrgName)).getSearchResults()) != null && !identities.isEmpty()) {
                Iterator i = identities.iterator();
                while (!isSpecialUser && i.hasNext()) {
                    String idName = ((AMIdentity)i.next()).getName();
                    if (!name.equalsIgnoreCase(idName)) continue;
                    isSpecialUser = true;
                }
            }
        } else {
            isSpecialUser = true;
        }
        return isSpecialUser;
    }

    public boolean isExists(SSOToken token, IdType type, String name, String amOrgName) throws SSOException, IdRepoException {
        IdRepo idRepo;
        Set plugIns = this.getIdRepoPlugins(amOrgName);
        Set configuredPluginClasses = this.getConfiguredPlugins(amOrgName, plugIns, IdOperation.READ, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        boolean exists = false;
        while (it.hasNext() && ((idRepo = (IdRepo)it.next()).getClass().getName().equals("com.sun.identity.idm.plugins.internal.SpecialRepo") || !(exists = idRepo.isExists(token, type, name)))) {
        }
        return exists;
    }

    public boolean isActive(SSOToken token, IdType type, String name, String amOrgName, String amsdkDN) throws SSOException, IdRepoException {
        IdRepoException origEx = null;
        this.checkPermission(token, amOrgName, name, null, IdOperation.READ, type);
        Set plugIns = this.getIdRepoPlugins(amOrgName);
        Set configuredPluginClasses = this.getConfiguredPlugins(amOrgName, plugIns, IdOperation.READ, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        boolean active = false;
        while (it.hasNext()) {
            IdRepo idRepo = (IdRepo)it.next();
            try {
                active = idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && amsdkDN != null ? idRepo.isActive(token, type, amsdkDN) : idRepo.isActive(token, type, name);
                if (!active) continue;
                break;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.isActive: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.isActive: Unable to check isActive identity in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = ide;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.isActive: Unable to check if identity is active " + type.getName() + "::" + name + " in any configured data store", (Throwable)origEx);
            }
            throw origEx;
        }
        return active;
    }

    public void setActiveStatus(SSOToken token, IdType type, String name, String amOrgName, String amsdkDN, boolean active) throws SSOException, IdRepoException {
        IdRepoException origEx = null;
        this.checkPermission(token, amOrgName, name, null, IdOperation.EDIT, type);
        Set plugIns = this.getIdRepoPlugins(amOrgName);
        Set configuredPluginClasses = this.getConfiguredPlugins(amOrgName, plugIns, IdOperation.EDIT, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        while (it.hasNext()) {
            IdRepo idRepo = (IdRepo)it.next();
            try {
                if (idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && amsdkDN != null) {
                    idRepo.setActiveStatus(token, type, amsdkDN, active);
                    continue;
                }
                idRepo.setActiveStatus(token, type, name, active);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl:setActiveStatus: Unable to set attributes in the following repository" + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = ide;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IsActive: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("Unable to setActiveStatus in the following repository" + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                if (ide.getErrorCode().equalsIgnoreCase("220") && origEx != null) continue;
                origEx = ide;
            }
        }
        if (noOfSuccess == 0) {
            IdServicesImpl.getDebug().error("Unable to setActiveStatus for identity " + type.getName() + "::" + name + " in any configured " + "datastore", (Throwable)origEx);
            throw origEx;
        }
    }

    public void modifyMemberShip(SSOToken token, IdType type, String name, Set members, IdType membersType, int operation, String amOrgName) throws IdRepoException, SSOException {
        IdRepoException origEx = null;
        this.checkPermission(token, amOrgName, name, null, IdOperation.EDIT, type);
        Set plugIns = this.getIdRepoPlugins(amOrgName);
        Set configuredPluginClasses = this.getConfiguredPlugins(amOrgName, plugIns, IdOperation.EDIT, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        while (it.hasNext()) {
            IdRepo idRepo = (IdRepo)it.next();
            if (!idRepo.getSupportedTypes().contains(membersType)) continue;
            try {
                idRepo.modifyMemberShip(token, type, name, members, membersType, operation);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.modifyMembership: Unable to modify memberships  in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = ide;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.modifyMembership: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().error("IdServicesImpl.modifyMembership: Unable to modify memberships in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = ide;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.modifyMemberShip: Unable to modify members for identity " + type.getName() + "::" + name + " in any configured data store", (Throwable)origEx);
            }
            throw origEx;
        }
    }

    public void removeAttributes(SSOToken token, IdType type, String name, Set attrNames, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        IdRepoException origEx = null;
        this.checkPermission(token, amOrgName, name, attrNames, IdOperation.EDIT, type);
        Set plugIns = this.getIdRepoPlugins(amOrgName);
        Set configuredPluginClasses = this.getConfiguredPlugins(amOrgName, plugIns, IdOperation.EDIT, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        while (it.hasNext()) {
            IdRepo idRepo = (IdRepo)it.next();
            try {
                Map cMap = idRepo.getConfiguration();
                attrNames = this.mapAttributeNames(attrNames, cMap);
                if (idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && amsdkDN != null) {
                    idRepo.removeAttributes(token, type, amsdkDN, attrNames);
                    continue;
                }
                idRepo.removeAttributes(token, type, name, attrNames);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.removeAttributes: Unable to modify identity in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = ide;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.removeAttributes: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.removeAttributes: Unable to remove attributes in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                if (ide.getErrorCode().equalsIgnoreCase("220") && origEx != null) continue;
                origEx = ide;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.removeAttributes: Unable to remove attributes  for identity " + type.getName() + "::" + name + " in any configured data store", (Throwable)origEx);
            }
            throw origEx;
        }
    }

    public IdSearchResults search(SSOToken token, IdType type, String pattern, IdSearchControl ctrl, String amOrgName) throws IdRepoException, SSOException {
        IdRepoException origEx = null;
        this.checkPermission(token, amOrgName, null, null, IdOperation.READ, type);
        Set plugIns = this.getIdRepoPlugins(amOrgName);
        Set configuredPluginClasses = this.getConfiguredPlugins(amOrgName, plugIns, IdOperation.READ, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        Object[][] amsdkResults = new Object[1][2];
        boolean amsdkIncluded = false;
        Object[][] arrayOfResult = new Object[noOfSuccess][2];
        int iterNo = 0;
        int maxTime = ctrl.getTimeOut();
        int maxResults = ctrl.getMaxResults();
        Set returnAttrs = ctrl.getReturnAttributes();
        boolean returnAllAttrs = ctrl.isGetAllReturnAttributesEnabled();
        IdSearchOpModifier modifier = ctrl.getSearchModifier();
        int filterOp = -1;
        if (modifier.equals(IdSearchOpModifier.AND)) {
            filterOp = 1;
        } else if (modifier.equals(IdSearchOpModifier.OR)) {
            filterOp = 0;
        }
        Map avPairs = ctrl.getSearchModifierMap();
        boolean recursive = ctrl.isRecursive();
        while (it.hasNext()) {
            IdRepo idRepo = (IdRepo)it.next();
            try {
                Map cMap = idRepo.getConfiguration();
                RepoSearchResults results = idRepo.search(token, type, pattern, maxTime, maxResults, returnAttrs, returnAllAttrs, filterOp, avPairs, recursive);
                if (idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo")) {
                    amsdkResults[0][0] = results;
                    amsdkResults[0][1] = cMap;
                    amsdkIncluded = true;
                    continue;
                }
                arrayOfResult[iterNo][0] = results;
                arrayOfResult[iterNo][1] = cMap;
                ++iterNo;
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.search: Unable to search in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = ide;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.search: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.search: Unable to search identity in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = ide;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.search: Unable to search for identity " + type.getName() + "::" + pattern + " in any configured data store", (Throwable)origEx);
            }
            throw origEx;
        }
        IdSearchResults res = this.combineSearchResults(token, arrayOfResult, iterNo, type, amOrgName, amsdkIncluded, amsdkResults);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IdRepo getSpecialRepoPlugin(SSOToken token, String orgName) throws SSOException, IdRepoException {
        IdRepo pluginClass = null;
        boolean pluginInitialized = false;
        Map map = this.idRepoMap;
        synchronized (map) {
            Object o = this.idRepoMap.get("com.sun.identity.idm.plugins.internal.SpecialRepo");
            if (o instanceof IdRepo) {
                pluginClass = (IdRepo)o;
            }
            if (pluginClass == null) {
                try {
                    Class<?> thisClass = Thread.currentThread().getContextClassLoader().loadClass("com.sun.identity.idm.plugins.internal.SpecialRepo");
                    pluginClass = (IdRepo)thisClass.newInstance();
                    pluginClass.initialize(new HashMap());
                    this.idRepoMap.put("com.sun.identity.idm.plugins.internal.SpecialRepo", pluginClass);
                    pluginInitialized = true;
                }
                catch (Exception e) {
                    IdServicesImpl.getDebug().error("IdServicesImpl.getSpecialIdentities: Unable to instantiate plugin: com.sun.identity.idm.plugins.internal.SpecialRepo", (Throwable)e);
                }
            }
        }
        if (pluginInitialized) {
            HashMap<String, String> listenerConfig = new HashMap<String, String>();
            listenerConfig.put("realm", orgName);
            IdRepoListener lter = new IdRepoListener();
            lter.setConfigMap(listenerConfig);
            pluginClass.addListener(token, lter);
        }
        return pluginClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IdRepo getAgentRepoPlugin(SSOToken token, String orgName) throws SSOException, IdRepoException {
        IdRepo pluginClass = null;
        boolean pluginInitialized = false;
        String cacheKey = orgName + ":" + "com.sun.identity.idm.plugins.internal.AgentsRepo";
        Map map = this.idRepoMap;
        synchronized (map) {
            Object o = this.idRepoMap.get(cacheKey);
            if (o instanceof IdRepo) {
                pluginClass = (IdRepo)o;
            }
            if (pluginClass == null) {
                try {
                    Class<?> thisClass = Thread.currentThread().getContextClassLoader().loadClass("com.sun.identity.idm.plugins.internal.AgentsRepo");
                    pluginClass = (IdRepo)thisClass.newInstance();
                    HashMap config = new HashMap(2);
                    HashSet<String> realmName = new HashSet<String>();
                    realmName.add(orgName);
                    config.put("agentsRepoRealmName", realmName);
                    pluginClass.initialize(config);
                    this.idRepoMap.put(cacheKey, pluginClass);
                    pluginInitialized = true;
                }
                catch (Exception e) {
                    IdServicesImpl.getDebug().error("IdServicesImpl.getAgentRepoPlugin: Unable to instantiate plugin: com.sun.identity.idm.plugins.internal.AgentsRepo", (Throwable)e);
                }
            }
        }
        if (pluginInitialized) {
            HashMap<String, String> listenerConfig = new HashMap<String, String>();
            listenerConfig.put("realm", orgName);
            IdRepoListener lter = new IdRepoListener();
            lter.setConfigMap(listenerConfig);
            pluginClass.addListener(token, lter);
        }
        return pluginClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IdRepo getAMRepoPlugin(SSOToken token, String orgName) throws SSOException, IdRepoException {
        String p = "com.iplanet.am.sdk.AMSDKRepo";
        String cacheKey = orgName + ":" + "amSDK";
        IdRepo pluginClass = null;
        Map map = this.idRepoMap;
        synchronized (map) {
            Object o = this.idRepoMap.get(cacheKey);
            if (o instanceof IdRepo) {
                pluginClass = (IdRepo)o;
            }
            if (pluginClass == null) {
                HashMap amsdkConfig = new HashMap();
                HashSet<String> vals = new HashSet<String>();
                vals.add(DNMapper.realmNameToAMSDKName(orgName));
                amsdkConfig.put("amSDKOrgName", vals);
                try {
                    Class<?> thisClass = Thread.currentThread().getContextClassLoader().loadClass(p);
                    pluginClass = (IdRepo)thisClass.newInstance();
                    pluginClass.initialize(amsdkConfig);
                    this.idRepoMap.put(cacheKey, pluginClass);
                }
                catch (Exception e) {
                    IdServicesImpl.getDebug().error("IdServicesImpl.getAMRepoPlugin: Unable to instantiate plugin: " + p, (Throwable)e);
                }
                if (pluginClass != null) {
                    HashMap<String, String> listenerConfig = new HashMap<String, String>();
                    listenerConfig.put("realm", orgName);
                    listenerConfig.put("amsdk", "true");
                    IdRepoListener lter = new IdRepoListener();
                    lter.setConfigMap(listenerConfig);
                    pluginClass.addListener(token, lter);
                }
            }
        }
        return pluginClass;
    }

    public IdSearchResults getSpecialIdentities(SSOToken token, IdType type, String orgName) throws IdRepoException, SSOException {
        IdRepo specialRepo;
        Set opSet;
        OrderedSet pluginClasses = new OrderedSet();
        if (ServiceManager.isConfigMigratedTo70() && ServiceManager.getBaseDN().equalsIgnoreCase(orgName) && (opSet = (specialRepo = this.getSpecialRepoPlugin(token, orgName)).getSupportedOperations(type)) != null && opSet.contains(IdOperation.READ)) {
            pluginClasses.add(specialRepo);
        }
        if (pluginClasses.isEmpty()) {
            return new IdSearchResults(type, orgName);
        }
        specialRepo = (IdRepo)pluginClasses.iterator().next();
        RepoSearchResults res = specialRepo.search(token, type, "*", 0, 0, Collections.EMPTY_SET, false, 0, Collections.EMPTY_MAP, false);
        Object[][] obj = new Object[1][2];
        obj[0][0] = res;
        obj[0][1] = Collections.EMPTY_MAP;
        return this.combineSearchResults(token, obj, 1, type, orgName, false, null);
    }

    public void setAttributes(SSOToken token, IdType type, String name, Map attributes, boolean isAdd, String amOrgName, String amsdkDN, boolean isString) throws IdRepoException, SSOException {
        Set configuredPluginClasses;
        IdRepoException origEx = null;
        this.checkPermission(token, amOrgName, name, attributes.keySet(), IdOperation.EDIT, type);
        Set plugIns = this.getIdRepoPlugins(amOrgName);
        Set set = configuredPluginClasses = attributes.containsKey("objectclass") ? this.getConfiguredPlugins(amOrgName, plugIns, IdOperation.SERVICE, type) : this.getConfiguredPlugins(amOrgName, plugIns, IdOperation.EDIT, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        while (it.hasNext()) {
            IdRepo idRepo = (IdRepo)it.next();
            try {
                Map cMap = idRepo.getConfiguration();
                attributes = this.mapAttributeNames(attributes, cMap);
                if (idRepo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && amsdkDN != null) {
                    if (isString) {
                        idRepo.setAttributes(token, type, amsdkDN, attributes, isAdd);
                        continue;
                    }
                    idRepo.setBinaryAttributes(token, type, amsdkDN, attributes, isAdd);
                    continue;
                }
                if (isString) {
                    idRepo.setAttributes(token, type, name, attributes, isAdd);
                    continue;
                }
                idRepo.setBinaryAttributes(token, type, name, attributes, isAdd);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.setAttributes: Unable to set attributes in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = ide;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.setAttributes: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.setAttributes: Unable to modify identity in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                if (ide.getErrorCode().equalsIgnoreCase("220") && origEx != null) continue;
                origEx = ide;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.setAttributes: Unable to set attributes  for identity " + type.getName() + "::" + name + " in any configured data" + " store", (Throwable)origEx);
            }
            throw origEx;
        }
    }

    public Set getAssignedServices(SSOToken token, IdType type, String name, Map mapOfServiceNamesAndOCs, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        IdRepoException origEx = null;
        this.checkPermission(token, amOrgName, name, null, IdOperation.READ, type);
        Set plugIns = this.getIdRepoPlugins(amOrgName);
        Set configuredPluginClasses = this.getConfiguredPlugins(amOrgName, plugIns, IdOperation.SERVICE, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            if (ServiceManager.getBaseDN().equalsIgnoreCase(amOrgName) && type.equals(IdType.REALM)) {
                return configuredPluginClasses;
            }
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        Object idRepo = null;
        HashSet resultsSet = new HashSet();
        while (it.hasNext()) {
            IdRepo repo = (IdRepo)it.next();
            try {
                Set services = null;
                services = repo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && amsdkDN != null ? repo.getAssignedServices(token, type, amsdkDN, mapOfServiceNamesAndOCs) : repo.getAssignedServices(token, type, name, mapOfServiceNamesAndOCs);
                if (services == null || services.isEmpty()) continue;
                resultsSet.addAll(services);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().error("IdServicesImpl.getAssignedServices: Services not supported for repository " + repo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = ide;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.getAssignedServices: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.getAssignedServices: Unable to get services for identity in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = ide;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.getAssignedServices: Unable to get assigned services for identity " + type.getName() + "::" + name + " in any configured data store", (Throwable)origEx);
            }
            throw origEx;
        }
        return resultsSet;
    }

    public void assignService(SSOToken token, IdType type, String name, String serviceName, SchemaType stype, Map attrMap, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        IdRepoException origEx = null;
        this.checkPermission(token, amOrgName, name, null, IdOperation.SERVICE, type);
        Set plugIns = this.getIdRepoPlugins(amOrgName);
        Set configuredPluginClasses = this.getConfiguredPlugins(amOrgName, plugIns, IdOperation.SERVICE, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        Object idRepo = null;
        while (it.hasNext()) {
            IdRepo repo = (IdRepo)it.next();
            Map cMap = repo.getConfiguration();
            try {
                attrMap = this.mapAttributeNames(attrMap, cMap);
                if (repo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && amsdkDN != null) {
                    repo.assignService(token, type, amsdkDN, serviceName, stype, attrMap);
                    continue;
                }
                repo.assignService(token, type, name, serviceName, stype, attrMap);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().error("IdServicesImpl.assignService: Assign Services not supported for repository " + repo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = ide;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.assignService: FatalException ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().error("IdServicesImpl.assignService: Unable to assign Service identity in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = ide;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.assignService: Unable to assign service for identity " + type.getName() + "::" + name + " in any configured data store ", (Throwable)origEx);
            }
            throw origEx;
        }
    }

    public void unassignService(SSOToken token, IdType type, String name, String serviceName, Map attrMap, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        IdRepoException origEx = null;
        this.checkPermission(token, amOrgName, name, null, IdOperation.SERVICE, type);
        Set plugIns = this.getIdRepoPlugins(amOrgName);
        Set configuredPluginClasses = this.getConfiguredPlugins(amOrgName, plugIns, IdOperation.SERVICE, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        Object idRepo = null;
        while (it.hasNext()) {
            IdRepo repo = (IdRepo)it.next();
            Map cMap = repo.getConfiguration();
            try {
                attrMap = this.mapAttributeNames(attrMap, cMap);
                if (repo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && amsdkDN != null) {
                    repo.unassignService(token, type, amsdkDN, serviceName, attrMap);
                    continue;
                }
                repo.unassignService(token, type, name, serviceName, attrMap);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().error("IdServicesImpl.unassignService: Unassign Service not supported for repository " + repo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = ide;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.unassignService: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.unassignService: Unable to unassign service in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = ide;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.unassignService: Unable to unassign Service for identity " + type.getName() + "::" + name + " in any configured " + "data store ", (Throwable)origEx);
            }
            throw origEx;
        }
    }

    public Map getServiceAttributesAscending(SSOToken token, IdType type, String name, String serviceName, Set attrNames, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        HashMap<String, Set<Object>> finalResult;
        block25: {
            finalResult = new HashMap<String, Set<Object>>();
            HashSet<String> finalAttrName = new HashSet<String>();
            String nextName = name;
            String nextAmOrgName = amOrgName;
            String nextAmsdkDN = amsdkDN;
            IdType nextType = type;
            HashSet<String> missingAttr = new HashSet<String>(attrNames);
            do {
                block24: {
                    try {
                        Map serviceResult = this.getServiceAttributes(token, nextType, nextName, serviceName, missingAttr, nextAmOrgName, nextAmsdkDN);
                        if (IdServicesImpl.getDebug().messageEnabled()) {
                            IdServicesImpl.getDebug().message("IdServicesImpl.getServiceAttributesAscending: nextType=" + nextType + "; nextName=" + nextName + "; serviceName=" + serviceName + "; missingAttr=" + missingAttr + "; nextAmOrgName=" + nextAmOrgName + "; nextAmsdkDN=" + nextAmsdkDN);
                            IdServicesImpl.getDebug().message("  getServiceAttributesAscending: serviceResult=" + serviceResult);
                            IdServicesImpl.getDebug().message("  getServiceAttributesAscending:  finalResult=" + finalResult);
                            IdServicesImpl.getDebug().message("  getServiceAttributesAscending:  finalAttrName=" + finalAttrName);
                        }
                        if (serviceResult != null) {
                            Set srvNameReturned = serviceResult.keySet();
                            Iterator nameIt = srvNameReturned.iterator();
                            while (nameIt.hasNext()) {
                                String attr = (String)nameIt.next();
                                Set attrValue = (Set)serviceResult.get(attr);
                                if (attrValue.isEmpty()) continue;
                                finalResult.put(attr, attrValue);
                                finalAttrName.add(attr);
                            }
                            if (IdServicesImpl.getDebug().messageEnabled()) {
                                IdServicesImpl.getDebug().message("    getServiceAttributesAscending: serviceResult=" + serviceResult);
                                IdServicesImpl.getDebug().message("    getServiceAttributesAscending: finalResult=" + finalResult);
                            }
                        }
                        if (finalAttrName.containsAll(attrNames)) {
                            if (IdServicesImpl.getDebug().messageEnabled()) {
                                IdServicesImpl.getDebug().message("exit getServiceAttributesAscending: finalResult=" + finalResult);
                            }
                            return finalResult;
                        }
                        missingAttr.clear();
                        Iterator it = attrNames.iterator();
                        while (it.hasNext()) {
                            String attrName = (String)it.next();
                            if (finalAttrName.contains(attrName)) continue;
                            missingAttr.add(attrName);
                        }
                    }
                    catch (IdRepoException idrepo) {
                        if (IdServicesImpl.getDebug().warningEnabled()) {
                            IdServicesImpl.getDebug().warning("  getServiceAttributesAscending: idrepoerr", (Throwable)idrepo);
                        }
                    }
                    catch (SSOException ssoex) {
                        if (!IdServicesImpl.getDebug().warningEnabled()) break block24;
                        IdServicesImpl.getDebug().warning("  getServiceAttributesAscending: ssoex", (Throwable)((Object)ssoex));
                    }
                }
                try {
                    if (nextType.equals(IdType.USER) || nextType.equals(IdType.AGENT)) {
                        nextAmsdkDN = nextAmOrgName;
                        nextType = IdType.REALM;
                        continue;
                    }
                    OrganizationConfigManager ocm = new OrganizationConfigManager(token, nextAmOrgName);
                    OrganizationConfigManager parentOCM = ocm.getParentOrgConfigManager();
                    String tmpParentName = parentOCM.getOrganizationName();
                    String parentName = DNMapper.realmNameToAMSDKName(tmpParentName);
                    if (IdServicesImpl.getDebug().messageEnabled()) {
                        IdServicesImpl.getDebug().message("  getServiceAttributesAscending:  tmpParentName=" + tmpParentName + " parentName=" + parentName);
                    }
                    nextType = IdType.REALM;
                    if (nextAmOrgName.equalsIgnoreCase(parentName)) {
                        nextName = null;
                    } else {
                        nextAmOrgName = parentName;
                    }
                    nextAmOrgName = parentName;
                    nextAmsdkDN = parentName;
                }
                catch (SMSException smse) {
                    if (IdServicesImpl.getDebug().warningEnabled()) {
                        IdServicesImpl.getDebug().warning("  getServiceAttributesAscending: smserror", (Throwable)smse);
                    }
                    nextName = null;
                }
            } while (nextName != null);
            if (!missingAttr.isEmpty()) {
                try {
                    ServiceSchemaManager ssm = new ServiceSchemaManager(serviceName, token);
                    ServiceSchema schema = ssm.getDynamicSchema();
                    Map gAttrs = schema.getAttributeDefaults();
                    Iterator missingIt = missingAttr.iterator();
                    while (missingIt.hasNext()) {
                        String missingAttrName = (String)missingIt.next();
                        finalResult.put(missingAttrName, (Set<Object>)gAttrs.get(missingAttrName));
                    }
                }
                catch (SMSException smse) {
                    if (!IdServicesImpl.getDebug().messageEnabled()) break block25;
                    IdServicesImpl.getDebug().message("IdServicesImpl(): getServiceAttributeAscending  Failed to get global default.", (Throwable)smse);
                }
            }
        }
        if (IdServicesImpl.getDebug().messageEnabled()) {
            IdServicesImpl.getDebug().message("exit end  getServiceAttributesAscending:  finalResult=" + finalResult);
        }
        return finalResult;
    }

    public Map getServiceAttributes(SSOToken token, IdType type, String name, String serviceName, Set attrNames, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        return this.getServiceAttributes(token, type, name, serviceName, attrNames, amOrgName, amsdkDN, true);
    }

    public Map getBinaryServiceAttributes(SSOToken token, IdType type, String name, String serviceName, Set attrNames, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        return this.getServiceAttributes(token, type, name, serviceName, attrNames, amOrgName, amsdkDN, false);
    }

    public Map getServiceAttributes(SSOToken token, IdType type, String name, String serviceName, Set attrNames, String amOrgName, String amsdkDN, boolean isString) throws IdRepoException, SSOException {
        this.checkPermission(token, amOrgName, name, attrNames, IdOperation.READ, type);
        Set plugIns = this.getIdRepoPlugins(amOrgName);
        Set configuredPluginClasses = this.getConfiguredPlugins(amOrgName, plugIns, IdOperation.SERVICE, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        Object idRepo = null;
        HashSet<Map> resultsSet = new HashSet<Map>();
        IdRepoException origEx = null;
        while (it.hasNext()) {
            IdRepo repo = (IdRepo)it.next();
            Map cMap = repo.getConfiguration();
            try {
                Map attrs = null;
                attrs = repo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && amsdkDN != null ? (isString ? repo.getServiceAttributes(token, type, amsdkDN, serviceName, attrNames) : repo.getBinaryServiceAttributes(token, type, amsdkDN, serviceName, attrNames)) : (isString ? repo.getServiceAttributes(token, type, name, serviceName, attrNames) : repo.getBinaryServiceAttributes(token, type, name, serviceName, attrNames));
                attrs = this.reverseMapAttributeNames(attrs, cMap);
                resultsSet.add(attrs);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.getServiceAttributes: Services not supported for repository " + repo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = ide;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.getServiceAttributes: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.getServiceAttributes: Unable to get service attributes for the repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
                origEx = ide;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.getServiceAttributes: Unable to get service attributes for identity " + type.getName() + "::" + name + " in any configured data store", (Throwable)origEx);
            }
            throw origEx;
        }
        Map resultsMap = this.combineAttrMaps(resultsSet, isString);
        return resultsMap;
    }

    public void modifyService(SSOToken token, IdType type, String name, String serviceName, SchemaType stype, Map attrMap, String amOrgName, String amsdkDN) throws IdRepoException, SSOException {
        this.checkPermission(token, amOrgName, name, attrMap.keySet(), IdOperation.SERVICE, type);
        Set plugIns = this.getIdRepoPlugins(amOrgName);
        Set configuredPluginClasses = this.getConfiguredPlugins(amOrgName, plugIns, IdOperation.SERVICE, type);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        int noOfSuccess = configuredPluginClasses.size();
        Object idRepo = null;
        while (it.hasNext()) {
            IdRepo repo = (IdRepo)it.next();
            Map cMap = repo.getConfiguration();
            try {
                attrMap = this.mapAttributeNames(attrMap, cMap);
                if (repo.getClass().getName().equals("com.iplanet.am.sdk.AMSDKRepo") && amsdkDN != null) {
                    repo.modifyService(token, type, amsdkDN, serviceName, stype, attrMap);
                    continue;
                }
                repo.modifyService(token, type, name, serviceName, stype, attrMap);
            }
            catch (IdRepoUnsupportedOpException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.modifyService: Modify Services not supported for repository " + repo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
            }
            catch (IdRepoFatalException idf) {
                IdServicesImpl.getDebug().error("IdServicesImpl.modifyService: Fatal Exception ", (Throwable)idf);
                throw idf;
            }
            catch (IdRepoException ide) {
                if (idRepo != null && IdServicesImpl.getDebug().warningEnabled()) {
                    IdServicesImpl.getDebug().warning("IdServicesImpl.modifyService: Unable to modify service in the following repository " + idRepo.getClass().getName() + " :: " + ide.getMessage());
                }
                --noOfSuccess;
            }
        }
        if (noOfSuccess == 0) {
            if (IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("IdServicesImpl.modifyService: Unable to modify service attributes for identity " + type.getName() + "::" + name + " in any configured data store");
            }
            Object[] args = new Object[]{IdOperation.SERVICE.toString()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "302", args);
        }
    }

    public Set getSupportedTypes(SSOToken token, String amOrgName) throws IdRepoException, SSOException {
        HashSet unionSupportedTypes = new HashSet();
        if (!this.orgExist(token, amOrgName)) {
            String installTime = SystemProperties.get("installTime", "false");
            if (!installTime.equals("true")) {
                debug.error("IdServicesImpl.getSupportedTypes: Realm " + amOrgName + " does not exist.");
            }
            Object[] args = new Object[]{amOrgName};
            throw new IdRepoUnsupportedOpException("amIdRepo", "312", args);
        }
        Set plugIns = this.getIdRepoPlugins(amOrgName);
        Set configuredPluginClasses = this.getAllConfiguredPlugins(amOrgName, plugIns);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        while (it.hasNext()) {
            IdRepo repo = (IdRepo)it.next();
            Set supportedTypes = repo.getSupportedTypes();
            if (supportedTypes == null || supportedTypes.isEmpty()) continue;
            unionSupportedTypes.addAll(supportedTypes);
        }
        unionSupportedTypes.retainAll(IdUtils.supportedTypes);
        return unionSupportedTypes;
    }

    public Set getSupportedOperations(SSOToken token, IdType type, String amOrgName) throws IdRepoException, SSOException {
        HashSet unionSupportedOps = new HashSet();
        Set plugIns = this.getIdRepoPlugins(amOrgName);
        Set configuredPluginClasses = this.getAllConfiguredPlugins(amOrgName, plugIns);
        if (configuredPluginClasses == null || configuredPluginClasses.isEmpty()) {
            throw new IdRepoException("amIdRepo", "301", null);
        }
        Iterator it = configuredPluginClasses.iterator();
        while (it.hasNext()) {
            IdRepo repo = (IdRepo)it.next();
            Set supportedOps = repo.getSupportedOperations(type);
            if (supportedOps == null || supportedOps.isEmpty()) continue;
            unionSupportedOps.addAll(supportedOps);
        }
        return unionSupportedOps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearIdRepoOrgPlugin(String orgName, String serviceComponent) {
        if (serviceComponent.equalsIgnoreCase("/")) {
            Map map = this.idRepoMap;
            synchronized (map) {
                Set keys = this.idRepoMap.keySet();
                HashSet<String> keysToRemove = new HashSet<String>();
                Iterator it = keys.iterator();
                while (it.hasNext()) {
                    String cachekey = (String)it.next();
                    String[] cachedOrgName = cachekey.split(":");
                    if (!cachedOrgName[0].equalsIgnoreCase(orgName)) continue;
                    keysToRemove.add(cachekey);
                }
                HashSet removeInstance = new HashSet();
                Iterator it2 = keysToRemove.iterator();
                while (it2.hasNext()) {
                    String cachekey = (String)it2.next();
                    Object o = this.idRepoMap.get(cachekey);
                    if (o instanceof IdRepo) {
                        removeInstance.add(o);
                    } else {
                        Map rMap = (Map)o;
                        removeInstance.addAll(rMap.values());
                    }
                    this.idRepoMap.remove(cachekey);
                }
                it2 = removeInstance.iterator();
                while (it2.hasNext()) {
                    IdRepo repo = (IdRepo)it2.next();
                    repo.removeListener();
                    repo.shutdown();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearIdRepoPlugins(String orgName, String serviceComponent, int type) {
        if (IdServicesImpl.getDebug().messageEnabled()) {
            IdServicesImpl.getDebug().message("IdServicesImpl.clearIdRepoPlugins(): orgName: " + orgName + "; serviceComponent: " + serviceComponent + "Cleanup IdRepo Plugins is called...\n." + " Cleaning up the map.." + this.idRepoMap);
        }
        if (serviceComponent.equalsIgnoreCase("/")) {
            this.clearIdRepoOrgPlugin(orgName, serviceComponent);
            return;
        }
        HashSet<String> dsNameSet = new HashSet<String>();
        HashSet removeInstance = new HashSet();
        Map map = this.idRepoMap;
        synchronized (map) {
            Object o;
            String cachekey;
            Set keys = this.idRepoMap.keySet();
            HashSet<String> keysToRemove = new HashSet<String>();
            Iterator<Object> it = keys.iterator();
            block3: while (it.hasNext()) {
                String[] cachedOrgName;
                cachekey = (String)it.next();
                o = this.idRepoMap.get(cachekey);
                if (o instanceof IdRepo || !(cachedOrgName = cachekey.split(":"))[0].equalsIgnoreCase(orgName)) continue;
                Map rMap = (Map)o;
                Set rKeys = rMap.keySet();
                Iterator it2 = rKeys.iterator();
                while (it2.hasNext()) {
                    String dsName = (String)it2.next();
                    String slashDsName = "/" + dsName;
                    if (!dsName.equalsIgnoreCase(serviceComponent) && !slashDsName.equalsIgnoreCase(serviceComponent)) continue;
                    dsNameSet.add(dsName);
                    removeInstance.add(rMap.get(dsName));
                    keysToRemove.add(cachekey);
                    continue block3;
                }
            }
            it = keysToRemove.iterator();
            while (it.hasNext()) {
                cachekey = (String)it.next();
                o = this.idRepoMap.get(cachekey);
                if (o instanceof IdRepo) continue;
                Map rMap = (Map)o;
                Iterator it2 = dsNameSet.iterator();
                while (it2.hasNext()) {
                    String localName = (String)it2.next();
                    rMap.remove(localName);
                }
            }
        }
        Iterator it = removeInstance.iterator();
        while (it.hasNext()) {
            IdRepo repo = (IdRepo)it.next();
            repo.removeListener();
            repo.shutdown();
        }
        if (type == 1 || type == 4) {
            SSOToken stoken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            Set pluginsNames = this.getIdRepoPlugins(orgName);
            this.getInitializedPlugins(stoken, orgName, pluginsNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearIdRepoPlugins() {
        if (IdServicesImpl.getDebug().messageEnabled()) {
            IdServicesImpl.getDebug().message("IdServicesImpl.cleanupIdRepoPlugins(): Cleanup IdRepo Plugins is called...\n. Cleaning up the map.." + this.idRepoMap);
        }
        HashSet localSet = new HashSet();
        Map map = this.idRepoMap;
        synchronized (map) {
            Set keys = this.idRepoMap.keySet();
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                String cachekey = (String)it.next();
                Object o = this.idRepoMap.get(cachekey);
                if (o instanceof IdRepo) {
                    localSet.add(this.idRepoMap.get(cachekey));
                    continue;
                }
                Map rMap = (Map)o;
                localSet.addAll(rMap.values());
            }
            this.idRepoMap.clear();
        }
        Iterator it = localSet.iterator();
        while (it.hasNext()) {
            IdRepo repo = (IdRepo)it.next();
            repo.removeListener();
            repo.shutdown();
        }
    }

    private Set getIdRepoPlugins(String orgName) {
        if (this.idRepoPlugins == null) {
            return Collections.EMPTY_SET;
        }
        if (ServiceManager.isCoexistenceMode() && !this.idRepoPlugins.contains("amSDK")) {
            this.idRepoPlugins.add("amSDK");
        }
        return this.idRepoPlugins;
    }

    public void reloadIdRepoServiceSchema() {
        this.idRepoPlugins = this.idRepoSubSchema.getSubSchemaNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getInitializedPlugins(SSOToken token, String orgName, Set pluginNames) {
        OrderedSet pluginClasses = new OrderedSet();
        Iterator it = pluginNames.iterator();
        while (it.hasNext()) {
            String p = (String)it.next();
            if (ServiceManager.isCoexistenceMode() && p.equals("amSDK")) continue;
            String cacheKey = orgName + ":" + p;
            Set pNames = this.getConfiguredPluginNames(orgName, p);
            IdRepo pClass = null;
            Map classMap = null;
            Map map = this.idRepoMap;
            synchronized (map) {
                Iterator<Object> it2;
                Object obj = this.idRepoMap.get(cacheKey);
                if (obj instanceof Map) {
                    classMap = (Map)obj;
                }
                if (classMap != null && !classMap.isEmpty()) {
                    it2 = classMap.keySet().iterator();
                    while (it2.hasNext()) {
                        String pName = (String)it2.next();
                        pClass = (IdRepo)classMap.get(pName);
                        pluginClasses.add(pClass);
                        if (pNames == null) continue;
                        pNames.remove(pName);
                    }
                } else if (pNames == null) {
                    this.idRepoMap.put(cacheKey, Collections.EMPTY_MAP);
                    continue;
                }
                if (pNames != null) {
                    it2 = pNames.iterator();
                    while (it2.hasNext()) {
                        Set vals;
                        String pn = (String)it2.next();
                        Map configMap = this.getConfigMap(orgName, p, pn);
                        if (configMap == null || configMap.isEmpty() || (vals = (Set)configMap.get("sunIdRepoClass")) == null) continue;
                        String className = (String)vals.iterator().next();
                        try {
                            Class<?> thisClass = Thread.currentThread().getContextClassLoader().loadClass(className);
                            IdRepo thisPlugin = (IdRepo)thisClass.newInstance();
                            thisPlugin.initialize(configMap);
                            HashMap<String, String> listenerConfig = new HashMap<String, String>();
                            listenerConfig.put("realm", orgName);
                            if (className.equals("com.iplanet.am.sdk.AMSDKRepo")) {
                                listenerConfig.put("amsdk", "true");
                            }
                            listenerConfig.put("plugin-name", pn);
                            IdRepoListener lter = new IdRepoListener();
                            lter.setConfigMap(listenerConfig);
                            thisPlugin.addListener(token, lter);
                            HashMap<String, IdRepo> tmpMap = (HashMap<String, IdRepo>)this.idRepoMap.get(cacheKey);
                            if (tmpMap == null || tmpMap.isEmpty()) {
                                tmpMap = new HashMap<String, IdRepo>();
                            }
                            tmpMap.put(pn, thisPlugin);
                            this.idRepoMap.put(cacheKey, tmpMap);
                            pluginClasses.add(thisPlugin);
                        }
                        catch (Exception e) {
                            IdServicesImpl.getDebug().error("IdServicesImpl.getConfiguredPlugins: Unable to instantiate plugin: " + className, (Throwable)e);
                        }
                    }
                }
            }
        }
        return pluginClasses;
    }

    private Set getConfiguredPlugins(String orgName, Set pluginNames, IdOperation op, IdType type) throws SSOException, IdRepoException {
        IdRepo amRepo;
        IdRepo agentRepo;
        Set agOpSet;
        IdRepo specialRepo;
        Set opSet;
        OrderedSet pluginClasses = new OrderedSet();
        SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        if (ServiceManager.isConfigMigratedTo70() && ServiceManager.getBaseDN().equalsIgnoreCase(orgName) && (opSet = (specialRepo = this.getSpecialRepoPlugin(token, orgName)).getSupportedOperations(type)) != null && opSet.contains(op)) {
            pluginClasses.add(specialRepo);
        }
        if (svcRevisionNumber >= 30 && (agOpSet = (agentRepo = this.getAgentRepoPlugin(token, orgName)).getSupportedOperations(type)) != null && agOpSet.contains(op)) {
            pluginClasses.add(agentRepo);
        }
        if (ServiceManager.isCoexistenceMode() && (opSet = (amRepo = this.getAMRepoPlugin(token, orgName)).getSupportedOperations(type)) != null && opSet.contains(op)) {
            pluginClasses.add(amRepo);
        }
        OrderedSet otherPlugins = (OrderedSet)this.getInitializedPlugins(token, orgName, pluginNames);
        Iterator iter = otherPlugins.iterator();
        Object[] args = new Object[]{"", op.getName(), type.getName()};
        while (iter.hasNext()) {
            IdRepo idRepoPlugin = (IdRepo)iter.next();
            args[0] = idRepoPlugin.getClass().getName();
            Set opSet2 = idRepoPlugin.getSupportedOperations(type);
            if (opSet2 == null || !opSet2.contains(op)) continue;
            pluginClasses.add(idRepoPlugin);
        }
        if (pluginClasses == null || pluginClasses.isEmpty()) {
            throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
        }
        return pluginClasses;
    }

    private Set getAllConfiguredPlugins(String orgName, Set pluginNames) throws SSOException, IdRepoException {
        OrderedSet pluginClasses = new OrderedSet();
        SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        if (!this.orgExist(token, orgName)) {
            String rName = DNMapper.orgNameToRealmName(orgName);
            debug.error("IdServicesImpl.getAllConfiguredPlugins: Realm " + rName + " does not exist.");
            Object[] args = new Object[]{rName};
            throw new IdRepoUnsupportedOpException("amIdRepo", "312", args);
        }
        if (ServiceManager.isConfigMigratedTo70() && ServiceManager.getBaseDN().equalsIgnoreCase(orgName)) {
            IdRepo specialRepo = this.getSpecialRepoPlugin(token, orgName);
            pluginClasses.add(specialRepo);
        }
        if (svcRevisionNumber >= 30) {
            IdRepo agentRepo = this.getAgentRepoPlugin(token, orgName);
            pluginClasses.add(agentRepo);
        }
        if (ServiceManager.isCoexistenceMode()) {
            IdRepo amRepo = this.getAMRepoPlugin(token, orgName);
            pluginClasses.add(amRepo);
        }
        pluginClasses.addAll(this.getInitializedPlugins(token, orgName, pluginNames));
        return pluginClasses;
    }

    private Set getConfiguredPluginNames(String orgName, String schemaName) {
        HashSet<String> cPlugins = null;
        SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        try {
            ServiceConfigManager scm = new ServiceConfigManager(token, "sunIdentityRepositoryService", "1.0");
            if (scm == null) {
                return cPlugins;
            }
            ServiceConfig sc = scm.getOrganizationConfig(orgName, null);
            if (sc == null) {
                return cPlugins;
            }
            ServiceConfig subConfig = null;
            Set plugins = sc.getSubConfigNames();
            if (plugins != null && !plugins.isEmpty()) {
                Iterator items = plugins.iterator();
                while (items.hasNext()) {
                    String pName = (String)items.next();
                    subConfig = sc.getSubConfig(pName);
                    if (subConfig == null || !subConfig.getSchemaID().equalsIgnoreCase(schemaName)) continue;
                    if (cPlugins == null) {
                        cPlugins = new HashSet<String>();
                    }
                    cPlugins.add(pName);
                }
            }
            return cPlugins;
        }
        catch (SMSException smse) {
            if (ServiceManager.isConfigMigratedTo70() && IdServicesImpl.getDebug().warningEnabled()) {
                IdServicesImpl.getDebug().warning("SM Exception: unable to get plugin information", (Throwable)smse);
            }
            return cPlugins;
        }
        catch (SSOException ssoe) {
            if (debug.warningEnabled()) {
                IdServicesImpl.getDebug().warning("SSO Exception: ", (Throwable)((Object)ssoe));
            }
            return cPlugins;
        }
    }

    private Map getConfigMap(String orgName, String pluginName, String configName) {
        SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        if (ServiceManager.isCoexistenceMode() && pluginName.equals("amSDK")) {
            HashMap amsdkConfig = new HashMap();
            HashSet<String> vals = new HashSet<String>();
            vals.add(DNMapper.realmNameToAMSDKName(orgName));
            amsdkConfig.put("amSDKOrgName", vals);
            return amsdkConfig;
        }
        Map configMap = Collections.EMPTY_MAP;
        try {
            ServiceConfigManager scm = new ServiceConfigManager(token, "sunIdentityRepositoryService", "1.0");
            if (scm == null) {
                return configMap;
            }
            ServiceConfig sc = scm.getOrganizationConfig(orgName, null);
            if (sc == null) {
                return configMap;
            }
            ServiceConfig subConfig = sc.getSubConfig(configName);
            if (subConfig != null && subConfig.getSchemaID().equalsIgnoreCase(pluginName)) {
                configMap = subConfig.getAttributes();
            }
            return configMap;
        }
        catch (SMSException smse) {
            IdServicesImpl.getDebug().error("IdServicesImpl.getConfigMap: SM Exception: unable to get plugin information", (Throwable)smse);
            return configMap;
        }
        catch (SSOException ssoe) {
            IdServicesImpl.getDebug().error("IdServicesImpl.getConfigMap: SSO Exception: ", (Throwable)((Object)ssoe));
            return configMap;
        }
    }

    private Map combineAttrMaps(Set setOfMaps, boolean isString) {
        AMHashMap resultMap = new AMHashMap(!isString);
        Iterator it = setOfMaps.iterator();
        while (it.hasNext()) {
            Map currMap = (Map)it.next();
            if (currMap == null) continue;
            Iterator keyset = currMap.keySet().iterator();
            while (keyset.hasNext()) {
                Object thisSet;
                Object resultSet;
                String thisAttr = (String)keyset.next();
                if (isString) {
                    resultSet = (Set)resultMap.get(thisAttr);
                    thisSet = (Set)currMap.get(thisAttr);
                    if (resultSet != null) {
                        resultSet.addAll(thisSet);
                        continue;
                    }
                    resultSet = new HashSet((Set)currMap.get(thisAttr));
                    resultMap.put(thisAttr, resultSet);
                    continue;
                }
                resultSet = (byte[][])resultMap.get(thisAttr);
                thisSet = (byte[][])currMap.get(thisAttr);
                int combinedSize = ((Object)thisSet).length;
                if (resultSet != null) {
                    int i;
                    combinedSize = ((Object)resultSet).length + ((Object)thisSet).length;
                    byte[][] tmpSet = new byte[combinedSize][];
                    for (i = 0; i < ((Object)resultSet).length; ++i) {
                        tmpSet[i] = (byte[])resultSet[i];
                    }
                    for (i = 0; i < ((Object)thisSet).length; ++i) {
                        tmpSet[i] = (byte[])thisSet[i];
                    }
                    resultSet = tmpSet;
                } else {
                    resultSet = (byte[][])thisSet.clone();
                }
                resultMap.put(thisAttr, resultSet);
            }
        }
        return resultMap;
    }

    private Map mapAttributeNames(Map attrMap, Map configMap) {
        Map resultMap;
        if (attrMap == null || attrMap.isEmpty()) {
            return attrMap;
        }
        Map[] mapArray = this.getAttributeNameMap(configMap);
        if (mapArray == null) {
            resultMap = attrMap;
        } else {
            resultMap = new CaseInsensitiveHashMap();
            Map forwardMap = mapArray[0];
            Iterator it = attrMap.keySet().iterator();
            while (it.hasNext()) {
                String curr = (String)it.next();
                if (forwardMap.containsKey(curr)) {
                    resultMap.put((String)forwardMap.get(curr), (Set)attrMap.get(curr));
                    continue;
                }
                resultMap.put(curr, (Set)attrMap.get(curr));
            }
        }
        return resultMap;
    }

    private Set mapAttributeNames(Set attrNames, Map configMap) {
        Set resultSet;
        if (attrNames == null || attrNames.isEmpty()) {
            return attrNames;
        }
        Map[] mapArray = this.getAttributeNameMap(configMap);
        if (mapArray == null) {
            resultSet = attrNames;
        } else {
            resultSet = new CaseInsensitiveHashSet();
            Map forwardMap = mapArray[0];
            Iterator it = attrNames.iterator();
            while (it.hasNext()) {
                String curr = (String)it.next();
                if (forwardMap.containsKey(curr)) {
                    resultSet.add((String)forwardMap.get(curr));
                    continue;
                }
                resultSet.add(curr);
            }
        }
        return resultSet;
    }

    private Map reverseMapAttributeNames(Map attrMap, Map configMap) {
        Map resultMap;
        if (attrMap == null || attrMap.isEmpty()) {
            return attrMap;
        }
        Map[] mapArray = this.getAttributeNameMap(configMap);
        if (mapArray == null) {
            resultMap = attrMap;
        } else {
            resultMap = new CaseInsensitiveHashMap();
            Map reverseMap = mapArray[1];
            Iterator it = attrMap.keySet().iterator();
            while (it.hasNext()) {
                String curr = (String)it.next();
                if (reverseMap.containsKey(curr)) {
                    resultMap.put((String)reverseMap.get(curr), attrMap.get(curr));
                    continue;
                }
                resultMap.put(curr, attrMap.get(curr));
            }
        }
        return resultMap;
    }

    private Set combineMembers(SSOToken token, Set membersSet, IdType type, String orgName, boolean amsdkIncluded, Set amsdkMemberships) {
        HashSet<AMIdentity> results = new HashSet<AMIdentity>();
        CaseInsensitiveHashMap resultsMap = new CaseInsensitiveHashMap();
        if (amsdkIncluded && amsdkMemberships != null) {
            Iterator it = amsdkMemberships.iterator();
            while (it.hasNext()) {
                String m = (String)it.next();
                String mname = DNUtils.DNtoName(m);
                AMIdentity id = new AMIdentity(token, mname, type, orgName, m);
                results.add(id);
                resultsMap.put(mname, id);
            }
        }
        Iterator miter = membersSet.iterator();
        while (miter.hasNext()) {
            Set first = (Set)miter.next();
            if (first == null) continue;
            Iterator it = first.iterator();
            while (it.hasNext()) {
                String m = (String)it.next();
                String mname = DNUtils.DNtoName(m);
                if (resultsMap.containsKey(mname)) continue;
                AMIdentity id = new AMIdentity(token, mname, type, orgName, null);
                results.add(id);
                resultsMap.put(mname, id);
            }
        }
        return results;
    }

    private IdSearchResults combineSearchResults(SSOToken token, Object[][] arrayOfResult, int sizeOfArray, IdType type, String orgName, boolean amsdkIncluded, Object[][] amsdkResults) {
        Iterator it;
        CaseInsensitiveHashMap amsdkDNs = new CaseInsensitiveHashMap();
        CaseInsensitiveHashMap resultsMap = new CaseInsensitiveHashMap();
        int errorCode = 0;
        if (amsdkIncluded) {
            RepoSearchResults amsdkRepoRes = (RepoSearchResults)amsdkResults[0][0];
            Set results = amsdkRepoRes.getSearchResults();
            Map attrResults = amsdkRepoRes.getResultAttributes();
            it = results.iterator();
            while (it.hasNext()) {
                String dn = (String)it.next();
                String name = LDAPDN.explodeDN((String)dn, (boolean)true)[0];
                amsdkDNs.put(name, dn);
                HashSet<Map> attrMaps = new HashSet<Map>();
                attrMaps.add((Map)attrResults.get(dn));
                resultsMap.put(name, attrMaps);
            }
            errorCode = amsdkRepoRes.getErrorCode();
        }
        for (int i = 0; i < sizeOfArray; ++i) {
            RepoSearchResults current = (RepoSearchResults)arrayOfResult[i][0];
            Map configMap = (Map)arrayOfResult[i][1];
            it = current.getSearchResults().iterator();
            Map allAttrMaps = current.getResultAttributes();
            while (it.hasNext()) {
                String m = (String)it.next();
                String mname = DNUtils.DNtoName(m, false);
                Map attrMap = (Map)allAttrMaps.get(m);
                attrMap = this.reverseMapAttributeNames(attrMap, configMap);
                HashSet<Map> attrMaps = (HashSet<Map>)resultsMap.get(mname);
                if (attrMaps == null) {
                    attrMaps = new HashSet<Map>();
                }
                attrMaps.add(attrMap);
                resultsMap.put(mname, attrMaps);
            }
        }
        IdSearchResults results = new IdSearchResults(type, orgName);
        Iterator it2 = resultsMap.keySet().iterator();
        while (it2.hasNext()) {
            String mname = (String)it2.next();
            Map combinedMap = this.combineAttrMaps((Set)resultsMap.get(mname), true);
            AMIdentity id = new AMIdentity(token, mname, type, orgName, (String)amsdkDNs.get(mname));
            results.addResult(id, combinedMap);
        }
        results.setErrorCode(errorCode);
        return results;
    }

    private Map[] getAttributeNameMap(Map configMap) {
        Set attributeMap = (Set)configMap.get("sunIdRepoAttributeMapping");
        if (attributeMap == null || attributeMap.isEmpty()) {
            return null;
        }
        Map[] returnArray = new Map[2];
        int size = attributeMap.size();
        returnArray[0] = new CaseInsensitiveHashMap(size);
        returnArray[1] = new CaseInsensitiveHashMap(size);
        Iterator it = attributeMap.iterator();
        while (it.hasNext()) {
            String mapString = (String)it.next();
            int eqIndex = mapString.indexOf(61);
            if (eqIndex > -1) {
                String first = mapString.substring(0, eqIndex);
                String second = mapString.substring(eqIndex + 1);
                returnArray[0].put(first, second);
                returnArray[1].put(second, first);
                continue;
            }
            returnArray[0].put(mapString, mapString);
            returnArray[1].put(mapString, mapString);
        }
        return returnArray;
    }

    private boolean checkPermission(SSOToken token, String realm, String name, Set attrs, IdOperation op, IdType type) throws IdRepoException, SSOException {
        if (!ServiceManager.isConfigMigratedTo70()) {
            return true;
        }
        HashSet thisAction = null;
        thisAction = op.equals(IdOperation.READ) ? READ_ACTION : WRITE_ACTION;
        try {
            DelegationEvaluator de = new DelegationEvaluator();
            String resource = type.getName();
            if (name != null) {
                resource = resource + "/" + name;
            }
            DelegationPermission dp = new DelegationPermission(realm, "sunIdentityRepositoryService", "1.0", "application", resource, thisAction, Collections.EMPTY_MAP);
            HashMap<String, Set> envMap = Collections.EMPTY_MAP;
            if (attrs != null) {
                envMap = new HashMap<String, Set>();
                envMap.put(DELEGATION_ATTRS_NAME, attrs);
            }
            if (!de.isAllowed(token, dp, envMap)) {
                Object[] args = new Object[]{op.getName(), token.getPrincipal().getName()};
                throw new IdRepoException("amIdRepo", "402", args);
            }
            return true;
        }
        catch (DelegationException dex) {
            IdServicesImpl.getDebug().error("IdServicesImpl.checkPermission Got Delegation Exception: ", (Throwable)dex);
            Object[] args = new Object[]{op.getName(), token.getPrincipal().getName()};
            throw new IdRepoException("amIdRepo", "402", args);
        }
    }

    private boolean orgExist(SSOToken token, String orgName) {
        boolean isExist = false;
        try {
            ServiceConfigManager scm = new ServiceConfigManager(token, "sunIdentityRepositoryService", "1.0");
            if (scm != null) {
                if (scm.getOrganizationConfig(orgName, null) != null) {
                    isExist = true;
                } else if (debug.messageEnabled()) {
                    debug.message("IdServicesImpl.orgExist organization does not exist. orgName=" + orgName);
                }
            } else if (debug.messageEnabled()) {
                debug.message("IdServicesImpl.orgExist service not configured for this org. orgName=" + orgName);
            }
        }
        catch (SMSException smse) {
            String installTime = SystemProperties.get("installTime", "false");
            if (!installTime.equals("true")) {
                IdServicesImpl.getDebug().error("IdServicesImpl.orgExist:  sms Exception: realm not found", (Throwable)smse);
            }
        }
        catch (SSOException ssoe) {
            IdServicesImpl.getDebug().error("IdServicesImpl.orgExist:  SSO  Exception: realm not found", (Throwable)((Object)ssoe));
        }
        return isExist;
    }

    static {
        READ_ACTION.add("READ");
        WRITE_ACTION.add("MODIFY");
    }
}

