/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.cli;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.log.LogManager;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.LogReader;
import com.sun.identity.log.handlers.SecureFileHandler;
import com.sun.identity.log.secure.SecureLogHelper;
import com.sun.identity.log.secure.VerifierList;
import com.sun.identity.log.spi.VerifierAction;
import com.sun.identity.security.keystore.AMPassword;
import com.sun.identity.setup.Bootstrap;
import com.sun.identity.setup.ConfiguratorException;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.tools.bundles.VersionCheck;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.Vector;

public class ISArchiveVerify {
    private static String USAGE = "Usage: amverifyarchive -l <logName> -p <path> -u <uname> -w <password>";
    private static String PREFIX = "_secure.";
    private String curMAC = null;
    private String prevSignature = null;
    private boolean verified = true;
    private SecureLogHelper helper;
    private AMPassword verPassword;
    private static ResourceBundle bundle = null;
    static final int INVALID = 0;
    static final int LOGNAME = 1;
    static final int PATH = 2;
    static final int USERNAME = 3;
    static final int PASSWORD = 4;
    static Map OPTIONS = new HashMap();

    static int getToken(String arg) {
        try {
            return (Integer)OPTIONS.get(arg);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args.length != 8) {
            System.err.println(USAGE);
            System.exit(1);
        }
        ISArchiveVerify.runCommand(args);
    }

    private static void runCommand(String[] argv) throws Exception {
        try {
            Bootstrap.load();
        }
        catch (ConfiguratorException ex) {
            System.err.println(ex.getL10NMessage(java.util.Locale.getDefault()));
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Cannot bootstrap the system" + e.getMessage());
            System.exit(1);
        }
        if (VersionCheck.isVersionValid() == 1) {
            System.exit(1);
        }
        int ln = 0;
        int path = 0;
        int uname = 0;
        int passwd = 0;
        try {
            block13: for (int i = 0; i < argv.length; ++i) {
                int opt = ISArchiveVerify.getToken(argv[i]);
                switch (opt) {
                    case 1: {
                        ln = ++i;
                        continue block13;
                    }
                    case 2: {
                        path = ++i;
                        continue block13;
                    }
                    case 3: {
                        uname = ++i;
                        continue block13;
                    }
                    case 4: {
                        passwd = ++i;
                        continue block13;
                    }
                    default: {
                        throw new Exception();
                    }
                }
            }
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                System.err.println(e.getMessage());
            }
            e.printStackTrace();
            System.err.println(USAGE);
            System.exit(1);
        }
        try {
            ISArchiveVerify iav = new ISArchiveVerify();
            boolean verified = iav.verifyArchive(argv[ln], argv[path], argv[uname], argv[passwd]);
            if (verified) {
                System.out.println(bundle.getString("verificationOfLogArchiveFor") + " " + argv[ln] + " " + bundle.getString("archiveVerificationPassed"));
            } else {
                System.out.println(bundle.getString("verificationOfLogArchiveFor") + " " + argv[ln] + " " + bundle.getString("archiveVerificationFailed"));
            }
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                System.err.println(e.getMessage());
            }
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private boolean verifyLogRecord(String[] record, int macPos) throws Exception {
        StringBuffer data = new StringBuffer();
        for (int m = 0; m < record.length - 2; ++m) {
            data.append(record[m]);
        }
        this.curMAC = new String(record[macPos]);
        this.verified = this.helper.verifyMAC(data.toString(), SecureLogHelper.toByteArray(this.curMAC));
        return this.verified;
    }

    private boolean verifySignature(String[] record, int signPos, int recPos) throws Exception {
        byte[] newMAC;
        String curSign = new String(record[signPos]);
        if (this.curMAC == null) {
            return false;
        }
        byte[] prevMAC = SecureLogHelper.toByteArray(this.curMAC);
        if (this.prevSignature == null || this.prevSignature.equals("")) {
            newMAC = new byte[prevMAC.length];
            System.arraycopy(prevMAC, 0, newMAC, 0, prevMAC.length);
        } else {
            newMAC = new byte[prevMAC.length + SecureLogHelper.toByteArray(this.prevSignature).length];
            System.arraycopy(prevMAC, 0, newMAC, 0, prevMAC.length);
            System.arraycopy(SecureLogHelper.toByteArray(this.prevSignature), 0, newMAC, prevMAC.length, SecureLogHelper.toByteArray(this.prevSignature).length);
        }
        if (recPos != 0) {
            this.prevSignature = curSign;
        }
        this.verified = this.helper.verifySignature(SecureLogHelper.toByteArray(curSign), newMAC);
        return this.verified;
    }

    public boolean verifyArchive(String logName, String path, String uname, String passwd) throws Exception {
        TreeMap tm;
        String log = logName;
        LogManager lm = (LogManager)LogManagerUtil.getLogManager();
        lm.readConfiguration();
        this.verPassword = new AMPassword(passwd.toCharArray());
        SSOToken ssoToken = null;
        SSOTokenManager ssoMngr = null;
        try {
            ssoMngr = SSOTokenManager.getInstance();
            ssoToken = ssoMngr.createSSOToken(new AuthPrincipal(uname), passwd);
        }
        catch (SSOException ssoe) {
            System.out.println(bundle.getString("archiveVerification") + "SSOException: " + ssoe.getMessage());
            return false;
        }
        catch (UnsupportedOperationException uoe) {
            System.out.println(bundle.getString("archiveVerification") + "UnsupportedOperationException: " + uoe.getMessage());
            return false;
        }
        VerifierList vl = new VerifierList();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if ((tm = vl.getKeysAndFiles(new File(path), logName)).size() == 0) {
            System.out.println(bundle.getString("archiveVerification") + bundle.getString("noFilesToVerify") + ", size == 0");
            return true;
        }
        Object[] keyFiles = tm.keySet().toArray();
        String verFile = new String();
        if (keyFiles.length == 1) {
            System.out.println(bundle.getString("archiveVerification") + bundle.getString("noFilesToVerify") + ", keyFiles.length == 1");
        }
        for (int i = 1; i < keyFiles.length; ++i) {
            this.helper = SecureFileHandler.getSecureLogHelperInst();
            Vector logFiles = (Vector)tm.get(keyFiles[i]);
            String tmpName = ((String)keyFiles[i]).substring(((String)keyFiles[i]).indexOf(".") + 1);
            verFile = tmpName.substring(tmpName.indexOf("."));
            verFile = PREFIX + "ver" + verFile;
            this.helper.initializeVerifier(path + verFile, this.verPassword, this.verPassword);
            this.helper.reinitializeVerifier(path + verFile, this.verPassword);
            this.curMAC = null;
            this.prevSignature = null;
            for (int j = 0; j < logFiles.size(); ++j) {
                System.out.println(bundle.getString("fileBeingVerified") + (String)logFiles.elementAt(j));
                int lastRecInFile = 0;
                String[][] result = new String[1][1];
                try {
                    result = LogReader.read((String)logFiles.elementAt(j), ssoToken);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (result != null || result.length != 0) {
                    int l;
                    Vector<String> header = new Vector<String>(result[0].length);
                    for (int k = 0; k < result[0].length; ++k) {
                        header.add(result[0][k]);
                    }
                    int signPos = -1;
                    int macPos = -1;
                    String signFldName = "Signature";
                    String macFldName = "MAC";
                    for (l = 0; l < header.size(); ++l) {
                        if (!((String)header.get(l)).equalsIgnoreCase(signFldName)) continue;
                        signPos = l;
                        break;
                    }
                    for (l = 0; l < header.size(); ++l) {
                        if (!((String)header.get(l)).equalsIgnoreCase(macFldName)) continue;
                        macPos = l;
                        break;
                    }
                    if (signPos == -1 || macPos == -1) {
                        return VerifierAction.doVerifierAction(log, this.verified);
                    }
                    for (int k = 1; k < result.length; ++k) {
                        if (result[k][signPos].equals("-")) {
                            this.verified = this.verifyLogRecord(result[k], macPos);
                            if (!this.verified) {
                                System.err.println(bundle.getString("recordVerificationFailed") + (String)logFiles.elementAt(j) + " " + bundle.getString("atRecordNumber") + k);
                                break;
                            }
                            System.out.println(bundle.getString("recordVerificationPassed") + (String)logFiles.elementAt(j) + " " + bundle.getString("atRecordNumber") + k);
                            continue;
                        }
                        lastRecInFile = result.length - 1 - k;
                        this.verified = this.verifySignature(result[k], signPos, lastRecInFile);
                        if (!this.verified) {
                            System.err.println(bundle.getString("signatureVerificationFailed") + (String)logFiles.elementAt(j) + bundle.getString("atRecordNumber") + k);
                            break;
                        }
                        System.out.println(bundle.getString("signatureVerificationPassed") + (String)logFiles.elementAt(j) + bundle.getString("atRecordNumber") + k);
                    }
                } else {
                    System.err.println(bundle.getString("archiveVerification") + bundle.getString("emptyReturn") + (String)logFiles.elementAt(j));
                }
                if (this.verified) continue;
                return this.verified;
            }
            this.helper.reinitializeVerifier(path + verFile, this.verPassword);
        }
        return this.verified;
    }

    static {
        bundle = Locale.getInstallResourceBundle((String)"amLogging");
        OPTIONS.put("-l", new Integer(1));
        OPTIONS.put("-p", new Integer(2));
        OPTIONS.put("-u", new Integer(3));
        OPTIONS.put("-w", new Integer(4));
    }
}

