/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyEvent;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.PolicyStatsListener;
import com.sun.identity.policy.ResBundleUtils;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.SubjectTypeManager;
import com.sun.identity.policy.interfaces.PolicyListener;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.stats.Stats;
import com.sun.identity.shared.stats.StatsListener;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import netscape.ldap.util.DN;

class PolicyCache
implements ServiceListener {
    public static final String POLICY_STATS = "amPolicyStats";
    static final Debug DEBUG = PolicyManager.debug;
    private static final String CACHE_KEY_DELIMITER = "/";
    private static final String POLICIES_COMPONENT = "/policies/";
    private static final String RESOURCES_COMPONENT = "/resources/";
    private static final String REALM_SUBJECTS_COMPONENT = "/realmsubjects";
    private static PolicyCache policyCache;
    private Map policies = Collections.synchronizedMap(new HashMap());
    private Map policyManagers = Collections.synchronizedMap(new HashMap());
    private Map policyListenersMap = Collections.synchronizedMap(new HashMap());
    private ServiceConfigManager scm;
    private SSOToken token;

    static synchronized PolicyCache getInstance() throws PolicyException {
        if (policyCache == null) {
            if (DEBUG.messageEnabled()) {
                DEBUG.message("Creating singleton policy cache");
            }
            policyCache = new PolicyCache();
            try {
                PolicyCache.policyCache.token = ServiceTypeManager.getSSOToken();
                PolicyCache.policyCache.scm = new ServiceConfigManager("iPlanetAMPolicyService", PolicyCache.policyCache.token);
                PolicyCache.policyCache.scm.addListener(policyCache);
            }
            catch (SMSException smse) {
                DEBUG.error(ResBundleUtils.getString("can_not_create_policy_cache"), (Throwable)smse);
                throw new PolicyException("amPolicy", "can_not_create_policy_cache", null, smse);
            }
            catch (SSOException ssoe) {
                DEBUG.error(ResBundleUtils.getString("can_not_create_policy_cache"), (Throwable)((Object)ssoe));
                throw new PolicyException("amPolicy", "can_not_create_policy_cache", null, (Throwable)((Object)ssoe));
            }
            Stats policyStats = Stats.getInstance((String)POLICY_STATS);
            if (policyStats.isEnabled()) {
                PolicyStatsListener policyStatsListener = new PolicyStatsListener(policyStats);
                policyStats.addStatsListener((StatsListener)policyStatsListener);
                if (DEBUG.messageEnabled()) {
                    DEBUG.message("PolicyCache.getInstance(): Registered PolicyStatsListener with  Stats service");
                }
            }
        }
        return policyCache;
    }

    private PolicyCache() {
    }

    Policy getPolicy(String orgName, String policyName) {
        String cacheKey = this.buildCacheKey(orgName, policyName);
        if (DEBUG.messageEnabled()) {
            StringBuffer sb = new StringBuffer(100);
            sb.append("at PolicyCache.getPolicy(orgName,policyName):");
            sb.append("orgName=").append(orgName).append(":").append("policyName=").append(policyName).append("cacheKey=").append(cacheKey);
            DEBUG.message(sb.toString());
        }
        return this.getPolicy(cacheKey);
    }

    Policy getPolicy(String cacheKey) {
        Policy policy = null;
        if (DEBUG.messageEnabled()) {
            DEBUG.message("PolicyCache:cacheKeys in cache:" + this.policies.keySet());
        }
        if (this.policies.containsKey(cacheKey)) {
            policy = (Policy)this.policies.get(cacheKey);
            if (DEBUG.messageEnabled() && policy == null) {
                DEBUG.message("PolicyCache:returning null policy from cache for key:" + cacheKey);
            }
        } else {
            if (DEBUG.messageEnabled()) {
                DEBUG.message("PolicyCache:refreshing policy for cache key:" + cacheKey);
            }
            policy = this.refreshPolicy(cacheKey);
        }
        return policy;
    }

    Policy refreshPolicy(String cacheKey) {
        String[] cacheKeyTokens = this.tokenizeCacheKey(cacheKey);
        Policy policy = null;
        String orgName = cacheKeyTokens[5];
        String policyName = cacheKeyTokens[1];
        if (DEBUG.messageEnabled()) {
            StringBuffer sb = new StringBuffer(500);
            sb.append("at PolicyCache.refreshPolicy refreshing policy for - ").append("cacheKey=").append(cacheKey).append(":").append("policyName=").append(policyName).append(":").append("orgName=").append(orgName);
            DEBUG.message(sb.toString());
        }
        try {
            PolicyManager pm = this.getPolicyManager(orgName);
            policy = pm.getPolicy(policyName);
        }
        catch (PolicyException pe) {
            Object[] objs = new String[]{cacheKey};
            DEBUG.error(ResBundleUtils.getString("can_not_refresh_policy_for_cachekey", objs), (Throwable)pe);
        }
        catch (SSOException ssoe) {
            Object[] objs = new String[]{cacheKey};
            DEBUG.error(ResBundleUtils.getString("can_not_refresh_policy_for_cachekey", objs), (Throwable)((Object)ssoe));
        }
        if (policy == null) {
            DEBUG.error("refreshed policy is null for cache key : " + cacheKey);
        } else {
            this.policies.put(cacheKey, policy);
            policy.initializeEvaluationWeights();
        }
        return policy;
    }

    void addPolicyListener(PolicyListener policyListener) {
        String listenerServiceName = policyListener.getServiceTypeName();
        HashSet<PolicyListener> newListeners = new HashSet<PolicyListener>();
        newListeners.add(policyListener);
        Set oldListeners = (Set)this.policyListenersMap.get(listenerServiceName);
        if (oldListeners != null) {
            newListeners.addAll(oldListeners);
        }
        this.policyListenersMap.put(listenerServiceName, newListeners);
    }

    void removePolicyListener(PolicyListener policyListener) {
        String listenerServiceName = policyListener.getServiceTypeName();
        Set oldListeners = (Set)this.policyListenersMap.get(listenerServiceName);
        if (oldListeners != null) {
            HashSet newListeners = new HashSet();
            newListeners.addAll(oldListeners);
            newListeners.remove(policyListener);
            this.policyListenersMap.put(listenerServiceName, newListeners);
        }
    }

    public void schemaChanged(String serviceName, String version) {
    }

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int changeType) {
    }

    public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int changeType) {
        if (DEBUG.messageEnabled()) {
            StringBuffer sb = new StringBuffer(255);
            sb.append("Received SMS notification, orgConfigChanged");
            sb.append("serviceName, version, orgName, groupName, ");
            sb.append(" serviceComponent, changeType:");
            sb.append(serviceName).append(":").append(version).append(":");
            sb.append(orgName).append(":").append(groupName).append(":");
            sb.append(serviceComponent).append(":").append(changeType);
            DEBUG.message(sb.toString());
        }
        Policy oldPolicy = null;
        Policy newPolicy = null;
        if (serviceComponent.startsWith(POLICIES_COMPONENT)) {
            String cacheKey = this.buildCacheKey(serviceName, version, orgName, groupName, serviceComponent);
            if (changeType == 1) {
                if (DEBUG.messageEnabled()) {
                    DEBUG.message("SMS Notification- policy added -Refreshing policy for cacheKey=" + cacheKey);
                }
                newPolicy = this.refreshPolicy(cacheKey);
            } else if (changeType == 2) {
                if (DEBUG.messageEnabled()) {
                    DEBUG.message("SMS Notification- policy removed - cacheKey=" + cacheKey);
                }
                oldPolicy = (Policy)this.policies.get(cacheKey);
                this.policies.put(cacheKey, null);
            } else if (changeType == 4) {
                oldPolicy = (Policy)this.policies.get(cacheKey);
                if (DEBUG.messageEnabled()) {
                    DEBUG.message("SMS Notification- policy modified -Refreshing policy for cacheKey=" + cacheKey);
                }
                newPolicy = this.refreshPolicy(cacheKey);
            } else {
                DEBUG.error("SMS Notification- unsupported change type : " + changeType);
            }
            Iterator iter = this.policyListenersMap.keySet().iterator();
            while (iter.hasNext()) {
                String listenerServiceName = (String)iter.next();
                HashSet affectedResourceNames = new HashSet();
                try {
                    if (oldPolicy != null) {
                        affectedResourceNames.addAll(oldPolicy.getResourceNames(listenerServiceName));
                    }
                    if (newPolicy != null) {
                        affectedResourceNames.addAll(newPolicy.getResourceNames(listenerServiceName));
                    }
                }
                catch (SSOException ssoe) {
                    DEBUG.error(ResBundleUtils.getString("invalid_sso_token"), (Throwable)((Object)ssoe));
                }
                catch (NameNotFoundException nnfe) {
                    Object[] objs = new String[]{listenerServiceName};
                    DEBUG.error(ResBundleUtils.getString("service_name_not_found", objs), (Throwable)nnfe);
                }
                if (affectedResourceNames.isEmpty()) continue;
                this.firePolicyChanged(listenerServiceName, affectedResourceNames, changeType);
            }
        }
        if (serviceComponent.startsWith(RESOURCES_COMPONENT)) {
            try {
                PolicyManager pm = this.getPolicyManager(orgName);
                String resourceTypeName = serviceComponent.substring("/resources".length() + 1);
                if (DEBUG.messageEnabled()) {
                    DEBUG.message("SMS Notification- resource index modified-clearing index for resource type " + resourceTypeName);
                }
                pm.getResourceIndexManager().clearResourceIndex(resourceTypeName);
            }
            catch (PolicyException pe) {
                DEBUG.error("error while clearing resource index ", (Throwable)pe);
            }
            catch (SSOException ssoe) {
                DEBUG.error(ResBundleUtils.getString("invalid_sso_token"), (Throwable)((Object)ssoe));
            }
        }
        if (serviceComponent.startsWith(REALM_SUBJECTS_COMPONENT)) {
            if (DEBUG.messageEnabled()) {
                DEBUG.message("SMS Notification- realm subjects modified - resetting realm subjects for orgName:" + orgName);
            }
            this.realmSubjectsChanged(orgName);
        }
    }

    private String buildCacheKey(String serviceName, String version, String orgName, String groupName, String serviceComponent) {
        StringBuffer sb = new StringBuffer(100);
        sb.append(serviceComponent).append(CACHE_KEY_DELIMITER);
        sb.append(groupName).append(CACHE_KEY_DELIMITER);
        sb.append(version).append(CACHE_KEY_DELIMITER);
        sb.append(serviceName).append(CACHE_KEY_DELIMITER);
        sb.append(orgName);
        return sb.toString().toLowerCase();
    }

    private String buildCacheKey(String orgName, String policyName) {
        String serviceComponent = "/Policies/" + policyName;
        return this.buildCacheKey("iPlanetAMPolicyService", "1.0", orgName, "default", serviceComponent);
    }

    private String[] tokenizeCacheKey(String cacheKey) {
        String[] tokens = new String[6];
        StringTokenizer st = new StringTokenizer(cacheKey, CACHE_KEY_DELIMITER);
        tokens[0] = st.nextToken();
        tokens[1] = st.nextToken();
        tokens[2] = st.nextToken();
        tokens[3] = st.nextToken();
        tokens[4] = st.nextToken();
        tokens[5] = st.nextToken();
        return tokens;
    }

    private void firePolicyChanged(String serviceName, Set affectedResourceNames, int changeType) {
        if (DEBUG.messageEnabled()) {
            StringBuffer sb = new StringBuffer(255);
            sb.append("at firePolicyChanged(serrviceName,affectedResourceNames):");
            sb.append(serviceName).append(":");
            sb.append(affectedResourceNames.toString());
            DEBUG.message(sb.toString());
        }
        PolicyEvent policyEvent = new PolicyEvent();
        policyEvent.setResourceNames(affectedResourceNames);
        policyEvent.setChangeType(changeType);
        Set pListeners = (Set)this.policyListenersMap.get(serviceName);
        if (pListeners != null) {
            Iterator listeners = pListeners.iterator();
            while (listeners.hasNext()) {
                PolicyListener policyListener = (PolicyListener)listeners.next();
                try {
                    policyListener.policyChanged(policyEvent);
                }
                catch (Exception e) {
                    DEBUG.error("policy change not handled properly", (Throwable)e);
                }
            }
        }
        PolicyEvaluator.policyChanged(serviceName, policyEvent);
    }

    PolicyManager getPolicyManager(String orgName) throws PolicyException, SSOException {
        PolicyManager pm = (PolicyManager)this.policyManagers.get(orgName = new DN(orgName).toRFCString().toLowerCase());
        if (pm == null) {
            pm = new PolicyManager(this.token, orgName);
            this.policyManagers.put(orgName, pm);
            if (DEBUG.messageEnabled()) {
                StringBuffer sb = new StringBuffer(255);
                sb.append("at PolicyCache.getPolicyManager():");
                sb.append("creating and caching pm for orgname ");
                sb.append(orgName);
                DEBUG.message(sb.toString());
            }
        }
        return pm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void policyConfigChanged(String orgName) {
        block11: {
            String pattern = CACHE_KEY_DELIMITER + orgName;
            if (DEBUG.messageEnabled()) {
                StringBuffer sb = new StringBuffer(255);
                sb.append("at PolicyCache.policyConfigChanged():");
                sb.append("updating policy config for orgname ");
                sb.append(orgName);
                DEBUG.message(sb.toString());
            }
            try {
                int i;
                PolicyManager pm = this.getPolicyManager(orgName);
                Map policyConfig = pm.getPolicyConfig();
                if (policyConfig == null || policyConfig.isEmpty()) break block11;
                Set cacheKeys = this.policies.keySet();
                String[] clonedCacheKeys = new String[]{};
                Map map = this.policies;
                synchronized (map) {
                    clonedCacheKeys = new String[cacheKeys.size()];
                    i = 0;
                    Iterator cacheIter = cacheKeys.iterator();
                    while (cacheIter.hasNext()) {
                        clonedCacheKeys[i] = (String)cacheIter.next();
                        ++i;
                    }
                }
                int length = clonedCacheKeys.length;
                for (i = 0; i < length; ++i) {
                    Policy policy;
                    String cacheKey = clonedCacheKeys[i];
                    if (!cacheKey.endsWith(pattern) || (policy = policyCache.getPolicy(cacheKey)) == null) continue;
                    policy.getSubjects().setPolicyConfig(policyConfig);
                }
            }
            catch (NameNotFoundException nnfe) {
                if (DEBUG.warningEnabled()) {
                    DEBUG.warning("Can not set policy config for orgname:" + orgName + ":" + nnfe.getMessage());
                }
            }
            catch (PolicyException pe) {
                DEBUG.error("Can not set policy config for orgname:" + orgName, (Throwable)pe);
            }
            catch (SSOException se) {
                DEBUG.error("Can not set policy config for orgname:" + orgName, (Throwable)((Object)se));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void realmSubjectsChanged(String orgName) {
        DEBUG.message("resetting realm subjects");
        try {
            SubjectTypeManager stm;
            PolicyManager pm = this.getPolicyManager(orgName);
            SubjectTypeManager subjectTypeManager = stm = pm.getSubjectTypeManager();
            synchronized (subjectTypeManager) {
                stm.resetRealmSubjects();
            }
        }
        catch (PolicyException pe) {
            DEBUG.error("Can not reset realmSubjects for orgname:" + orgName, (Throwable)pe);
        }
        catch (SSOException se) {
            DEBUG.error("Can not reset realmSubjects for orgname:" + orgName, (Throwable)((Object)se));
        }
    }

    static void printStats(Stats policyStats) {
        policyStats.record("PolicyCache: Number of policies in cache: " + PolicyCache.policyCache.policies.size());
        policyStats.record("PolicyCache: Number of policyManagers in cache:" + PolicyCache.policyCache.policyManagers.size());
        policyStats.record("PolicyCache: Number of service names in  policyListeners cache: " + PolicyCache.policyCache.policyListenersMap.size());
    }

    void clearSubjectResultCache(String tokenIdString) throws PolicyException {
        if (DEBUG.messageEnabled()) {
            DEBUG.message("PolicyCache.clearSubjectResultCache(tokenIdString):  clearing cached subject evaluation result for  tokenId XXXXX in each cached Policy");
        }
        HashSet policyNames = new HashSet();
        policyNames.addAll(this.policies.keySet());
        Iterator iter = policyNames.iterator();
        while (iter.hasNext()) {
            Policy policy = (Policy)this.policies.get(iter.next());
            if (policy == null) continue;
            policy.clearSubjectResultCache(tokenIdString);
        }
    }
}

