/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.Cache;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenListener;
import com.sun.identity.policy.ActionDecision;
import com.sun.identity.policy.ActionSchema;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyCache;
import com.sun.identity.policy.PolicyConfig;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyDecisionCacheListener;
import com.sun.identity.policy.PolicyEvent;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.PolicySSOTokenListener;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.ProtectedResource;
import com.sun.identity.policy.ResourceIndexManager;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.ResourceResult;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.interfaces.PolicyListener;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.stats.Stats;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.ServiceManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class PolicyEvaluator {
    public static final String ALL_RESOURCES = "---ALL_RESOURCES---";
    public static final String ADVICING_ORGANIZATION = "AdvicingOrganization";
    public static final String EMPTY_RESOURCE_NAME = "";
    public static final String SUN_AM_REQUESTED_RESOURCE = "sun.am.requestedResource";
    public static final String SUN_AM_REQUESTED_ACTIONS = "sun.am.requestedActions";
    public static final String SUN_AM_POLICY_CONFIG = "sun.am.policyConfig";
    private static final Debug DEBUG = PolicyManager.debug;
    private static final boolean USE_POLICY_CACHE = true;
    private static final boolean INCLUDE_SUPER_RESOURCE_POLCIES = true;
    private static final long DEFAULT_USER_NSROLE_CACHE_TTL = 600000L;
    private String orgName;
    private String serviceTypeName;
    private ServiceType serviceType;
    private PolicyCache policyCache;
    private PolicyManager policyManager;
    private ResourceIndexManager resourceIndexManager;
    private HashMap booleanActionNameTrueValues;
    private HashMap booleanActionNameFalseValues;
    private Set actionNames;
    private Set orgNames = new HashSet();
    private Set serviceTypeNames = new HashSet();
    private PolicyDecisionCacheListener listener = null;
    static Map policyResultsCache = new HashMap();
    public static Map ssoListenerRegistry = Collections.synchronizedMap(new HashMap());
    private static Map policyListenerRegistry = Collections.synchronizedMap(new HashMap());
    static Map userNSRoleCache = Collections.synchronizedMap(new HashMap());
    private static long userNSRoleCacheTTL = 0L;
    public static SSOTokenListener ssoListener = new PolicySSOTokenListener();
    private static Map resourceNamesMap = new HashMap();
    private static final int RESOURCE_NAMES_CACHE_SIZE = 1000;
    static final String ORGANIZATION_NAME = "organizationName";
    static final String SERVICE_TYPE_NAME = "serviceTypeName";
    static Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyEvaluator(String serviceTypeName) throws SSOException, NameNotFoundException, PolicyException {
        this(EMPTY_RESOURCE_NAME, serviceTypeName);
        Object object = lock;
        synchronized (object) {
            if (!policyListenerRegistry.containsKey(serviceTypeName)) {
                this.listener = new PolicyDecisionCacheListener(serviceTypeName);
                try {
                    PolicyCache.getInstance().addPolicyListener(this.listener);
                }
                catch (PolicyException pe) {
                    DEBUG.error("PolicyEvaluator: registering policy decision  cache listener failed");
                }
                policyListenerRegistry.put(serviceTypeName, this.listener);
                if (DEBUG.messageEnabled()) {
                    DEBUG.message("PolicyEvaluator:policy listener for service " + serviceTypeName + " added");
                }
            } else {
                this.listener = (PolicyDecisionCacheListener)policyListenerRegistry.get(serviceTypeName);
            }
        }
    }

    public PolicyEvaluator(String orgName, String serviceTypeName) throws SSOException, PolicyException, NameNotFoundException {
        orgName = orgName == null || orgName.equals("/") || orgName.length() == 0 ? ServiceManager.getBaseDN() : DNMapper.orgNameToDN(orgName);
        this.orgName = orgName;
        this.serviceTypeName = serviceTypeName;
        this.policyCache = PolicyCache.getInstance();
        ServiceTypeManager stm = ServiceTypeManager.getServiceTypeManager();
        this.serviceType = stm.getServiceType(serviceTypeName);
        this.policyManager = this.policyCache.getPolicyManager(orgName);
        this.orgNames.add(this.policyManager.getOrganizationDN());
        this.serviceTypeNames.add(serviceTypeName);
        this.resourceIndexManager = this.policyManager.getResourceIndexManager();
    }

    public boolean isAllowed(SSOToken token, String resourceName, String actionName) throws PolicyException, SSOException {
        return this.isAllowed(token, resourceName, actionName, new HashMap());
    }

    public boolean isAllowed(SSOToken token, String resourceName, String actionName, Map envParameters) throws SSOException, PolicyException {
        Set set;
        ActionSchema schema = this.serviceType.getActionSchema(actionName);
        if (this.booleanActionNameFalseValues == null) {
            this.booleanActionNameFalseValues = new HashMap(10);
        }
        String falseValue = null;
        falseValue = (String)this.booleanActionNameFalseValues.get(actionName);
        if (falseValue == null) {
            falseValue = schema.getFalseValue();
            this.booleanActionNameFalseValues.put(actionName, falseValue);
        }
        if (this.booleanActionNameTrueValues == null) {
            this.booleanActionNameTrueValues = new HashMap(10);
        }
        String trueValue = null;
        trueValue = (String)this.booleanActionNameTrueValues.get(actionName);
        if (trueValue == null) {
            trueValue = schema.getTrueValue();
            this.booleanActionNameTrueValues.put(actionName, trueValue);
        }
        if (!AttributeSchema.Syntax.BOOLEAN.equals(schema.getSyntax())) {
            Object[] objs = new String[]{actionName};
            throw new PolicyException("amPolicy", "action_does_not_have_boolean_syntax", objs, null);
        }
        boolean actionAllowed = false;
        HashSet<String> actionNames = new HashSet<String>(1);
        actionNames.add(actionName);
        PolicyDecision policyDecision = this.getPolicyDecision(token, resourceName, actionNames, envParameters);
        ActionDecision actionDecision = (ActionDecision)policyDecision.getActionDecisions().get(actionName);
        if (actionDecision != null && (set = actionDecision.getValues()) != null) {
            if (set.contains(falseValue)) {
                actionAllowed = false;
            } else if (set.contains(trueValue)) {
                actionAllowed = true;
            }
        }
        return actionAllowed;
    }

    public PolicyDecision getPolicyDecision(SSOToken token, String resourceName, Set actionNames) throws PolicyException, SSOException {
        return this.getPolicyDecision(token, resourceName, actionNames, null);
    }

    public PolicyDecision getPolicyDecision(SSOToken token, String resourceName, Set actionNames, Map envParameters) throws SSOException, PolicyException {
        if (resourceName == null || resourceName == EMPTY_RESOURCE_NAME) {
            resourceName = EMPTY_RESOURCE_NAME;
        }
        resourceName = this.serviceType.canonicalize(resourceName);
        HashSet<String> resourceNames = new HashSet<String>(1);
        resourceNames.add(resourceName);
        if (actionNames == null || actionNames.isEmpty()) {
            actionNames = this.serviceType.getActionNames();
        }
        HashSet actions = new HashSet();
        if (actionNames != null) {
            actions.addAll(actionNames);
        }
        if (envParameters == null || envParameters.isEmpty()) {
            envParameters = new HashMap();
        }
        envParameters.put(SUN_AM_REQUESTED_RESOURCE, resourceNames);
        envParameters.put(SUN_AM_REQUESTED_ACTIONS, actions);
        envParameters.put(SUN_AM_POLICY_CONFIG, this.policyManager.getPolicyConfig());
        return this.getPolicyDecision(token, resourceName, actionNames, envParameters, new HashSet());
    }

    private PolicyDecision getPolicyDecision(SSOToken token, String resourceName, Set actionNames, Map envParameters, Set visitedOrgs) throws PolicyException, SSOException {
        String orgWithAlias;
        String orgAlias;
        if (DEBUG.messageEnabled()) {
            DEBUG.message("Evaluating policies at org " + this.orgName);
        }
        if (actionNames == null || actionNames.isEmpty()) {
            actionNames = this.serviceType.getActionNames();
        }
        HashSet actions = new HashSet();
        actions.addAll(actionNames);
        PolicyDecision mergedPolicyDecision = null;
        Set policyNameSet = null;
        HashSet<String> toRemovePolicyNameSet = null;
        policyNameSet = this.resourceIndexManager.getPolicyNames(this.serviceType, resourceName, true);
        if (DEBUG.messageEnabled()) {
            String tokenPrincipal = token != null ? token.getPrincipal().getName() : EMPTY_RESOURCE_NAME;
            DEBUG.message("at PolicyEvaluator" + ".getPolicyDecision()" + " principal, resource name, " + "action names, policy names," + " orgName =" + tokenPrincipal + ",  " + resourceName + ",  " + actionNames + ",  " + policyNameSet + ",  " + this.orgName);
        }
        Iterator policyIter = policyNameSet.iterator();
        while (policyIter.hasNext()) {
            String policyName = (String)policyIter.next();
            Policy policy = this.policyManager.getPolicy(policyName, true);
            if (policy != null && policy.isActive()) {
                String decision;
                PolicyDecision policyDecision = policy.getPolicyDecision(token, this.serviceTypeName, resourceName, actions, envParameters);
                if (!policy.isReferralPolicy() && policyDecision.hasAdvices()) {
                    PolicyEvaluator.addAdvice(policyDecision, ADVICING_ORGANIZATION, this.orgName);
                }
                if (PolicyUtils.logStatus && token != null && (decision = policyDecision.toString()) != null && decision.length() != 0) {
                    String[] objs = new String[]{policyName, this.orgName, this.serviceTypeName, resourceName, actionNames.toString(), decision};
                    PolicyUtils.logAccessMessage("POLICY_EVALUATION", objs, token);
                }
                if (mergedPolicyDecision == null) {
                    mergedPolicyDecision = policyDecision;
                } else {
                    PolicyEvaluator.mergePolicyDecisions(this.serviceType, policyDecision, mergedPolicyDecision);
                }
                if (!PolicyConfig.continueEvaluationOnDenyDecision()) {
                    actions.removeAll(PolicyEvaluator.getFinalizedActions(this.serviceType, mergedPolicyDecision));
                }
                if (!actions.isEmpty()) continue;
                break;
            }
            if (toRemovePolicyNameSet == null) {
                toRemovePolicyNameSet = new HashSet<String>();
            }
            toRemovePolicyNameSet.add(policyName);
            if (!DEBUG.messageEnabled()) continue;
            DEBUG.message("PolicyEvaluator.getPolicyDecision():" + policyName + " is inactive or non-existent");
        }
        if (toRemovePolicyNameSet != null) {
            policyNameSet.removeAll(toRemovePolicyNameSet);
        }
        Set orgsToVisit = this.getOrgsToVisit(policyNameSet);
        if (PolicyConfig.orgAliasMappedResourcesEnabled() && "iPlanetAMWebAgentService".equalsIgnoreCase(this.serviceTypeName) && (orgAlias = this.policyManager.getOrgAliasWithResource(resourceName)) != null && (orgWithAlias = this.policyManager.getOrgNameWithAlias(orgAlias)) != null) {
            if (DEBUG.messageEnabled()) {
                DEBUG.message("PolicyEvaluator.getPolicyDecision():adding orgWithAlias to orgsToVisit=" + orgWithAlias);
            }
            orgsToVisit.add(orgWithAlias);
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("at PolicyEvaluator" + ".getPolicyDecision()" + " orgsToVist=" + orgsToVisit.toString());
        }
        orgsToVisit.removeAll(visitedOrgs);
        if (DEBUG.messageEnabled()) {
            DEBUG.message("at PolicyEvaluator" + ".getPolicyDecision()" + " orgsToVist(after removing already visited orgs=" + orgsToVisit.toString());
        }
        while (!orgsToVisit.isEmpty() && !actions.isEmpty()) {
            String orgToVisit = (String)orgsToVisit.iterator().next();
            orgsToVisit.remove(orgToVisit);
            visitedOrgs.add(orgToVisit);
            try {
                this.policyManager.verifyOrgName(orgToVisit);
            }
            catch (NameNotFoundException nnfe) {
                if (!DEBUG.warningEnabled()) continue;
                DEBUG.warning("Organization does not exist - skipping referral to " + orgToVisit);
                continue;
            }
            PolicyEvaluator pe = new PolicyEvaluator(orgToVisit, this.serviceTypeName);
            Map savedPolicyConfig = (Map)envParameters.get(SUN_AM_POLICY_CONFIG);
            envParameters.put(SUN_AM_POLICY_CONFIG, PolicyConfig.getPolicyConfig(orgToVisit));
            PolicyDecision policyDecision = pe.getPolicyDecision(token, resourceName, actionNames, envParameters, visitedOrgs);
            envParameters.put(SUN_AM_POLICY_CONFIG, savedPolicyConfig);
            if (mergedPolicyDecision == null) {
                mergedPolicyDecision = policyDecision;
            } else {
                PolicyEvaluator.mergePolicyDecisions(this.serviceType, policyDecision, mergedPolicyDecision);
            }
            if (PolicyConfig.continueEvaluationOnDenyDecision()) continue;
            actions.removeAll(PolicyEvaluator.getFinalizedActions(this.serviceType, mergedPolicyDecision));
        }
        if (mergedPolicyDecision == null) {
            mergedPolicyDecision = new PolicyDecision();
        }
        return mergedPolicyDecision;
    }

    public Set getProtectedResourcesIgnoreConditions(SSOToken token, String rootResource) throws SSOException, PolicyException {
        if (rootResource == null || rootResource == EMPTY_RESOURCE_NAME) {
            rootResource = EMPTY_RESOURCE_NAME;
        }
        HashSet<ProtectedResource> protectedResources = new HashSet<ProtectedResource>();
        Set topLevelResources = null;
        if (rootResource.equals(ALL_RESOURCES)) {
            topLevelResources = this.resourceIndexManager.getTopLevelResourceNames(this.serviceType);
        } else {
            topLevelResources = new HashSet<String>();
            topLevelResources.add(rootResource);
        }
        Iterator iter = topLevelResources.iterator();
        while (iter.hasNext()) {
            String topLevelResource = (String)iter.next();
            Set resourceNames = this.getResourceNames(token, topLevelResource, true);
            Iterator resourceIter = resourceNames.iterator();
            while (resourceIter.hasNext()) {
                String resourceName = (String)resourceIter.next();
                Set protectingPolicies = this.getProtectingPolicies(token, resourceName);
                if (protectingPolicies == null || protectingPolicies.isEmpty()) continue;
                boolean allReferralPolicies = true;
                Iterator iter1 = protectingPolicies.iterator();
                while (iter1.hasNext()) {
                    Policy policy = (Policy)iter1.next();
                    if (policy.isReferralPolicy()) continue;
                    allReferralPolicies = false;
                    break;
                }
                if (allReferralPolicies) continue;
                protectedResources.add(new ProtectedResource(resourceName, protectingPolicies));
            }
        }
        return protectedResources;
    }

    Set getProtectingPolicies(SSOToken token, String resourceName) throws PolicyException, SSOException {
        return this.getProtectingPolicies(token, resourceName, new HashSet());
    }

    private Set getProtectingPolicies(SSOToken token, String resourceName, Set visitedOrgs) throws PolicyException, SSOException {
        Object pp;
        String orgWithAlias;
        String orgAlias;
        Policy policy;
        String policyName;
        HashSet<Policy> protectingPolicies = new HashSet<Policy>();
        Set policyNameSet = this.resourceIndexManager.getPolicyNames(this.serviceType, resourceName, false);
        HashSet<String> toRemovePolicyNameSet = null;
        if (DEBUG.messageEnabled()) {
            String tokenPrincipal = token != null ? token.getPrincipal().getName() : EMPTY_RESOURCE_NAME;
            DEBUG.message("at PolicyEvaluator.getProtectingPolicies()" + " principal, resource name, policy names," + " orgName =" + tokenPrincipal + ",  " + resourceName + ",  " + policyNameSet + ",  " + this.orgName);
        }
        Iterator policyIter = policyNameSet.iterator();
        while (policyIter.hasNext()) {
            policyName = (String)policyIter.next();
            policy = this.policyManager.getPolicy(policyName);
            if (policy != null && policy.isActive()) {
                if (!policy.isReferralPolicy()) {
                    if (!policy.isApplicableToUser(token)) continue;
                    policy.setOrganizationName(this.orgName);
                    protectingPolicies.add(policy);
                    continue;
                }
                policy.setOrganizationName(this.orgName);
                protectingPolicies.add(policy);
                continue;
            }
            if (toRemovePolicyNameSet == null) {
                toRemovePolicyNameSet = new HashSet<String>();
            }
            toRemovePolicyNameSet.add(policyName);
            if (!DEBUG.messageEnabled()) continue;
            DEBUG.message("PolicyEvaluator.getProtectingPolicies():" + policyName + " is inactive or non-existent");
        }
        if (toRemovePolicyNameSet != null) {
            policyNameSet.removeAll(toRemovePolicyNameSet);
        }
        policyNameSet = this.resourceIndexManager.getSuperResourcePolicyNames(this.serviceType, resourceName);
        if (toRemovePolicyNameSet != null) {
            toRemovePolicyNameSet.clear();
        }
        policyIter = policyNameSet.iterator();
        while (policyIter.hasNext()) {
            policyName = (String)policyIter.next();
            policy = this.policyManager.getPolicy(policyName);
            if (policy != null && policy.isActive()) {
                if (!policy.isReferralPolicy()) continue;
                policy.setOrganizationName(this.orgName);
                protectingPolicies.add(policy);
                continue;
            }
            if (toRemovePolicyNameSet == null) {
                toRemovePolicyNameSet = new HashSet();
            }
            toRemovePolicyNameSet.add(policyName);
            if (!DEBUG.messageEnabled()) continue;
            DEBUG.message("PolicyEvaluator.getProtectingPolicies():" + policyName + " is inactive or non-existent");
        }
        if (toRemovePolicyNameSet != null) {
            policyNameSet.removeAll(toRemovePolicyNameSet);
        }
        Set orgsToVisit = this.getOrgsToVisit(policyNameSet);
        if (DEBUG.messageEnabled()) {
            DEBUG.message("at PolicyEvaluator.getProtectingPolicies()" + " orgsToVist=" + orgsToVisit.toString());
        }
        if (PolicyConfig.orgAliasMappedResourcesEnabled() && "iPlanetAMWebAgentService".equalsIgnoreCase(this.serviceTypeName) && (orgAlias = this.policyManager.getOrgAliasWithResource(resourceName)) != null && (orgWithAlias = this.policyManager.getOrgNameWithAlias(orgAlias)) != null) {
            if (DEBUG.messageEnabled()) {
                DEBUG.message("PolicyEvaluator.getProtectingPolicies():adding orgWithAlias to orgsToVisit=" + orgWithAlias);
            }
            orgsToVisit.add(orgWithAlias);
        }
        orgsToVisit.removeAll(visitedOrgs);
        if (DEBUG.messageEnabled()) {
            DEBUG.message("at PolicyEvaluator.getProtectingPolicies()" + " orgsToVist(after removing already visited orgs=" + orgsToVisit.toString());
        }
        while (orgsToVisit.size() != 0) {
            String orgToVisit = (String)orgsToVisit.iterator().next();
            orgsToVisit.remove(orgToVisit);
            visitedOrgs.add(orgToVisit);
            try {
                this.policyManager.verifyOrgName(orgToVisit);
            }
            catch (NameNotFoundException nnfe) {
                if (!DEBUG.warningEnabled()) continue;
                DEBUG.warning("Organization does not exist - skipping referral to " + orgToVisit);
                continue;
            }
            PolicyEvaluator pe = new PolicyEvaluator(orgToVisit, this.serviceTypeName);
            pp = pe.getProtectingPolicies(token, resourceName, visitedOrgs);
            protectingPolicies.addAll((Collection<Policy>)pp);
        }
        String principalName = token != null ? token.getPrincipal().getName() : EMPTY_RESOURCE_NAME;
        StringBuffer sb = null;
        pp = null;
        if (PolicyManager.debug.messageEnabled() || PolicyUtils.logStatus) {
            sb = new StringBuffer();
            Iterator pIter = protectingPolicies.iterator();
            while (pIter.hasNext()) {
                Policy policy2 = (Policy)pIter.next();
                sb.append(policy2.getOrganizationName()).append(":").append(policy2.getName()).append(",");
            }
            pp = sb.toString();
        }
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message("Computed policies  protecting resource " + resourceName + "for principal:" + principalName + " " + (String)pp);
        }
        if (PolicyUtils.logStatus && token != null) {
            String[] objs = new String[]{principalName, resourceName, pp};
            PolicyUtils.logAccessMessage("PROTECTED_RESOURCES", objs, token);
        }
        return protectingPolicies;
    }

    public Set getResourceResults(SSOToken token, String resourceName, String scope, Map envParameters) throws SSOException, PolicyException {
        HashSet<ResourceResult> resultsSet;
        if ("subtree".equals(scope)) {
            resultsSet = this.getResourceResultTree(token, resourceName, scope, envParameters).getResourceResults();
        } else if ("strict-subtree".equals(scope) || "self".equals(scope)) {
            ResourceResult result = this.getResourceResultTree(token, resourceName, scope, envParameters);
            resultsSet = new HashSet<ResourceResult>();
            resultsSet.add(result);
        } else {
            DEBUG.error("PolicyEvaluator: invalid request scope: " + scope);
            Object[] objs = new String[]{scope};
            throw new PolicyException("amPolicy", "invalid_request_scope", objs, null);
        }
        return resultsSet;
    }

    public ResourceResult getResourceResult(SSOToken token, String resourceName, String scope, Map envParameters) throws SSOException, PolicyException {
        if ("subtree".equals(scope) || "strict-subtree".equals(scope) || "self".equals(scope)) {
            if ("subtree".equals(scope)) {
                scope = "strict-subtree";
            }
            return this.getResourceResultTree(token, resourceName, scope, envParameters);
        }
        DEBUG.error("PolicyEvaluator: invalid request scope: " + scope);
        Object[] objs = new String[]{scope};
        throw new PolicyException("amPolicy", "invalid_request_scope", objs, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceResult getResourceResultTree(SSOToken token, String resourceName, String scope, Map envParameters) throws PolicyException, SSOException {
        String userSSOTokenIDStr;
        String string = userSSOTokenIDStr = token != null ? ((Object)token.getTokenID()).toString() : EMPTY_RESOURCE_NAME;
        if (token == null) {
            if (DEBUG.messageEnabled()) {
                DEBUG.message("user sso token is null, forcing ResourceResult evaluation to self_scope");
            }
            scope = "self";
        }
        ResourceResult resourceResult = null;
        if (resourceName == null || resourceName == EMPTY_RESOURCE_NAME) {
            resourceName = EMPTY_RESOURCE_NAME;
        }
        resourceName = this.serviceType.canonicalize(resourceName);
        Map clientEnv = PolicyUtils.cloneMap(envParameters);
        Map map = policyResultsCache;
        synchronized (map) {
            HashMap results;
            HashMap resultsCache;
            HashMap rscCache = (HashMap)policyResultsCache.get(this.serviceTypeName);
            if (rscCache != null && (resultsCache = (HashMap)rscCache.get(resourceName)) != null && (results = (HashMap)resultsCache.get(userSSOTokenIDStr)) != null && (resourceResult = (ResourceResult)results.get(scope)) != null) {
                long currentTime = System.currentTimeMillis();
                long ttlMinimal = resourceResult.getTimeToLive();
                if (ttlMinimal > currentTime) {
                    Map cachedEnv = resourceResult.getEnvMap();
                    if (clientEnv == null && cachedEnv == null || clientEnv != null && ((Object)clientEnv).equals(cachedEnv)) {
                        if (DEBUG.messageEnabled()) {
                            DEBUG.message("PolicyEvaluator. getResourceResult(): we get the result from the cache.\n" + resourceResult.toXML());
                        }
                        return resourceResult;
                    }
                    if (PolicyManager.debug.messageEnabled()) {
                        PolicyManager.debug.message("PolicyEvaluator.getResourceesultTree():cached envMap does not equal request envMap, request envMap = " + clientEnv + ", cachedEnv=" + cachedEnv);
                    }
                }
            }
        }
        if (this.actionNames == null || this.actionNames.isEmpty()) {
            this.actionNames = this.serviceType.getActionNames();
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("PolicyEvaluator:computing policy decisions  for resource : " + resourceName);
        }
        PolicyDecision policyDecision = this.getPolicyDecision(token, resourceName, this.actionNames, envParameters);
        resourceResult = new ResourceResult(resourceName, policyDecision);
        if ("subtree".equals(scope)) {
            ResourceResult virtualResourceResult = new ResourceResult("-__viRTuAl-rOot--_", new PolicyDecision());
            virtualResourceResult.addResourceResult(resourceResult, this.serviceType);
            resourceResult = virtualResourceResult;
        }
        if ("subtree".equals(scope) || "strict-subtree".equals(scope)) {
            Set resourceNames;
            Cache resourceNamesCache = (Cache)resourceNamesMap.get(this.serviceTypeName);
            if (resourceNamesCache == null) {
                resourceNamesCache = new Cache(1000);
                resourceNamesMap.put(this.serviceTypeName, resourceNamesCache);
            }
            if ((resourceNames = (Set)resourceNamesCache.get(resourceName)) == null) {
                if (DEBUG.messageEnabled()) {
                    DEBUG.message("Computing subresources for:  " + resourceName);
                }
                resourceNames = this.getResourceNames(token, resourceName, true);
                resourceNames = PolicyEvaluator.removeDuplicateResourceNames(resourceNames, this.serviceType);
                resourceNames = PolicyEvaluator.removeResourceName(resourceNames, this.serviceType, resourceName);
                resourceNamesCache.put(resourceName, resourceNames);
            }
            if (DEBUG.messageEnabled()) {
                DEBUG.message("PolicyEvaluator:computing policy decisions  for subresources : " + resourceNames);
            }
            Iterator resourceNameIter = resourceNames.iterator();
            while (resourceNameIter.hasNext()) {
                String subResourceName = (String)resourceNameIter.next();
                if (!"subtree".equals(scope) && !this.serviceType.compare(resourceName, subResourceName, false).equals(ResourceMatch.SUB_RESOURCE_MATCH)) continue;
                PolicyDecision pDecision = this.getPolicyDecision(token, subResourceName, this.actionNames, envParameters);
                resourceResult.addResourceResult(new ResourceResult(subResourceName, pDecision), this.serviceType);
            }
        }
        if (resourceResult != null && !resourceResult.hasAdvices()) {
            resourceResult.setEnvMap(clientEnv);
            HashMap<String, ResourceResult> scopeElem = null;
            HashMap cacheElem = null;
            HashMap rscElem = null;
            Map subResourceName = policyResultsCache;
            synchronized (subResourceName) {
                rscElem = (HashMap)policyResultsCache.get(this.serviceTypeName);
                if (rscElem != null) {
                    cacheElem = (HashMap)rscElem.get(resourceName);
                    if (cacheElem != null) {
                        scopeElem = (HashMap<String, ResourceResult>)cacheElem.get(userSSOTokenIDStr);
                        if (scopeElem == null) {
                            scopeElem = new HashMap();
                        }
                    } else {
                        cacheElem = new HashMap();
                        scopeElem = new HashMap();
                    }
                } else {
                    rscElem = new HashMap();
                    cacheElem = new HashMap();
                    scopeElem = new HashMap<String, ResourceResult>();
                }
                scopeElem.put(scope, resourceResult);
                cacheElem.put(userSSOTokenIDStr, scopeElem);
                rscElem.put(resourceName, cacheElem);
                policyResultsCache.put(this.serviceTypeName, rscElem);
            }
            if (token != null && !ssoListenerRegistry.containsKey(userSSOTokenIDStr)) {
                try {
                    token.addSSOTokenListener(ssoListener);
                }
                catch (SSOException se) {
                    DEBUG.error("PolicyEvaluator:failed to add sso token listener");
                }
                ssoListenerRegistry.put(userSSOTokenIDStr, ssoListener);
                if (DEBUG.messageEnabled()) {
                    DEBUG.message("PolicyEvaluator.getResourceResultTree(): sso listener added .\n");
                }
            }
            if (DEBUG.messageEnabled()) {
                DEBUG.message("PolicyEvaluator: we added the evaluation  result to the cache");
            }
        }
        return resourceResult;
    }

    public Set getResourceNames(SSOToken token, String resourceName, boolean followReferral) throws PolicyException, SSOException {
        HashSet<String> visitedOrgs = new HashSet<String>();
        visitedOrgs.add(this.policyManager.getOrganizationDN());
        return this.getResourceNames(token, resourceName, followReferral, visitedOrgs);
    }

    public Set getResourceNames(SSOToken token, String resourceName, boolean followReferral, Set visitedOrgs) throws PolicyException, SSOException {
        String orgAlias;
        DEBUG.message("PolicyEvaluator.getResourceNames():entering");
        HashSet resourceNames = new HashSet();
        Set policyNameSet = null;
        HashSet<String> toRemovePolicyNameSet = null;
        HashSet<String> orgsToVisit = new HashSet<String>();
        policyNameSet = this.resourceIndexManager.getSubResourcePolicyNames(this.serviceType, resourceName);
        policyNameSet.addAll(this.resourceIndexManager.getPolicyNames(this.serviceType, resourceName, true));
        policyNameSet.addAll(this.resourceIndexManager.getWildSubResourcePolicyNames(this.serviceType, resourceName));
        if (policyNameSet != null && !policyNameSet.isEmpty()) {
            Iterator policyIter = policyNameSet.iterator();
            while (policyIter.hasNext()) {
                String policyName = (String)policyIter.next();
                Policy policy = this.policyManager.getPolicy(policyName, true);
                if (policy != null && policy.isActive()) {
                    Set pResourceNames = policy.getResourceNames(token, this.serviceTypeName, resourceName, true);
                    if (pResourceNames == null) continue;
                    resourceNames.addAll(pResourceNames);
                    continue;
                }
                if (toRemovePolicyNameSet == null) {
                    toRemovePolicyNameSet = new HashSet<String>();
                }
                toRemovePolicyNameSet.add(policyName);
                if (!DEBUG.messageEnabled()) continue;
                DEBUG.message("PolicyEvaluator.getResourceNames():" + policyName + " is inactive or non-existent");
            }
            if (toRemovePolicyNameSet != null) {
                policyNameSet.removeAll(toRemovePolicyNameSet);
            }
            orgsToVisit.addAll(this.getOrgsToVisit(policyNameSet));
            if (DEBUG.messageEnabled()) {
                DEBUG.message("PolicyEvaluator.getResourceNames():realmAliasEnabled=" + PolicyConfig.orgAliasMappedResourcesEnabled() + ", serviceTypeName=" + this.serviceTypeName);
            }
        }
        if (PolicyConfig.orgAliasMappedResourcesEnabled() && "iPlanetAMWebAgentService".equalsIgnoreCase(this.serviceTypeName) && (orgAlias = this.policyManager.getOrgAliasWithResource(resourceName)) != null) {
            String orgWithAlias = this.policyManager.getOrgNameWithAlias(orgAlias);
            if (orgWithAlias != null) {
                if (DEBUG.messageEnabled()) {
                    DEBUG.message("PolicyEvaluator.getgetResourceNames():adding orgWithAlias to orgsToVisit=" + orgWithAlias);
                }
                orgsToVisit.add(orgWithAlias);
            } else if (DEBUG.messageEnabled()) {
                DEBUG.message("PolicyEvaluator.getgetResourceNames():no realm matched orgAlias:" + orgAlias);
            }
        }
        orgsToVisit.removeAll(visitedOrgs);
        while (orgsToVisit.size() != 0) {
            String orgToVisit = (String)orgsToVisit.iterator().next();
            orgsToVisit.remove(orgToVisit);
            visitedOrgs.add(orgToVisit);
            try {
                this.policyManager.verifyOrgName(orgToVisit);
            }
            catch (NameNotFoundException nnfe) {
                if (!DEBUG.warningEnabled()) continue;
                DEBUG.warning("PolicyEvaluator.getgetResourceNames():Organization does not exist - skipping referral to " + orgToVisit);
                continue;
            }
            PolicyEvaluator pe = new PolicyEvaluator(orgToVisit, this.serviceTypeName);
            resourceNames.addAll(pe.getResourceNames(token, resourceName, true, visitedOrgs));
        }
        return resourceNames;
    }

    public void addPolicyListener(PolicyListener policyListener) {
        this.policyCache.addPolicyListener(policyListener);
    }

    public void removePolicyListener(PolicyListener policyListener) {
        this.policyCache.removePolicyListener(policyListener);
    }

    static PolicyDecision mergePolicyDecisions(ServiceType serviceType, PolicyDecision pd1, PolicyDecision pd2) {
        Map actionDecisions1 = pd1.getActionDecisions();
        HashSet actions = new HashSet();
        actions.addAll(actionDecisions1.keySet());
        Iterator iter = actions.iterator();
        while (iter.hasNext()) {
            String action = (String)iter.next();
            ActionDecision ad1 = (ActionDecision)actionDecisions1.get(action);
            pd2.addActionDecision(ad1, serviceType);
        }
        HashMap mergedReponseAttrsMap = new HashMap();
        PolicyUtils.appendMapToMap(pd1.getResponseAttributes(), mergedReponseAttrsMap);
        PolicyUtils.appendMapToMap(pd2.getResponseAttributes(), mergedReponseAttrsMap);
        pd2.setResponseAttributes(mergedReponseAttrsMap);
        return pd2;
    }

    static Set getFinalizedActions(ServiceType serviceType, PolicyDecision pd) {
        HashSet<String> finalizedActions = new HashSet<String>();
        Map actionDecisions = pd.getActionDecisions();
        Iterator actions = actionDecisions.keySet().iterator();
        while (actions.hasNext()) {
            String action = (String)actions.next();
            ActionDecision actionDecision = (ActionDecision)actionDecisions.get(action);
            Set values = actionDecision.getValues();
            if (values == null || values.isEmpty()) continue;
            try {
                ActionSchema schema = serviceType.getActionSchema(action);
                if (!AttributeSchema.Syntax.BOOLEAN.equals(schema.getSyntax()) || !values.contains(schema.getFalseValue())) continue;
                finalizedActions.add(action);
            }
            catch (InvalidNameException e) {
                DEBUG.error("can not find action schmea for action = " + action, (Throwable)e);
            }
        }
        return finalizedActions;
    }

    private Set getOrgsToVisit(Set policyNameSet) throws PolicyException, SSOException {
        HashSet orgsToVisit = new HashSet();
        Iterator policyNames = policyNameSet.iterator();
        while (policyNames.hasNext()) {
            String policyName = (String)policyNames.next();
            Policy policy = this.policyManager.getPolicy(policyName, true);
            if (policy == null) continue;
            orgsToVisit.addAll(policy.getReferredToOrganizations());
        }
        return orgsToVisit;
    }

    private static Set removeDuplicateResourceNames(Set resourceNames, ServiceType serviceType) {
        HashSet<String> answer = resourceNames;
        if (resourceNames != null && serviceType != null) {
            answer = new HashSet<String>(resourceNames.size());
            Iterator iter = resourceNames.iterator();
            while (iter.hasNext()) {
                String resourceName = (String)iter.next();
                Iterator answerIter = answer.iterator();
                boolean duplicate = false;
                while (answerIter.hasNext()) {
                    String answerResourceName = (String)answerIter.next();
                    if (!serviceType.compare(resourceName, answerResourceName, false).equals(ResourceMatch.EXACT_MATCH)) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate) continue;
                answer.add(resourceName);
            }
        }
        return answer;
    }

    private static Set removeResourceName(Set resourceNames, ServiceType serviceType, String resourceName) {
        HashSet answer = resourceNames;
        if (resourceNames != null && serviceType != null && resourceName != null) {
            answer = new HashSet(resourceNames.size());
            answer.addAll(resourceNames);
            Iterator iter = resourceNames.iterator();
            while (iter.hasNext()) {
                String rName = (String)iter.next();
                if (!serviceType.compare(resourceName, rName, false).equals(ResourceMatch.EXACT_MATCH)) continue;
                answer.remove(rName);
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void policyChanged(String serviceTypeName, PolicyEvent pe) {
        if (DEBUG.messageEnabled()) {
            DEBUG.message("PolicyEvaulator.policyChanged():serviceTypeName=" + serviceTypeName);
        }
        resourceNamesMap.remove(serviceTypeName);
        Cache resourceNamesCache = (Cache)resourceNamesMap.get(serviceTypeName);
        if (resourceNamesCache == null || resourceNamesCache.size() == 0) {
            return;
        }
        try {
            DEBUG.error("PolicyEvaluator.policyChanged: enterred try block");
            ServiceTypeManager stm = ServiceTypeManager.getServiceTypeManager();
            ServiceType serviceType = stm.getServiceType(serviceTypeName);
            HashSet<String> resourceNamesToRemove = new HashSet<String>();
            Cache cache = resourceNamesCache;
            synchronized (cache) {
                Enumeration resourceNames = resourceNamesCache.keys();
                while (resourceNames.hasMoreElements()) {
                    String resourceName = (String)resourceNames.nextElement();
                    if (resourceNamesToRemove.contains(resourceName)) continue;
                    Set affectedResourceNames = pe.getResourceNames();
                    Iterator iter = affectedResourceNames.iterator();
                    while (iter.hasNext()) {
                        String affectedResourceName = (String)iter.next();
                        if (serviceType.compare(resourceName, affectedResourceName) == ResourceMatch.NO_MATCH) continue;
                        resourceNamesToRemove.add(resourceName);
                    }
                }
                Iterator iter1 = resourceNamesToRemove.iterator();
                while (iter1.hasNext()) {
                    String resourceNameToRemove = (String)iter1.next();
                    resourceNamesCache.remove(resourceNameToRemove);
                }
            }
        }
        catch (SSOException e) {
            DEBUG.error("PolicyEvaluator.policyChanged:", (Throwable)((Object)e));
        }
        catch (PolicyException pex) {
            DEBUG.error("PolicyEvaluator.policyChanged:", (Throwable)pex);
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("PolicyEvaulator.policyChanged():serviceTypeName=" + serviceTypeName + ", new cached resoruceNames=" + resourceNamesMap.get(serviceTypeName));
        }
    }

    private static void addAdvice(PolicyDecision pd, String adviceKey, String adviceValue) {
        if (pd != null && pd.hasAdvices()) {
            Map actionDecisions = pd.getActionDecisions();
            Iterator actionDecisionIter = actionDecisions.keySet().iterator();
            while (actionDecisionIter.hasNext()) {
                String key = (String)actionDecisionIter.next();
                ActionDecision ad = (ActionDecision)actionDecisions.get(key);
                Map advices = ad.getAdvices();
                if (advices == null || advices.isEmpty()) continue;
                HashSet<String> values = (HashSet<String>)advices.get(adviceKey);
                if (values == null) {
                    values = new HashSet<String>();
                }
                values.add(adviceValue);
                advices.put(adviceKey, values);
            }
        }
    }

    PolicyDecision getPolicyDecisionIgnoreSubjects(String resourceName, Set actionNames, Map env) throws PolicyException, SSOException {
        HashSet<String> resourceNames = new HashSet<String>(1);
        resourceNames.add(resourceName);
        if (actionNames == null || actionNames.isEmpty()) {
            actionNames = this.serviceType.getActionNames();
        }
        HashSet actions = new HashSet();
        if (actionNames != null) {
            actions.addAll(actionNames);
        }
        if (env == null || env.isEmpty()) {
            env = new HashMap();
        }
        env.put(SUN_AM_REQUESTED_RESOURCE, resourceNames);
        env.put(SUN_AM_REQUESTED_ACTIONS, actions);
        env.put(SUN_AM_POLICY_CONFIG, this.policyManager.getPolicyConfig());
        return this.getPolicyDecision(null, resourceName, actionNames, env, new HashSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getUserNSRoleValues(SSOToken token) throws SSOException, PolicyException {
        if (userNSRoleCacheTTL == 0L) {
            Map map = userNSRoleCache;
            synchronized (map) {
                String orgName = ServiceManager.getBaseDN();
                Map pConfigValues = PolicyConfig.getPolicyConfig(orgName);
                userNSRoleCacheTTL = PolicyConfig.getSubjectsResultTtl(pConfigValues);
                if (userNSRoleCacheTTL <= 0L) {
                    userNSRoleCacheTTL = 600000L;
                    if (DEBUG.warningEnabled()) {
                        DEBUG.warning("Invalid TTL got from configuration. Set TTL to default:" + userNSRoleCacheTTL);
                    }
                }
                if (DEBUG.messageEnabled()) {
                    DEBUG.message("userNSRoleCacheTTL=" + userNSRoleCacheTTL);
                }
            }
        }
        if (token == null) {
            return null;
        }
        String tokenIDStr = ((Object)token.getTokenID()).toString();
        Object[] element = (Object[])userNSRoleCache.get(tokenIDStr);
        if (element != null) {
            long currentTime;
            Long timeStamp = (Long)element[0];
            long timeToLive = 0L;
            if (timeStamp != null) {
                timeToLive = timeStamp;
            }
            if (timeToLive > (currentTime = System.currentTimeMillis())) {
                if (DEBUG.messageEnabled()) {
                    DEBUG.message("PolicyEvaluator.getUserNSRoleValues(): get the nsRole values from cache.\n");
                }
                return (HashSet)element[1];
            }
        }
        try {
            AMStoreConnection am = new AMStoreConnection(token);
            AMUser user = am.getUser(token.getPrincipal().getName());
            if (user == null || !user.isActivated()) {
                return null;
            }
            HashSet<String> roleSet = new HashSet<String>();
            HashSet roles = new HashSet();
            Set staticRoles = user.getRoleDNs();
            Set filteredRoles = user.getFilteredRoleDNs();
            if (staticRoles != null) {
                roles.addAll(staticRoles);
            }
            if (filteredRoles != null) {
                roles.addAll(filteredRoles);
            }
            if (!roles.isEmpty()) {
                Iterator iter = roles.iterator();
                while (iter.hasNext()) {
                    String role = (String)iter.next();
                    if (role == null) continue;
                    roleSet.add(new DN(role).toRFCString().toLowerCase());
                }
            }
            if (DEBUG.messageEnabled()) {
                DEBUG.message("PolicyEvaluator.getUserNSRoleValues(): added user nsRoles: " + roleSet);
            }
            Object[] elem = new Object[]{new Long(System.currentTimeMillis() + userNSRoleCacheTTL), roleSet};
            userNSRoleCache.put(tokenIDStr, elem);
            if (!ssoListenerRegistry.containsKey(tokenIDStr)) {
                token.addSSOTokenListener(ssoListener);
                ssoListenerRegistry.put(tokenIDStr, ssoListener);
                if (DEBUG.messageEnabled()) {
                    DEBUG.message("PolicyEvaluator.getUserNSRoleValues(): sso listener added .\n");
                }
            }
            return roleSet;
        }
        catch (AMException e) {
            throw new PolicyException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void printStats(Stats policyStats) {
        int resultsCacheSize = 0;
        Map map = policyResultsCache;
        synchronized (map) {
            resultsCacheSize = policyResultsCache.size();
        }
        policyStats.record("PolicyEvaluator: Number of services in  resultsCache: " + resultsCacheSize);
        policyStats.record("PolicyEvaluator: Number of token IDs in  sessionListernerRgistry:" + ssoListenerRegistry.size());
        policyStats.record("PolicyEvaluator: Number of serviceNames  in policyListenerRegistry: " + policyListenerRegistry.size());
        policyStats.record("PolicyEvaluator: Number of token IDs  in role cahce: " + userNSRoleCache.size());
        policyStats.record("PolicyEvaluator:Number of serviceNames in  resourceNames cache: " + resourceNamesMap.size());
    }
}

