/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.plugins.OrgReferral;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PeerOrgReferral
extends OrgReferral {
    private static Debug debug = Debug.getInstance((String)"amPolicy");
    private static final String PEER_ORG_REFERRAL = "PeerOrgReferral";

    public String getReferralTypeName() {
        return PEER_ORG_REFERRAL;
    }

    public ValidValues getValidValues(SSOToken token) throws SSOException, PolicyException {
        return this.getValidValues(token, "*");
    }

    public ValidValues getValidValues(SSOToken token, String pattern) throws SSOException, PolicyException {
        HashSet<String> values = new HashSet<String>();
        int status = 0;
        if (debug.messageEnabled()) {
            debug.message("PeerOrgReferral.getValidValues():entering");
        }
        try {
            Set orgSet = (Set)this._configurationMap.get("OrganizationName");
            if (orgSet == null || orgSet.isEmpty()) {
                debug.error("PeerOrgReferral.getValidValues():  Organization name not set");
                throw new PolicyException("amPolicy", "org_name_not_set", null, null);
            }
            Iterator iter = orgSet.iterator();
            String orgName = (String)iter.next();
            OrganizationConfigManager orgConfigManager = new OrganizationConfigManager(token, orgName);
            String fullOrgName = orgConfigManager.getOrganizationName();
            if (debug.messageEnabled()) {
                debug.message("PeerOrgReferral.getValidValues():fullOrgName=" + fullOrgName);
            }
            OrganizationConfigManager parentOrgConfig = orgConfigManager.getParentOrgConfigManager();
            String fullParentOrgName = parentOrgConfig.getOrganizationName();
            Set subOrgNames = parentOrgConfig.getSubOrganizationNames(pattern, false);
            if (!fullOrgName.equals(fullParentOrgName) && subOrgNames != null && !subOrgNames.isEmpty()) {
                Iterator subOrgsIter = subOrgNames.iterator();
                while (subOrgsIter.hasNext()) {
                    String fullSubOrgName;
                    String subOrgName = (String)subOrgsIter.next();
                    OrganizationConfigManager subOrgManager = parentOrgConfig.getSubOrgConfigManager(subOrgName);
                    if (subOrgManager == null || fullOrgName.equals(fullSubOrgName = subOrgManager.getOrganizationName())) continue;
                    values.add(fullSubOrgName);
                }
            }
            if (debug.messageEnabled()) {
                debug.message("PeerOrgReferral.getValidValues():returning=" + values);
            }
        }
        catch (SMSException smse) {
            debug.error("Can not get valid values for referral " + this.getReferralTypeName() + smse);
            Object[] objs = new String[]{this.getReferralTypeName()};
            throw new PolicyException("amPolicy", "can_not_get_values_for_referral", objs, smse);
        }
        return new ValidValues(status, values);
    }
}

