/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationManager;
import com.sun.identity.delegation.DelegationPermission;
import com.sun.identity.delegation.DelegationPrivilege;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.CreateServiceConfig;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.OrgConfigViaAMSDK;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SMSMigration70 {
    private static String orgNamingAttr;

    public static void main(String[] args) {
    }

    public static void migrate63To70(SSOToken token, String entryDN) {
        try {
            ServiceConfigManager scm;
            ServiceConfig sc;
            if (ServiceManager.isRealmEnabled()) {
                System.out.println("\n\n\nSMSMigration70::main() : Realms enabled. \n\nService Management Migration to 7.0 cannot be done. ");
                throw new Exception("\n\n\nSMSMigration70::main() : Realms enabled. \n\nService Management Migration to 7.0 cannot be done.");
            }
            entryDN = entryDN.toLowerCase();
            SMSMigration70.addIdRepoAMSDKPlugin(token, entryDN);
            Map addMap = SMSMigration70.getOrgAttributes(token, entryDN);
            String rootRealmDN = "ou=services," + entryDN;
            OrganizationConfigManager ocmAddAttr = new OrganizationConfigManager(token, rootRealmDN);
            ocmAddAttr.setAttributes("sunidentityrepositoryservice", addMap);
            SMSMigration70.migrateToRealms(token, entryDN);
            ServiceSchemaManager ssm = new ServiceSchemaManager("sunidentityrepositoryservice", token);
            ServiceSchema gss = ssm.getGlobalSchema();
            if (gss != null) {
                HashMap attrSet = new HashMap(2);
                HashSet<String> realmValue = new HashSet<String>(2);
                realmValue.add("true");
                attrSet.put("realmMode", realmValue);
                HashSet<String> coExistValue = new HashSet<String>(2);
                coExistValue.add("false");
                attrSet.put("coexistenceMode", coExistValue);
                gss.setAttributeDefaults(attrSet);
            }
            if ((sc = (scm = new ServiceConfigManager("sunidentityrepositoryservice", token)).getGlobalConfig(null)) != null) {
                HashMap map = new HashMap(2);
                HashSet<String> realmSet = new HashSet<String>(2);
                realmSet.add("true");
                map.put("realmMode", realmSet);
                HashSet<String> coExistSet = new HashSet<String>(2);
                coExistSet.add("false");
                map.put("coexistenceMode", coExistSet);
                sc.setAttributes(map);
            }
            ServiceManager.checkFlags(token);
            System.out.println("migrateToRealms.REALM is " + ServiceManager.isRealmEnabled());
            System.out.println("migrateToRealms.COEXISTENCE is " + ServiceManager.isCoexistenceMode());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void migrateToRealms(SSOToken token, String entryDN) {
        try {
            OrganizationConfigManager ocm = new OrganizationConfigManager(token, entryDN);
            Set subOrgNames = ocm.getSubOrganizationNames("*", false);
            if (orgNamingAttr == null) {
                orgNamingAttr = ocm.getNamingAttrForOrg();
            }
            System.out.println("Organization naming attr is " + orgNamingAttr);
            Iterator subOrgs = subOrgNames.iterator();
            System.out.println("SIZE is " + subOrgNames.size());
            while (subOrgs.hasNext()) {
                String org = orgNamingAttr + "=" + (String)subOrgs.next() + "," + entryDN;
                System.out.println("Organization is " + org);
                SMSMigration70.addIdRepoAMSDKPlugin(token, org);
                SMSMigration70.migrateOrganization(token, org);
                SMSMigration70.migrateDelegationPolicies(token, org);
                SMSMigration70.migrateToRealms(token, org);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void addIdRepoAMSDKPlugin(SSOToken token, String orgName) throws SMSException, SSOException {
        ServiceConfigManager scm = new ServiceConfigManager("sunidentityrepositoryservice", token);
        ServiceConfig sc = scm.getOrganizationConfig(orgName, null);
        HashMap attributes = new HashMap();
        HashSet<String> values = new HashSet<String>();
        values.add("com.iplanet.am.sdk.AMSDKRepo");
        attributes.put("sunIdRepoClass", values);
        values = new HashSet();
        values.add(DNMapper.realmNameToAMSDKName(DNMapper.orgNameToDN(orgName)));
        attributes.put("amSDKOrgName", values);
        sc.addSubConfig("amsdk1", "amSDK", 0, attributes);
    }

    protected static void migrateDelegationPolicies(SSOToken token, String orgName) throws SSOException {
        System.out.println("Migrating delegation policies for org: " + orgName);
        try {
            DelegationManager dm = new DelegationManager(token, orgName);
            Set privileges = dm.getPrivileges();
            HashSet<DelegationPrivilege> newPrivileges = new HashSet<DelegationPrivilege>();
            Iterator items = privileges.iterator();
            while (items.hasNext()) {
                DelegationPrivilege dp = (DelegationPrivilege)items.next();
                String name = dp.getName();
                dm.removePrivilege(name);
                Set permissions = dp.getPermissions();
                DelegationPermission perm = null;
                int index = -1;
                Iterator perms = permissions.iterator();
                while (perms.hasNext()) {
                    perm = (DelegationPermission)perms.next();
                    String resource = perm.getOrganizationName();
                    index = resource.toLowerCase().indexOf("," + SMSEntry.getRootSuffix());
                    if (index == -1) continue;
                    resource = resource.substring(0, index) + "," + DNMapper.serviceDN + resource.substring(index + SMSEntry.getRootSuffix().length() + 1);
                    perm.setOrganizationName(resource);
                }
                Set subjects = dp.getSubjects();
                HashSet<String> newSubjects = new HashSet<String>();
                Iterator ss = subjects.iterator();
                while (ss.hasNext()) {
                    String subject = (String)ss.next();
                    index = subject.toLowerCase().indexOf("," + SMSEntry.getRootSuffix());
                    if (index != -1) {
                        subject = subject.substring(0, index) + "," + DNMapper.serviceDN + subject.substring(index + SMSEntry.getRootSuffix().length() + 1);
                    }
                    newSubjects.add(subject);
                }
                dp.setSubjects(newSubjects);
                newPrivileges.add(dp);
            }
            int index = orgName.toLowerCase().indexOf("," + SMSEntry.getRootSuffix());
            if (index != -1) {
                orgName = orgName.substring(0, index) + "," + DNMapper.serviceDN + orgName.substring(index + 1 + SMSEntry.getRootSuffix().length());
            }
            dm = new DelegationManager(token, orgName);
            Iterator items2 = newPrivileges.iterator();
            while (items2.hasNext()) {
                DelegationPrivilege dp = (DelegationPrivilege)items2.next();
                dm.addPrivilege(dp);
            }
            System.out.println("Delegation Policies for org: " + orgName + "\n" + privileges);
        }
        catch (DelegationException de) {
            System.out.println("   " + de.getMessage());
        }
    }

    protected static Map getOrgAttributes(SSOToken token, String org) {
        HashMap<String, Set> map = new HashMap<String, Set>();
        try {
            OrgConfigViaAMSDK amsdk = new OrgConfigViaAMSDK(token, org, org);
            Set orgStatus = amsdk.getSDKAttributeValue("inetDomainStatus");
            Set orgPrefDom = amsdk.getSDKAttributeValue("sunPreferredDomain");
            Set orgAssocDom = amsdk.getSDKAttributeValue("associatedDomain");
            Set orgAlias = amsdk.getSDKAttributeValue("sunOrganizationAlias");
            orgAlias.addAll(orgPrefDom);
            orgAlias.addAll(orgAssocDom);
            map.put("sunOrganizationStatus", orgStatus);
            map.put("sunOrganizationAliases", orgAlias);
            System.out.println("\n addIdRepoAMSDKPlugin.Org Status &  ");
            System.out.println("addIdRepoAMSDKPlugin.Org Alias. ");
            Iterator its = map.keySet().iterator();
            while (its.hasNext()) {
                String st = (String)its.next();
                System.out.println(st + "=" + map.get(st));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static void migrateOrganization(SSOToken token, String org) {
        try {
            String orglc = org.toLowerCase();
            int sdn = orglc.indexOf(SMSEntry.baseDN);
            if (sdn > 0) {
                System.out.println("\n migrateOrganization.Org Name: " + org);
                Map map = SMSMigration70.getOrgAttributes(token, org);
                String realm = org;
                if (!orgNamingAttr.equalsIgnoreCase("o")) {
                    String tmp = org.substring(0, sdn);
                    realm = DNMapper.replaceString(tmp, orgNamingAttr + "=", "o=") + org.substring(sdn);
                }
                System.out.println("\nmigrateOrganization.realm: " + realm);
                String orgDN = "ou=services," + org;
                System.out.println("\nmigrateOrganization.orgDN Name: " + orgDN);
                CachedSubEntries cse = CachedSubEntries.getInstance(token, orgDN);
                Set subEntries = cse.getSubEntries(token);
                sdn = realm.toLowerCase().indexOf(SMSEntry.baseDN);
                String realmDN = realm.substring(0, sdn) + "ou=services" + "," + realm.substring(sdn);
                System.out.println("\nmigrateOrganization.RealmDN Name: " + realmDN);
                CreateServiceConfig.createOrganization(token, realmDN);
                DNMapper.migration = true;
                OrganizationConfigManager ocmAddAttrs = new OrganizationConfigManager(token, realmDN);
                ocmAddAttrs.setAttributes("sunidentityrepositoryservice", map);
                Iterator iter = subEntries.iterator();
                while (iter.hasNext()) {
                    String serviceName = (String)iter.next();
                    System.out.println("\nmigrateOrganization.ServiceName: " + serviceName);
                    SMSMigration70.migrateConfigData(token, realmDN, serviceName, org);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void migrateConfigData(SSOToken token, String realmDN, String serviceName, String org) {
        try {
            System.out.println("Initial value. migrateConfigData.REALM is " + ServiceManager.isRealmEnabled());
            System.out.println("initial value. migrateConfigData.COEXISTENCE is " + ServiceManager.isCoexistenceMode());
            OrganizationConfigManager ocmAdd = new OrganizationConfigManager(token, realmDN);
            ServiceConfigManager scmGet = new ServiceConfigManager(serviceName, token);
            System.out.println("\nMigrating Organization Config data");
            ServiceConfig orgServiceConfig = scmGet.getOrganizationConfig(org, null);
            SMSMigration70.migrateConfigs(token, orgServiceConfig, serviceName, ocmAdd);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void migrateConfigs(SSOToken token, ServiceConfig scGet, String serviceName, OrganizationConfigManager ocmAdd) {
        try {
            Map attrResults = scGet.getAttributes();
            Iterator it = attrResults.keySet().iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                System.out.println(s + "=" + attrResults.get(s));
            }
            ServiceConfig newServiceConfig = ocmAdd.addServiceConfig(serviceName, attrResults);
            Set subConfigNames = scGet.getSubConfigNames();
            Iterator itr = subConfigNames.iterator();
            int j = 0;
            while (itr.hasNext()) {
                String subConfigName = (String)itr.next();
                ServiceConfig oldSubConfig = scGet.getSubConfig(subConfigName);
                String scID = oldSubConfig.getSchemaID();
                if (scID == null || scID.length() == 0) {
                    scID = subConfigName;
                }
                System.out.println("Sub Config Name " + subConfigName);
                System.out.println("Sub ConfigID " + scID);
                Map subConfigMap = oldSubConfig.getAttributes();
                newServiceConfig.addSubConfig(subConfigName, scID, scGet.getPriority(), subConfigMap);
                SMSMigration70.migrateSubEntries(token, newServiceConfig, oldSubConfig, subConfigName);
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void migrateSubEntries(SSOToken token, ServiceConfig newServiceConfig, ServiceConfig oldSubConfig, String subConfigName) {
        try {
            Set subEntryNames = oldSubConfig.getSubConfigNames();
            if (subEntryNames != null && !subEntryNames.isEmpty()) {
                Iterator iter = subEntryNames.iterator();
                int k = 0;
                while (iter.hasNext()) {
                    String subEntryName = (String)iter.next();
                    System.out.println("Sub Config Name1 " + subEntryName);
                    ServiceConfig subEntryConfig = oldSubConfig.getSubConfig(subEntryName);
                    Map subEntryConfigMap = subEntryConfig.getAttributes();
                    Iterator it1 = subEntryConfigMap.keySet().iterator();
                    while (it1.hasNext()) {
                        String s1 = (String)it1.next();
                        System.out.println(s1 + "=" + subEntryConfigMap.get(s1));
                    }
                    String serviceID = subEntryConfig.getSchemaID();
                    if (serviceID.length() == 0) {
                        serviceID = subEntryName;
                    }
                    System.out.println("serviceID " + serviceID);
                    StringBuffer sb = new StringBuffer(8);
                    String subConfigDN = "ou=" + subEntryName + "," + "ou=" + subConfigName + "," + newServiceConfig.getDN();
                    SMSEntry newsubConfigSMSEntry = new SMSEntry(token, subConfigDN);
                    SMSUtils.setAttributeValuePairs(newsubConfigSMSEntry, subEntryConfigMap, Collections.EMPTY_SET);
                    newsubConfigSMSEntry.addAttribute("sunserviceID", serviceID);
                    newsubConfigSMSEntry.addAttribute("sunsmspriority", sb.append(oldSubConfig.getPriority()).toString());
                    newsubConfigSMSEntry.addAttribute("objectclass", "sunServiceComponent");
                    newsubConfigSMSEntry.addAttribute("objectclass", "top");
                    newsubConfigSMSEntry.save(token);
                    CachedSMSEntry cachedE = CachedSMSEntry.getInstance(token, newsubConfigSMSEntry.getDN(), null);
                    cachedE.refresh(newsubConfigSMSEntry);
                    SMSMigration70.migrateSubEntries(token, newServiceConfig, subEntryConfig, subEntryName);
                    ++k;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

