/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceAttributeValidator;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class SiteIDValidator
implements ServiceAttributeValidator {
    private static final String PLATFORM_SERVER_LIST = "iplanet-am-platform-server-list";
    private static Debug debug = Debug.getInstance((String)"amSession");
    private Set serverAddrSet = new HashSet();
    private Set serverIdSet = new HashSet();

    public boolean validate(Set values) {
        if (values.size() == 0) {
            return true;
        }
        HashSet<String> idSet = new HashSet<String>();
        HashSet<String> urlSet = new HashSet<String>();
        Iterator it = values.iterator();
        boolean serverLookup = false;
        serverLookup = this.getServerDetails();
        while (it.hasNext()) {
            String value = (String)it.next();
            StringTokenizer tok = new StringTokenizer(value, "|");
            if (tok.countTokens() != 2) {
                return false;
            }
            String url = tok.nextToken();
            String id = tok.nextToken();
            int byteLength = id.getBytes().length;
            if (byteLength != 2 || idSet.contains(id)) {
                return false;
            }
            idSet.add(id);
            if (urlSet.contains(url)) {
                return false;
            }
            urlSet.add(url);
            if (serverLookup) {
                if (this.serverAddrSet.contains(url)) {
                    return false;
                }
                if (!this.serverIdSet.contains(id)) continue;
                return false;
            }
            if (!debug.messageEnabled()) continue;
            debug.message("Unable to get server list information. Server validation cannot be performed");
        }
        return true;
    }

    private boolean getServerDetails() {
        block7: {
            if (!this.serverAddrSet.isEmpty()) {
                return true;
            }
            try {
                Map attrs;
                Set serverList;
                ServiceSchema ss;
                SSOToken stoken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                ServiceSchemaManager ssm = new ServiceSchemaManager("iPlanetAMPlatformService", stoken);
                if (ssm != null && (ss = ssm.getGlobalSchema()) != null && (serverList = (Set)(attrs = ss.getAttributeDefaults()).get(PLATFORM_SERVER_LIST)) != null && !serverList.isEmpty()) {
                    Iterator serverIterator = serverList.iterator();
                    while (serverIterator.hasNext()) {
                        String serverVal = (String)serverIterator.next();
                        if (serverVal == null) continue;
                        StringTokenizer tk = new StringTokenizer(serverVal, "|");
                        String serverUrl = tk.nextToken();
                        String serverId = tk.nextToken();
                        this.serverAddrSet.add(serverUrl);
                        StringTokenizer sidtk = new StringTokenizer(serverId, "|");
                        this.serverIdSet.add(sidtk.nextToken());
                    }
                }
                return true;
            }
            catch (SMSException se) {
                if (debug.messageEnabled()) {
                    debug.message("Site List Validator. Unable to get global config: SMSException", (Throwable)se);
                }
            }
            catch (SSOException ssoe) {
                if (!debug.messageEnabled()) break block7;
                debug.message("Site List Validator. Unable to get global config: SSOException", (Throwable)((Object)ssoe));
            }
        }
        return false;
    }
}

