/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tools.bundles;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public class CopyUtils {
    protected static int BUFFER_SIZE = 8192;

    private CopyUtils() {
    }

    public static void copyFile(File sourceFile, File destFile, boolean overwrite, boolean preserveLastModified) throws IOException {
        CopyUtils.copyFile(sourceFile, destFile, null, overwrite, preserveLastModified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile, Properties tokens, boolean overwrite, boolean preserveLastModified) throws IOException {
        if (overwrite || !destFile.exists() || destFile.lastModified() < sourceFile.lastModified()) {
            File parent;
            if (destFile.exists() && destFile.isFile()) {
                destFile.delete();
            }
            if ((parent = destFile.getParentFile()) != null && !parent.exists()) {
                parent.mkdirs();
            }
            if (sourceFile.isDirectory()) {
                destFile.mkdirs();
                return;
            }
            String line = null;
            if (tokens != null && !tokens.isEmpty()) {
                BufferedReader in = new BufferedReader(new FileReader(sourceFile));
                BufferedWriter out = new BufferedWriter(new FileWriter(destFile));
                try {
                    while ((line = in.readLine()) != null) {
                        if (line.length() > 0) {
                            Enumeration<?> tokensName = tokens.propertyNames();
                            while (tokensName.hasMoreElements()) {
                                String name = (String)tokensName.nextElement();
                                if (line.indexOf(name) < 0) continue;
                                line = line.replaceAll(name, tokens.getProperty(name));
                            }
                            out.write(line);
                            out.newLine();
                            continue;
                        }
                        out.newLine();
                    }
                }
                finally {
                    out.close();
                    in.close();
                }
            }
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                in = new FileInputStream(sourceFile);
                out = new FileOutputStream(destFile);
                byte[] buffer = new byte[BUFFER_SIZE];
                int count = 0;
                while ((count = in.read(buffer, 0, buffer.length)) != -1) {
                    out.write(buffer, 0, count);
                }
            }
            finally {
                out.close();
                in.close();
            }
            if (preserveLastModified) {
                destFile.setLastModified(sourceFile.lastModified());
            }
        }
    }
}

