/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.impl;

import com.sun.identity.tune.base.AMTuneDSBase;
import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.FileHandler;
import com.sun.identity.tune.config.AMTuneConfigInfo;
import com.sun.identity.tune.util.AMTuneUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class TuneDS6Impl
extends AMTuneDSBase {
    private String dsAdmPath;
    private String dsConf;
    private String dbBackupDir;

    public TuneDS6Impl(boolean isSMStore) {
        super(isSMStore);
    }

    public void initialize(AMTuneConfigInfo configInfo) throws AMTuneException {
        super.initialize(configInfo);
        if (AMTuneUtil.isWindows2003()) {
            this.dsAdmPath = this.dsConfInfo.getDSToolsBinDir() + "/" + "dsadm.exe ";
            this.dsConf = this.dsConfInfo.getDSToolsBinDir() + "/" + "dsconf.exe ";
        } else {
            this.dsAdmPath = this.dsConfInfo.getDSToolsBinDir() + "/" + "dsadm ";
            this.dsConf = this.dsConfInfo.getDSToolsBinDir() + "/" + "dsconf ";
        }
        this.dbBackupDir = "amtune-" + AMTuneUtil.getRandomStr();
        this.checkDSRealVersion();
    }

    private void checkDSRealVersion() throws AMTuneException {
        StringBuffer rBuff;
        String verCmd = this.dsAdmPath + " --version";
        int extVal = AMTuneUtil.executeCommand(verCmd, rBuff = new StringBuffer());
        if (extVal == -1) {
            this.mWriter.writelnLocaleMsg("pt-ds-version-fail-msg");
            this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
            this.pLogger.log(Level.SEVERE, "checkDSRealVersion", "dsadm cmd error " + rBuff.toString());
            throw new AMTuneException("Error getting DS version.");
        }
        if (rBuff.toString().indexOf("6.3") == -1 && rBuff.indexOf("6.2") != -1) {
            this.mWriter.writelnLocaleMsg("pt-ds-unsupported-msg");
            this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
            this.pLogger.log(Level.SEVERE, "checkDSRealVersion", "Unsupported DS version" + rBuff.toString());
            throw new AMTuneException("Unsupported DS version.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTuning() throws AMTuneException {
        try {
            this.pLogger.log(Level.FINE, "startTuning", "Start tuning.");
            this.mWriter.writeln("#####################################################################");
            this.mWriter.writelnLocaleMsg("pt-fam-ds6-tuning");
            if (this.isSM) {
                this.mWriter.writelnLocaleMsg("pt-fam-sm-ds-tuning");
            }
            this.mWriter.writeln("#####################################################################");
            this.mWriter.writelnLocaleMsg("pt-init");
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.computeTuneValues();
            this.mWriter.writeln("=====================================================================");
            this.modifyLDAP();
            if (!AMTuneUtil.isWindows2003()) {
                this.tuneUsingDSE();
            }
            if (!this.isSM) {
                this.tuneDSIndex();
            }
            this.tuneFuture();
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "startTuning", "Error Tuning DSEE6.0");
            this.mWriter.writelnLocaleMsg("pt-error-tuning-msg");
            this.pLogger.logException("startTuning", ex);
        }
        finally {
            try {
                this.releaseCon();
            }
            catch (Exception exception) {}
            this.deletePasswordFile();
        }
    }

    private List getIndexForDB() throws AMTuneException {
        ArrayList<String> idxList = new ArrayList<String>();
        try {
            this.pLogger.log(Level.FINE, "getIndexForDB", "Get existing index.");
            String listIndexCmd = this.dsConf + "list-indexes --port " + this.dsConfInfo.getDsPort() + " --unsecured --no-inter " + "--pwd-file " + this.dsPassFilePath + " " + this.dsConfInfo.getRootSuffix();
            StringBuffer resultBuffer = new StringBuffer();
            int retVal = AMTuneUtil.executeCommand(listIndexCmd, resultBuffer);
            if (retVal == -1) {
                throw new AMTuneException(resultBuffer.toString());
            }
            StringTokenizer idxTokens = new StringTokenizer(resultBuffer.toString(), " ");
            while (idxTokens.hasMoreTokens()) {
                idxList.add(idxTokens.nextToken().trim());
            }
            this.pLogger.log(Level.FINE, "getIndexForDB", "Returning idx list " + ((Object)idxList).toString());
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "getIndexForDB", "Error finding index");
            throw new AMTuneException(ex.getMessage());
        }
        return idxList;
    }

    private void tuneDSIndex() throws AMTuneException {
        try {
            this.pLogger.log(Level.FINE, "tuneDSIndex", "Tune DS Index.");
            List existingIdx = this.getIndexForDB();
            List notIdxList = this.tuneDSIndex(existingIdx);
            if (this.configInfo.isReviewMode()) {
                return;
            }
            if (notIdxList.size() == 0) {
                this.mWriter.writelnLocaleMsg("pt-all-idx-exist");
            } else {
                this.mWriter.writeLocaleMsg("pt-creating-idx");
                this.mWriter.writeln(notIdxList.toString());
                Iterator idxListItr = notIdxList.iterator();
                while (idxListItr.hasNext()) {
                    String curAttr = (String)idxListItr.next();
                    this.mWriter.writeLocaleMsg("pt-create-idx-attr");
                    this.mWriter.writeln(curAttr);
                    this.createIndex(curAttr);
                    this.mWriter.writelnLocaleMsg("pt-done");
                }
            }
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "tuneDSIndex", "Error tuning index.");
            throw new AMTuneException(ex.getMessage());
        }
    }

    private void createIndex(String attrName) throws AMTuneException {
        try {
            this.pLogger.log(Level.FINE, "createIndex", "Create index for " + attrName);
            String createIndexCmd = this.dsConf + "create-index --port " + this.dsConfInfo.getDsPort() + " --unsecured --no-inter --pwd-file " + this.dsPassFilePath + " " + this.dsConfInfo.getRootSuffix() + " " + attrName;
            StringBuffer resultBuffer = new StringBuffer();
            int retVal = AMTuneUtil.executeCommand(createIndexCmd, resultBuffer);
            if (retVal == -1) {
                throw new AMTuneException(resultBuffer.toString());
            }
        }
        catch (Exception ex) {
            this.mWriter.writelnLocaleMsg("pt-idx-create-error");
            this.pLogger.log(Level.SEVERE, "createIndex", "Error creating index for attribute " + attrName);
        }
    }

    protected void tuneUsingDSE() throws AMTuneException {
        try {
            super.tuneUsingDSE();
            this.pLogger.log(Level.FINE, "tuneUsingDSE", "");
            if (this.configInfo.isReviewMode()) {
                return;
            }
            this.pLogger.log(Level.FINE, "tuneUsingDSE", "Modify dse.ldif");
            if (this.curDBHomeLocation.equals(this.newDBHomeLocation)) {
                this.pLogger.log(Level.INFO, "tuneUsingDSE", "Current DB Location is same as recommended value.");
                return;
            }
            this.stopDS();
            this.backUpDS();
            FileHandler dseH = new FileHandler(this.dseLdifPath);
            int reqLineNo = dseH.lineContains("nsslapd-db-home-directory:");
            dseH.replaceLine(reqLineNo, "nsslapd-db-home-directory: " + this.newDBHomeLocation);
            dseH.close();
            this.startDS();
        }
        catch (FileNotFoundException fex) {
            throw new AMTuneException(fex.getMessage());
        }
        catch (IOException ioe) {
            throw new AMTuneException(ioe.getMessage());
        }
    }

    private void modifyLDAP() throws AMTuneException {
        this.pLogger.log(Level.FINE, "modifyLDAP", "Modify LDAP attributes.");
        boolean applyRec = false;
        boolean remAci = false;
        this.ldapTuningRecommendations();
        if (this.configInfo.isReviewMode()) {
            return;
        }
        this.stopDS();
        this.backUpDS();
        this.startDS();
        applyRec = this.applyRecommendations();
        if (applyRec || remAci) {
            this.stopDS();
            this.startDS();
        }
    }

    protected void backUpDS() throws AMTuneException {
        try {
            String dbBackUpSuccessFile = this.instanceDir + "/" + "bak" + "/" + this.dbBackupDir + "/" + "SUCCESS.dontdelete";
            File successFile = new File(dbBackUpSuccessFile);
            if (successFile.isFile()) {
                this.pLogger.log(Level.INFO, "backUpDS", "Backup exists");
                return;
            }
            File bakDir = new File(this.dsConfInfo.getDsInstanceDir() + "/" + "bak");
            if (!bakDir.isDirectory()) {
                bakDir.mkdir();
            }
            StringBuffer resultBuffer = new StringBuffer();
            String db2BakCmd = this.dsAdmPath + "backup " + this.instanceDir + " " + bakDir.getAbsolutePath() + "/" + this.dbBackupDir;
            this.pLogger.log(Level.FINE, "backUpDS", "Backing up DS instance." + this.instanceDir);
            int retVal = AMTuneUtil.executeCommand(db2BakCmd, resultBuffer);
            if (retVal == -1) {
                this.mWriter.writelnLocaleMsg("pt-cannot-backup-db");
                this.pLogger.log(Level.SEVERE, "backUpDS", "Error taking backup: " + resultBuffer.toString());
                throw new AMTuneException("Data Base Backup failed.");
            }
            this.pLogger.log(Level.FINE, "backUpDS", "Backing up Done...");
            try {
                File dseLdif = new File(this.dseLdifPath);
                this.pLogger.log(Level.FINE, "backUpDS", "Backing " + this.dseLdifPath);
                File bakDseFile = new File(this.instanceDir + "/" + "bak" + "/" + this.dbBackupDir + "/" + "dse.ldif");
                AMTuneUtil.CopyFile(dseLdif, bakDseFile);
                this.pLogger.log(Level.FINE, "backUpDS", "Backing Done..");
            }
            catch (Exception ex) {
                throw new AMTuneException("Couldn't bakup dse.ldif. " + ex.getMessage());
            }
            successFile.createNewFile();
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "backUpDS", "Error backing up DS " + ex.getMessage());
            throw new AMTuneException(ex.getMessage());
        }
    }

    protected void stopDS() throws AMTuneException {
        this.pLogger.log(Level.FINE, "stopDS", "Stopping DS6.");
        StringBuffer resultBuffer = new StringBuffer();
        String stopCmd = this.dsAdmPath + "stop " + this.instanceDir;
        int retVal = AMTuneUtil.executeCommand(stopCmd, resultBuffer);
        if (retVal == -1) {
            throw new AMTuneException(resultBuffer.toString());
        }
        this.pLogger.log(Level.FINE, "stopDS", "DS6 Successfully stopped.");
    }

    protected void startDS() throws AMTuneException {
        this.pLogger.log(Level.FINE, "startDS", "Starting DS6.");
        StringBuffer resultBuffer = new StringBuffer();
        String startCmd = this.dsAdmPath + "start " + this.instanceDir;
        int retVal = AMTuneUtil.executeCommand(startCmd, resultBuffer);
        if (retVal == -1) {
            throw new AMTuneException(resultBuffer.toString());
        }
        this.pLogger.log(Level.FINE, "startDS", "DS6 Successfully started.");
    }
}

