/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.DataConnection;
import org.apache.ftpserver.ftplet.DataType;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpReplyOutput;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.ftplet.Ftplet;
import org.apache.ftpserver.ftplet.FtpletEnum;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.ServerFtpStatistics;
import org.apache.ftpserver.listener.Connection;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.apache.ftpserver.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RETR
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger((Class)RETR.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(Connection connection, FtpRequest request, FtpSessionImpl session, FtpReplyOutput out) throws IOException, FtpException {
        block34: {
            try {
                InputStream is;
                boolean failure;
                FtpletEnum ftpletRet;
                Ftplet ftpletContainer;
                String fileName;
                FtpServerContext serverContext;
                block33: {
                    DataConnection dataConnection;
                    long skipLen = session.getFileOffset();
                    serverContext = connection.getServerContext();
                    fileName = request.getArgument();
                    if (fileName == null) {
                        out.write(FtpReplyUtil.translate(session, 501, "RETR", null));
                        return;
                    }
                    ftpletContainer = serverContext.getFtpletContainer();
                    try {
                        ftpletRet = ftpletContainer.onDownloadStart((FtpSession)session, request, out);
                    }
                    catch (Exception e) {
                        this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                        ftpletRet = FtpletEnum.RET_DISCONNECT;
                    }
                    if (ftpletRet == FtpletEnum.RET_SKIP) {
                        return;
                    }
                    if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
                        serverContext.getConnectionManager().closeConnection(connection);
                        return;
                    }
                    FileObject file = null;
                    try {
                        file = session.getFileSystemView().getFileObject(fileName);
                    }
                    catch (Exception ex) {
                        this.LOG.debug("Exception getting file object", (Throwable)ex);
                    }
                    if (file == null) {
                        out.write(FtpReplyUtil.translate(session, 550, "RETR.missing", fileName));
                        return;
                    }
                    fileName = file.getFullName();
                    if (!file.doesExist()) {
                        out.write(FtpReplyUtil.translate(session, 550, "RETR.missing", fileName));
                        return;
                    }
                    if (!file.isFile()) {
                        out.write(FtpReplyUtil.translate(session, 550, "RETR.invalid", fileName));
                        return;
                    }
                    if (!file.hasReadPermission()) {
                        out.write(FtpReplyUtil.translate(session, 550, "RETR.permission", fileName));
                        return;
                    }
                    out.write(FtpReplyUtil.translate(session, 150, "RETR", null));
                    failure = false;
                    is = null;
                    try {
                        dataConnection = session.getDataConnection().openConnection();
                    }
                    catch (Exception e) {
                        this.LOG.debug("Exception getting the output data stream", (Throwable)e);
                        out.write(FtpReplyUtil.translate(session, 425, "RETR", null));
                        session.resetState();
                        session.getDataConnection().closeDataConnection();
                        return;
                    }
                    try {
                        is = this.openInputStream(connection, session, file, skipLen);
                        long transSz = dataConnection.transferToClient(is);
                        String userName = session.getUser().getName();
                        this.LOG.info("File download : " + userName + " - " + fileName);
                        ServerFtpStatistics ftpStat = (ServerFtpStatistics)serverContext.getFtpStatistics();
                        if (ftpStat == null) break block33;
                        ftpStat.setDownload(connection, file, transSz);
                    }
                    catch (SocketException ex) {
                        this.LOG.debug("Socket exception during data transfer", (Throwable)ex);
                        failure = true;
                        out.write(FtpReplyUtil.translate(session, 426, "RETR", fileName));
                        IoUtils.close(is);
                    }
                    catch (IOException ex2) {
                        this.LOG.debug("IOException during data transfer", (Throwable)ex2);
                        failure = true;
                        out.write(FtpReplyUtil.translate(session, 551, "RETR", fileName));
                        {
                            catch (Throwable throwable) {
                                IoUtils.close(is);
                                throw throwable;
                            }
                        }
                        IoUtils.close(is);
                    }
                }
                IoUtils.close(is);
                if (failure) break block34;
                out.write(FtpReplyUtil.translate(session, 226, "RETR", fileName));
                try {
                    ftpletRet = ftpletContainer.onDownloadEnd((FtpSession)session, request, out);
                }
                catch (Exception e) {
                    this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                    ftpletRet = FtpletEnum.RET_DISCONNECT;
                }
                if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
                    serverContext.getConnectionManager().closeConnection(connection);
                    return;
                }
            }
            finally {
                session.resetState();
                session.getDataConnection().closeDataConnection();
            }
        }
    }

    public InputStream openInputStream(Connection connection, FtpSessionImpl session, FileObject file, long skipLen) throws IOException {
        InputStream in;
        if (session.getDataType() == DataType.ASCII) {
            long offset = 0L;
            in = new BufferedInputStream(file.createInputStream(0L));
            while (offset++ < skipLen) {
                int c = in.read();
                if (c == -1) {
                    throw new IOException("Cannot skip");
                }
                if (c != 10) continue;
                ++offset;
            }
        } else {
            in = file.createInputStream(skipLen);
        }
        return in;
    }
}

