package org.jboss.internal.soa.esb.publish;

import java.net.URI;

import org.jboss.soa.esb.Service;

/**
 * Contract Publisher which represents a referenced contract.
 *
 * @author <a href="mailto:kevin.conner@jboss.com">Kevin Conner</a>
 */
public interface ContractReferencePublisher extends Publisher
{
    /**
     * Get the service represented by this contract configuration.
     * @return The service.
     */
    public Service getService() ;
    
    /**
     * Get the service description represented by this contract configuration.
     * @return The service description.
     */
    public String getDescription() ;
    
    /**
     * Get the URI of the service.
     * @return The service URI.
     */
    public URI getServiceURI() ;
    
    /**
     * Get the URI of the contract.
     * @return The contract URI.
     */
    public URI getServiceContractURI() ;
}
