/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.listeners.config.mappers120;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.UdpListenerDocument;
import org.jboss.soa.esb.listeners.gateway.mina.UdpGatewayConfig;
import org.jboss.soa.esb.listeners.gateway.mina.UdpGatewayListener;
import org.w3c.dom.Element;

/**
 * Config mapper class for the UDP Listener.
 *
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 */
public class UdpListenerMapper {

    public static Element map(final Element root, final UdpListenerDocument.UdpListener listener, final XMLBeansModel model) throws ConfigurationException
    {
        final Element listenerNode = YADOMUtil.addElement(root, "listener");

        listenerNode.setAttribute("name", listener.getName());

        // Map the standard listener attributes - common across all listener types...
        MapperUtil.mapDefaultAttributes(listener, listenerNode, model);

        // Map the <property> elements targeted at the listener - from the listener itself.
        MapperUtil.mapProperties(listener.getPropertyList(), listenerNode);

        listenerNode.setAttribute("gatewayClass", UdpGatewayListener.class.getName());

        // Map the host, port, and handler class
        listenerNode.setAttribute(UdpGatewayConfig.HOST_ATTR, listener.getHost());
        listenerNode.setAttribute(UdpGatewayConfig.PORT_ATTR, listener.getPort().toString());
        listenerNode.setAttribute(UdpGatewayConfig.HANDLER_CLASS_ATTR, listener.getHandlerClass());

        return listenerNode;
    }
}