/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */

package org.jboss.soa.esb.listeners.config.model;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.listeners.config.ServiceContract;
import org.jboss.soa.esb.listeners.config.ServicePublisher;
import org.jboss.soa.esb.listeners.config.WebserviceInfo;
import org.w3c.dom.Document;

/**
 * Adapter interface for external querying of the model.
 * 
 * <a href='mailto:Kevin.Conner@jboss.com>Kevin Conner</a>
 */
public interface ModelAdapter
{
    /**
     * Verify the schedule provider configuration.
     * @throws ConfigurationException
     */
    public void verifyScheduleProviderConfig()
        throws ConfigurationException ;

    /**
     * Get a map of service publishers provided by each service.
     * 
     * @return The map of service publishers, keyed by service.
     */
    public Map<Service, List<ServicePublisher>> getServicePublishers() ;

    /**
     * Generate the ESB Aware configuration document.
     * @return The ESB aware configuration.
     * @throws ConfigurationException Error creating configuration. 
     */
    public Document generateESBAwareConfig()
        throws ConfigurationException ;

    /**
     * Generate the gateway configuration document.
     * @return The gateway configuration.
     * @throws ConfigurationException Error creating configuration. 
     */
    public Document generateGatewayConfig()
        throws ConfigurationException ;

    /**
     * Get the list of actions in this deployment.
     * @return a list of actions or null if none present.
     */
    public Set<String> getActions() ;

    /**
     * Get the list of services which require a webservice endpoint.
     * @return The list of services.
     */
    public List<WebserviceInfo> getWebserviceServices() ;
    
    /**
     * Get the list of service contracts.
     * @return The list of service contracts.
     */
    public List<ServiceContract> getServiceContracts() ;
    
    /**
     * Gets the global authentication domain.
     * 
     * @return String The name of the authentication domain.
     */
    public String getAuthDomain() ;
    
    /**
     * Gets the global authentication method.
     * 
     * @return String The name of the authentication method.
     */
    public String getAuthMethod() ;
}
