/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.helpers;

import java.util.Hashtable;
import java.util.Properties;

import javax.naming.Context;
import javax.naming.NamingException;

import junit.framework.TestCase;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.common.Environment;

/**
 * AppServerContex unit tests.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class AppServerContextUnitTest extends TestCase {
	
	private Logger log = Logger.getLogger( AppServerContextUnitTest.class );
	final String initialContextFactory = MockInitialContextFactory.class.getName() ;
        
	public void test_AppServerContext() throws NamingException, NamingContextException {
        Properties environment = new Properties();
        environment.setProperty(Context.PROVIDER_URL, "http://localhost:1234");
        environment.setProperty(Context.INITIAL_CONTEXT_FACTORY, initialContextFactory);
        environment.setProperty(Context.URL_PKG_PREFIXES, Environment.JBOSS_URL_PKG_PREFIX);
        Context ctx = NamingContextPool.getNamingContext(environment);
        try {
		
		
		Hashtable props = ctx.getEnvironment();
		log.debug(props);
		assertEquals(initialContextFactory, props.get(Context.INITIAL_CONTEXT_FACTORY));
		assertEquals("http://localhost:1234", props.get(Context.PROVIDER_URL));
        } finally {
            NamingContextPool.releaseNamingContext(ctx) ;
        }
	}
}
