/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.config;

import static org.junit.Assert.assertTrue;

import java.io.File;
import java.net.URL;
import java.util.Map;

import junit.framework.JUnit4TestAdapter;

import org.jboss.deployment.DeploymentException;
import org.junit.Test;

/**
 * Unit test for JBoss4ESBDeployer. 
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 */
public class JBoss4ESBDeployerUnitTest
{
    @Test
    public void getSchemasFromFileShouldReturnEmptyMap() throws DeploymentException
    {
        File file = new File(getClass().getResource("schemasDir/mock.xsd").getFile());
        Map<String, String> schemas = JBoss4ESBDeployer.getSchemasFromDirectory(file);
        assertTrue(schemas.isEmpty());
    }
    
    @Test
    public void getSchemasFromDirectory() throws DeploymentException
    {
        File directory = new File(getClass().getResource("schemasDir").getFile());
        Map<String, String> schemas = JBoss4ESBDeployer.getSchemasFromDirectory(directory);
        assertAddedSchemas(schemas);
    }
    
    @Test
    public void getSchemasFromArchive() throws DeploymentException
    {
        URL resource = getClass().getResource("schemasDir.esb");
        File archive = new File(resource.getFile());
        Map<String, String> schemas = JBoss4ESBDeployer.getSchemasFromArchive(archive);
        assertTrue(schemas.containsKey("mock.xsd"));
    }
    
    @Test
    public void getSchemasFromExplodedArchiveWithEsbFile() throws DeploymentException
    {
        final URL resource = getClass().getResource("schemasExploded.esb");
        final File jbossEsbXml = new File(resource.getFile() + File.separator + "META-INF" + File.separator + "jboss-esb.xml" );
        final Map<String, String> schemas = JBoss4ESBDeployer.getSchemas(jbossEsbXml);
        assertAddedSchemas(schemas);
    }
    
    @Test
    public void getSchemasFromArchiveNullArchive() throws DeploymentException
    {
        Map<String, String> schemas = JBoss4ESBDeployer.getSchemasFromArchive(null);
        assertTrue(schemas.isEmpty());
    }
    
    private void assertAddedSchemas(final Map<String, String> schemas)
    {
        assertTrue(schemas.containsKey("mock.xsd"));
        assertTrue(schemas.containsKey("subdir" + File.separator + "type.xsd"));
        assertTrue(schemas.containsKey("subdir" + File.separator + "subdir2" + File.separator + "type.xsd"));
    }

    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(JBoss4ESBDeployerUnitTest.class);
    }

}
