package org.jboss.soa.esb.listeners.config;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;

import junit.framework.TestCase;

import org.jboss.internal.soa.esb.publish.ContractReferencePublisher;
import org.jboss.internal.soa.esb.webservice.ESBServiceContractReferencePublisher;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleController;

/**
 * @author
 */
public class ServicePublisherUnitTest extends TestCase {

    public void test_101() throws ConfigurationException, IOException {
        executeTest("jbossesb_config_04.xml", "jbossesb_config_05.xml");
    }

    public void test_110() throws ConfigurationException, IOException {
        executeTest("jbossesb_config_04.110.xml", "jbossesb_config_05.110.xml");
    }

    public void test_120() throws ConfigurationException, IOException {
        executeTest("jbossesb_config_04.120.xml", "jbossesb_config_05.120.xml");
    }

    private void executeTest(final String resource1, final String resource2) throws ConfigurationException, IOException {
        Generator generator;
        ManagedLifecycleController controller1 = new ManagedLifecycleController(null);
        ManagedLifecycleController controller2 = new ManagedLifecycleController(null);

        assertEquals("Service count", 0, ServicePublisher.getServices().size());
        
        generator = new Generator(getClass().getResourceAsStream(resource1));
        ServicePublisher.addServicePublishers(controller1, generator.getModel().getServicePublishers());
        List<ServicePublisher> publishers = ServicePublisher.getServicePublishers();
        assertEquals(2, publishers.size());
        assertEquals("A1", publishers.get(0).getCategory() + publishers.get(0).getServiceName());
        assertEquals(null, publishers.get(0).getContractPublisher());
        assertEquals("B2", publishers.get(1).getCategory() + publishers.get(1).getServiceName());
        assertEquals(null, publishers.get(1).getContractPublisher());

        assertEquals("Service count", 2, ServicePublisher.getServices().size());
        
        generator = new Generator(getClass().getResourceAsStream(resource2));
        ServicePublisher.addServicePublishers(controller2, generator.getModel().getServicePublishers());
        publishers = ServicePublisher.getServicePublishers();
        assertEquals(4, publishers.size());
        assertEquals("A1", publishers.get(0).getCategory() + publishers.get(0).getServiceName());
        assertEquals(null, publishers.get(0).getContractPublisher());
        assertEquals("B2", publishers.get(1).getCategory() + publishers.get(1).getServiceName());
        assertEquals(null, publishers.get(1).getContractPublisher());
        assertEquals("C3", publishers.get(2).getCategory() + publishers.get(2).getServiceName());
        assertEquals(null, publishers.get(2).getContractPublisher());
        assertEquals("D4", publishers.get(3).getCategory() + publishers.get(3).getServiceName());
        assertTrue(publishers.get(3).getContractPublisher() instanceof MockContractPublisher);
        
        assertEquals("A1", 1, ServicePublisher.getServicePublishers(new Service("A", "1")).size()) ;
        assertEquals("B2", 1, ServicePublisher.getServicePublishers(new Service("B", "2")).size()) ;
        assertEquals("C3", 1, ServicePublisher.getServicePublishers(new Service("C", "3")).size()) ;
        assertEquals("D4", 1, ServicePublisher.getServicePublishers(new Service("D", "4")).size()) ;
        
        assertEquals("Service count", 4, ServicePublisher.getServices().size());

        final ESBServiceContractReferencePublisher publisher = new ESBServiceContractReferencePublisher(new Service("C", "3"), "test", "endpoint") ;
        ServicePublisher.addContractReferencePublishers(controller2, Arrays.asList(publisher)) ;
        assertEquals("C3", 2, ServicePublisher.getServicePublishers(new Service("C", "3")).size()) ;
        
        assertEquals("Service count", 4, ServicePublisher.getServices().size());
        
        ServicePublisher.removeServicePublishers(controller1);
        publishers = ServicePublisher.getServicePublishers();
        assertEquals(3, publishers.size());
        assertEquals("C3", publishers.get(0).getCategory() + publishers.get(0).getServiceName());
        assertEquals(null, publishers.get(0).getContractPublisher());
        assertEquals("C3", publishers.get(1).getCategory() + publishers.get(1).getServiceName());
        assertTrue("ContractReferencePublisher", publishers.get(1).getPublisher() instanceof ContractReferencePublisher);
        assertEquals("D4", publishers.get(2).getCategory() + publishers.get(2).getServiceName());
        assertTrue(publishers.get(2).getContractPublisher() instanceof MockContractPublisher);
        
        assertEquals("Service count", 2, ServicePublisher.getServices().size());
        
        assertEquals("A1", 0, ServicePublisher.getServicePublishers(new Service("A", "1")).size()) ;
        assertEquals("B2", 0, ServicePublisher.getServicePublishers(new Service("B", "2")).size()) ;
        assertEquals("C3", 2, ServicePublisher.getServicePublishers(new Service("C", "3")).size()) ;
        assertEquals("D4", 1, ServicePublisher.getServicePublishers(new Service("D", "4")).size()) ;
        
        ServicePublisher.removeServicePublishers(controller2) ;
    }
}
