package org.jboss.soa.esb.services.jbpm.integration.command;

import java.io.Serializable;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;

import org.jbpm.command.Command;

/**
 * Based on the jBPM enterprise code, this class handles specialisation
 * associated with the command executor.
 * 
 * @author <a href='kevin.conner@jboss.com'>Kevin Conner</a>
 */
public class CommandListener extends AbstractMessageListener
{
    /**
     * Extract a serialized jBPM command object from the message.
     * @param message The message containing the command object.
     * @throws JMSException For errors during extraction.
     */
    protected Command extractCommand(Message message)
        throws JMSException
    {
        Command command = null;
        if (message instanceof ObjectMessage)
        {
            log.debug("deserializing command from jms message...");
            ObjectMessage objectMessage = (ObjectMessage)message;
            Serializable object = objectMessage.getObject();
            if (object instanceof Command)
            {
                command = (Command)object;
            }
            else
            {
                log.warn("ignoring object message cause it isn't a command '" + object + "'" + (object != null ? " (" + object.getClass().getName() + ")" : ""));
            }
        }
        else
        {
            log.warn("ignoring message '" + message + "' cause it isn't an ObjectMessage (" + message.getClass().getName() + ")");
        }
        return command;
    }
}
