/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.jbpm.integration.timer;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.jboss.soa.esb.services.jbpm.integration.AbstractJmsServiceFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.svc.Service;

/**
 * Implementation of a scheduler service using quartz.
 * <h3>Configuration</h3>
 * 
 * The JMS message service factory exposes the following configurable fields.
 * 
 * <ul>
 * <li><code>connectionFactoryJndiName</code></li>
 * <li><code>destinationJndiName</code></li>
 * <li><code>isCommitEnabled</code></li>
 * <li><code>providerAdapterJNDI</code></li>
 * </ul>
 */
public class JmsSchedulerServiceFactory extends AbstractJmsServiceFactory
{
    /**
     * Serial Version UID for this class.
     */
    private static final long serialVersionUID = 1642915732295620551L;
    
    /**
     * The JNDI name for locating the jBPM timer queue destination.
     */
    String destinationJndiName = "queue/JbpmTimerQueue";
    /**
     * The JMS destination for the scheduler.
     */
    private Destination destination;

    /**
     * Get the JMS destination associated with this scheduler.
     * @return The associated JMS destination.
     */
    public Destination getDestination()
    {
      if (destination == null)
      {
        try
        {
          destination = (Destination)lookup(destinationJndiName);
        }
        catch (NamingException e)
        {
          throw new JbpmException("could not retrieve job destination", e);
        }
      }
      return destination;
    }

    /**
     * Create a JMS scheduler service based on this factory.
     */
    public Service openService()
    {
      try
      {
        return new JmsSchedulerService(JbpmConfiguration.getInstance().getCurrentJbpmContext(),
            getConnectionFactory(), getDestination(), isCommitEnabled());
      }
      catch (JMSException e)
      {
        throw new JbpmException("couldn't open message session", e);
      }
    }

    /**
     * Close this factory.
     */
    public void close()
    {
      super.close() ;
      destination = null;
    }
}
