/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.server.jbpmAsync;

import javax.management.ObjectName;

import junit.framework.Test;

import org.jboss.test.JBossTestCase;

/**
 * Test asynchronous callbacks for jBPM processes.
 * 
 * @author <a href='mailto:kevin.conner@jboss.com'>Kevin Conner</a>
 */
public class JbpmAsyncUnitTest extends JBossTestCase
{
    /**
     * The name of the deployment archive.
     */
    private static final String ESB_ARCHIVE = "jbpm-async-test.esb" ;
    
    /**
     * Construct the test case with the specified name.
     * @param name The name of the test case.
     */
    public JbpmAsyncUnitTest(final String name)
    {
        super(name) ;
    }
    
    /**
     * Test for normal asynchronous callback.
     * @throws Exception For any failures.
     */
    public void testAsyncCallback()
        throws Exception
    {
        execute("setSuspendProcess", new Object[] {Boolean.FALSE}, new String[] {Boolean.TYPE.getName()}) ;
        execute("startProcess", null, null) ;
        
        final Boolean result = (Boolean)execute("checkWaitingAction", new Object[] {new Long(10000L)}, new String[] {Long.TYPE.getName()}) ;
        assertEquals("checkWaitingAction", Boolean.TRUE, result) ;
    }
    /**
     * Test for asynchronous callback on a suspended process.
     * @throws Exception For any failures.
     */
    public void testSuspendedAsyncCallback()
        throws Exception
    {
        execute("setSuspendProcess", new Object[] {Boolean.TRUE}, new String[] {Boolean.TYPE.getName()}) ;
        execute("startProcess", null, null) ;
        
        final Boolean suspendedResult = (Boolean)execute("checkWaitingAction", new Object[] {new Long(10000L)}, new String[] {Long.TYPE.getName()}) ;
        assertEquals("checkWaitingAction", Boolean.FALSE, suspendedResult) ;
        
        execute("resumeProcessInstance", null, null) ;
        
        final Boolean resumedResult = (Boolean)execute("checkWaitingAction", new Object[] {new Long(30000L)}, new String[] {Long.TYPE.getName()}) ;
        assertEquals("checkWaitingAction", Boolean.TRUE, resumedResult) ;
    }
    
    /**
     * Execute the specified method on the mbean.
     * @param method The method name.
     * @param values The parmeter values.
     * @param types The parameter types.
     * @return The method return value.
     * @throws Exception For errors during invocation.
     */
    private Object execute(final String method, final Object[] values, final String[] types)
        throws Exception
    {
        return getServer().invoke(new ObjectName(JbpmServerMBean.OBJECT_NAME), method, values, types) ;
    }
    
    /**
     * Create the test suite.
     * @return The suite representing this test case.
     */
    public static Test suite()
        throws Exception
    {
        return getDeploySetup(JbpmAsyncUnitTest.class, ESB_ARCHIVE);
    }
}
