/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.Reader;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.query.TextFilter;
import org.apache.jackrabbit.core.query.lucene.DateField;
import org.apache.jackrabbit.core.query.lucene.DoubleField;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.LongField;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.name.NameFormat;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.Path;
import org.apache.jackrabbit.name.PathFormat;
import org.apache.jackrabbit.name.QName;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeIndexer {
    private static final Logger log = LoggerFactory.getLogger((Class)NodeIndexer.class);
    protected final NodeState node;
    protected final ItemStateManager stateProvider;
    protected final NamespaceMappings mappings;
    protected final List textFilters;

    protected NodeIndexer(NodeState node, ItemStateManager stateProvider, NamespaceMappings mappings, List textFilters) {
        this.node = node;
        this.stateProvider = stateProvider;
        this.mappings = mappings;
        this.textFilters = textFilters;
    }

    public static Document createDocument(NodeState node, ItemStateManager stateProvider, NamespaceMappings mappings, List textFilters) throws RepositoryException {
        NodeIndexer indexer = new NodeIndexer(node, stateProvider, mappings, textFilters);
        return indexer.createDoc();
    }

    protected Document createDoc() throws RepositoryException {
        Document doc = new Document();
        doc.add(new Field(FieldNames.UUID, this.node.getNodeId().getUUID().toString(), Field.Store.YES, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
        try {
            if (this.node.getParentId() == null) {
                doc.add(new Field(FieldNames.PARENT, "", Field.Store.YES, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                doc.add(new Field(FieldNames.LABEL, "", Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
            } else {
                doc.add(new Field(FieldNames.PARENT, this.node.getParentId().toString(), Field.Store.YES, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                NodeState parent = (NodeState)this.stateProvider.getItemState(this.node.getParentId());
                NodeState.ChildNodeEntry child = parent.getChildNodeEntry(this.node.getNodeId());
                String name = NameFormat.format((QName)child.getName(), (NamespaceResolver)this.mappings);
                doc.add(new Field(FieldNames.LABEL, name, Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
            }
        }
        catch (NoSuchItemStateException e) {
            this.throwRepositoryException((Exception)((Object)e));
        }
        catch (ItemStateException e) {
            this.throwRepositoryException((Exception)((Object)e));
        }
        catch (NoPrefixDeclaredException e) {
            // empty catch block
        }
        Set props = this.node.getPropertyNames();
        Iterator it = props.iterator();
        while (it.hasNext()) {
            QName propName = (QName)it.next();
            PropertyId id = new PropertyId(this.node.getNodeId(), propName);
            try {
                PropertyState propState = (PropertyState)this.stateProvider.getItemState(id);
                InternalValue[] values = propState.getValues();
                for (int i = 0; i < values.length; ++i) {
                    this.addValue(doc, values[i], propState.getName());
                }
                if (values.length <= 1) continue;
                this.addMVPName(doc, propState.getName());
            }
            catch (NoSuchItemStateException e) {
                this.throwRepositoryException((Exception)((Object)e));
            }
            catch (ItemStateException e) {
                this.throwRepositoryException((Exception)((Object)e));
            }
        }
        return doc;
    }

    private void throwRepositoryException(Exception e) throws RepositoryException {
        String msg = "Error while indexing node: " + this.node.getNodeId() + " of " + "type: " + this.node.getNodeTypeName();
        throw new RepositoryException(msg, (Throwable)e);
    }

    private void addMVPName(Document doc, QName name) {
        try {
            String propName = NameFormat.format((QName)name, (NamespaceResolver)this.mappings);
            doc.add(new Field(FieldNames.MVP, propName, Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
        }
        catch (NoPrefixDeclaredException noPrefixDeclaredException) {
            // empty catch block
        }
    }

    private void addValue(Document doc, InternalValue value, QName name) {
        String fieldName = name.getLocalName();
        try {
            fieldName = NameFormat.format((QName)name, (NamespaceResolver)this.mappings);
        }
        catch (NoPrefixDeclaredException e) {
            // empty catch block
        }
        Object internalValue = value.internalValue();
        switch (value.getType()) {
            case 2: {
                this.addBinaryValue(doc, fieldName, internalValue);
                break;
            }
            case 6: {
                this.addBooleanValue(doc, fieldName, internalValue);
                break;
            }
            case 5: {
                this.addCalendarValue(doc, fieldName, internalValue);
                break;
            }
            case 4: {
                this.addDoubleValue(doc, fieldName, internalValue);
                break;
            }
            case 3: {
                this.addLongValue(doc, fieldName, internalValue);
                break;
            }
            case 9: {
                this.addReferenceValue(doc, fieldName, internalValue);
                break;
            }
            case 8: {
                this.addPathValue(doc, fieldName, internalValue);
                break;
            }
            case 1: {
                boolean tokenize = !name.equals((Object)QName.JCR_UUID);
                this.addStringValue(doc, fieldName, internalValue, tokenize);
                break;
            }
            case 7: {
                this.addNameValue(doc, fieldName, internalValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal internal value type");
            }
        }
    }

    protected void addBinaryValue(Document doc, String fieldName, Object internalValue) {
        try {
            String jcrData = this.mappings.getPrefix("http://www.jcp.org/jcr/1.0") + ":data";
            if (!jcrData.equals(fieldName)) {
                return;
            }
            if (this.node.hasPropertyName(QName.JCR_MIMETYPE)) {
                PropertyState dataProp = (PropertyState)this.stateProvider.getItemState(new PropertyId(this.node.getNodeId(), QName.JCR_DATA));
                PropertyState mimeTypeProp = (PropertyState)this.stateProvider.getItemState(new PropertyId(this.node.getNodeId(), QName.JCR_MIMETYPE));
                String encoding = null;
                if (this.node.hasPropertyName(QName.JCR_ENCODING)) {
                    PropertyState encodingProp = (PropertyState)this.stateProvider.getItemState(new PropertyId(this.node.getNodeId(), QName.JCR_ENCODING));
                    encoding = encodingProp.getValues()[0].internalValue().toString();
                }
                String mimeType = mimeTypeProp.getValues()[0].internalValue().toString();
                Map fields = Collections.EMPTY_MAP;
                Iterator<Object> it = this.textFilters.iterator();
                while (it.hasNext()) {
                    TextFilter filter = (TextFilter)it.next();
                    if (!filter.canFilter(mimeType)) continue;
                    fields = filter.doFilter(dataProp, encoding);
                    break;
                }
                it = fields.keySet().iterator();
                while (it.hasNext()) {
                    String field = (String)it.next();
                    Reader r = (Reader)fields.get(field);
                    doc.add(new Field(field, r));
                }
            }
        }
        catch (Exception e) {
            log.warn("Exception while indexing binary property: " + e.toString());
            log.debug("Dump: ", (Throwable)e);
        }
    }

    protected void addBooleanValue(Document doc, String fieldName, Object internalValue) {
        doc.add(new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, internalValue.toString()), Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
    }

    protected void addCalendarValue(Document doc, String fieldName, Object internalValue) {
        long millis = ((Calendar)internalValue).getTimeInMillis();
        doc.add(new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, DateField.timeToString(millis)), Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
    }

    protected void addDoubleValue(Document doc, String fieldName, Object internalValue) {
        double doubleVal = (Double)internalValue;
        doc.add(new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, DoubleField.doubleToString(doubleVal)), Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
    }

    protected void addLongValue(Document doc, String fieldName, Object internalValue) {
        long longVal = (Long)internalValue;
        doc.add(new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, LongField.longToString(longVal)), Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
    }

    protected void addReferenceValue(Document doc, String fieldName, Object internalValue) {
        String uuid = internalValue.toString();
        doc.add(new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, uuid), Field.Store.YES, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
    }

    protected void addPathValue(Document doc, String fieldName, Object internalValue) {
        Path path = (Path)internalValue;
        String pathString = path.toString();
        try {
            pathString = PathFormat.format((Path)path, (NamespaceResolver)this.mappings);
        }
        catch (NoPrefixDeclaredException e) {
            // empty catch block
        }
        doc.add(new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, pathString), Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
    }

    protected void addStringValue(Document doc, String fieldName, Object internalValue) {
        this.addStringValue(doc, fieldName, internalValue, true);
    }

    protected void addStringValue(Document doc, String fieldName, Object internalValue, boolean tokenized) {
        String stringValue = String.valueOf(internalValue);
        doc.add(new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, stringValue), Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
        if (tokenized) {
            doc.add(new Field(FieldNames.FULLTEXT, stringValue, Field.Store.NO, Field.Index.TOKENIZED, Field.TermVector.NO));
            int idx = fieldName.indexOf(58);
            fieldName = fieldName.substring(0, idx + 1) + "FULL:" + fieldName.substring(idx + 1);
            doc.add(new Field(fieldName, stringValue, Field.Store.NO, Field.Index.TOKENIZED, Field.TermVector.NO));
        }
    }

    protected void addNameValue(Document doc, String fieldName, Object internalValue) {
        QName qualiName = (QName)internalValue;
        String normValue = internalValue.toString();
        try {
            normValue = this.mappings.getPrefix(qualiName.getNamespaceURI()) + ":" + qualiName.getLocalName();
        }
        catch (NamespaceException e) {
            // empty catch block
        }
        doc.add(new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, normValue), Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
    }
}

