/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.io.Serializable;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.uuid.UUID;

public class NodeReferencesId
implements Serializable {
    static final long serialVersionUID = -3819311769214730025L;
    private final NodeId targetId;

    public NodeReferencesId(UUID uuid) {
        this.targetId = new NodeId(uuid);
    }

    public NodeReferencesId(NodeId targetId) {
        if (targetId == null) {
            throw new IllegalArgumentException("targetId must not be null");
        }
        this.targetId = targetId;
    }

    public NodeId getTargetId() {
        return this.targetId;
    }

    public static NodeReferencesId valueOf(String s) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException("invalid NodeReferencesId literal");
        }
        return new NodeReferencesId(NodeId.valueOf(s));
    }

    public String toString() {
        return this.targetId.toString();
    }

    public int hashCode() {
        return this.targetId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NodeReferencesId) {
            return this.targetId.getUUID().equals((Object)((NodeReferencesId)obj).targetId.getUUID());
        }
        return false;
    }
}

