/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.OrderedMapIterator;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.nodetype.NodeDefId;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.NodeStateListener;
import org.apache.jackrabbit.name.QName;

public class NodeState
extends ItemState {
    static final long serialVersionUID = 4392375681805781770L;
    private QName nodeTypeName;
    private Set mixinTypeNames = Collections.EMPTY_SET;
    private NodeId id;
    private NodeId parentId;
    private NodeDefId defId;
    private ChildNodeEntries childNodeEntries = new ChildNodeEntries();
    private boolean sharedChildNodeEntries = false;
    private HashSet propertyNames = new HashSet();
    private boolean sharedPropertyNames = false;
    private transient NodeStateListener listener;
    static /* synthetic */ Class class$org$apache$jackrabbit$core$state$NodeState$ChildNodeEntry;

    public NodeState(NodeState overlayedState, int initialStatus, boolean isTransient) {
        super(overlayedState, initialStatus, isTransient);
        this.pull();
    }

    public NodeState(NodeId id, QName nodeTypeName, NodeId parentId, int initialStatus, boolean isTransient) {
        super(initialStatus, isTransient);
        this.id = id;
        this.parentId = parentId;
        this.nodeTypeName = nodeTypeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void copy(ItemState state) {
        ItemState itemState = state;
        synchronized (itemState) {
            NodeState nodeState = (NodeState)state;
            this.id = nodeState.id;
            this.parentId = nodeState.parentId;
            this.nodeTypeName = nodeState.nodeTypeName;
            this.mixinTypeNames = nodeState.mixinTypeNames;
            this.defId = nodeState.defId;
            this.propertyNames = nodeState.propertyNames;
            this.sharedPropertyNames = true;
            nodeState.sharedPropertyNames = true;
            this.childNodeEntries = nodeState.childNodeEntries;
            this.sharedChildNodeEntries = true;
            nodeState.sharedChildNodeEntries = true;
        }
    }

    public final boolean isNode() {
        return true;
    }

    public NodeId getParentId() {
        return this.parentId;
    }

    public ItemId getId() {
        return this.id;
    }

    public NodeId getNodeId() {
        return this.id;
    }

    public void setParentId(NodeId parentId) {
        this.parentId = parentId;
    }

    public QName getNodeTypeName() {
        return this.nodeTypeName;
    }

    public synchronized Set getMixinTypeNames() {
        return Collections.unmodifiableSet(this.mixinTypeNames);
    }

    public synchronized void setMixinTypeNames(Set names) {
        this.mixinTypeNames = names instanceof HashSet ? (Set)((HashSet)names).clone() : new HashSet(names);
    }

    public NodeDefId getDefinitionId() {
        return this.defId;
    }

    public void setDefinitionId(NodeDefId defId) {
        this.defId = defId;
    }

    public boolean hasChildNodeEntries() {
        return !this.childNodeEntries.isEmpty();
    }

    public synchronized boolean hasChildNodeEntry(QName name) {
        return !this.childNodeEntries.get(name).isEmpty();
    }

    public synchronized boolean hasChildNodeEntry(NodeId id) {
        return this.childNodeEntries.get(id) != null;
    }

    public synchronized boolean hasChildNodeEntry(QName name, int index) {
        return this.childNodeEntries.get(name, index) != null;
    }

    public synchronized boolean hasPropertyName(QName propName) {
        return this.propertyNames.contains(propName);
    }

    public synchronized ChildNodeEntry getChildNodeEntry(QName nodeName, int index) {
        return this.childNodeEntries.get(nodeName, index);
    }

    public synchronized ChildNodeEntry getChildNodeEntry(NodeId id) {
        return this.childNodeEntries.get(id);
    }

    public synchronized List getChildNodeEntries() {
        return this.childNodeEntries;
    }

    public synchronized List getChildNodeEntries(QName nodeName) {
        return this.childNodeEntries.get(nodeName);
    }

    public synchronized ChildNodeEntry addChildNodeEntry(QName nodeName, NodeId id) {
        if (this.sharedChildNodeEntries) {
            this.childNodeEntries = (ChildNodeEntries)this.childNodeEntries.clone();
            this.sharedChildNodeEntries = false;
        }
        ChildNodeEntry entry = this.childNodeEntries.add(nodeName, id);
        this.notifyNodeAdded(entry);
        return entry;
    }

    public synchronized boolean renameChildNodeEntry(QName oldName, int index, QName newName) {
        ChildNodeEntry oldEntry;
        if (this.sharedChildNodeEntries) {
            this.childNodeEntries = (ChildNodeEntries)this.childNodeEntries.clone();
            this.sharedChildNodeEntries = false;
        }
        if ((oldEntry = this.childNodeEntries.remove(oldName, index)) != null) {
            ChildNodeEntry newEntry = this.childNodeEntries.add(newName, oldEntry.getId());
            this.notifyNodeAdded(newEntry);
            this.notifyNodeRemoved(oldEntry);
            return true;
        }
        return false;
    }

    public synchronized boolean removeChildNodeEntry(QName nodeName, int index) {
        ChildNodeEntry entry;
        if (this.sharedChildNodeEntries) {
            this.childNodeEntries = (ChildNodeEntries)this.childNodeEntries.clone();
            this.sharedChildNodeEntries = false;
        }
        if ((entry = this.childNodeEntries.remove(nodeName, index)) != null) {
            this.notifyNodeRemoved(entry);
        }
        return entry != null;
    }

    public synchronized boolean removeChildNodeEntry(NodeId id) {
        ChildNodeEntry entry;
        if (this.sharedChildNodeEntries) {
            this.childNodeEntries = (ChildNodeEntries)this.childNodeEntries.clone();
            this.sharedChildNodeEntries = false;
        }
        if ((entry = this.childNodeEntries.remove(id)) != null) {
            this.notifyNodeRemoved(entry);
        }
        return entry != null;
    }

    public synchronized void removeAllChildNodeEntries() {
        if (this.sharedChildNodeEntries) {
            this.childNodeEntries = (ChildNodeEntries)this.childNodeEntries.clone();
            this.sharedChildNodeEntries = false;
        }
        this.childNodeEntries.removeAll();
    }

    public synchronized void setChildNodeEntries(List nodeEntries) {
        if (nodeEntries instanceof ChildNodeEntries) {
            ChildNodeEntries entries = (ChildNodeEntries)nodeEntries;
            this.childNodeEntries = (ChildNodeEntries)entries.clone();
            this.sharedChildNodeEntries = false;
        } else {
            if (this.sharedChildNodeEntries) {
                this.childNodeEntries = new ChildNodeEntries();
                this.sharedChildNodeEntries = false;
            } else {
                this.childNodeEntries.removeAll();
            }
            this.childNodeEntries.addAll(nodeEntries);
        }
        this.notifyNodesReplaced();
    }

    public synchronized Set getPropertyNames() {
        return Collections.unmodifiableSet(this.propertyNames);
    }

    public synchronized void addPropertyName(QName propName) {
        if (this.sharedPropertyNames) {
            this.propertyNames = (HashSet)this.propertyNames.clone();
            this.sharedPropertyNames = false;
        }
        this.propertyNames.add(propName);
    }

    public synchronized boolean removePropertyName(QName propName) {
        if (this.sharedPropertyNames) {
            this.propertyNames = (HashSet)this.propertyNames.clone();
            this.sharedPropertyNames = false;
        }
        return this.propertyNames.remove(propName);
    }

    public synchronized void removeAllPropertyNames() {
        if (this.sharedPropertyNames) {
            this.propertyNames = new HashSet();
            this.sharedPropertyNames = false;
        } else {
            this.propertyNames.clear();
        }
    }

    public synchronized void setPropertyNames(Set propNames) {
        if (propNames instanceof HashSet) {
            HashSet names = (HashSet)propNames;
            this.propertyNames = (HashSet)names.clone();
            this.sharedPropertyNames = false;
        } else {
            if (this.sharedPropertyNames) {
                this.propertyNames = new HashSet();
                this.sharedPropertyNames = false;
            } else {
                this.propertyNames.clear();
            }
            this.propertyNames.addAll(propNames);
        }
    }

    public synchronized void setNodeTypeName(QName nodeTypeName) {
        this.nodeTypeName = nodeTypeName;
    }

    public synchronized Set getAddedPropertyNames() {
        if (!this.hasOverlayedState()) {
            return Collections.unmodifiableSet(this.propertyNames);
        }
        NodeState other = (NodeState)this.getOverlayedState();
        HashSet set = new HashSet(this.propertyNames);
        set.removeAll(other.propertyNames);
        return set;
    }

    public synchronized List getAddedChildNodeEntries() {
        if (!this.hasOverlayedState()) {
            return this.childNodeEntries;
        }
        NodeState other = (NodeState)this.getOverlayedState();
        return this.childNodeEntries.removeAll(other.childNodeEntries);
    }

    public synchronized Set getRemovedPropertyNames() {
        if (!this.hasOverlayedState()) {
            return Collections.EMPTY_SET;
        }
        NodeState other = (NodeState)this.getOverlayedState();
        HashSet set = new HashSet(other.propertyNames);
        set.removeAll(this.propertyNames);
        return set;
    }

    public synchronized List getRemovedChildNodeEntries() {
        if (!this.hasOverlayedState()) {
            return Collections.EMPTY_LIST;
        }
        NodeState other = (NodeState)this.getOverlayedState();
        return other.childNodeEntries.removeAll(this.childNodeEntries);
    }

    public synchronized List getReorderedChildNodeEntries() {
        if (!this.hasOverlayedState()) {
            return Collections.EMPTY_LIST;
        }
        ChildNodeEntries otherChildNodeEntries = ((NodeState)this.overlayedState).childNodeEntries;
        if (this.childNodeEntries.isEmpty() || otherChildNodeEntries.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List ours = this.childNodeEntries.retainAll(otherChildNodeEntries);
        List others = otherChildNodeEntries.retainAll(this.childNodeEntries);
        ArrayList<ChildNodeEntry> reordered = null;
        int i = 0;
        while (i < ours.size()) {
            int j;
            ChildNodeEntry other;
            ChildNodeEntry entry = (ChildNodeEntry)ours.get(i);
            if (entry == (other = (ChildNodeEntry)others.get(i)) || entry.getId().equals(other.getId())) {
                ++i;
                continue;
            }
            if (reordered == null) {
                reordered = new ArrayList<ChildNodeEntry>();
            }
            if (i + 1 < ours.size() && entry.getId().equals(((ChildNodeEntry)others.get(i + 1)).getId())) {
                for (j = i; j < ours.size(); ++j) {
                    if (!((ChildNodeEntry)ours.get(j)).getId().equals(other.getId())) continue;
                    entry = (ChildNodeEntry)ours.get(j);
                    break;
                }
            }
            reordered.add(entry);
            for (j = i; j < ours.size(); ++j) {
                if (!((ChildNodeEntry)ours.get(j)).getId().equals(entry.getId())) continue;
                ours.remove(j);
            }
            for (j = i; j < ours.size(); ++j) {
                if (!((ChildNodeEntry)others.get(j)).getId().equals(entry.getId())) continue;
                others.remove(j);
            }
        }
        if (reordered == null) {
            return Collections.EMPTY_LIST;
        }
        return reordered;
    }

    public void setContainer(ItemStateListener listener) {
        if (listener instanceof NodeStateListener) {
            if (this.listener != null) {
                throw new IllegalStateException("State already connected to a listener: " + this.listener);
            }
            this.listener = (NodeStateListener)listener;
        }
        super.setContainer(listener);
    }

    public long calculateMemoryFootprint() {
        return 350 + this.mixinTypeNames.size() * 250 + this.childNodeEntries.size() * 300 + this.propertyNames.size() * 250;
    }

    protected void notifyNodeAdded(ChildNodeEntry added) {
        if (this.listener != null) {
            this.listener.nodeAdded(this, added.getName(), added.getIndex(), added.getId());
        }
    }

    protected void notifyNodesReplaced() {
        if (this.listener != null) {
            this.listener.nodesReplaced(this);
        }
    }

    protected void notifyNodeRemoved(ChildNodeEntry removed) {
        if (this.listener != null) {
            this.listener.nodeRemoved(this, removed.getName(), removed.getIndex(), removed.getId());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public static final class ChildNodeEntry {
        private int hash = 0;
        private final QName name;
        private final int index;
        private final NodeId id;

        private ChildNodeEntry(QName name, NodeId id, int index) {
            if (name == null) {
                throw new IllegalArgumentException("name can not be null");
            }
            this.name = name;
            if (id == null) {
                throw new IllegalArgumentException("id can not be null");
            }
            this.id = id;
            if (index < 1) {
                throw new IllegalArgumentException("index is 1-based");
            }
            this.index = index;
        }

        public NodeId getId() {
            return this.id;
        }

        public QName getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ChildNodeEntry) {
                ChildNodeEntry other = (ChildNodeEntry)obj;
                return this.name.equals((Object)other.name) && this.id.equals(other.id) && this.index == other.index;
            }
            return false;
        }

        public String toString() {
            return this.name.toString() + "[" + this.index + "] -> " + this.id;
        }

        public int hashCode() {
            int h = this.hash;
            if (h == 0) {
                h = 17;
                h = 37 * h + this.name.hashCode();
                h = 37 * h + this.id.hashCode();
                this.hash = h = 37 * h + this.index;
            }
            return h;
        }
    }

    private static class ChildNodeEntries
    implements List,
    Cloneable,
    Serializable {
        private LinkedMap entries = new LinkedMap();
        private HashMap nameMap = new HashMap();

        ChildNodeEntries() {
        }

        ChildNodeEntry get(NodeId id) {
            return (ChildNodeEntry)this.entries.get((Object)id);
        }

        List get(QName nodeName) {
            Object obj = this.nameMap.get(nodeName);
            if (obj == null) {
                return Collections.EMPTY_LIST;
            }
            if (obj instanceof ArrayList) {
                return Collections.unmodifiableList((ArrayList)obj);
            }
            return Collections.singletonList(obj);
        }

        ChildNodeEntry get(QName nodeName, int index) {
            if (index < 1) {
                throw new IllegalArgumentException("index is 1-based");
            }
            Object obj = this.nameMap.get(nodeName);
            if (obj == null) {
                return null;
            }
            if (obj instanceof ArrayList) {
                ArrayList siblings = (ArrayList)obj;
                if (index <= siblings.size()) {
                    return (ChildNodeEntry)siblings.get(index - 1);
                }
            } else if (index == 1) {
                return (ChildNodeEntry)obj;
            }
            return null;
        }

        ChildNodeEntry add(QName nodeName, NodeId id) {
            ArrayList<Object> siblings = null;
            int index = 0;
            Object obj = this.nameMap.get(nodeName);
            if (obj != null) {
                if (obj instanceof ArrayList) {
                    siblings = (ArrayList<Object>)obj;
                } else {
                    siblings = new ArrayList<Object>();
                    siblings.add(obj);
                    this.nameMap.put(nodeName, siblings);
                }
                index = siblings.size();
            }
            ChildNodeEntry entry = new ChildNodeEntry(nodeName, id, ++index);
            if (siblings != null) {
                siblings.add(entry);
            } else {
                this.nameMap.put(nodeName, entry);
            }
            this.entries.put((Object)id, (Object)entry);
            return entry;
        }

        void addAll(List entriesList) {
            Iterator iter = entriesList.iterator();
            while (iter.hasNext()) {
                ChildNodeEntry entry = (ChildNodeEntry)iter.next();
                this.add(entry.getName(), entry.getId());
            }
        }

        public ChildNodeEntry remove(QName nodeName, int index) {
            if (index < 1) {
                throw new IllegalArgumentException("index is 1-based");
            }
            Object obj = this.nameMap.get(nodeName);
            if (obj == null) {
                return null;
            }
            if (obj instanceof ChildNodeEntry) {
                if (index != 1) {
                    return null;
                }
                ChildNodeEntry removedEntry = (ChildNodeEntry)obj;
                this.nameMap.remove(nodeName);
                this.entries.remove((Object)removedEntry.getId());
                return removedEntry;
            }
            ArrayList siblings = (ArrayList)obj;
            if (index > siblings.size()) {
                return null;
            }
            ChildNodeEntry removedEntry = (ChildNodeEntry)siblings.remove(index - 1);
            this.entries.remove((Object)removedEntry.getId());
            for (int i = index - 1; i < siblings.size(); ++i) {
                ChildNodeEntry oldEntry = (ChildNodeEntry)siblings.get(i);
                ChildNodeEntry newEntry = new ChildNodeEntry(nodeName, oldEntry.getId(), oldEntry.getIndex() - 1);
                siblings.set(i, newEntry);
                this.entries.put((Object)newEntry.getId(), (Object)newEntry);
            }
            if (siblings.size() == 0) {
                this.nameMap.remove(nodeName);
            } else if (siblings.size() == 1) {
                this.nameMap.put(nodeName, siblings.get(0));
            }
            return removedEntry;
        }

        ChildNodeEntry remove(NodeId id) {
            ChildNodeEntry entry = (ChildNodeEntry)this.entries.get((Object)id);
            if (entry != null) {
                return this.remove(entry.getName(), entry.getIndex());
            }
            return entry;
        }

        public ChildNodeEntry remove(ChildNodeEntry entry) {
            return this.remove(entry.getName(), entry.getIndex());
        }

        public void removeAll() {
            this.nameMap.clear();
            this.entries.clear();
        }

        List removeAll(ChildNodeEntries other) {
            if (this.entries.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            if (other.isEmpty()) {
                return this;
            }
            ArrayList<ChildNodeEntry> result = new ArrayList<ChildNodeEntry>();
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                ChildNodeEntry otherEntry;
                ChildNodeEntry entry = (ChildNodeEntry)iter.next();
                if (entry == (otherEntry = other.get(entry.getId())) || otherEntry != null && entry.getName().equals((Object)otherEntry.getName())) continue;
                result.add(entry);
            }
            return result;
        }

        List retainAll(ChildNodeEntries other) {
            if (this.entries.isEmpty() || other.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<ChildNodeEntry> result = new ArrayList<ChildNodeEntry>();
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                ChildNodeEntry otherEntry;
                ChildNodeEntry entry = (ChildNodeEntry)iter.next();
                if (entry == (otherEntry = other.get(entry.getId()))) {
                    result.add(entry);
                    continue;
                }
                if (otherEntry == null || !entry.getName().equals((Object)otherEntry.getName())) continue;
                result.add(entry);
            }
            return result;
        }

        public boolean contains(Object o) {
            if (o instanceof ChildNodeEntry) {
                return this.entries.containsKey((Object)((ChildNodeEntry)o).getId());
            }
            return false;
        }

        public boolean containsAll(Collection c) {
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                if (this.contains(iter.next())) continue;
                return false;
            }
            return true;
        }

        public Object get(int index) {
            return this.entries.getValue(index);
        }

        public int indexOf(Object o) {
            if (o instanceof ChildNodeEntry) {
                return this.entries.indexOf((Object)((ChildNodeEntry)o).getId());
            }
            return -1;
        }

        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        public int lastIndexOf(Object o) {
            return this.indexOf(o);
        }

        public Iterator iterator() {
            return new EntriesIterator();
        }

        public ListIterator listIterator() {
            return new EntriesIterator();
        }

        public ListIterator listIterator(int index) {
            if (index < 0 || index >= this.entries.size()) {
                throw new IndexOutOfBoundsException();
            }
            EntriesIterator iter = new EntriesIterator();
            while (index-- > 0) {
                iter.next();
            }
            return iter;
        }

        public int size() {
            return this.entries.size();
        }

        public List subList(int fromIndex, int toIndex) {
            return Collections.unmodifiableList(new ArrayList(this).subList(fromIndex, toIndex));
        }

        public Object[] toArray() {
            Object[] array = new ChildNodeEntry[this.size()];
            return this.toArray(array);
        }

        public Object[] toArray(Object[] a) {
            if (!a.getClass().getComponentType().isAssignableFrom(class$org$apache$jackrabbit$core$state$NodeState$ChildNodeEntry == null ? (class$org$apache$jackrabbit$core$state$NodeState$ChildNodeEntry = NodeState.class$("org.apache.jackrabbit.core.state.NodeState$ChildNodeEntry")) : class$org$apache$jackrabbit$core$state$NodeState$ChildNodeEntry)) {
                throw new ArrayStoreException();
            }
            if (a.length < this.size()) {
                a = new ChildNodeEntry[this.size()];
            }
            MapIterator iter = this.entries.mapIterator();
            int i = 0;
            while (iter.hasNext()) {
                iter.next();
                a[i] = this.entries.getValue(i);
                ++i;
            }
            while (i < a.length) {
                a[i++] = null;
            }
            return a;
        }

        public void add(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Object remove(int index) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public Object set(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeShort(this.size());
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                ChildNodeEntry entry = (ChildNodeEntry)iter.next();
                out.writeUTF(entry.getName().toString());
                out.writeUTF(entry.getId().toString());
            }
        }

        private void readObject(ObjectInputStream in) throws IOException {
            this.entries = new LinkedMap();
            this.nameMap = new HashMap();
            int count = in.readShort();
            for (int i = 0; i < count; ++i) {
                QName name = QName.valueOf((String)in.readUTF());
                String s = in.readUTF();
                this.add(name, NodeId.valueOf(s));
            }
        }

        protected Object clone() {
            ChildNodeEntries clone = new ChildNodeEntries();
            clone.entries = (LinkedMap)this.entries.clone();
            clone.nameMap = new HashMap(this.nameMap.size());
            Iterator it = this.nameMap.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                Object obj = this.nameMap.get(key);
                if (obj instanceof ArrayList) {
                    obj = ((ArrayList)obj).clone();
                }
                clone.nameMap.put(key, obj);
            }
            return clone;
        }

        class EntriesIterator
        implements ListIterator {
            private final OrderedMapIterator mapIter;

            EntriesIterator() {
                this.mapIter = ChildNodeEntries.this.entries.orderedMapIterator();
            }

            public boolean hasNext() {
                return this.mapIter.hasNext();
            }

            public Object next() {
                this.mapIter.next();
                return this.mapIter.getValue();
            }

            public boolean hasPrevious() {
                return this.mapIter.hasPrevious();
            }

            public int nextIndex() {
                return ChildNodeEntries.this.entries.indexOf(this.mapIter.getKey()) + 1;
            }

            public Object previous() {
                this.mapIter.previous();
                return this.mapIter.getValue();
            }

            public int previousIndex() {
                return ChildNodeEntries.this.entries.indexOf(this.mapIter.getKey()) - 1;
            }

            public void add(Object o) {
                throw new UnsupportedOperationException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void set(Object o) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

