/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.common;

import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.stats.Stats;
import com.sun.identity.shared.stats.StatsListener;

public class CacheStats
implements StatsListener {
    String name;
    int intervalCount = 0;
    int cacheSize = 0;
    long totalGetRequests = 0L;
    long totalCacheHits = 0L;
    long totalIntervalHits = 0L;
    Debug debug;
    private static Stats stats = null;
    private static final String CACHE_STATS_FILE_NAME = "amSDKStats";

    public static CacheStats createInstance(String instanceName, Debug debugObject) {
        CacheStats cStats = new CacheStats(instanceName, debugObject);
        if (stats.isEnabled()) {
            stats.addStatsListener(cStats);
        }
        return cStats;
    }

    public CacheStats(String instanceName, Debug debugObject) {
        this.name = instanceName;
        this.debug = debugObject;
        if (this.debug.messageEnabled()) {
            this.debug.message("CacheStats() Stats : " + stats.isEnabled());
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHitCount(int sizeOfCache) {
        if (stats.isEnabled()) {
            CacheStats cacheStats = this;
            synchronized (cacheStats) {
                ++this.totalCacheHits;
                ++this.totalIntervalHits;
                this.cacheSize = sizeOfCache;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRequestCount(int sizeOfCache) {
        if (stats.isEnabled()) {
            CacheStats cacheStats = this;
            synchronized (cacheStats) {
                ++this.totalGetRequests;
                ++this.intervalCount;
                this.cacheSize = sizeOfCache;
            }
        }
    }

    protected synchronized int getIntervalCount() {
        return this.intervalCount;
    }

    public synchronized void printStats() {
        stats.record("SDK Cache Statistics\n--------------------\nNumber of requests during this interval: " + this.intervalCount + "\nNumber of Cache Hits during this interval: " + this.totalIntervalHits + "\nHit ratio for this interval: " + (double)this.totalIntervalHits / (double)this.intervalCount + "\nTotal number of requests since server start: " + this.totalGetRequests + "\nTotal number of Cache Hits since server start: " + this.totalCacheHits + "\nOverall Hit ratio: " + (double)this.totalCacheHits / (double)this.totalGetRequests + "\nTotal Cache Size: " + this.cacheSize + "\n");
        this.intervalCount = 0;
        this.totalIntervalHits = 0L;
    }

    static {
        stats = Stats.getInstance(CACHE_STATS_FILE_NAME);
    }
}

