/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.client;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.comm.client.AlreadyRegisteredException;
import com.iplanet.services.comm.client.NotificationHandler;
import com.iplanet.services.comm.client.SendRequestException;
import com.iplanet.services.comm.share.PLLBundle;
import com.iplanet.services.comm.share.RequestSet;
import com.iplanet.services.comm.share.ResponseSet;
import com.iplanet.services.naming.WebtopNaming;
import com.sun.identity.common.HttpURLConnectionManager;
import com.sun.identity.shared.debug.Debug;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.Cookie;

public class PLLClient {
    private static Hashtable notificationHandlers = new Hashtable();
    private static Debug debug = Debug.getInstance("PLLClient");
    private static boolean useCache = Boolean.getBoolean(SystemProperties.get("com.sun.identity.urlconnection.useCache", "false"));

    public static Vector send(URL url, RequestSet set) throws SendRequestException {
        return PLLClient.send(url, null, set, null);
    }

    public static Vector send(URL url, String cookies, RequestSet set) throws SendRequestException {
        return PLLClient.send(url, cookies, set, null);
    }

    public static Vector send(URL url, RequestSet set, HashMap cookieTable) throws SendRequestException {
        return PLLClient.send(url, null, set, cookieTable);
    }

    private static Vector send(URL url, String cookies, RequestSet set, HashMap cookieTable) throws SendRequestException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        BufferedReader in = null;
        try {
            int len;
            if (WebtopNaming.SiteMonitor.keepMonitoring && !WebtopNaming.SiteMonitor.isAvailable(url)) {
                debug.error("Site " + url.toString() + " is down.");
                throw new SendRequestException("Site is down.");
            }
            conn = HttpURLConnectionManager.getConnection(url);
            conn.setDoOutput(true);
            conn.setUseCaches(useCache);
            conn.setRequestMethod("POST");
            StringBuffer cookieStr = null;
            if (cookies != null) {
                cookieStr = new StringBuffer();
                cookieStr.append(cookies);
            }
            if (cookieTable != null && !cookieTable.isEmpty()) {
                Iterator it = cookieTable.values().iterator();
                while (it.hasNext()) {
                    Cookie cookie = (Cookie)it.next();
                    if (cookieStr == null) {
                        cookieStr = new StringBuffer();
                    } else {
                        cookieStr.append(";");
                    }
                    cookieStr.append(cookie.getName()).append("=").append(cookie.getValue());
                }
            }
            if (cookieStr != null) {
                cookies = cookieStr.toString();
                if (debug.messageEnabled()) {
                    debug.message("sending cookies: " + cookies);
                }
                conn.setRequestProperty("Cookie", cookies);
            }
            conn.setRequestProperty("Content-Type", "text/xml;charset=UTF-8");
            String xml = set.toXMLString();
            int requestLength = xml.getBytes("UTF-8").length;
            conn.setRequestProperty("Content-Length", Integer.toString(requestLength));
            out = conn.getOutputStream();
            out.write(xml.getBytes("UTF-8"));
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            StringBuffer in_buf = new StringBuffer();
            char[] buf = new char[1024];
            while ((len = in.read(buf, 0, buf.length)) != -1) {
                in_buf.append(buf, 0, len);
            }
            String in_string = in_buf.toString();
            Map<String, List<String>> headers = conn.getHeaderFields();
            if (cookieTable != null) {
                PLLClient.parseCookies(headers, cookieTable);
            }
            ResponseSet resset = ResponseSet.parseXML(in_string);
            Vector vector = resset.getResponses();
            return vector;
        }
        catch (Exception e) {
            debug.message("PLLClient send exception: ", e);
            throw new SendRequestException(e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new SendRequestException(e.getMessage());
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new SendRequestException(e.getMessage());
                }
            }
        }
    }

    public static void parseCookies(Map headers, HashMap cookieTable) {
        if (headers == null || headers.isEmpty()) {
            return;
        }
        if (debug.messageEnabled()) {
            debug.message("header in parseCookies(): " + headers);
        }
        Iterator hrs = headers.entrySet().iterator();
        while (hrs.hasNext()) {
            List list;
            Map.Entry me = hrs.next();
            String key = (String)me.getKey();
            if (key == null || !key.equalsIgnoreCase("Set-cookie") && !key.equalsIgnoreCase("cookie") || (list = (List)me.getValue()) == null || list.isEmpty()) continue;
            Cookie cookie = null;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                String nameValue;
                int index;
                StringTokenizer stz;
                String cookieStr = (String)it.next();
                if (debug.messageEnabled()) {
                    debug.message("cookie: " + cookieStr);
                }
                if (!(stz = new StringTokenizer(cookieStr, ";")).hasMoreTokens() || (index = (nameValue = stz.nextToken()).indexOf("=")) == -1) continue;
                String tmpName = nameValue.substring(0, index).trim();
                String value = nameValue.substring(index + 1);
                cookie = new Cookie(tmpName, value);
                cookieTable.put(tmpName, cookie);
            }
        }
    }

    public static void addNotificationHandler(String service, NotificationHandler handler) throws AlreadyRegisteredException {
        if (notificationHandlers.containsKey(service)) {
            throw new AlreadyRegisteredException(PLLBundle.getString("alreadyRegistered") + service);
        }
        notificationHandlers.put(service, handler);
    }

    public static void removeNotificationHandler(String service) {
        notificationHandlers.remove(service);
    }

    public static NotificationHandler getNotificationHandler(String service) {
        return (NotificationHandler)notificationHandlers.get(service);
    }
}

