/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.spi;

import com.sun.identity.shared.locale.AMResourceBundleCache;
import com.sun.identity.shared.locale.L10NMessage;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.security.auth.login.LoginException;

public class AuthLoginException
extends LoginException
implements L10NMessage {
    private String _message;
    private Throwable _nestedException;
    private static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    private String _bundleName = null;
    private String _errorCode = null;
    private Object[] _args = null;
    private ResourceBundle _bundle = null;

    public AuthLoginException(String message, Throwable nestedException) {
        this._message = message;
        this._nestedException = nestedException;
    }

    public AuthLoginException(Throwable nestedException) {
        this._nestedException = nestedException;
        if (nestedException instanceof L10NMessage) {
            this._errorCode = ((L10NMessage)((Object)nestedException)).getErrorCode();
        }
    }

    public AuthLoginException(String message) {
        this._message = message;
    }

    public AuthLoginException(String rbName, String errorCode, Object[] args, Throwable nestedException) {
        this._bundleName = rbName;
        this._errorCode = errorCode;
        this._args = args;
        this._nestedException = nestedException;
    }

    public AuthLoginException(String rbName, String errorCode, Object[] args) {
        this(rbName, errorCode, args, null);
    }

    public String getL10NMessage(Locale locale) {
        String result = this._message;
        if (this._bundleName != null && locale != null && this._errorCode != null) {
            this._bundle = amCache.getResBundle(this._bundleName, locale);
            String mid = this._bundle.getString(this._errorCode);
            result = this._args == null || this._args.length == 0 ? mid : MessageFormat.format(mid, this._args);
        }
        String chainedMessage = null;
        if (this._nestedException != null) {
            if (this._nestedException instanceof L10NMessage) {
                L10NMessage lex = (L10NMessage)((Object)this._nestedException);
                chainedMessage = lex.getL10NMessage(locale);
            } else {
                chainedMessage = this._nestedException.getMessage();
            }
        }
        if (result == null) {
            result = chainedMessage;
        } else if (chainedMessage != null) {
            result = result + "\n" + chainedMessage;
        }
        return result;
    }

    public String getResourceBundleName() {
        return this._bundleName;
    }

    public String getErrorCode() {
        return this._errorCode;
    }

    public Object[] getMessageArgs() {
        return this._args;
    }

    public String getMessage() {
        return this.getL10NMessage(Locale.ENGLISH);
    }

    public void printStackTrace() {
        System.err.println(this.fetchStackTrace());
    }

    public void printStackTrace(PrintWriter pw) {
        pw.println(this.fetchStackTrace());
    }

    public void printStackTrace(PrintStream ps) {
        ps.println(this.fetchStackTrace());
    }

    private String getLocalMessage(Locale locale) {
        String result = this._message;
        if (this._bundleName != null && locale != null) {
            this._bundle = amCache.getResBundle(this._bundleName, locale);
            String mid = this._bundle.getString(this._errorCode);
            result = this._args == null || this._args.length == 0 ? mid : MessageFormat.format(mid, this._args);
        }
        return result;
    }

    private String getLocalMessage() {
        return this.getLocalMessage(Locale.ENGLISH);
    }

    private String fetchStackTrace() {
        String stackString = null;
        StringBuffer messageBuffer = new StringBuffer();
        int exCount = 1;
        Throwable rootException = this;
        messageBuffer.append(rootException.getClass().getName() + "(" + exCount + ")" + ":" + ((AuthLoginException)rootException).getLocalMessage() + "\n");
        while (rootException instanceof AuthLoginException && ((AuthLoginException)rootException)._nestedException != null) {
            rootException = ((AuthLoginException)rootException)._nestedException;
            ++exCount;
            if (rootException instanceof AuthLoginException) {
                messageBuffer.append(rootException.getClass().getName() + "(" + exCount + ")" + ":" + ((AuthLoginException)rootException).getLocalMessage() + "\n");
                continue;
            }
            messageBuffer.append(rootException.getClass().getName() + "(" + exCount + ")" + ":" + rootException.getMessage() + "\n");
        }
        if (rootException == this) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ((AuthLoginException)rootException).printExceptionStackTrace(pw);
            stackString = sw.getBuffer().toString();
        } else {
            StringWriter rootStackWriter = new StringWriter();
            StringWriter thisStackWriter = new StringWriter();
            rootException.printStackTrace(new PrintWriter(rootStackWriter));
            this.printExceptionStackTrace(new PrintWriter(thisStackWriter));
            StringBuffer rootStackTrace = rootStackWriter.getBuffer();
            rootStackTrace.insert(0, messageBuffer.toString());
            stackString = rootStackTrace.toString();
        }
        return stackString;
    }

    private void printExceptionStackTrace(PrintWriter pw) {
        super.printStackTrace(pw);
    }
}

